/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen;

import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.blockentity.FluidInterfaceBlockEntity;
import com.refinedmods.refinedstorage.blockentity.NetworkNodeBlockEntity;
import com.refinedmods.refinedstorage.container.FluidInterfaceContainerMenu;
import com.refinedmods.refinedstorage.render.FluidRenderer;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.RedstoneModeSideButton;
import com.refinedmods.refinedstorage.util.RenderUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class FluidInterfaceScreen
extends BaseScreen<FluidInterfaceContainerMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("refinedstorage", "textures/gui/fluid_interface.png");
    private static final FluidRenderer TANK_RENDERER = new FluidRenderer(16000, 12, 47, 1);

    public FluidInterfaceScreen(FluidInterfaceContainerMenu containerMenu, Inventory inventory, Component title) {
        super(containerMenu, 211, 204, inventory, title);
    }

    @Override
    public void onPostInit(int x, int y) {
        this.addSideButton(new RedstoneModeSideButton(this, NetworkNodeBlockEntity.REDSTONE_MODE));
    }

    @Override
    public void tick(int x, int y) {
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int x, int y, int mouseX, int mouseY) {
        graphics.m_280218_(TEXTURE, x, y, 0, 0, this.f_97726_, this.f_97727_);
        if (!FluidInterfaceBlockEntity.TANK_IN.getValue().isEmpty()) {
            TANK_RENDERER.render(graphics, x + 46, y + 56, FluidInterfaceBlockEntity.TANK_IN.getValue());
        }
        if (!FluidInterfaceBlockEntity.TANK_OUT.getValue().isEmpty()) {
            TANK_RENDERER.render(graphics, x + 118, y + 56, FluidInterfaceBlockEntity.TANK_OUT.getValue());
        }
    }

    @Override
    public void renderForeground(GuiGraphics graphics, int mouseX, int mouseY) {
        this.renderString(graphics, 7, 7, this.f_96539_.getString());
        this.renderString(graphics, 47, 20, I18n.m_118938_((String)"gui.refinedstorage.fluid_interface.in", (Object[])new Object[0]));
        this.renderString(graphics, 116, 20, I18n.m_118938_((String)"gui.refinedstorage.fluid_interface.out", (Object[])new Object[0]));
        this.renderString(graphics, 7, 111, I18n.m_118938_((String)"container.inventory", (Object[])new Object[0]));
        if (RenderUtils.inBounds(46, 56, 12, 47, mouseX, mouseY) && !FluidInterfaceBlockEntity.TANK_IN.getValue().isEmpty()) {
            this.renderTooltip(graphics, mouseX, mouseY, FluidInterfaceBlockEntity.TANK_IN.getValue().getDisplayName().getString() + "\n" + ChatFormatting.GRAY + API.instance().getQuantityFormatter().formatInBucketForm(FluidInterfaceBlockEntity.TANK_IN.getValue().getAmount()) + ChatFormatting.RESET);
        }
        if (RenderUtils.inBounds(118, 56, 12, 47, mouseX, mouseY) && !FluidInterfaceBlockEntity.TANK_OUT.getValue().isEmpty()) {
            this.renderTooltip(graphics, mouseX, mouseY, FluidInterfaceBlockEntity.TANK_OUT.getValue().getDisplayName().getString() + "\n" + ChatFormatting.GRAY + API.instance().getQuantityFormatter().formatInBucketForm(FluidInterfaceBlockEntity.TANK_OUT.getValue().getAmount()) + ChatFormatting.RESET);
        }
    }
}

