/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.ironchest.common;

import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.StringUtils;

public class Util {
    static String BOOK_AUTHOR = "cpw";

    public static String toEnglishName(String internalName) {
        return Arrays.stream(internalName.toLowerCase(Locale.ROOT).split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    public static ItemStack createDirtGuideBook() {
        ItemStack book = new ItemStack((ItemLike)Items.f_42615_);
        Util.addBookInformationStatic(book, new ListTag(), "dirtchest9000", 5);
        return book;
    }

    public static void addBookInformationStatic(ItemStack book, ListTag bookPages, @Nullable String name, int pageCount) {
        String key = name == null ? "unknown" : name;
        Util.addTranslatedPages(bookPages, "ironchest.book." + key, pageCount);
        book.m_41700_("pages", (Tag)bookPages);
        book.m_41700_("generation", (Tag)IntTag.m_128679_((int)3));
        book.m_41700_("author", (Tag)StringTag.m_129297_((String)BOOK_AUTHOR));
        book.m_41700_("title", (Tag)StringTag.m_129297_((String)"How to use your DirtChest 9000!"));
    }

    public static void addTranslatedPages(ListTag bookPages, String translationKey, int pageCount) {
        for (int i = 1; i <= pageCount; ++i) {
            bookPages.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237115_((String)(translationKey + "." + i)))));
        }
    }
}

