/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.util;

import com.lothrazar.library.render.type.LineRenderType;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

public class RenderUtil {
    public static void drawString(GuiGraphics gg, String str, int x, int y) {
        Minecraft mc = Minecraft.m_91087_();
        gg.m_280488_(mc.f_91062_, str, x, y, 0xFFFFFF);
    }

    public static void drawStack(GuiGraphics poseStack, ItemStack stack) {
        Minecraft mc = Minecraft.m_91087_();
        int width = mc.m_91268_().m_85445_();
        int height = mc.m_91268_().m_85446_();
        poseStack.m_280064_(stack, width / 2, height / 2, 0, 10);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void createBox(MultiBufferSource.BufferSource bufferSource, PoseStack poseStack, float x, float y, float z, float offset) {
        long c = System.currentTimeMillis() / 15L % 360L;
        float[] color = RenderUtil.getHSBtoRGBF((float)c / 360.0f, 1.0f, 1.0f);
        Minecraft mc = Minecraft.m_91087_();
        Vec3 cameraPosition = mc.f_91063_.m_109153_().m_90583_();
        Vec3 vec = new Vec3((double)x, (double)y, (double)z).m_82546_(cameraPosition);
        if (vec.m_82554_(Vec3.f_82478_) > 200.0) {
            vec = vec.m_82541_().m_82490_(200.0);
            x = (float)((double)x + vec.f_82479_);
            y = (float)((double)y + vec.f_82480_);
            z = (float)((double)z + vec.f_82481_);
        }
        RenderSystem.disableDepthTest();
        RenderType renderType = LineRenderType.tombLinesType();
        VertexConsumer vertexConsumer = bufferSource.m_6299_(renderType);
        poseStack.m_85837_(-cameraPosition.f_82479_, -cameraPosition.f_82480_, -cameraPosition.f_82481_);
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        vertexConsumer.m_252986_(pose, x, y, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x + offset, y, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x, y, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x, y + offset, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x, y, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x, y, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x + offset, y + offset, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x, y + offset, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x + offset, y + offset, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x + offset, y, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x + offset, y + offset, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x + offset, y + offset, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x, y + offset, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x, y + offset, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x, y + offset, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x + offset, y + offset, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x + offset, y, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x + offset, y, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x + offset, y, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x + offset, y + offset, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x, y, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x + offset, y, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x, y, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x, y + offset, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        bufferSource.m_109912_(renderType);
        RenderSystem.enableDepthTest();
    }

    public static float[] getRGBColor3F(int color) {
        return new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
    }

    public static int intColor(int r, int g, int b) {
        return r * 65536 + g * 256 + b;
    }

    public static float[] getHSBtoRGBF(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
    }
}

