/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch;

import com.mojang.datafixers.util.Pair;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.data.reloader.MobPatchReloadListener;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public class CustomMobPatch<T extends PathfinderMob>
extends MobPatch<T> {
    private final MobPatchReloadListener.CustomMobPatchProvider provider;

    public CustomMobPatch(Faction faction, MobPatchReloadListener.CustomMobPatchProvider provider) {
        super(faction);
        this.provider = provider;
    }

    @Override
    protected void initAI() {
        super.initAI();
        ((PathfinderMob)this.original).f_21345_.m_25352_(0, new AnimatedAttackGoal<CustomMobPatch>(this, this.provider.getCombatBehaviorsBuilder().build(this)));
        ((PathfinderMob)this.original).f_21345_.m_25352_(1, (Goal)new TargetChasingGoal(this, (PathfinderMob)this.getOriginal(), this.provider.getChasingSpeed(), true));
    }

    public void initAttributes() {
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.MAX_STRIKES.get()).m_22100_(this.provider.getAttributeValues().getDouble(EpicFightAttributes.MAX_STRIKES.get()));
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()).m_22100_(this.provider.getAttributeValues().getDouble(EpicFightAttributes.ARMOR_NEGATION.get()));
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.IMPACT.get()).m_22100_(this.provider.getAttributeValues().getDouble(EpicFightAttributes.IMPACT.get()));
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.STUN_ARMOR.get()).m_22100_(this.provider.getAttributeValues().getDouble(EpicFightAttributes.STUN_ARMOR.get()));
        if (this.provider.getAttributeValues().containsKey((Object)Attributes.f_22281_)) {
            ((PathfinderMob)this.original).m_21051_(Attributes.f_22281_).m_22100_(this.provider.getAttributeValues().getDouble((Object)Attributes.f_22281_));
        }
    }

    @Override
    public void initAnimator(Animator animator) {
        for (Pair<LivingMotion, StaticAnimation> pair : this.provider.getDefaultAnimations()) {
            animator.addLivingAnimation((LivingMotion)pair.getFirst(), (StaticAnimation)pair.getSecond());
        }
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonAggressiveMobUpdateMotion(considerInaction);
    }

    @Override
    public StaticAnimation getHitAnimation(StunType stunType) {
        return this.provider.getStunAnimations().get((Object)stunType);
    }

    @Override
    public SoundEvent getWeaponHitSound(InteractionHand hand) {
        CapabilityItem itemCap = this.getAdvancedHoldingItemCapability(hand);
        if (itemCap.isEmpty()) {
            return this.provider.getHitSound();
        }
        return itemCap.getHitSound();
    }

    @Override
    public SoundEvent getSwingSound(InteractionHand hand) {
        CapabilityItem itemCap = this.getAdvancedHoldingItemCapability(hand);
        if (itemCap.isEmpty()) {
            return this.provider.getSwingSound();
        }
        return itemCap.getSmashingSound();
    }

    @Override
    public HitParticleType getWeaponHitParticle(InteractionHand hand) {
        CapabilityItem itemCap = this.getAdvancedHoldingItemCapability(hand);
        if (itemCap.isEmpty()) {
            return this.provider.getHitParticle();
        }
        return itemCap.getHitParticle();
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTicks) {
        float scale = this.provider.getScale();
        return super.getModelMatrix(partialTicks).scale(scale, scale, scale);
    }
}

