/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.compat;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import net.irisshaders.iris.pipeline.programs.ExtendedShader;
import net.minecraftforge.eventbus.api.IEventBus;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.shader.AnimationShaderInstance;
import yesman.epicfight.compat.ICompatModule;
import yesman.epicfight.main.EpicFightMod;

public class IRISCompat
implements ICompatModule {
    private static final Map<String, Supplier<AnimationShaderInstance>> IRIS_SHADER_PROVIDERS = Maps.newHashMap();

    public static void putIrisShaderProvider(String name, Supplier<AnimationShaderInstance> shaderSupplier) {
        EpicFightRenderTypes.clearAnimationShaderInstance(name);
        IRIS_SHADER_PROVIDERS.put(name, shaderSupplier);
    }

    public static void clearIrisShaders() {
        EpicFightMod.CLIENT_CONFIGS.shaderModeSwitchingLocked = false;
        IRIS_SHADER_PROVIDERS.clear();
    }

    @Override
    public void onModEventBus(IEventBus eventBus) {
    }

    @Override
    public void onForgeEventBus(IEventBus eventBus) {
    }

    @Override
    public void onModEventBusClient(IEventBus eventBus) {
        EpicFightRenderTypes.registerShaderTransformer(shaderInstance -> shaderInstance instanceof ExtendedShader, shaderInstance -> IRIS_SHADER_PROVIDERS.get(shaderInstance.m_173365_()).get());
    }

    @Override
    public void onForgeEventBusClient(IEventBus eventBus) {
    }
}

