/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.layer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.client.forgeevent.AnimatedArmorTextureEvent;
import yesman.epicfight.api.client.model.AnimatedMesh;
import yesman.epicfight.api.client.model.Mesh;
import yesman.epicfight.api.client.model.MeshProvider;
import yesman.epicfight.api.client.model.transformer.CustomModelBakery;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.model.JsonModelLoader;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.mesh.HumanoidMesh;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.patched.layer.ModelRenderLayer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class WearableItemLayer<E extends LivingEntity, T extends LivingEntityPatch<E>, M extends HumanoidModel<E>, AM extends HumanoidMesh>
extends ModelRenderLayer<E, T, M, HumanoidArmorLayer<E, M, M>, AM> {
    private static final Map<ResourceLocation, AnimatedMesh> ARMOR_MODELS = Maps.newHashMap();
    private static final Map<String, ResourceLocation> EPICFIGHT_OVERRIDING_TEXTURES = Maps.newHashMap();
    private final boolean firstPersonModel;
    private final TextureAtlas armorTrimAtlas;

    public static void clearModels() {
        ARMOR_MODELS.values().forEach(AnimatedMesh::destroy);
        ARMOR_MODELS.clear();
        EPICFIGHT_OVERRIDING_TEXTURES.clear();
    }

    public static void putModel(ResourceLocation rl, AnimatedMesh animatedMesh) {
        AnimatedMesh oldModel;
        if (ARMOR_MODELS.containsKey(rl) && (oldModel = ARMOR_MODELS.get(rl)) != animatedMesh) {
            ARMOR_MODELS.get(rl).destroy();
        }
        ARMOR_MODELS.put(rl, animatedMesh);
    }

    public WearableItemLayer(MeshProvider<AM> meshProvider, boolean firstPersonModel, ModelManager modelManager) {
        super(meshProvider);
        this.firstPersonModel = firstPersonModel;
        this.armorTrimAtlas = modelManager.m_119428_(Sheets.f_265912_);
    }

    private void renderArmor(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, AnimatedMesh model, Armature armature, float r, float g, float b, ResourceLocation armorTexture, OpenMatrix4f[] poses) {
        model.draw(poseStack, multiBufferSource, RenderType.m_110431_((ResourceLocation)armorTexture), packedLight, r, g, b, 1.0f, OverlayTexture.f_118083_, armature, poses);
    }

    private void renderGlint(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, AnimatedMesh model, Armature armature, OpenMatrix4f[] poses) {
        model.draw(poseStack, multiBufferSource, RenderType.m_110484_(), packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, armature, poses);
    }

    private void renderTrim(PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight, AnimatedMesh model, Armature armature, ArmorMaterial armorMaterial, ArmorTrim armorTrim, EquipmentSlot slot, OpenMatrix4f[] poses) {
        TextureAtlasSprite textureatlassprite = this.armorTrimAtlas.m_118316_(WearableItemLayer.innerModel(slot) ? armorTrim.m_267774_(armorMaterial) : armorTrim.m_267606_(armorMaterial));
        VertexConsumer vertexConsumer = textureatlassprite.m_118381_(multiBufferSource.m_6299_(EpicFightRenderTypes.getTriangulated(Sheets.m_266442_())));
        model.drawToBuffer(poseStack, vertexConsumer, Mesh.DrawingFunction.ENTITY_TEXTURED, packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, armature, poses);
    }

    @Override
    public void renderLayer(T entitypatch, E entityliving, HumanoidArmorLayer<E, M, M> vanillaLayer, PoseStack poseStack, MultiBufferSource buf, int packedLight, OpenMatrix4f[] poses, float bob, float yRot, float xRot, float partialTicks) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            HumanoidModel defaultModel;
            AnimatedMesh armorMesh;
            ItemStack itemstack;
            Item item;
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR) continue;
            boolean chestPart = false;
            if (((LivingEntityPatch)entitypatch).isFirstPerson() && this.firstPersonModel) {
                if (slot != EquipmentSlot.CHEST) continue;
                chestPart = true;
            }
            if (slot == EquipmentSlot.HEAD && this.firstPersonModel || !((item = (itemstack = entityliving.m_6844_(slot)).m_41720_()) instanceof ArmorItem)) continue;
            ArmorItem armorItem = (ArmorItem)item;
            if (slot != armorItem.m_40402_()) {
                return;
            }
            poseStack.m_85836_();
            float head = 0.0f;
            if (slot == EquipmentSlot.HEAD) {
                poseStack.m_85837_(0.0, (double)head * 0.055, 0.0);
            }
            if ((armorMesh = this.getArmorModel(vanillaLayer, defaultModel = vanillaLayer.m_117078_(slot), entityliving, armorItem, itemstack, slot)) == null) {
                poseStack.m_85849_();
                return;
            }
            armorMesh.initialize();
            if (chestPart && armorMesh.hasPart("torso")) {
                armorMesh.getPart("torso").setHidden(true);
            }
            if (armorItem instanceof DyeableLeatherItem) {
                DyeableLeatherItem dyeableItem = (DyeableLeatherItem)armorItem;
                int i = dyeableItem.m_41121_(itemstack);
                float r = (float)(i >> 16 & 0xFF) / 255.0f;
                float g = (float)(i >> 8 & 0xFF) / 255.0f;
                float b = (float)(i & 0xFF) / 255.0f;
                this.renderArmor(poseStack, buf, packedLight, armorMesh, ((LivingEntityPatch)entitypatch).getArmature(), r, g, b, this.getArmorTexture(itemstack, (LivingEntity)entityliving, armorMesh, slot, null, (M)defaultModel), poses);
                this.renderArmor(poseStack, buf, packedLight, armorMesh, ((LivingEntityPatch)entitypatch).getArmature(), 1.0f, 1.0f, 1.0f, this.getArmorTexture(itemstack, (LivingEntity)entityliving, armorMesh, slot, "overlay", (M)defaultModel), poses);
            } else {
                this.renderArmor(poseStack, buf, packedLight, armorMesh, ((LivingEntityPatch)entitypatch).getArmature(), 1.0f, 1.0f, 1.0f, this.getArmorTexture(itemstack, (LivingEntity)entityliving, armorMesh, slot, null, (M)defaultModel), poses);
            }
            ArmorTrim.m_266285_((RegistryAccess)entityliving.m_9236_().m_9598_(), (ItemStack)itemstack).ifPresent(armorTrim -> this.renderTrim(poseStack, buf, packedLight, armorMesh, entitypatch.getArmature(), armorItem.m_40401_(), (ArmorTrim)armorTrim, slot, poses));
            if (itemstack.m_41790_()) {
                this.renderGlint(poseStack, buf, packedLight, armorMesh, ((LivingEntityPatch)entitypatch).getArmature(), poses);
            }
            poseStack.m_85849_();
        }
    }

    private AnimatedMesh getArmorModel(HumanoidArmorLayer<E, M, M> originalRenderer, M originalModel, E entityliving, ArmorItem armorItem, ItemStack stack, EquipmentSlot slot) {
        ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)armorItem);
        if (ARMOR_MODELS.containsKey(registryName) && !ClientEngine.getInstance().renderEngine.shouldRenderVanillaModel()) {
            return ARMOR_MODELS.get(registryName);
        }
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        ResourceLocation rl = new ResourceLocation(ForgeRegistries.ITEMS.getKey((Object)armorItem).m_135827_(), "animmodels/armor/" + ForgeRegistries.ITEMS.getKey((Object)armorItem).m_135815_() + ".json");
        AnimatedMesh model = null;
        if (resourceManager.m_213713_(rl).isPresent()) {
            JsonModelLoader modelLoader = new JsonModelLoader(resourceManager, rl);
            model = modelLoader.loadAnimatedMesh(AnimatedMesh::new);
        } else {
            Model customModel = ForgeHooksClient.getArmorModel(entityliving, (ItemStack)stack, (EquipmentSlot)slot, originalModel);
            if (customModel == originalModel || !(customModel instanceof HumanoidModel)) {
                model = ((HumanoidMesh)this.mesh.get()).getHumanoidArmorModel(slot);
            } else {
                HumanoidModel humanoidModel = (HumanoidModel)customModel;
                model = CustomModelBakery.bakeArmor(humanoidModel, armorItem, slot);
            }
        }
        WearableItemLayer.putModel(registryName, model);
        return model;
    }

    private ResourceLocation getArmorTexture(ItemStack itemstack, LivingEntity entity, AnimatedMesh armorMesh, EquipmentSlot slot, String type, M originalModel) {
        int idx2;
        ArmorItem item = (ArmorItem)itemstack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, WearableItemLayer.innerModel(slot) ? 2 : 1, type == null ? "" : String.format("_%s", type));
        String s2 = String.format("%s/epicfight/%s", (s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)itemstack, (String)s1, (EquipmentSlot)slot, (String)type)).substring(0, idx2 = s1.lastIndexOf(47)), s1.substring(idx2 + 1));
        ResourceLocation resourcelocation2 = EPICFIGHT_OVERRIDING_TEXTURES.get(s2);
        if (resourcelocation2 != null) {
            return resourcelocation2;
        }
        if (!EPICFIGHT_OVERRIDING_TEXTURES.containsKey(s2)) {
            resourcelocation2 = new ResourceLocation(s2);
            ResourceManager rm = Minecraft.m_91087_().m_91098_();
            if (rm.m_213713_(resourcelocation2).isPresent()) {
                EPICFIGHT_OVERRIDING_TEXTURES.put(s2, resourcelocation2);
                return resourcelocation2;
            }
            EPICFIGHT_OVERRIDING_TEXTURES.put(s2, null);
        }
        AnimatedArmorTextureEvent animatedArmorTextureEvent = new AnimatedArmorTextureEvent(entity, itemstack, slot, (HumanoidModel<?>)originalModel);
        MinecraftForge.EVENT_BUS.post((Event)animatedArmorTextureEvent);
        ResourceLocation extensionTexturePath = animatedArmorTextureEvent.getResultLocation();
        if (armorMesh.getRenderProperty() != null && armorMesh.getRenderProperty().getCustomTexturePath() != null) {
            s1 = armorMesh.getRenderProperty().getCustomTexturePath();
            extensionTexturePath = null;
        }
        if (extensionTexturePath != null) {
            return extensionTexturePath;
        }
        ResourceLocation resourcelocation = (ResourceLocation)HumanoidArmorLayer.f_117070_.get(s1);
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            HumanoidArmorLayer.f_117070_.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    private static boolean innerModel(EquipmentSlot slot) {
        return slot == EquipmentSlot.LEGS;
    }
}

