/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.WitherBossModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.WitherBossRenderer;
import net.minecraft.client.renderer.entity.layers.WitherArmorLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.model.MeshProvider;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.mesh.WitherMesh;
import yesman.epicfight.client.renderer.patched.entity.PatchedLivingEntityRenderer;
import yesman.epicfight.client.renderer.patched.layer.PatchedWitherArmorLayer;
import yesman.epicfight.world.capabilities.entitypatch.boss.WitherPatch;

@OnlyIn(value=Dist.CLIENT)
public class PWitherRenderer
extends PatchedLivingEntityRenderer<WitherBoss, WitherPatch, WitherBossModel<WitherBoss>, WitherBossRenderer, WitherMesh> {
    public static final ResourceLocation WITHER_INVULNERABLE_LOCATION = new ResourceLocation("textures/entity/wither/wither_invulnerable.png");
    private static final ResourceLocation WITHER_LOCATION = new ResourceLocation("textures/entity/wither/wither.png");

    public PWitherRenderer(EntityRendererProvider.Context context, EntityType<?> entityType) {
        super(context, entityType);
        this.addPatchedLayer(WitherArmorLayer.class, new PatchedWitherArmorLayer());
    }

    @Override
    public void render(WitherBoss entityIn, WitherPatch entitypatch, WitherBossRenderer renderer, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        boolean isVisible = this.isVisible(entityIn, entitypatch);
        boolean isVisibleToPlayer = !isVisible && !entityIn.m_20177_((Player)mc.f_91074_);
        boolean isGlowing = mc.m_91314_((Entity)entityIn);
        RenderType renderType = this.getRenderType(entityIn, entitypatch, renderer, isVisible, isVisibleToPlayer, isGlowing);
        WitherMesh mesh = this.getMeshProvider(entitypatch).get();
        Armature armature = entitypatch.getArmature();
        poseStack.m_85836_();
        this.mulPoseStack(poseStack, armature, entityIn, entitypatch, partialTicks);
        OpenMatrix4f[] poseMatrices = this.getPoseMatrices(entitypatch, armature, partialTicks, false);
        if (renderType != null) {
            int transparencyCount = entitypatch.getTransparency();
            if (transparencyCount == 0) {
                if (!entitypatch.isGhost()) {
                    mesh.draw(poseStack, buffer, renderType, packedLight, 1.0f, 1.0f, 1.0f, 1.0f, this.getOverlayCoord(entityIn, entitypatch, partialTicks), entitypatch.getArmature(), poseMatrices);
                }
            } else {
                float transparency = ((float)Math.abs(transparencyCount) + partialTicks) / 41.0f;
                if (transparencyCount < 0) {
                    transparency = 1.0f - transparency;
                }
                mesh.draw(poseStack, buffer, RenderType.m_110473_((ResourceLocation)WITHER_LOCATION), packedLight, 1.0f, 1.0f, 1.0f, transparency, OverlayTexture.f_118083_, entitypatch.getArmature(), poseMatrices);
                mesh.draw(poseStack, buffer, RenderType.m_110473_((ResourceLocation)WITHER_INVULNERABLE_LOCATION), packedLight, 1.0f, 1.0f, 1.0f, Mth.m_14031_((float)(transparency * 3.1415f)), OverlayTexture.f_118083_, entitypatch.getArmature(), poseMatrices);
            }
            this.renderLayer(renderer, entitypatch, entityIn, poseMatrices, buffer, poseStack, packedLight, partialTicks);
        }
        if (renderType != null && Minecraft.m_91087_().m_91290_().m_114377_()) {
            for (Layer.Priority priority : Layer.Priority.HIGHEST.lowers()) {
                AnimationPlayer animPlayer = entitypatch.getClientAnimator().getCompositeLayer((Layer.Priority)priority).animationPlayer;
                float playTime = animPlayer.getPrevElapsedTime() + (animPlayer.getElapsedTime() - animPlayer.getPrevElapsedTime()) * partialTicks;
                animPlayer.getAnimation().renderDebugging(poseStack, buffer, entitypatch, playTime, partialTicks);
            }
        }
        poseStack.m_85849_();
    }

    protected boolean isVisible(WitherBoss witherboss, WitherPatch witherpatch) {
        return !witherpatch.isGhost() || witherpatch.getTransparency() != 0;
    }

    @Override
    public void mulPoseStack(PoseStack poseStack, Armature armature, WitherBoss witherboss, WitherPatch entitypatch, float partialTicks) {
        super.mulPoseStack(poseStack, armature, witherboss, entitypatch, partialTicks);
        float f = 1.0f;
        int i = witherboss.m_31502_();
        if (i > 0) {
            f -= ((float)i - partialTicks) / 440.0f;
        }
        poseStack.m_85841_(f, f, f);
    }

    @Override
    public MeshProvider<WitherMesh> getMeshProvider(WitherPatch entitypatch) {
        return Meshes.WITHER;
    }
}

