/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.patched.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.forgeevent.PrepareModelEvent;
import yesman.epicfight.api.client.model.AnimatedMesh;
import yesman.epicfight.api.client.model.MeshProvider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class PCutsomGeoEntityRenderer<E extends LivingEntity>
extends PatchedEntityRenderer<E, LivingEntityPatch<E>, GeoEntityRenderer<E>, AnimatedMesh> {
    private final MeshProvider<AnimatedMesh> mesh;

    public PCutsomGeoEntityRenderer(MeshProvider<AnimatedMesh> mesh, EntityRendererProvider.Context context) {
        super(context);
        this.mesh = mesh;
    }

    @Override
    public void render(E entityIn, LivingEntityPatch<E> entitypatch, GeoEntityRenderer<E> renderer, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        super.render(entityIn, entitypatch, renderer, buffer, poseStack, packedLight, partialTicks);
        Minecraft mc = Minecraft.m_91087_();
        boolean isVisibleToPlayer = !entityIn.m_20177_((Player)mc.f_91074_);
        RenderType renderType = renderer.getRenderType(entityIn, renderer.m_5478_(entityIn), buffer, partialTicks);
        Armature armature = entitypatch.getArmature();
        poseStack.m_85836_();
        this.mulPoseStack(poseStack, armature, entityIn, entitypatch, partialTicks);
        OpenMatrix4f[] poseMatrices = this.getPoseMatrices(entitypatch, armature, partialTicks, false);
        if (renderType != null) {
            AnimatedMesh mesh = this.mesh.get();
            mesh.initialize();
            PrepareModelEvent prepareModelEvent = new PrepareModelEvent(this, mesh, entitypatch, buffer, poseStack, packedLight, partialTicks);
            if (!MinecraftForge.EVENT_BUS.post((Event)prepareModelEvent)) {
                mesh.draw(poseStack, buffer, renderType, packedLight, 1.0f, 1.0f, 1.0f, isVisibleToPlayer ? 0.15f : 1.0f, renderer.getPackedOverlay(entityIn, partialTicks), entitypatch.getArmature(), poseMatrices);
            }
        }
        if (!entityIn.m_5833_()) {
            this.renderLayer(renderer, entitypatch, entityIn, poseMatrices, buffer, poseStack, packedLight, partialTicks);
        }
        if (renderType != null && Minecraft.m_91087_().m_91290_().m_114377_()) {
            for (Layer layer : entitypatch.getClientAnimator().getAllLayers()) {
                AnimationPlayer animPlayer = layer.animationPlayer;
                float playTime = animPlayer.getPrevElapsedTime() + (animPlayer.getElapsedTime() - animPlayer.getPrevElapsedTime()) * partialTicks;
                animPlayer.getAnimation().renderDebugging(poseStack, buffer, entitypatch, playTime, partialTicks);
            }
        }
        poseStack.m_85849_();
    }

    protected void renderLayer(GeoEntityRenderer<E> renderer, LivingEntityPatch<E> entitypatch, E entityIn, OpenMatrix4f[] poses, MultiBufferSource buffer, PoseStack poseStack, int packedLightIn, float partialTicks) {
        ArrayList layers = new ArrayList(renderer.getRenderLayers());
        for (GeoRenderLayer layer2 : layers) {
            Class<?> rendererClass = layer2.getClass();
            if (!rendererClass.isAnonymousClass()) continue;
            rendererClass = rendererClass.getSuperclass();
        }
        OpenMatrix4f modelMatrix = new OpenMatrix4f().mulFront(poses[entitypatch.getArmature().getRootJoint().getId()]);
        OpenMatrix4f transpose = OpenMatrix4f.transpose(modelMatrix, null);
        poseStack.m_85836_();
        MathUtils.translateStack(poseStack, modelMatrix);
        MathUtils.rotateStack(poseStack, transpose);
        poseStack.m_85837_(0.0, this.getLayerCorrection(), 0.0);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        layers.forEach(layer -> {});
        poseStack.m_85849_();
    }

    @Override
    public void mulPoseStack(PoseStack poseStack, Armature armature, E entityIn, LivingEntityPatch<E> entitypatch, float partialTicks) {
        super.mulPoseStack(poseStack, armature, entityIn, entitypatch, partialTicks);
        if (entityIn.m_6047_()) {
            poseStack.m_85837_(0.0, 0.15, 0.0);
        }
    }

    protected double getLayerCorrection() {
        return 1.15;
    }

    @Override
    public MeshProvider<AnimatedMesh> getMeshProvider(LivingEntityPatch<E> entitypatch) {
        return this.mesh;
    }
}

