/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.api.exception.ShaderParsingException;
import yesman.epicfight.client.renderer.EpicFightVertexFormat;
import yesman.epicfight.client.renderer.shader.AnimationShaderInstance;
import yesman.epicfight.client.renderer.shader.ShaderParser;
import yesman.epicfight.client.renderer.shader.VanillaAnimationShader;
import yesman.epicfight.main.EpicFightMod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="epicfight", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class EpicFightRenderTypes
extends RenderType {
    private static final Function<ResourceLocation, RenderType> ENTITY_INDICATOR = Util.m_143827_(textureLocation -> {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(f_173102_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(textureLocation, false, false)).m_110685_(f_110134_).m_110671_(f_110153_).m_110677_(f_110155_).m_110691_(true);
        return EpicFightRenderTypes.m_173215_((String)"epicfight:entity_indicator", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)state);
    });
    private static final RenderType DEBUG_COLLIDER = EpicFightRenderTypes.m_173215_((String)"epicfight:debug_collider", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINE_STRIP, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173104_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.empty())).m_110669_(f_110119_).m_110685_(f_110139_).m_110675_(f_110129_).m_110687_(f_110114_).m_110661_(f_110110_).m_110691_(false));
    private static final RenderType DEBUG_QUADS = EpicFightRenderTypes.m_173215_((String)"epicfight:debug_quad", (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173104_).m_110669_(f_110119_).m_110685_(f_110134_).m_110687_(f_110114_).m_110661_(f_110110_).m_110691_(false));
    private static final Function<RenderType, RenderType> TRIANGULATED_RENDER_TYPES = Util.m_143827_(renderType$1 -> {
        if (renderType$1 instanceof RenderType.CompositeRenderType) {
            RenderType.CompositeRenderType compositeRenderType = (RenderType.CompositeRenderType)renderType$1;
            return new RenderType.CompositeRenderType(renderType$1.f_110133_, renderType$1.f_110389_, VertexFormat.Mode.TRIANGLES, renderType$1.m_110507_(), renderType$1.m_110405_(), renderType$1.f_110393_, compositeRenderType.f_110511_);
        }
        return renderType$1;
    });
    private static Map<ResourceLocation, Resource> SHADER_LIBS;
    private static final List<ShaderTransformer> ANIMATION_SHADERS_TRANSFORMERS;
    private static final Map<String, AnimationShaderInstance> ANIMATION_SHADERS;
    private static final Function<VertexFormat, VertexFormat> ANIMATION_VERTEX_FORMATS;

    public static RenderType getTriangulated(RenderType renderType) {
        return TRIANGULATED_RENDER_TYPES.apply(renderType);
    }

    public static RenderType entityIndicator(ResourceLocation resourcelocation) {
        return ENTITY_INDICATOR.apply(resourcelocation);
    }

    public static RenderType debugCollider() {
        return DEBUG_COLLIDER;
    }

    public static RenderType m_269166_() {
        return DEBUG_QUADS;
    }

    public static AnimationShaderInstance getAnimationShader(ShaderInstance shaderInstance) {
        if (shaderInstance instanceof AnimationShaderInstance) {
            AnimationShaderInstance animationShaderInstance = (AnimationShaderInstance)shaderInstance;
            return animationShaderInstance;
        }
        try {
            if (!ANIMATION_SHADERS.containsKey(shaderInstance.m_173365_())) {
                AnimationShaderInstance animationShaderInstance = null;
                for (ShaderTransformer shaderTransformer : ANIMATION_SHADERS_TRANSFORMERS) {
                    if (!shaderTransformer.predicate().test(shaderInstance)) continue;
                    animationShaderInstance = shaderTransformer.transformer().apply(shaderInstance);
                    break;
                }
                if (animationShaderInstance == null) {
                    animationShaderInstance = ShaderTransformer.VANILLA_TRANSFORMER.transformer.apply(shaderInstance);
                }
                if (animationShaderInstance != null) {
                    ANIMATION_SHADERS.put(shaderInstance.m_173365_(), animationShaderInstance);
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            EpicFightMod.LOGGER.warn("Failed to create shader with " + e.getMessage() + ". Automatically switches animation shader mode off.");
            Minecraft.m_91087_().f_91060_.m_109818_();
            Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)Component.m_237110_((String)"epicfight.messages.shader_transform_fail", (Object[])new Object[]{shaderInstance.m_173365_()}).m_130940_(ChatFormatting.RED));
            EpicFightMod.CLIENT_CONFIGS.shaderModeSwitchingLocked = true;
            EpicFightMod.CLIENT_CONFIGS.useAnimationShader.setValue(false);
            EpicFightMod.CLIENT_CONFIGS.save();
        }
        return ANIMATION_SHADERS.get(shaderInstance.m_173365_());
    }

    public static AnimationShaderInstance getAnimationShader(RenderType renderType) {
        if (renderType instanceof RenderType.CompositeRenderType) {
            RenderType.CompositeRenderType compositeRenderType = (RenderType.CompositeRenderType)renderType;
            Optional shaderInstanceOptional = compositeRenderType.f_110511_.f_173274_.f_173136_;
            if (shaderInstanceOptional.isPresent()) {
                return EpicFightRenderTypes.getAnimationShader((ShaderInstance)((Supplier)shaderInstanceOptional.get()).get());
            }
        }
        return null;
    }

    public static VertexFormat getAnimationVertexFormat(VertexFormat vertexFormat) {
        if (vertexFormat instanceof EpicFightVertexFormat.AnimationVertexFormat) {
            return vertexFormat;
        }
        return ANIMATION_VERTEX_FORMATS.apply(vertexFormat);
    }

    public static void registerShaderTransformer(Predicate<ShaderInstance> predicate, Function<ShaderInstance, AnimationShaderInstance> transformer) {
        ANIMATION_SHADERS_TRANSFORMERS.add(new ShaderTransformer(predicate, transformer));
    }

    @SubscribeEvent
    public static void registerShadersEvent(RegisterShadersEvent event) throws IOException {
        ANIMATION_SHADERS.clear();
        Map shaderLibs = ((ResourceManager)((GameRenderer.ResourceCache)event.getResourceProvider()).f_244315_()).m_214159_("shaders/include", rl -> {
            String s = rl.m_135815_();
            return s.endsWith(".glsl");
        });
        SHADER_LIBS = ImmutableMap.copyOf((Map)shaderLibs);
        EpicFightMod.CLIENT_CONFIGS.shaderModeSwitchingLocked = false;
    }

    public static void clearAnimationShaderInstance(String shaderName) {
        if (!ANIMATION_SHADERS.containsKey(shaderName)) {
            return;
        }
        AnimationShaderInstance animationShaderInstance = ANIMATION_SHADERS.get(shaderName);
        animationShaderInstance._clear();
        animationShaderInstance._close();
        ANIMATION_SHADERS.remove(shaderName);
    }

    private EpicFightRenderTypes() {
        super(null, null, null, -1, false, false, null, null);
    }

    static {
        ANIMATION_SHADERS_TRANSFORMERS = Lists.newArrayList();
        ANIMATION_SHADERS = Maps.newConcurrentMap();
        ANIMATION_VERTEX_FORMATS = Util.m_143827_(vertexFormat -> {
            if (vertexFormat instanceof EpicFightVertexFormat.AnimationVertexFormat) {
                return vertexFormat;
            }
            ImmutableMap.Builder vertexFormatElements = ImmutableMap.builder();
            vertexFormat.getElementMapping().entrySet().stream().filter(entry -> EpicFightVertexFormat.keep((VertexFormatElement)entry.getValue())).map(entry -> Pair.of((Object)((String)entry.getKey()), (Object)EpicFightVertexFormat.convert((VertexFormatElement)entry.getValue()))).forEach(pair -> vertexFormatElements.put((Object)((String)pair.getFirst()), (Object)((VertexFormatElement)pair.getSecond())));
            vertexFormatElements.put((Object)"Joints", (Object)EpicFightVertexFormat.ELEMENT_JOINTS);
            vertexFormatElements.put((Object)"Weights", (Object)EpicFightVertexFormat.ELEMENT_WEIGHTS);
            EpicFightVertexFormat.AnimationVertexFormat animationVertexFormat = new EpicFightVertexFormat.AnimationVertexFormat((ImmutableMap<String, VertexFormatElement>)vertexFormatElements.build());
            return animationVertexFormat;
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    private record ShaderTransformer(Predicate<ShaderInstance> predicate, Function<ShaderInstance, AnimationShaderInstance> transformer) {
        public static final ShaderTransformer VANILLA_TRANSFORMER = new ShaderTransformer(shaderInstance -> true, shaderInstance -> {
            ShaderParser shaderParser = null;
            try {
                ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
                ResourceLocation shaderLocation = new ResourceLocation(shaderInstance.m_173365_());
                shaderParser = new ShaderParser((ResourceProvider)resourceManager, shaderInstance.m_173365_());
                boolean hasNormalAttribute = shaderParser.hasAttribute("Normal");
                boolean isEyesShader = "rendertype_eyes".equals(shaderLocation.m_135815_());
                if (shaderParser.hasAttribute("Color")) {
                    shaderParser.addUniform("Color", ShaderParser.GLSLType.VEC4, "in .* Color;", ShaderParser.InsertPosition.FOLLOWING, Integer.MAX_VALUE, ShaderParser.ExceptionHandler.THROW, new Double[]{1.0, 1.0, 1.0, 1.0});
                }
                if (shaderParser.hasAttribute("UV1") && !isEyesShader) {
                    shaderParser.addUniform("UV1", ShaderParser.GLSLType.IVEC2, "in .* UV1;", ShaderParser.InsertPosition.FOLLOWING, Integer.MAX_VALUE, ShaderParser.ExceptionHandler.THROW, new Integer[]{0, 0});
                }
                if (shaderParser.hasAttribute("UV2") && !isEyesShader) {
                    shaderParser.addUniform("UV2", ShaderParser.GLSLType.IVEC2, "in .* UV2;", ShaderParser.InsertPosition.FOLLOWING, Integer.MAX_VALUE, ShaderParser.ExceptionHandler.THROW, new Integer[]{0, 0});
                }
                shaderParser.remove("Color", ShaderParser.Usage.ATTRIBUTE, ShaderParser.ExceptionHandler.IGNORE);
                shaderParser.remove("UV1", ShaderParser.Usage.ATTRIBUTE, ShaderParser.ExceptionHandler.IGNORE);
                shaderParser.remove("UV2", ShaderParser.Usage.ATTRIBUTE, ShaderParser.ExceptionHandler.IGNORE);
                shaderParser.addAttribute("Joints", ShaderParser.ExceptionHandler.THROW, ShaderParser.GLSLType.IVEC3);
                shaderParser.addAttribute("Weights", ShaderParser.ExceptionHandler.THROW, ShaderParser.GLSLType.VEC3);
                if (hasNormalAttribute && !isEyesShader) {
                    shaderParser.addUniform("Normal_Mv_Matrix", ShaderParser.GLSLType.MATRIX3F, ShaderParser.ExceptionHandler.THROW, null);
                }
                shaderParser.addUniformArray("Poses", ShaderParser.GLSLType.MATRIX4F, ShaderParser.ExceptionHandler.THROW, null, 40);
                shaderParser.replaceScript("Position", "Position_a", -1, ShaderParser.ExceptionHandler.THROW, "gl_Position", "in vec3 Position;");
                if (hasNormalAttribute && !isEyesShader) {
                    shaderParser.replaceScript("Normal", "Normal_a", -1, ShaderParser.ExceptionHandler.THROW, "uniform mat3 Normal_Mv_Matrix;", "in vec3 Normal;");
                }
                shaderParser.insertToScript("in vec3 Position;", "\nvec3 Position_a = vec3(0.0);", 0, ShaderParser.InsertPosition.FOLLOWING);
                if (hasNormalAttribute && !isEyesShader) {
                    shaderParser.insertToScript("in vec3 Normal;", "\nvec3 Normal_a = vec3(0.0);", 0, ShaderParser.InsertPosition.FOLLOWING);
                }
                shaderParser.insertToScript("void main\\(\\) \\{", "void setAnimationPosition() {\n    for(int i=0;i<3;i++)\n    {\n        mat4 jointTransform = Poses[Joints[i]];\n        vec4 posePosition = jointTransform * vec4(Position, 1.0);\n        Position_a += vec3(posePosition.xyz) * Weights[i];\n    }\n}\n\n", 0, ShaderParser.InsertPosition.PRECEDING);
                if (hasNormalAttribute && !isEyesShader) {
                    shaderParser.insertToScript("void main\\(\\) \\{", "void setAnimationNormal() {\n    \n    for(int i=0;i<3;i++)\n    {\n        mat4 jointTransform = Poses[Joints[i]];\n        vec4 poseNormal = jointTransform * vec4(Normal, 1.0);\n        Normal_a += vec3(poseNormal.xyz) * Weights[i];\n    }\n    \n    Normal_a = Normal_Mv_Matrix * Normal_a;\n}\n", 0, ShaderParser.InsertPosition.PRECEDING);
                    shaderParser.insertToScript("void main\\(\\) \\{", "\n    setAnimationNormal();", 0, ShaderParser.InsertPosition.FOLLOWING);
                }
                shaderParser.insertToScript("void main\\(\\) \\{", "\n    setAnimationPosition();", 0, ShaderParser.InsertPosition.FOLLOWING);
                HashMap cache = Maps.newHashMap();
                cache.putAll(SHADER_LIBS);
                shaderParser.addToResourceCache(cache);
                GameRenderer.ResourceCache resourceProvider = new GameRenderer.ResourceCache((ResourceProvider)resourceManager, (Map)cache);
                return new VanillaAnimationShader((ResourceProvider)resourceProvider, new ResourceLocation("epicfight", shaderLocation.m_135815_()), EpicFightRenderTypes.getAnimationVertexFormat(shaderInstance.m_173364_()));
            }
            catch (IOException | ShaderParsingException e) {
                e.printStackTrace();
                if (shaderParser != null) {
                    EpicFightMod.LOGGER.warn("Shader Script\n " + shaderParser.getOriginalScript());
                }
                throw new RuntimeException("Can't create animation shader", e);
            }
        });
    }
}

