/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.screen.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.client.gui.screen.config.EditItemListScreen;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCapability;
import yesman.epicfight.world.capabilities.provider.ItemCapabilityProvider;

@OnlyIn(value=Dist.CLIENT)
public class EditSwitchingItemScreen
extends Screen {
    private RegisteredItemList battleAutoSwitchItems;
    private RegisteredItemList miningAutoSwitchItems;
    protected final Screen parentScreen;
    private Runnable deferredTooltip;

    public EditSwitchingItemScreen(Screen parentScreen) {
        super((Component)Component.m_237115_((String)"epicfight.gui.configuration.autoswitching"));
        this.parentScreen = parentScreen;
    }

    protected void m_7856_() {
        if (this.battleAutoSwitchItems == null) {
            this.battleAutoSwitchItems = new RegisteredItemList(200, this.f_96544_, (Component)Component.m_237115_((String)"epicfight.gui.to_battle_mode"));
            EpicFightMod.CLIENT_CONFIGS.battleAutoSwitchItems.stream().sorted((e1, e2) -> e1.m_5524_().compareTo(e2.m_5524_())).forEach(item -> this.battleAutoSwitchItems.addEntry((Item)item));
        } else {
            this.battleAutoSwitchItems.resize(200, this.f_96544_);
        }
        if (this.miningAutoSwitchItems == null) {
            this.miningAutoSwitchItems = new RegisteredItemList(200, this.f_96544_, (Component)Component.m_237115_((String)"epicfight.gui.to_mining_mode"));
            EpicFightMod.CLIENT_CONFIGS.miningAutoSwitchItems.stream().sorted((e1, e2) -> e1.m_5524_().compareTo(e2.m_5524_())).forEach(item -> this.miningAutoSwitchItems.addEntry((Item)item));
        } else {
            this.miningAutoSwitchItems.resize(200, this.f_96544_);
        }
        this.battleAutoSwitchItems.m_93507_(this.f_96543_ / 2 - 204);
        this.miningAutoSwitchItems.m_93507_(this.f_96543_ / 2 + 4);
        this.m_142416_((GuiEventListener)this.battleAutoSwitchItems);
        this.m_142416_((GuiEventListener)this.miningAutoSwitchItems);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> {
            EpicFightMod.CLIENT_CONFIGS.battleAutoSwitchItems.clear();
            EpicFightMod.CLIENT_CONFIGS.miningAutoSwitchItems.clear();
            EpicFightMod.CLIENT_CONFIGS.battleAutoSwitchItems.addAll(this.battleAutoSwitchItems.toList());
            EpicFightMod.CLIENT_CONFIGS.miningAutoSwitchItems.addAll(this.miningAutoSwitchItems.toList());
            EpicFightMod.CLIENT_CONFIGS.save();
            this.m_7379_();
        }).m_252987_(this.f_96543_ / 2 - 80, this.f_96544_ - 28, 160, 20).m_253136_());
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280039_(guiGraphics);
        this.battleAutoSwitchItems.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.miningAutoSwitchItems.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 16, 0xFFFFFF);
        if (this.deferredTooltip != null) {
            this.deferredTooltip.run();
            this.deferredTooltip = null;
        }
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parentScreen);
    }

    @OnlyIn(value=Dist.CLIENT)
    class RegisteredItemList
    extends ObjectSelectionList<ItemEntry> {
        private final Component title;

        public RegisteredItemList(int width, int height, Component title) {
            super(EditSwitchingItemScreen.this.f_96541_, width, height, 32, height - 50, 22);
            this.title = title;
            this.m_93473_(true, 13);
            if (this.m_93511_() != null) {
                this.m_93494_((AbstractSelectionList.Entry)((ItemEntry)this.m_93511_()));
            }
            this.m_7085_((AbstractSelectionList.Entry)new ButtonInEntry());
        }

        public void resize(int width, int height) {
            this.f_93388_ = width;
            this.f_93389_ = height;
            this.f_93390_ = 32;
            this.f_93391_ = height - 50;
            this.f_93393_ = 0;
            this.f_93392_ = width;
        }

        protected void m_7415_(GuiGraphics guiGraphics, int x, int y) {
            MutableComponent component = Component.m_237113_((String)"").m_7220_(this.title).m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.BOLD});
            guiGraphics.m_280614_(this.f_93386_.f_91062_, (Component)component, x + this.f_93388_ / 2 - this.f_93386_.f_91062_.m_92852_((FormattedText)component) / 2, Math.min(this.f_93390_ + 3, y), 0xFFFFFF, false);
        }

        public int m_5759_() {
            return this.f_93388_;
        }

        protected int m_5756_() {
            return this.f_93392_ - 6;
        }

        protected void addEntry(Item item) {
            this.m_6702_().add(new ItemEntry(item.m_7968_()));
        }

        protected void removeIfPresent(Item item) {
            this.m_6702_().remove((Object)new ItemEntry(item.m_7968_()));
        }

        protected List<Item> toList() {
            ArrayList list = Lists.newArrayList();
            for (ItemEntry entry : this.m_6702_()) {
                if (entry.itemStack.m_41619_()) continue;
                list.add(entry.itemStack.m_41720_());
            }
            return list;
        }

        @OnlyIn(value=Dist.CLIENT)
        class ItemEntry
        extends ObjectSelectionList.Entry<ItemEntry> {
            private static final Set<Item> UNRENDERABLES = Sets.newHashSet();
            private final ItemStack itemStack;

            public ItemEntry(ItemStack itemStack) {
                this.itemStack = itemStack;
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                try {
                    if (!UNRENDERABLES.contains(this.itemStack.m_41720_())) {
                        guiGraphics.m_280480_(this.itemStack, left + 4, top + 1);
                    }
                }
                catch (Exception e) {
                    UNRENDERABLES.add(this.itemStack.m_41720_());
                }
                Component component = this.itemStack.m_41786_();
                guiGraphics.m_280614_(((RegisteredItemList)RegisteredItemList.this).f_93386_.f_91062_, component, left + 30, top + 5, 0xFFFFFF, false);
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    if (RegisteredItemList.this.m_93511_() != null && ((ItemEntry)RegisteredItemList.this.m_93511_()).equals((Object)this)) {
                        RegisteredItemList.this.m_93502_((AbstractSelectionList.Entry)this);
                        return false;
                    }
                    RegisteredItemList.this.m_6987_((AbstractSelectionList.Entry)this);
                    return true;
                }
                return false;
            }

            public boolean equals(Object obj) {
                if (obj instanceof ItemEntry && !(this instanceof ButtonInEntry)) {
                    return this.itemStack.m_41720_().equals(((ItemEntry)((Object)obj)).itemStack.m_41720_());
                }
                return super.equals(obj);
            }

            public Component m_142172_() {
                return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{this.itemStack.m_41786_()});
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        class ButtonInEntry
        extends ItemEntry {
            private final Button addItemButton;
            private final Button removeAllButton;
            private final Button automaticRegisterButton;

            public ButtonInEntry() {
                super(ItemStack.f_41583_);
                this.addItemButton = Button.m_253074_((Component)Component.m_237113_((String)"+"), button -> {
                    RegisteredItemList thisList = RegisteredItemList.this == EditSwitchingItemScreen.this.battleAutoSwitchItems ? EditSwitchingItemScreen.this.battleAutoSwitchItems : EditSwitchingItemScreen.this.miningAutoSwitchItems;
                    RegisteredItemList opponentList = RegisteredItemList.this == EditSwitchingItemScreen.this.battleAutoSwitchItems ? EditSwitchingItemScreen.this.miningAutoSwitchItems : EditSwitchingItemScreen.this.battleAutoSwitchItems;
                    RegisteredItemList.this.f_93386_.m_91152_((Screen)new EditItemListScreen(EditSwitchingItemScreen.this, thisList, opponentList));
                }).m_252987_(0, 0, 20, 20).m_253136_();
                this.removeAllButton = Button.m_253074_((Component)Component.m_237115_((String)"epicfight.gui.delete_all"), button -> {
                    RegisteredItemList.this.m_93516_();
                    RegisteredItemList.this.m_7085_((AbstractSelectionList.Entry)this);
                }).m_252987_(0, 0, 60, 20).m_253136_();
                this.automaticRegisterButton = Button.m_253074_((Component)Component.m_237115_((String)"epicfight.gui.auto_add"), button -> {
                    boolean isBattleTab;
                    boolean bl = isBattleTab = RegisteredItemList.this == EditSwitchingItemScreen.this.battleAutoSwitchItems;
                    if (isBattleTab) {
                        for (Item item : ForgeRegistries.ITEMS.getValues()) {
                            CapabilityItem itemCap = ItemCapabilityProvider.get(item);
                            if (itemCap == null || !(itemCap instanceof WeaponCapability)) continue;
                            ItemEntry itemEntry = new ItemEntry(item.m_7968_());
                            if (EditSwitchingItemScreen.this.battleAutoSwitchItems.m_6702_().contains((Object)itemEntry)) continue;
                            EditSwitchingItemScreen.this.battleAutoSwitchItems.m_7085_((AbstractSelectionList.Entry)itemEntry);
                        }
                    } else {
                        for (Item item : ForgeRegistries.ITEMS.getValues()) {
                            ItemEntry itemEntry = new ItemEntry(item.m_7968_());
                            if (EditSwitchingItemScreen.this.battleAutoSwitchItems.m_6702_().contains((Object)itemEntry) || EditSwitchingItemScreen.this.miningAutoSwitchItems.m_6702_().contains((Object)itemEntry)) continue;
                            EditSwitchingItemScreen.this.miningAutoSwitchItems.m_7085_((AbstractSelectionList.Entry)itemEntry);
                        }
                    }
                }).m_252987_(0, 0, 60, 20).m_257505_(Tooltip.m_257550_((Component)(RegisteredItemList.this == EditSwitchingItemScreen.this.battleAutoSwitchItems ? Component.m_237115_((String)"epicfight.gui.tooltip_battle") : Component.m_237115_((String)"epicfight.gui.tooltip_mining")))).m_253136_();
            }

            @Override
            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
                this.addItemButton.m_252865_(left + 25);
                this.addItemButton.m_253211_(top - 2);
                this.addItemButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
                this.removeAllButton.m_252865_(left + 47);
                this.removeAllButton.m_253211_(top - 2);
                this.removeAllButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
                this.automaticRegisterButton.m_252865_(left + 109);
                this.automaticRegisterButton.m_253211_(top - 2);
                this.automaticRegisterButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            }

            @Override
            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    if (this.addItemButton.m_5953_(mouseX, mouseY)) {
                        this.addItemButton.m_7435_(EditSwitchingItemScreen.this.f_96541_.m_91106_());
                        this.addItemButton.m_5691_();
                    }
                    if (this.removeAllButton.m_5953_(mouseX, mouseY)) {
                        this.removeAllButton.m_7435_(EditSwitchingItemScreen.this.f_96541_.m_91106_());
                        this.removeAllButton.m_5691_();
                    }
                    if (this.automaticRegisterButton.m_5953_(mouseX, mouseY)) {
                        this.automaticRegisterButton.m_7435_(EditSwitchingItemScreen.this.f_96541_.m_91106_());
                        this.automaticRegisterButton.m_5691_();
                    }
                }
                return false;
            }
        }
    }
}

