/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.datapack.screen;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.util.internal.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.types.datapack.ClipHoldingAnimation;
import yesman.epicfight.api.animation.types.datapack.FakeAnimation;
import yesman.epicfight.api.client.animation.property.TrailInfo;
import yesman.epicfight.api.client.model.AnimatedMesh;
import yesman.epicfight.api.client.model.MeshProvider;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.collider.MultiOBBCollider;
import yesman.epicfight.api.collider.OBBCollider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.model.JsonModelLoader;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.client.gui.datapack.screen.AttackAnimationPropertyScreen;
import yesman.epicfight.client.gui.datapack.screen.DatapackEditScreen;
import yesman.epicfight.client.gui.datapack.screen.MessageScreen;
import yesman.epicfight.client.gui.datapack.screen.PackEntry;
import yesman.epicfight.client.gui.datapack.screen.SelectAnimationScreen;
import yesman.epicfight.client.gui.datapack.screen.StaticAnimationPropertyScreen;
import yesman.epicfight.client.gui.datapack.widgets.CheckBox;
import yesman.epicfight.client.gui.datapack.widgets.ComboBox;
import yesman.epicfight.client.gui.datapack.widgets.Grid;
import yesman.epicfight.client.gui.datapack.widgets.InputComponentList;
import yesman.epicfight.client.gui.datapack.widgets.ModelPreviewer;
import yesman.epicfight.client.gui.datapack.widgets.PopupBox;
import yesman.epicfight.client.gui.datapack.widgets.ResizableComponent;
import yesman.epicfight.client.gui.datapack.widgets.ResizableEditBox;
import yesman.epicfight.client.gui.datapack.widgets.RowSpliter;
import yesman.epicfight.client.gui.datapack.widgets.Static;
import yesman.epicfight.client.gui.datapack.widgets.SubScreenOpenButton;
import yesman.epicfight.gameasset.ColliderPreset;

@OnlyIn(value=Dist.CLIENT)
public class ImportAnimationsScreen
extends Screen {
    private final SelectAnimationScreen caller;
    private final Grid animationGrid;
    private final ModelPreviewer modelPreviewer;
    private final List<FakeAnimation> fakeAnimations = Lists.newArrayList();
    private InputComponentList<FakeAnimation> inputComponentsList;
    private ComboBox<FakeAnimation.AnimationType> animationType;
    private Consumer<FakeAnimation.AnimationType> responder;
    private Map<ResourceLocation, PackEntry<FakeAnimation, ClipHoldingAnimation>> userAnimations = DatapackEditScreen.getCurrentScreen().getUserAniamtions();

    public ImportAnimationsScreen(SelectAnimationScreen caller, Armature armature, MeshProvider<AnimatedMesh> mesh) {
        super((Component)Component.m_237113_((String)"register_animation_screen"));
        this.fakeAnimations.addAll(this.userAnimations.values().stream().map(PackEntry::getKey).map(FakeAnimation::deepCopy).toList());
        this.caller = caller;
        this.modelPreviewer = new ModelPreviewer(10, 15, 0, 140, ResizableComponent.HorizontalSizing.LEFT_RIGHT, null, armature, mesh);
        this.modelPreviewer.setCollider(ColliderPreset.FIST);
        this.f_96541_ = caller.getMinecraft();
        this.f_96547_ = caller.getMinecraft().f_91062_;
        ScreenRectangle screenRect = caller.m_264198_();
        int split = screenRect.f_263770_() / 2 - 60;
        this.animationGrid = Grid.builder(this, caller.getMinecraft()).xy1(8, screenRect.m_274449_() + 14).xy2(split - 10, screenRect.f_263800_() - 21).rowHeight(26).rowEditable(Grid.GridBuilder.RowEditButton.NONE).transparentBackground(true).rowpositionChanged((rowposition, values) -> {
            this.inputComponentsList.importTag(this.fakeAnimations.get((int)rowposition));
            this.modelPreviewer.setTrailInfo(new TrailInfo[0]);
            if (this.fakeAnimations.get((int)rowposition).getAnimationClass() == FakeAnimation.AnimationType.ATTACK || this.fakeAnimations.get((int)rowposition).getAnimationClass() == FakeAnimation.AnimationType.BASIC_ATTACK) {
                this.inputComponentsList.getComponent(7, 1)._setActive(false);
                this.inputComponentsList.getComponent(8, 1)._setActive(false);
                this.inputComponentsList.getComponent(9, 1)._setActive(false);
                this.inputComponentsList.getComponent(10, 1)._setActive(false);
                this.inputComponentsList.getComponent(11, 1)._setActive(false);
                this.inputComponentsList.getComponent(12, 1)._setActive(false);
                this.inputComponentsList.getComponent(13, 1)._setActive(false);
                this.inputComponentsList.getComponent(14, 2)._setActive(false);
                this.inputComponentsList.getComponent(14, 4)._setActive(false);
                this.inputComponentsList.getComponent(14, 6)._setActive(false);
                this.inputComponentsList.getComponent(15, 2)._setActive(false);
                this.inputComponentsList.getComponent(15, 4)._setActive(false);
                this.inputComponentsList.getComponent(15, 6)._setActive(false);
                this.inputComponentsList.getComponent(16, 1)._setActive(false);
                if (this.fakeAnimations.get((int)rowposition).getPropertiesJson().has("trail_effects")) {
                    JsonArray trailArr = this.fakeAnimations.get((int)rowposition).getPropertiesJson().getAsJsonArray("trail_effects");
                    TrailInfo[] trailInfos = new TrailInfo[trailArr.size()];
                    int i = 0;
                    for (JsonElement element : trailArr) {
                        JsonObject trailObj = element.getAsJsonObject();
                        TrailInfo.Builder builder = TrailInfo.builder().time(trailObj.get("start_time").getAsFloat(), trailObj.get("end_time").getAsFloat()).joint(trailObj.get("joint").getAsString()).itemSkinHand(InteractionHand.valueOf((String)trailObj.get("item_skin_hand").getAsString().toUpperCase(Locale.ROOT)));
                        if (trailObj.has("lifetime")) {
                            builder.lifetime(trailObj.get("lifetime").getAsInt());
                        }
                        if (trailObj.has("interpolations")) {
                            builder.interpolations(trailObj.get("interpolations").getAsInt());
                        }
                        trailInfos[i] = TrailInfo.PREVIEWER_DEFAULT_TRAIL.overwrite(builder.create());
                        ++i;
                    }
                    this.modelPreviewer.setTrailInfo(trailInfos);
                }
            }
        }).addColumn(Grid.editbox("animation_name").editWidgetCreated(editbox -> editbox.m_94153_(ResourceLocation::m_135830_)).editable(true).valueChanged(event -> this.fakeAnimations.get(event.rowposition).setParameter("path", event.postValue)).width(180)).build();
        this.inputComponentsList = new InputComponentList<FakeAnimation>((Screen)this, 0, 0, 0, 0, 30){

            @Override
            public void importTag(FakeAnimation fakeAnim) {
                block12: {
                    block11: {
                        ImportAnimationsScreen.this.rearrangeComponents(fakeAnim.getAnimationClass());
                        this.setComponentsActive(true);
                        if (fakeAnim.getAnimationClass() == null) break block11;
                        switch (fakeAnim.getAnimationClass()) {
                            case STATIC: 
                            case MOVEMENT: {
                                ImportAnimationsScreen.this.animationType._setResponder((Consumer<FakeAnimation.AnimationType>)null);
                                this.setDataBindingComponenets(new Object[]{fakeAnim.getAnimationClass(), ParseUtil.nullParam(fakeAnim.getParameter("convertTime")), fakeAnim.getParameter("isRepeat")});
                                ImportAnimationsScreen.this.animationType._setResponder(ImportAnimationsScreen.this.responder);
                                break;
                            }
                            case LONG_HIT: 
                            case SHORT_HIT: {
                                ImportAnimationsScreen.this.animationType._setResponder((Consumer<FakeAnimation.AnimationType>)null);
                                this.setDataBindingComponenets(new Object[]{fakeAnim.getAnimationClass(), ParseUtil.nullParam(fakeAnim.getParameter("convertTime"))});
                                ImportAnimationsScreen.this.animationType._setResponder(ImportAnimationsScreen.this.responder);
                                break;
                            }
                            case ATTACK: 
                            case BASIC_ATTACK: {
                                CompoundTag colliderTag = new CompoundTag();
                                Collider collider = (Collider)fakeAnim.getParameter("collider");
                                if (collider != null) {
                                    collider.serialize(colliderTag);
                                }
                                ImportAnimationsScreen.this.animationType._setResponder((Consumer<FakeAnimation.AnimationType>)null);
                                Grid.PackImporter packImporter = new Grid.PackImporter();
                                ListTag phasesTag = (ListTag)fakeAnim.getParameter("phases");
                                for (int i = 0; i < phasesTag.size(); ++i) {
                                    packImporter.newRow();
                                    packImporter.newValue("phase", String.format("Phase%s", i));
                                }
                                this.setDataBindingComponenets(new Object[]{fakeAnim.getAnimationClass(), ParseUtil.nullParam(fakeAnim.getParameter("convertTime")), packImporter, ParseUtil.nullParam(fakeAnim.getParameter("antic")), ParseUtil.nullParam(fakeAnim.getParameter("preDelay")), ParseUtil.nullParam(fakeAnim.getParameter("contact")), ParseUtil.nullParam(fakeAnim.getParameter("recovery")), fakeAnim.getParameter("hand"), null, ParseUtil.nullParam(colliderTag.m_128423_("number")), colliderTag.m_128441_("center") ? ParseUtil.nullParam(ParseUtil.nullOrToString(colliderTag.m_128437_("center", 6).get(0), Tag::m_7916_)) : "", colliderTag.m_128441_("center") ? ParseUtil.nullParam(ParseUtil.nullOrToString(colliderTag.m_128437_("center", 6).get(1), Tag::m_7916_)) : "", colliderTag.m_128441_("center") ? ParseUtil.nullParam(ParseUtil.nullOrToString(colliderTag.m_128437_("center", 6).get(2), Tag::m_7916_)) : "", colliderTag.m_128441_("size") ? ParseUtil.nullParam(ParseUtil.nullOrToString(colliderTag.m_128437_("size", 6).get(0), Tag::m_7916_)) : "", colliderTag.m_128441_("size") ? ParseUtil.nullParam(ParseUtil.nullOrToString(colliderTag.m_128437_("size", 6).get(1), Tag::m_7916_)) : "", colliderTag.m_128441_("size") ? ParseUtil.nullParam(ParseUtil.nullOrToString(colliderTag.m_128437_("size", 6).get(2), Tag::m_7916_)) : "", fakeAnim.getParameter("colliderJoint")});
                                ImportAnimationsScreen.this.animationType._setResponder(ImportAnimationsScreen.this.responder);
                                if (fakeAnim.getPropertiesJson().has("trail_effects")) {
                                    JsonArray trailList = fakeAnim.getPropertiesJson().get("trail_effects").getAsJsonArray();
                                    TrailInfo[] trailArr = new TrailInfo[trailList.size()];
                                    int i = 0;
                                    for (JsonElement element : trailList) {
                                        JsonObject trailObj = element.getAsJsonObject();
                                        TrailInfo.Builder builder = TrailInfo.builder().time(trailObj.get("start_time").getAsFloat(), trailObj.get("end_time").getAsFloat()).joint(trailObj.get("joint").getAsString()).itemSkinHand(InteractionHand.valueOf((String)trailObj.get("item_skin_hand").getAsString().toUpperCase(Locale.ROOT)));
                                        if (trailObj.has("lifetime")) {
                                            builder.lifetime(trailObj.get("lifetime").getAsInt());
                                        }
                                        if (trailObj.has("interpolations")) {
                                            builder.interpolations(trailObj.get("interpolations").getAsInt());
                                        }
                                        trailArr[i] = TrailInfo.PREVIEWER_DEFAULT_TRAIL.overwrite(builder.create());
                                        ++i;
                                    }
                                    ImportAnimationsScreen.this.modelPreviewer.setTrailInfo(trailArr);
                                    break;
                                }
                                break block12;
                            }
                            default: {
                                ImportAnimationsScreen.this.animationType._setValue(null);
                                break;
                            }
                        }
                        break block12;
                    }
                    ImportAnimationsScreen.this.animationType._setResponder((Consumer<FakeAnimation.AnimationType>)null);
                    ImportAnimationsScreen.this.animationType._setValue(null);
                    ImportAnimationsScreen.this.animationType._setResponder(ImportAnimationsScreen.this.responder);
                }
            }
        };
        if (this.fakeAnimations.isEmpty()) {
            this.inputComponentsList.newRow();
            this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(4), 5, 60, 15, ResizableComponent.HorizontalSizing.LEFT_RIGHT, null, "datapack_edit.import_animation.place_tooltip"));
        }
        this.responder = clz -> {
            if (clz != null) {
                FakeAnimation fakeAnim = this.fakeAnimations.get(this.animationGrid.getRowposition());
                fakeAnim.setAnimationClass((FakeAnimation.AnimationType)((Object)clz));
                this.rearrangeComponents((FakeAnimation.AnimationType)((Object)clz));
            }
        };
        this.animationType = new ComboBox<FakeAnimation.AnimationType>(this, this.f_96547_, 0, 124, 100, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, 8, (Component)Component.m_237115_((String)"datapack_edit.import_animation.type"), List.of(FakeAnimation.AnimationType.values()), type -> type.toString(), this.responder);
        for (PackEntry<FakeAnimation, ClipHoldingAnimation> entry : this.userAnimations.values()) {
            this.animationGrid.addRowWithDefaultValues("animation_name", entry.getKey().getParameter("path"));
        }
    }

    public void rearrangeComponents(FakeAnimation.AnimationType animationClass) {
        ScreenRectangle screenRect = this.m_264198_();
        this.modelPreviewer.setCollider(null);
        this.modelPreviewer.setColliderJoint(null);
        this.modelPreviewer.clearAnimations();
        this.modelPreviewer.addAnimationToPlay(this.fakeAnimations.get(this.animationGrid.getRowposition()));
        this.inputComponentsList.clearComponents();
        this.inputComponentsList.newRow();
        this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(4), 85, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.import_animation.type"));
        this.inputComponentsList.addComponentCurrentRow(this.animationType.relocateX(screenRect, this.inputComponentsList.nextStart(5)));
        if (animationClass != null) {
            switch (animationClass) {
                case STATIC: 
                case MOVEMENT: {
                    ResizableEditBox convertTime = new ResizableEditBox(this.f_96547_, 0, 35, 0, 15, (Component)Component.m_237115_((String)"datapack_edit.import_animation.convert_time"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                    Boolean isRepeat = (Boolean)this.fakeAnimations.get(this.animationGrid.getRowposition()).getParameter("isRepeat");
                    if (isRepeat == null) {
                        isRepeat = false;
                    }
                    CheckBox repeat = new CheckBox(this.f_96547_, 0, 60, 0, 10, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, isRepeat, (Component)Component.m_237113_((String)""), value -> this.fakeAnimations.get(this.animationGrid.getRowposition()).setParameter("isRepeat", value));
                    convertTime.m_94151_(input -> {
                        Float f = StringUtil.isNullOrEmpty((String)input) ? null : Float.valueOf(input);
                        this.fakeAnimations.get(this.animationGrid.getRowposition()).setParameter("convertTime", f);
                    });
                    convertTime.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Float::parseFloat));
                    this.inputComponentsList.newRow();
                    this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(4), 85, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.import_animation.convert_time"));
                    this.inputComponentsList.addComponentCurrentRow(convertTime.relocateX(screenRect, this.inputComponentsList.nextStart(5)));
                    this.inputComponentsList.newRow();
                    this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(4), 85, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.import_animation.repeat"));
                    this.inputComponentsList.addComponentCurrentRow(repeat.relocateX(screenRect, this.inputComponentsList.nextStart(5)));
                    this.inputComponentsList.newRow();
                    this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(4), 85, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.import_animation.client_data"));
                    this.inputComponentsList.addComponentCurrentRow(SubScreenOpenButton.builder().subScreen(() -> new StaticAnimationPropertyScreen(this, this.fakeAnimations.get(this.animationGrid.getRowposition()))).bounds(this.inputComponentsList.nextStart(4), 0, 15, 15).build());
                    break;
                }
                case LONG_HIT: 
                case SHORT_HIT: 
                case KNOCK_DOWN: {
                    ResizableEditBox convertTime = new ResizableEditBox(this.f_96547_, 0, 35, 0, 15, (Component)Component.m_237115_((String)"datapack_edit.import_animation.convert_time"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                    convertTime.m_94151_(input -> {
                        Float f = StringUtil.isNullOrEmpty((String)input) ? null : Float.valueOf(input);
                        this.fakeAnimations.get(this.animationGrid.getRowposition()).setParameter("convertTime", f);
                    });
                    convertTime.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Float::parseFloat));
                    this.inputComponentsList.newRow();
                    this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(4), 85, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.import_animation.convert_time"));
                    this.inputComponentsList.addComponentCurrentRow(convertTime.relocateX(screenRect, this.inputComponentsList.nextStart(5)));
                    break;
                }
                case ATTACK: 
                case BASIC_ATTACK: {
                    this.modelPreviewer.setCollider(ColliderPreset.FIST);
                    ResizableEditBox convertTime = new ResizableEditBox(this.f_96547_, 0, 35, 0, 15, (Component)Component.m_237115_((String)"datapack_edit.import_animation.convert_time"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                    convertTime.m_94151_(input -> {
                        Float f = StringUtil.isNullOrEmpty((String)input) ? null : Float.valueOf(input);
                        this.fakeAnimations.get(this.animationGrid.getRowposition()).setParameter("convertTime", f);
                    });
                    convertTime.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Float::parseFloat));
                    ResizableEditBox antic = new ResizableEditBox(this.f_96547_, 0, 35, 0, 15, (Component)Component.m_237115_((String)"datapack_edit.import_animation.antic"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                    ResizableEditBox preDelay = new ResizableEditBox(this.f_96547_, 0, 35, 0, 15, (Component)Component.m_237115_((String)"datapack_edit.import_animation.preDelay"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                    ResizableEditBox contact = new ResizableEditBox(this.f_96547_, 0, 35, 0, 15, (Component)Component.m_237115_((String)"datapack_edit.import_animation.contact"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                    ResizableEditBox recovery = new ResizableEditBox(this.f_96547_, 0, 35, 0, 15, (Component)Component.m_237115_((String)"datapack_edit.import_animation.recovery"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                    ResizableEditBox colliderCount = new ResizableEditBox(this.f_96547_, 0, 40, 0, 15, (Component)Component.m_237115_((String)"datapack_edit.collider.count"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                    ResizableEditBox colliderCenterX = new ResizableEditBox(this.f_96547_, 0, 35, 0, 15, (Component)Component.m_237115_((String)"datapack_edit.collider.center.x"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                    ResizableEditBox colliderCenterY = new ResizableEditBox(this.f_96547_, 0, 35, 0, 15, (Component)Component.m_237115_((String)"datapack_edit.collider.center.y"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                    ResizableEditBox colliderCenterZ = new ResizableEditBox(this.f_96547_, 0, 35, 0, 15, (Component)Component.m_237115_((String)"datapack_edit.collider.center.z"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                    ResizableEditBox colliderSizeX = new ResizableEditBox(this.f_96547_, 0, 35, 0, 15, (Component)Component.m_237115_((String)"datapack_edit.collider.size.x"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                    ResizableEditBox colliderSizeY = new ResizableEditBox(this.f_96547_, 0, 35, 0, 15, (Component)Component.m_237115_((String)"datapack_edit.collider.size.y"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                    ResizableEditBox colliderSizeZ = new ResizableEditBox(this.f_96547_, 0, 35, 0, 15, (Component)Component.m_237115_((String)"datapack_edit.collider.size.z"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
                    ComboBox<Joint> colliderJoint = new ComboBox<Joint>(this, this.f_96547_, 0, 124, 100, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, 8, (Component)Component.m_237115_((String)"datapack_edit.import_animation.joint"), this.modelPreviewer.getArmature().getRootJoint().getAllJoints(), Joint::getName, null);
                    ComboBox<InteractionHand> interactionHand = new ComboBox<InteractionHand>(this, this.f_96547_, 0, 124, 100, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, 8, (Component)Component.m_237115_((String)"datapack_edit.import_animation.hand"), List.of(InteractionHand.MAIN_HAND, InteractionHand.OFF_HAND), ParseUtil::snakeToSpacedCamel, null);
                    PopupBox.ColliderPopupBox colliderPopup = new PopupBox.ColliderPopupBox(this, this.f_96547_, 0, 30, 130, 15, ResizableComponent.HorizontalSizing.LEFT_RIGHT, null, (Component)Component.m_237115_((String)"datapack_edit.collider"), null);
                    antic._setActive(false);
                    preDelay._setActive(false);
                    contact._setActive(false);
                    recovery._setActive(false);
                    colliderCount._setActive(false);
                    colliderCenterX._setActive(false);
                    colliderCenterY._setActive(false);
                    colliderCenterZ._setActive(false);
                    colliderSizeX._setActive(false);
                    colliderSizeY._setActive(false);
                    colliderSizeZ._setActive(false);
                    colliderJoint._setActive(false);
                    interactionHand._setActive(false);
                    colliderPopup._setActive(false);
                    Grid phasesGrid = Grid.builder(this, this.f_96541_).xy1(8, 0).xy2(12, 80).horizontalSizing(ResizableComponent.HorizontalSizing.LEFT_RIGHT).rowHeight(26).rowEditable(Grid.GridBuilder.RowEditButton.ADD_REMOVE).transparentBackground(false).rowpositionChanged((rowposition, values) -> {
                        FakeAnimation fakeAnimation = this.fakeAnimations.get(this.animationGrid.getRowposition());
                        ListTag phases = (ListTag)fakeAnimation.getParameter("phases");
                        CompoundTag tag = phases.m_128728_(rowposition.intValue());
                        antic.m_94144_(tag.m_128441_("antic") ? ParseUtil.valueOfOmittingType(tag.m_128423_("antic").m_7916_()) : "");
                        preDelay.m_94144_(tag.m_128441_("preDelay") ? ParseUtil.valueOfOmittingType(tag.m_128423_("preDelay").m_7916_()) : "");
                        contact.m_94144_(tag.m_128441_("contact") ? ParseUtil.valueOfOmittingType(tag.m_128423_("contact").m_7916_()) : "");
                        recovery.m_94144_(tag.m_128441_("recovery") ? ParseUtil.valueOfOmittingType(tag.m_128423_("recovery").m_7916_()) : "");
                        if (tag.m_128441_("joint")) {
                            String armature$joint = tag.m_128461_("joint");
                            String joinName = armature$joint.substring(armature$joint.lastIndexOf(46) + 1);
                            colliderJoint._setValue(this.modelPreviewer.getArmature().searchJointByName(joinName));
                        } else {
                            colliderJoint._setValue(null);
                        }
                        interactionHand._setValue(tag.m_128441_("hand") ? InteractionHand.valueOf((String)tag.m_128461_("hand")) : null);
                        if (tag.m_128441_("collider")) {
                            CompoundTag colliderTag = tag.m_128469_("collider");
                            colliderCount.m_94144_(ParseUtil.valueOfOmittingType(colliderTag.m_128423_("number")));
                            colliderCenterX.m_94144_(ParseUtil.valueOfOmittingType(colliderTag.m_128437_("center", 6).get(0)));
                            colliderCenterY.m_94144_(ParseUtil.valueOfOmittingType(colliderTag.m_128437_("center", 6).get(1)));
                            colliderCenterZ.m_94144_(ParseUtil.valueOfOmittingType(colliderTag.m_128437_("center", 6).get(2)));
                            colliderSizeX.m_94144_(ParseUtil.valueOfOmittingType(colliderTag.m_128437_("size", 6).get(0)));
                            colliderSizeY.m_94144_(ParseUtil.valueOfOmittingType(colliderTag.m_128437_("size", 6).get(1)));
                            colliderSizeZ.m_94144_(ParseUtil.valueOfOmittingType(colliderTag.m_128437_("size", 6).get(2)));
                        } else {
                            colliderPopup._setValue(null);
                            colliderCount.m_94144_("");
                            colliderCenterX.m_94144_("");
                            colliderCenterY.m_94144_("");
                            colliderCenterZ.m_94144_("");
                            colliderSizeX.m_94144_("");
                            colliderSizeY.m_94144_("");
                            colliderSizeZ.m_94144_("");
                        }
                        if (rowposition > -1) {
                            antic._setActive(true);
                            preDelay._setActive(true);
                            contact._setActive(true);
                            recovery._setActive(true);
                            colliderCount._setActive(true);
                            colliderCenterX._setActive(true);
                            colliderCenterY._setActive(true);
                            colliderCenterZ._setActive(true);
                            colliderSizeX._setActive(true);
                            colliderSizeY._setActive(true);
                            colliderSizeZ._setActive(true);
                            colliderJoint._setActive(true);
                            interactionHand._setActive(true);
                            colliderPopup._setActive(true);
                        }
                    }).addColumn(Grid.editbox("phase").editable(false).width(200)).pressAdd((grid, button) -> {
                        FakeAnimation fakeAnimation = this.fakeAnimations.get(this.animationGrid.getRowposition());
                        ListTag phases = (ListTag)fakeAnimation.getParameter("phases");
                        if (phases.isEmpty()) {
                            antic._setActive(true);
                            preDelay._setActive(true);
                            contact._setActive(true);
                            recovery._setActive(true);
                            colliderCount._setActive(true);
                            colliderCenterX._setActive(true);
                            colliderCenterY._setActive(true);
                            colliderCenterZ._setActive(true);
                            colliderSizeX._setActive(true);
                            colliderSizeY._setActive(true);
                            colliderSizeZ._setActive(true);
                            colliderJoint._setActive(true);
                            interactionHand._setActive(true);
                            colliderPopup._setActive(true);
                        }
                        phases.add((Object)new CompoundTag());
                        int rowposition = grid.addRowWithDefaultValues("phase", String.format("Phase%d", grid.m_6702_().size()));
                        grid.setGridFocus(rowposition, "phase");
                    }).pressRemove((grid, button) -> grid.removeRow(removedRow -> {
                        ListTag phases = (ListTag)this.fakeAnimations.get(this.animationGrid.getRowposition()).getParameter("phases");
                        for (int i = 0; i < grid.m_6702_().size(); ++i) {
                            grid.setValue(i, "phase", "Phase" + i);
                        }
                        phases.remove(removedRow);
                        if (phases.isEmpty()) {
                            antic._setActive(false);
                            preDelay._setActive(false);
                            contact._setActive(false);
                            recovery._setActive(false);
                            colliderCount._setActive(false);
                            colliderCenterX._setActive(false);
                            colliderCenterY._setActive(false);
                            colliderCenterZ._setActive(false);
                            colliderSizeX._setActive(false);
                            colliderSizeY._setActive(false);
                            colliderSizeZ._setActive(false);
                            colliderJoint._setActive(false);
                            interactionHand._setActive(false);
                            colliderPopup._setActive(false);
                        }
                    })).build();
                    antic.m_94151_(input -> {
                        if (!StringUtil.isNullOrEmpty((String)input)) {
                            ListTag phases = (ListTag)this.fakeAnimations.get(this.animationGrid.getRowposition()).getParameter("phases");
                            CompoundTag phaseTag = phases.m_128728_(phasesGrid.getRowposition());
                            phaseTag.m_128350_("antic", Float.valueOf(input).floatValue());
                        }
                    });
                    preDelay.m_94151_(input -> {
                        if (!StringUtil.isNullOrEmpty((String)input)) {
                            ListTag phases = (ListTag)this.fakeAnimations.get(this.animationGrid.getRowposition()).getParameter("phases");
                            CompoundTag phaseTag = phases.m_128728_(phasesGrid.getRowposition());
                            float f = Float.valueOf(input).floatValue();
                            phaseTag.m_128350_("preDelay", f);
                            this.modelPreviewer.setAttackTimeBegin(f);
                        }
                    });
                    contact.m_94151_(input -> {
                        if (!StringUtil.isNullOrEmpty((String)input)) {
                            ListTag phases = (ListTag)this.fakeAnimations.get(this.animationGrid.getRowposition()).getParameter("phases");
                            CompoundTag phaseTag = phases.m_128728_(phasesGrid.getRowposition());
                            float f = Float.valueOf(input).floatValue();
                            phaseTag.m_128350_("contact", f);
                            this.modelPreviewer.setAttackTimeEnd(f);
                        }
                    });
                    recovery.m_94151_(input -> {
                        if (!StringUtil.isNullOrEmpty((String)input)) {
                            ListTag phases = (ListTag)this.fakeAnimations.get(this.animationGrid.getRowposition()).getParameter("phases");
                            CompoundTag phaseTag = phases.m_128728_(phasesGrid.getRowposition());
                            phaseTag.m_128350_("recovery", Float.valueOf(input).floatValue());
                        }
                    });
                    antic.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Float::parseFloat));
                    preDelay.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Float::parseFloat));
                    contact.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Float::parseFloat));
                    recovery.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Float::parseFloat));
                    Runnable setCollider = () -> {
                        CompoundTag tag = new CompoundTag();
                        if (ParseUtil.isParsable(colliderCount.m_94155_(), Integer::parseInt)) {
                            tag.m_128405_("number", Integer.parseInt(colliderCount.m_94155_()));
                        }
                        ListTag center = new ListTag();
                        if (ParseUtil.isParsable(colliderCenterX.m_94155_(), Double::parseDouble)) {
                            center.add((Object)DoubleTag.m_128500_((double)Double.parseDouble(colliderCenterX.m_94155_())));
                        }
                        if (ParseUtil.isParsable(colliderCenterY.m_94155_(), Double::parseDouble)) {
                            center.add((Object)DoubleTag.m_128500_((double)Double.parseDouble(colliderCenterY.m_94155_())));
                        }
                        if (ParseUtil.isParsable(colliderCenterZ.m_94155_(), Double::parseDouble)) {
                            center.add((Object)DoubleTag.m_128500_((double)Double.parseDouble(colliderCenterZ.m_94155_())));
                        }
                        tag.m_128365_("center", (Tag)center);
                        ListTag size = new ListTag();
                        if (ParseUtil.isParsable(colliderSizeX.m_94155_(), Double::parseDouble)) {
                            size.add((Object)DoubleTag.m_128500_((double)Double.parseDouble(colliderSizeX.m_94155_())));
                        }
                        if (ParseUtil.isParsable(colliderSizeY.m_94155_(), Double::parseDouble)) {
                            size.add((Object)DoubleTag.m_128500_((double)Double.parseDouble(colliderSizeY.m_94155_())));
                        }
                        if (ParseUtil.isParsable(colliderSizeZ.m_94155_(), Double::parseDouble)) {
                            size.add((Object)DoubleTag.m_128500_((double)Double.parseDouble(colliderSizeZ.m_94155_())));
                        }
                        tag.m_128365_("size", (Tag)size);
                        FakeAnimation fakeAnimation = this.fakeAnimations.get(this.animationGrid.getRowposition());
                        ListTag phases = (ListTag)fakeAnimation.getParameter("phases");
                        CompoundTag phaseTag = phases.m_128728_(phasesGrid.getRowposition());
                        try {
                            Collider collider = ColliderPreset.deserializeSimpleCollider(tag);
                            phaseTag.m_128365_("collider", (Tag)tag);
                            this.modelPreviewer.setCollider(collider);
                        }
                        catch (Exception e) {
                            phaseTag.m_128473_("collider");
                            this.modelPreviewer.setCollider(ColliderPreset.FIST);
                        }
                    };
                    colliderCount.m_94151_(input -> setCollider.run());
                    colliderCenterX.m_94151_(input -> setCollider.run());
                    colliderCenterY.m_94151_(input -> setCollider.run());
                    colliderCenterZ.m_94151_(input -> setCollider.run());
                    colliderSizeX.m_94151_(input -> setCollider.run());
                    colliderSizeY.m_94151_(input -> setCollider.run());
                    colliderSizeZ.m_94151_(input -> setCollider.run());
                    colliderCount.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Integer::parseInt));
                    colliderCenterX.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
                    colliderCenterY.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
                    colliderCenterZ.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsableAllowingMinus(context, Double::parseDouble));
                    colliderSizeX.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Double::parseDouble));
                    colliderSizeY.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Double::parseDouble));
                    colliderSizeZ.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Double::parseDouble));
                    colliderJoint._setResponder(joint -> {
                        if (joint != null) {
                            ListTag phases = (ListTag)this.fakeAnimations.get(this.animationGrid.getRowposition()).getParameter("phases");
                            CompoundTag phaseTag = phases.m_128728_(phasesGrid.getRowposition());
                            phaseTag.m_128359_("joint", this.modelPreviewer.getArmature().toString() + "." + joint.getName());
                            this.modelPreviewer.setColliderJoint((Joint)joint);
                        }
                    });
                    interactionHand._setResponder(hand -> {
                        if (hand != null) {
                            ListTag phases = (ListTag)this.fakeAnimations.get(this.animationGrid.getRowposition()).getParameter("phases");
                            CompoundTag phaseTag = phases.m_128728_(phasesGrid.getRowposition());
                            phaseTag.m_128359_("hand", hand.toString());
                        }
                    });
                    colliderPopup._setResponder(pair -> {
                        if (pair.getSecond() != null) {
                            ListTag phases = (ListTag)this.fakeAnimations.get(this.animationGrid.getRowposition()).getParameter("phases");
                            CompoundTag phaseTag = phases.m_128728_(phasesGrid.getRowposition());
                            CompoundTag colliderTag = new CompoundTag();
                            ((Collider)pair.getSecond()).serialize(colliderTag);
                            colliderCount.m_94144_(String.valueOf(colliderTag.m_128451_("number")));
                            ListTag centerVec = colliderTag.m_128437_("center", 6);
                            colliderCenterX.m_94144_(String.valueOf(centerVec.m_128772_(0)));
                            colliderCenterY.m_94144_(String.valueOf(centerVec.m_128772_(1)));
                            colliderCenterZ.m_94144_(String.valueOf(centerVec.m_128772_(2)));
                            ListTag sizeVec = colliderTag.m_128437_("size", 6);
                            colliderSizeX.m_94144_(String.valueOf(sizeVec.m_128772_(0)));
                            colliderSizeY.m_94144_(String.valueOf(sizeVec.m_128772_(1)));
                            colliderSizeZ.m_94144_(String.valueOf(sizeVec.m_128772_(2)));
                            phaseTag.m_128365_("collider", (Tag)colliderTag);
                            this.modelPreviewer.setCollider((Collider)pair.getSecond(), (Joint)colliderJoint._getValue());
                        } else {
                            this.modelPreviewer.setCollider(ColliderPreset.FIST);
                        }
                    });
                    colliderPopup.applyFilter(collider -> collider instanceof OBBCollider || collider instanceof MultiOBBCollider);
                    this.inputComponentsList.newRow();
                    this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(4), 85, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.import_animation.convert_time"));
                    this.inputComponentsList.addComponentCurrentRow(convertTime.relocateX(screenRect, this.inputComponentsList.nextStart(5)));
                    this.inputComponentsList.newRow();
                    this.inputComponentsList.addComponentCurrentRow(new RowSpliter(this.inputComponentsList.nextStart(5), 10, 60, 15, ResizableComponent.HorizontalSizing.LEFT_RIGHT, null));
                    this.inputComponentsList.newRow();
                    this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(4), 85, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.import_animation.phases"));
                    this.inputComponentsList.newRow();
                    this.inputComponentsList.newRow();
                    this.inputComponentsList.addComponentCurrentRow(phasesGrid);
                    this.inputComponentsList.newRow();
                    this.inputComponentsList.newRow();
                    this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(4), 85, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.import_animation.antic"));
                    this.inputComponentsList.addComponentCurrentRow(antic.relocateX(screenRect, this.inputComponentsList.nextStart(5)));
                    this.inputComponentsList.newRow();
                    this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(4), 85, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.import_animation.pre_delay"));
                    this.inputComponentsList.addComponentCurrentRow(preDelay.relocateX(screenRect, this.inputComponentsList.nextStart(5)));
                    this.inputComponentsList.newRow();
                    this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(4), 85, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.import_animation.contact"));
                    this.inputComponentsList.addComponentCurrentRow(contact.relocateX(screenRect, this.inputComponentsList.nextStart(5)));
                    this.inputComponentsList.newRow();
                    this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(4), 85, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.import_animation.recovery"));
                    this.inputComponentsList.addComponentCurrentRow(recovery.relocateX(screenRect, this.inputComponentsList.nextStart(5)));
                    this.inputComponentsList.newRow();
                    this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(4), 85, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.import_animation.hand"));
                    this.inputComponentsList.addComponentCurrentRow(interactionHand.relocateX(screenRect, this.inputComponentsList.nextStart(5)));
                    this.inputComponentsList.newRow();
                    this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(4), 85, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.import_animation.collider"));
                    this.inputComponentsList.addComponentCurrentRow(colliderPopup.relocateX(screenRect, this.inputComponentsList.nextStart(5)));
                    this.inputComponentsList.newRow();
                    this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(20), 40, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.collider.count"));
                    this.inputComponentsList.addComponentCurrentRow(colliderCount.relocateX(screenRect, this.inputComponentsList.nextStart(5)));
                    this.inputComponentsList.newRow();
                    this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(20), 40, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.m_237115_((String)"datapack_edit.collider.center")));
                    this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(5), 8, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.m_237113_((String)"X: ")));
                    this.inputComponentsList.addComponentCurrentRow(colliderCenterX.relocateX(screenRect, this.inputComponentsList.nextStart(5)));
                    this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(8), 8, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.m_237113_((String)"Y: ")));
                    this.inputComponentsList.addComponentCurrentRow(colliderCenterY.relocateX(screenRect, this.inputComponentsList.nextStart(5)));
                    this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(8), 8, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.m_237113_((String)"Z: ")));
                    this.inputComponentsList.addComponentCurrentRow(colliderCenterZ.relocateX(screenRect, this.inputComponentsList.nextStart(5)));
                    this.inputComponentsList.newRow();
                    this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(20), 40, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.m_237115_((String)"datapack_edit.collider.size")));
                    this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(5), 8, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.m_237113_((String)"X: ")));
                    this.inputComponentsList.addComponentCurrentRow(colliderSizeX.relocateX(screenRect, this.inputComponentsList.nextStart(5)));
                    this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(8), 8, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.m_237113_((String)"Y: ")));
                    this.inputComponentsList.addComponentCurrentRow(colliderSizeY.relocateX(screenRect, this.inputComponentsList.nextStart(5)));
                    this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(8), 8, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.m_237113_((String)"Z: ")));
                    this.inputComponentsList.addComponentCurrentRow(colliderSizeZ.relocateX(screenRect, this.inputComponentsList.nextStart(5)));
                    this.inputComponentsList.newRow();
                    this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(4), 85, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.import_animation.joint"));
                    this.inputComponentsList.addComponentCurrentRow(colliderJoint.relocateX(screenRect, this.inputComponentsList.nextStart(5)));
                    this.inputComponentsList.newRow();
                    this.inputComponentsList.addComponentCurrentRow(new RowSpliter(this.inputComponentsList.nextStart(5), 10, 60, 15, ResizableComponent.HorizontalSizing.LEFT_RIGHT, null));
                    this.inputComponentsList.newRow();
                    this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(4), 85, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.import_animation.client_data"));
                    this.inputComponentsList.addComponentCurrentRow(SubScreenOpenButton.builder().subScreen(() -> new AttackAnimationPropertyScreen(this, this.fakeAnimations.get(this.animationGrid.getRowposition()), this.modelPreviewer.getArmature().rootJoint.getAllJoints(), this.modelPreviewer)).bounds(this.inputComponentsList.nextStart(4), 0, 15, 15).build());
                }
            }
        }
        this.inputComponentsList.newRow();
        this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(4), 60, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, (Component)Component.m_237115_((String)"datapack_edit.import_animation.preview")));
        this.inputComponentsList.newRow();
        this.inputComponentsList.newRow();
        this.inputComponentsList.newRow();
        int split = screenRect.f_263770_() / 2 - 60;
        this.inputComponentsList.addComponentCurrentRow(this.modelPreviewer);
        this.inputComponentsList.newRow();
        this.inputComponentsList.newRow();
        this.inputComponentsList.m_93437_(screenRect.f_263770_() - (split + 8), screenRect.f_263800_() - 21, screenRect.m_274449_() + 14, screenRect.m_274349_() - 36);
        this.inputComponentsList.m_93507_(split + 2);
    }

    protected void m_7856_() {
        ScreenRectangle screenRect = this.m_264198_();
        int split = screenRect.f_263770_() / 2 - 60;
        this.animationGrid.m_93437_(split - 10, screenRect.f_263800_() - 21, screenRect.m_274449_() + 14, screenRect.m_274349_() - 36);
        this.animationGrid.m_93507_(8);
        this.animationGrid.resize(screenRect);
        this.inputComponentsList.m_93437_(screenRect.f_263770_() - (split + 8), screenRect.f_263800_() - 21, screenRect.m_274449_() + 14, screenRect.m_274349_() - 36);
        this.inputComponentsList.m_93507_(split + 2);
        this.m_142416_(this.animationGrid);
        this.m_142416_((GuiEventListener)this.inputComponentsList);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_286989_, button -> {
            String errorMessage = this.createRealAnimations(this.fakeAnimations);
            if (errorMessage != null) {
                this.f_96541_.m_91152_(new MessageScreen("Failed to import the animations", errorMessage, this, button2 -> this.f_96541_.m_91152_((Screen)this), 300, 70).autoCalculateHeight());
            } else {
                this.m_7379_();
            }
        }).m_252794_(this.f_96543_ / 2 - 162, this.f_96544_ - 28).m_253046_(160, 21).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> this.f_96541_.m_91152_(new MessageScreen("", "Do you want to quit without saving changes?", this, button2 -> this.m_7379_(), button2 -> this.f_96541_.m_91152_((Screen)this), 180, 70))).m_252794_(this.f_96543_ / 2 + 2, this.f_96544_ - 28).m_253046_(160, 21).m_253136_());
    }

    public void m_86600_() {
        this.animationGrid._tick();
        this.inputComponentsList.tick();
    }

    public void m_7379_() {
        this.caller.refreshAnimationList();
        this.f_96541_.m_91152_((Screen)this.caller);
        this.modelPreviewer.onDestroy();
    }

    public void m_7400_(List<Path> paths) {
        this.f_96541_.m_91152_(new MessageScreen<String>("", "Enter the mod id", this, modid -> {
            this.animationGrid.setValueChangeEnabled(false);
            for (Path path : paths) {
                InputStream stream = null;
                try {
                    File file = path.toFile();
                    stream = new FileInputStream(file);
                    JsonModelLoader jsonLoader = new JsonModelLoader(stream, new ResourceLocation(modid, file.getName()));
                    String armatureName = this.modelPreviewer.getArmature().toString();
                    armatureName = armatureName.substring(armatureName.indexOf(":") + 1);
                    String animationPath = modid + ":" + armatureName.substring(armatureName.lastIndexOf("/") + 1) + "/" + file.getName().replace(".json", "");
                    FakeAnimation animation = new FakeAnimation(animationPath, this.modelPreviewer.getArmature(), jsonLoader.loadAnimationClip(this.modelPreviewer.getArmature()), jsonLoader.getRootJson().getAsJsonArray("animation"));
                    this.fakeAnimations.add(animation);
                    this.animationGrid.addRowWithDefaultValues("animation_name", animationPath);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.animationGrid.setValueChangeEnabled(true);
            this.f_96541_.m_91152_((Screen)this);
        }, button -> this.f_96541_.m_91152_((Screen)this), new ResizableEditBox(this.f_96541_.f_91062_, 0, 0, 0, 16, (Component)Component.m_237113_((String)"datapack_edit.import_animation.input"), null, null), 120, 80));
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.modelPreviewer.m_7979_(mouseX, mouseY, button, dx, dy)) {
            return true;
        }
        if (this.inputComponentsList.m_7979_(mouseX, mouseY, button, dx, dy)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dx, dy);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280039_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private String createRealAnimations(List<FakeAnimation> fakeAnimations) {
        this.userAnimations.forEach((name, animation) -> AnimationManager.getInstance().removeUserAnimation((ClipHoldingAnimation)animation.getValue()));
        this.userAnimations.clear();
        StringBuilder sb = new StringBuilder();
        boolean hasException = false;
        List<Object> uniquepaths = fakeAnimations.stream().map(fakeAnim -> fakeAnim.getParameter("path")).distinct().toList();
        if (uniquepaths.size() != fakeAnimations.size()) {
            hasException = true;
            sb.append("Duplicated animation path.");
        } else {
            for (FakeAnimation fakeAnimation : fakeAnimations) {
                try {
                    ClipHoldingAnimation result = fakeAnimation.createAnimation();
                    this.userAnimations.put(fakeAnimation.getRegistryName(), PackEntry.ofValue(fakeAnimation, result));
                    AnimationManager.getInstance().registerUserAnimation(result);
                }
                catch (Throwable e) {
                    hasException = true;
                    sb.append(String.format("%s : %s\n", fakeAnimation.getParameter("path"), e.getMessage()));
                    e.printStackTrace();
                }
            }
        }
        if (hasException) {
            return sb.toString();
        }
        return null;
    }
}

