/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.api.utils.math.Vec2i;
import yesman.epicfight.client.gui.EntityIndicator;
import yesman.epicfight.client.gui.ModIngameGui;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.config.EpicFightOptions;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;

@OnlyIn(value=Dist.CLIENT)
public class BattleModeGui
extends ModIngameGui {
    private static final Vec2f[] CLOCK_POS = new Vec2f[]{new Vec2f(0.5f, 0.5f), new Vec2f(0.5f, 0.0f), new Vec2f(0.0f, 0.0f), new Vec2f(0.0f, 1.0f), new Vec2f(1.0f, 1.0f), new Vec2f(1.0f, 0.0f)};
    public Font font;
    private int sliding = 29;
    private boolean slidingToggle = false;
    private final List<SkillContainer> skillIcons = Lists.newLinkedList();
    private final EpicFightOptions config;

    public BattleModeGui(Minecraft minecraft) {
        this.font = minecraft.f_91062_;
        this.config = EpicFightMod.CLIENT_CONFIGS;
    }

    public void renderGui(LocalPlayerPatch playerpatch, GuiGraphics guiGraphics, float partialTicks) {
        float ratio;
        if (!((LocalPlayer)playerpatch.getOriginal()).m_6084_() || ((LocalPlayer)playerpatch.getOriginal()).m_20202_() != null) {
            return;
        }
        if (this.sliding > 28) {
            return;
        }
        if (this.sliding > 0) {
            this.sliding = this.slidingToggle ? (this.sliding -= 2) : (this.sliding += 2);
        }
        Window sr = Minecraft.m_91087_().m_91268_();
        int width = sr.m_85445_();
        int height = sr.m_85446_();
        boolean depthTestEnabled = GL11.glGetBoolean((int)2929);
        boolean blendEnabled = GL11.glGetBoolean((int)3042);
        if (depthTestEnabled) {
            RenderSystem.disableDepthTest();
        }
        if (!blendEnabled) {
            RenderSystem.enableBlend();
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_166856_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        float maxStamina = playerpatch.getMaxStamina();
        float stamina = playerpatch.getStamina();
        if (maxStamina > 0.0f && stamina < maxStamina) {
            Vec2i pos = this.config.getStaminaPosition(width, height);
            float prevStamina = playerpatch.getPrevStamina();
            ratio = (prevStamina + (stamina - prevStamina) * partialTicks) / maxStamina;
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, (float)this.sliding, 0.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)ratio, (float)0.25f, (float)1.0f);
            guiGraphics.m_280411_(EntityIndicator.BATTLE_ICON, pos.x, pos.y, 118, 4, 2.0f, 38.0f, 237, 9, 255, 255);
            guiGraphics.m_280411_(EntityIndicator.BATTLE_ICON, pos.x, pos.y, (int)(118.0f * ratio), 4, 2.0f, 47.0f, (int)(237.0f * ratio), 9, 255, 255);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85849_();
        }
        if (playerpatch.isChargingSkill()) {
            int chargeAmount = playerpatch.getChargingSkill().getChargingAmount(playerpatch);
            int prevChargingAmount = playerpatch.getPrevChargingAmount();
            ratio = Math.min(((float)prevChargingAmount + (float)(chargeAmount - prevChargingAmount) * partialTicks) / (float)playerpatch.getChargingSkill().getMaxChargingTicks(), 1.0f);
            Vec2i pos = this.config.getChargingBarPosition(width, height);
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, (float)this.sliding, 0.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280163_(EntityIndicator.BATTLE_ICON, pos.x, pos.y, 1.0f, 71.0f, 238, 13, 255, 255);
            guiGraphics.m_280163_(EntityIndicator.BATTLE_ICON, pos.x, pos.y, 1.0f, 57.0f, (int)(238.0f * ratio), 13, 255, 255);
            ResourceLocation rl = new ResourceLocation(playerpatch.getChargingSkill().toString());
            String skillName = Component.m_237115_((String)String.format("skill.%s.%s", rl.m_135827_(), rl.m_135815_())).getString();
            int stringWidth = this.font.m_92895_(skillName);
            guiGraphics.drawString(this.font, skillName, (float)(pos.x + 120) - (float)stringWidth * 0.5f, (float)(pos.y - 12), 0xFFFFFF, true);
            poseStack.m_85849_();
        }
        for (int i = 0; i < SkillSlot.ENUM_MANAGER.universalValues().size(); ++i) {
            SkillContainer container = playerpatch.getSkill(i);
            if (container.isEmpty() || this.skillIcons.contains(container) || !container.getSkill().shouldDraw(container)) continue;
            this.skillIcons.add(container);
        }
        this.skillIcons.removeIf(skillContainer -> skillContainer.isEmpty() || !skillContainer.getSkill().shouldDraw((SkillContainer)skillContainer));
        SkillContainer innateSkillContainer = playerpatch.getSkill(SkillSlots.WEAPON_INNATE);
        if (!innateSkillContainer.isEmpty()) {
            this.drawWeaponInnateIcon(playerpatch, playerpatch.getSkill(SkillSlots.WEAPON_INNATE), guiGraphics, partialTicks);
        }
        ClientConfig.AlignDirection alignDirection = this.config.passivesAlignDirection.getValue();
        ClientConfig.HorizontalBasis horBasis = this.config.passivesXBase.getValue();
        ClientConfig.VerticalBasis verBasis = this.config.passivesYBase.getValue();
        int passiveX = horBasis.positionGetter.apply(width, this.config.passivesX.getValue());
        int passiveY = verBasis.positionGetter.apply(height, this.config.passivesY.getValue());
        int icons = this.skillIcons.size();
        Vec2i slotCoord = alignDirection.startCoordGetter.get(passiveX, passiveY, 24, 24, icons, horBasis, verBasis);
        for (SkillContainer container : this.skillIcons) {
            Skill skill;
            if (container.isEmpty() || !(skill = container.getSkill()).shouldDraw(container)) continue;
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            skill.drawOnGui(this, container, guiGraphics, slotCoord.x, slotCoord.y);
            slotCoord = alignDirection.nextPositionGetter.getNext(horBasis, verBasis, slotCoord, 24, 24);
        }
        poseStack.m_85849_();
        if (depthTestEnabled) {
            RenderSystem.enableDepthTest();
        }
        if (!blendEnabled) {
            RenderSystem.disableBlend();
        }
    }

    private void drawWeaponInnateIcon(LocalPlayerPatch playerpatch, SkillContainer container, GuiGraphics guiGraphics, float partialTicks) {
        int stringWidth;
        int j;
        PoseStack poseStack = guiGraphics.m_280168_();
        Window sr = Minecraft.m_91087_().m_91268_();
        int width = sr.m_85445_();
        int height = sr.m_85446_();
        Vec2i pos = this.config.getWeaponInnatePosition(width, height);
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, (float)this.sliding, 0.0f);
        boolean creative = ((LocalPlayer)playerpatch.getOriginal()).m_7500_();
        boolean fullstack = creative || container.isFull();
        boolean canUse = !container.isDisabled() && container.getSkill().checkExecuteCondition(playerpatch);
        float cooldownRatio = fullstack || container.isActivated() ? 1.0f : container.getResource(partialTicks);
        int vertexNum = 0;
        float iconSize = 32.0f;
        float bottom = (float)pos.y + iconSize;
        float right = (float)pos.x + iconSize;
        float middle = (float)pos.x + iconSize * 0.5f;
        float lastVertexX = 0.0f;
        float lastVertexY = 0.0f;
        float lastTexX = 0.0f;
        float lastTexY = 0.0f;
        if (cooldownRatio < 0.125f) {
            vertexNum = 6;
            lastTexX = cooldownRatio / 0.25f;
            lastTexY = 0.0f;
            lastVertexX = middle + iconSize * lastTexX;
            lastVertexY = pos.y;
            lastTexX += 0.5f;
        } else if (cooldownRatio < 0.375f) {
            vertexNum = 5;
            lastTexX = 1.0f;
            lastTexY = (cooldownRatio - 0.125f) / 0.25f;
            lastVertexX = right;
            lastVertexY = (float)pos.y + iconSize * lastTexY;
        } else if (cooldownRatio < 0.625f) {
            vertexNum = 4;
            lastTexX = (cooldownRatio - 0.375f) / 0.25f;
            lastTexY = 1.0f;
            lastVertexX = right - iconSize * lastTexX;
            lastVertexY = bottom;
            lastTexX = 1.0f - lastTexX;
        } else if (cooldownRatio < 0.875f) {
            vertexNum = 3;
            lastTexX = 0.0f;
            lastTexY = (cooldownRatio - 0.625f) / 0.25f;
            lastVertexX = pos.x;
            lastVertexY = bottom - iconSize * lastTexY;
            lastTexY = 1.0f - lastTexY;
        } else {
            vertexNum = 2;
            lastTexX = (cooldownRatio - 0.875f) / 0.25f;
            lastTexY = 0.0f;
            lastVertexX = (float)pos.x + iconSize * lastTexX;
            lastVertexY = pos.y;
        }
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)container.getSkill().getSkillTexture());
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        if (canUse) {
            if (container.getStack() > 0) {
                RenderSystem.setShaderColor((float)0.0f, (float)0.64f, (float)0.72f, (float)0.8f);
            } else {
                RenderSystem.setShaderColor((float)0.0f, (float)0.5f, (float)0.5f, (float)0.6f);
            }
        } else {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.6f);
        }
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85817_);
        for (j = 0; j < vertexNum; ++j) {
            bufferbuilder.m_252986_(poseStack.m_85850_().m_252922_(), (float)pos.x + iconSize * BattleModeGui.CLOCK_POS[j].x, (float)pos.y + iconSize * BattleModeGui.CLOCK_POS[j].y, 0.0f).m_7421_(BattleModeGui.CLOCK_POS[j].x, BattleModeGui.CLOCK_POS[j].y).m_5752_();
        }
        bufferbuilder.m_252986_(poseStack.m_85850_().m_252922_(), lastVertexX, lastVertexY, 0.0f).m_7421_(lastTexX, lastTexY).m_5752_();
        tessellator.m_85914_();
        if (canUse) {
            RenderSystem.setShaderColor((float)0.08f, (float)0.79f, (float)0.95f, (float)1.0f);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glCullFace((int)1028);
        bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85817_);
        for (j = 0; j < 2; ++j) {
            bufferbuilder.m_252986_(poseStack.m_85850_().m_252922_(), (float)pos.x + iconSize * BattleModeGui.CLOCK_POS[j].x, (float)pos.y + iconSize * BattleModeGui.CLOCK_POS[j].y, 0.0f).m_7421_(BattleModeGui.CLOCK_POS[j].x, BattleModeGui.CLOCK_POS[j].y).m_5752_();
        }
        for (j = CLOCK_POS.length - 1; j >= vertexNum; --j) {
            bufferbuilder.m_252986_(poseStack.m_85850_().m_252922_(), (float)pos.x + iconSize * BattleModeGui.CLOCK_POS[j].x, (float)pos.y + iconSize * BattleModeGui.CLOCK_POS[j].y, 0.0f).m_7421_(BattleModeGui.CLOCK_POS[j].x, BattleModeGui.CLOCK_POS[j].y).m_5752_();
        }
        bufferbuilder.m_252986_(poseStack.m_85850_().m_252922_(), lastVertexX, lastVertexY, 0.0f).m_7421_(lastTexX, lastTexY).m_5752_();
        tessellator.m_85914_();
        GL11.glCullFace((int)1029);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (container.isActivated() && (container.getSkill().getActivateType() == Skill.ActivateType.DURATION || container.getSkill().getActivateType() == Skill.ActivateType.DURATION_INFINITE)) {
            String s = String.format("%.0f", Float.valueOf((float)container.getRemainDuration() / 20.0f));
            stringWidth = (this.font.m_92895_(s) - 6) / 3;
            guiGraphics.m_280056_(this.font, s, pos.x + 13 - stringWidth, pos.y + 13, 0xFFFFFF, true);
        } else if (!fullstack) {
            String s = String.valueOf((int)(cooldownRatio * 100.0f));
            stringWidth = (this.font.m_92895_(s) - 6) / 3;
            guiGraphics.m_280056_(this.font, s, pos.x + 13 - stringWidth, pos.y + 13, 0xFFFFFF, true);
        }
        if (container.getSkill().getMaxStack() > 1) {
            String s = String.valueOf(container.getStack());
            stringWidth = (this.font.m_92895_(s) - 6) / 3;
            guiGraphics.m_280056_(this.font, s, pos.x + 25 - stringWidth, pos.y + 22, 0xFFFFFF, true);
        }
        poseStack.m_85849_();
    }

    public void slideUp() {
        this.sliding = 28;
        this.slidingToggle = true;
    }

    public void slideDown() {
        this.sliding = 1;
        this.slidingToggle = false;
    }

    public void reset() {
        this.skillIcons.clear();
    }

    public int getSlidingProgression() {
        return this.sliding;
    }
}

