/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.model.transformer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.api.LayerFeatureTransformerAPI;
import dev.tr7zw.skinlayers.api.MeshTransformer;
import dev.tr7zw.skinlayers.api.SkinLayersAPI;
import dev.tr7zw.skinlayers.versionless.render.CustomModelPart;
import dev.tr7zw.skinlayers.versionless.render.CustomizableCube;
import dev.tr7zw.skinlayers.versionless.util.Direction;
import it.unimi.dsi.fastutil.ints.IntList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import yesman.epicfight.api.client.model.AnimatedMesh;
import yesman.epicfight.api.client.model.SingleGroupVertexBuilder;
import yesman.epicfight.api.client.model.transformer.HumanoidModelTransformer;
import yesman.epicfight.api.client.model.transformer.VanillaModelTransformer;
import yesman.epicfight.api.utils.math.QuaternionUtils;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.api.utils.math.Vec3f;

@OnlyIn(value=Dist.CLIENT)
public class SkinLayer3DTransformer
extends CustomizableCube {
    static final HumanoidModelTransformer.PartTransformer<CustomizableCube> HEAD = new SimpleTransformer(9);
    static final HumanoidModelTransformer.PartTransformer<CustomizableCube> LEFT_FEET = new SimpleTransformer(5);
    static final HumanoidModelTransformer.PartTransformer<CustomizableCube> RIGHT_FEET = new SimpleTransformer(2);
    static final HumanoidModelTransformer.PartTransformer<CustomizableCube> LEFT_ARM = new LimbPartTransformer(16, 17, 19, 19.0f, false);
    static final HumanoidModelTransformer.PartTransformer<CustomizableCube> RIGHT_ARM = new LimbPartTransformer(11, 12, 14, 19.0f, false);
    static final HumanoidModelTransformer.PartTransformer<CustomizableCube> LEFT_LEG = new LimbPartTransformer(4, 5, 6, 6.0f, true);
    static final HumanoidModelTransformer.PartTransformer<CustomizableCube> RIGHT_LEG = new LimbPartTransformer(1, 2, 3, 6.0f, true);
    static final HumanoidModelTransformer.PartTransformer<CustomizableCube> CHEST = new ChestPartTransformer(18.0f);
    private static Field customModelPart$x;
    private static Field customModelPart$y;
    private static Field customModelPart$z;
    private static Field customModelPart$xRot;
    private static Field customModelPart$yRot;
    private static Field customModelPart$zRot;
    private static Field customizableCube$polygons;

    private SkinLayer3DTransformer() {
        super(0, 0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false, 0.0f, 0.0f, new Direction[0], (Direction[][])new Direction[][]{new Direction[0]});
    }

    public static AnimatedMesh transformMesh(AbstractClientPlayer abstractClientPlayer, CustomModelPart skinlayerModelPart, ModelPart vanillaModelPart, PlayerModelPart modelPart, List<ModelPart.Cube> vanillaCubes, List<CustomizableCube> cubes) {
        ArrayList partitions = Lists.newArrayList();
        float widthScale = SkinLayersModBase.config.baseVoxelSize;
        float heightScale = 1.035f;
        switch (modelPart) {
            case JACKET: {
                partitions.add(new ModelPartition(VanillaModelTransformer.CHEST, CHEST, "jacket", skinlayerModelPart, vanillaModelPart, vanillaCubes, cubes, poseStack -> poseStack.m_85841_(SkinLayersModBase.config.bodyVoxelWidthSize, heightScale, widthScale)));
                break;
            }
            case LEFT_SLEEVE: {
                partitions.add(new ModelPartition(VanillaModelTransformer.LEFT_ARM, LEFT_ARM, "leftSleeve", skinlayerModelPart, vanillaModelPart, vanillaCubes, cubes, poseStack -> poseStack.m_85841_(widthScale, heightScale, widthScale)));
                break;
            }
            case RIGHT_SLEEVE: {
                partitions.add(new ModelPartition(VanillaModelTransformer.RIGHT_ARM, RIGHT_ARM, "rightSleeve", skinlayerModelPart, vanillaModelPart, vanillaCubes, cubes, poseStack -> poseStack.m_85841_(widthScale, heightScale, widthScale)));
                break;
            }
            case LEFT_PANTS_LEG: {
                partitions.add(new ModelPartition(VanillaModelTransformer.LEFT_LEG, LEFT_LEG, "leftPantsLeg", skinlayerModelPart, vanillaModelPart, vanillaCubes, cubes, poseStack -> poseStack.m_85841_(widthScale, heightScale, widthScale)));
                break;
            }
            case RIGHT_PANTS_LEG: {
                partitions.add(new ModelPartition(VanillaModelTransformer.RIGHT_LEG, RIGHT_LEG, "rightPantsLeg", skinlayerModelPart, vanillaModelPart, vanillaCubes, cubes, poseStack -> poseStack.m_85841_(widthScale, heightScale, widthScale)));
                break;
            }
            case HAT: {
                partitions.add(new ModelPartition(VanillaModelTransformer.HEAD, HEAD, "hat", skinlayerModelPart, vanillaModelPart, vanillaCubes, cubes, poseStack -> {
                    float headsize = SkinLayersModBase.config.headVoxelSize;
                    poseStack.m_85837_(0.0, -6.0, 0.0);
                    poseStack.m_85841_(headsize, headsize, headsize);
                    poseStack.m_85837_(0.0, 6.0, 0.0);
                    poseStack.m_85837_(0.0, -0.96, 0.0);
                }));
                break;
            }
            default: {
                return null;
            }
        }
        return SkinLayer3DTransformer.bakeMeshFromCubes(abstractClientPlayer, partitions);
    }

    private static AnimatedMesh bakeMeshFromCubes(AbstractClientPlayer abstractClientPlayer, List<ModelPartition> partitions) {
        ArrayList vertices = Lists.newArrayList();
        HashMap indices = Maps.newHashMap();
        PoseStack poseStack = new PoseStack();
        HumanoidModelTransformer.PartTransformer.IndexCounter indexCounter = new HumanoidModelTransformer.PartTransformer.IndexCounter();
        poseStack.m_252781_(QuaternionUtils.YP.rotationDegrees(180.0f));
        poseStack.m_252781_(QuaternionUtils.XP.rotationDegrees(180.0f));
        poseStack.m_252880_(0.0f, -24.0f, 0.0f);
        for (ModelPartition modelpartition : partitions) {
            SkinLayer3DTransformer.bake(abstractClientPlayer, poseStack, modelpartition, vertices, indices, indexCounter);
        }
        return SingleGroupVertexBuilder.loadVertexInformation(vertices, indices);
    }

    private static void bake(AbstractClientPlayer abstractClientPlayer, PoseStack poseStack, ModelPartition modelpartition, List<SingleGroupVertexBuilder> vertices, Map<String, IntList> indices, HumanoidModelTransformer.PartTransformer.IndexCounter indexCounter) {
        modelpartition.vanillaModelPart.m_171322_(modelpartition.vanillaModelPart.m_233566_());
        ModelPart part = modelpartition.vanillaModelPart;
        poseStack.m_85836_();
        poseStack.m_252880_(part.f_104200_, part.f_104201_, part.f_104202_);
        if (part.f_104203_ != 0.0f || part.f_104204_ != 0.0f || part.f_104205_ != 0.0f) {
            poseStack.m_252781_(new Quaternionf().rotationZYX(part.f_104205_, part.f_104204_, part.f_104203_));
        }
        if (part.f_233553_ != 1.0f || part.f_233554_ != 1.0f || part.f_233555_ != 1.0f) {
            poseStack.m_85841_(part.f_233553_, part.f_233554_, part.f_233555_);
        }
        MeshTransformer transformer = SkinLayersAPI.getMeshTransformerProvider().prepareTransformer(modelpartition.vanillaModelPart);
        LayerFeatureTransformerAPI.getTransformer().transform(abstractClientPlayer, poseStack, modelpartition.vanillaModelPart);
        modelpartition.transformFunction.accept(poseStack);
        float posX = 0.0f;
        float posY = 0.0f;
        float posZ = 0.0f;
        float xRot = 0.0f;
        float yRot = 0.0f;
        float zRot = 0.0f;
        try {
            posX = ((Float)customModelPart$x.get(modelpartition.skinlayerModelPart)).floatValue();
            posY = ((Float)customModelPart$y.get(modelpartition.skinlayerModelPart)).floatValue();
            posZ = ((Float)customModelPart$z.get(modelpartition.skinlayerModelPart)).floatValue();
            xRot = ((Float)customModelPart$xRot.get(modelpartition.skinlayerModelPart)).floatValue();
            yRot = ((Float)customModelPart$yRot.get(modelpartition.skinlayerModelPart)).floatValue();
            zRot = ((Float)customModelPart$zRot.get(modelpartition.skinlayerModelPart)).floatValue();
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            // empty catch block
        }
        poseStack.m_252880_(posX, posY, posZ);
        if (xRot != 0.0f || yRot != 0.0f || zRot != 0.0f) {
            poseStack.m_252781_(new Quaternionf().rotationZYX(zRot, yRot, xRot));
        }
        for (ModelPart.Cube cube : modelpartition.vanillaCubes) {
            transformer.transform(cube);
            modelpartition.vanillaPartTransformer.bakeCube(poseStack, modelpartition.partName, cube, vertices, indices, indexCounter);
        }
        for (CustomizableCube customizableCube : modelpartition.customizableCubes) {
            modelpartition.partTransformer.bakeCube(poseStack, modelpartition.partName, customizableCube, vertices, indices, indexCounter);
        }
        poseStack.m_85849_();
    }

    static net.minecraft.core.Direction getDirectionFromVector(float x, float y, float z) {
        for (net.minecraft.core.Direction direction : net.minecraft.core.Direction.values()) {
            Vector3f direcVec = new Vector3f(Float.compare(x, -0.0f) == 0 ? 0.0f : x, y, z);
            if (!direcVec.equals((Object)direction.m_253071_())) continue;
            return direction;
        }
        return null;
    }

    static Vector3f getClipPoint(Vector3f pos1, Vector3f pos2, float yClip) {
        Vector3f direct = new Vector3f((Vector3fc)pos2);
        direct.sub((Vector3fc)pos1);
        direct.mul((yClip - pos1.y()) / (pos2.y() - pos1.y()));
        Vector3f clipPoint = new Vector3f((Vector3fc)pos1);
        clipPoint.add((Vector3fc)direct);
        return clipPoint;
    }

    static ModelPart.Vertex getTranslatedVertex(CustomizableCube.Vertex original, Matrix4f matrix) {
        Vector4f translatedPosition = new Vector4f(original.pos.x, original.pos.y, original.pos.z, 1.0f);
        translatedPosition.mul((Matrix4fc)matrix);
        return new ModelPart.Vertex(translatedPosition.x(), translatedPosition.y(), translatedPosition.z(), original.u, original.v);
    }

    static {
        try {
            customModelPart$x = CustomModelPart.class.getDeclaredField("x");
            customModelPart$y = CustomModelPart.class.getDeclaredField("y");
            customModelPart$z = CustomModelPart.class.getDeclaredField("z");
            customModelPart$xRot = CustomModelPart.class.getDeclaredField("xRot");
            customModelPart$yRot = CustomModelPart.class.getDeclaredField("yRot");
            customModelPart$zRot = CustomModelPart.class.getDeclaredField("zRot");
            customizableCube$polygons = CustomizableCube.class.getDeclaredField("polygons");
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        customModelPart$x.setAccessible(true);
        customModelPart$y.setAccessible(true);
        customModelPart$z.setAccessible(true);
        customModelPart$xRot.setAccessible(true);
        customModelPart$yRot.setAccessible(true);
        customModelPart$zRot.setAccessible(true);
        customizableCube$polygons.setAccessible(true);
    }

    static class ModelPartition {
        final HumanoidModelTransformer.PartTransformer<ModelPart.Cube> vanillaPartTransformer;
        final HumanoidModelTransformer.PartTransformer<CustomizableCube> partTransformer;
        final String partName;
        final CustomModelPart skinlayerModelPart;
        final ModelPart vanillaModelPart;
        final List<ModelPart.Cube> vanillaCubes;
        final List<CustomizableCube> customizableCubes;
        final Consumer<PoseStack> transformFunction;

        private ModelPartition(HumanoidModelTransformer.PartTransformer<ModelPart.Cube> vanillaPartTransformer, HumanoidModelTransformer.PartTransformer<CustomizableCube> partTransformer, String partName, CustomModelPart skinlayerModelPart, ModelPart vanillaModelPart, List<ModelPart.Cube> vanillaCubes, List<CustomizableCube> customCubes, Consumer<PoseStack> transformFunction) {
            this.vanillaPartTransformer = vanillaPartTransformer;
            this.partTransformer = partTransformer;
            this.partName = partName;
            this.skinlayerModelPart = skinlayerModelPart;
            this.vanillaModelPart = vanillaModelPart;
            this.vanillaCubes = vanillaCubes;
            this.customizableCubes = customCubes;
            this.transformFunction = transformFunction;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class SimpleTransformer
    extends HumanoidModelTransformer.PartTransformer<CustomizableCube> {
        final int jointId;

        public SimpleTransformer(int jointId) {
            this.jointId = jointId;
        }

        @Override
        public void bakeCube(PoseStack poseStack, String partName, CustomizableCube cube, List<SingleGroupVertexBuilder> vertices, Map<String, IntList> indices, HumanoidModelTransformer.PartTransformer.IndexCounter indexCounter) {
            CustomizableCube.Polygon[] polygons = null;
            try {
                polygons = (CustomizableCube.Polygon[])customizableCube$polygons.get(cube);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
                return;
            }
            for (CustomizableCube.Polygon polygon : polygons) {
                if (polygon == null) continue;
                Vector3f norm = new Vector3f(polygon.normal.x, polygon.normal.y, polygon.normal.z);
                norm.mul((Matrix3fc)poseStack.m_85850_().m_252943_());
                for (CustomizableCube.Vertex vertex : polygon.vertices) {
                    Vector4f pos = new Vector4f(vertex.pos.x, vertex.pos.y, vertex.pos.z, 1.0f);
                    pos.mul((Matrix4fc)poseStack.m_85850_().m_252922_());
                    vertices.add(new SingleGroupVertexBuilder().setPosition(new Vec3f(pos.x(), pos.y(), pos.z()).scale(0.0625f)).setNormal(new Vec3f(norm.x(), norm.y(), norm.z())).setTextureCoordinate(new Vec2f(vertex.u, vertex.v)).setEffectiveJointIDs(new Vec3f(this.jointId, 0.0f, 0.0f)).setEffectiveJointWeights(new Vec3f(1.0f, 0.0f, 0.0f)).setEffectiveJointNumber(1));
                }
                SimpleTransformer.triangluatePolygon(indices, partName, indexCounter);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class LimbPartTransformer
    extends HumanoidModelTransformer.PartTransformer<CustomizableCube> {
        final int upperJoint;
        final int lowerJoint;
        final int middleJoint;
        final boolean bendInFront;
        final float yClipCoord;

        public LimbPartTransformer(int upperJoint, int lowerJoint, int middleJoint, float yClipCoord, boolean bendInFront) {
            this.upperJoint = upperJoint;
            this.lowerJoint = lowerJoint;
            this.middleJoint = middleJoint;
            this.bendInFront = bendInFront;
            this.yClipCoord = yClipCoord;
        }

        @Override
        public void bakeCube(PoseStack poseStack, String partName, CustomizableCube cube, List<SingleGroupVertexBuilder> vertices, Map<String, IntList> indices, HumanoidModelTransformer.PartTransformer.IndexCounter indexCounter) {
            ArrayList animatedPolygons = Lists.newArrayList();
            CustomizableCube.Polygon[] polygons = null;
            try {
                polygons = (CustomizableCube.Polygon[])customizableCube$polygons.get(cube);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
                return;
            }
            for (CustomizableCube.Polygon polygon : polygons) {
                if (polygon == null) continue;
                Matrix4f matrix = poseStack.m_85850_().m_252922_();
                ModelPart.Vertex pos0 = SkinLayer3DTransformer.getTranslatedVertex(polygon.vertices[0], matrix);
                ModelPart.Vertex pos1 = SkinLayer3DTransformer.getTranslatedVertex(polygon.vertices[1], matrix);
                ModelPart.Vertex pos2 = SkinLayer3DTransformer.getTranslatedVertex(polygon.vertices[2], matrix);
                ModelPart.Vertex pos3 = SkinLayer3DTransformer.getTranslatedVertex(polygon.vertices[3], matrix);
                net.minecraft.core.Direction direction = SkinLayer3DTransformer.getDirectionFromVector(polygon.normal.x, polygon.normal.y, polygon.normal.z);
                if (pos1.f_104371_.y() > this.yClipCoord != pos2.f_104371_.y() > this.yClipCoord) {
                    boolean isFront;
                    boolean hasSameZ;
                    int lowerId;
                    int upperId;
                    float distance = pos2.f_104371_.y() - pos1.f_104371_.y();
                    float textureV = pos1.f_104373_ + (pos2.f_104373_ - pos1.f_104373_) * ((this.yClipCoord - pos1.f_104371_.y()) / distance);
                    Vector3f clipPos1 = SkinLayer3DTransformer.getClipPoint(pos1.f_104371_, pos2.f_104371_, this.yClipCoord);
                    Vector3f clipPos2 = SkinLayer3DTransformer.getClipPoint(pos0.f_104371_, pos3.f_104371_, this.yClipCoord);
                    ModelPart.Vertex pos4 = new ModelPart.Vertex(clipPos2, pos0.f_104372_, textureV);
                    ModelPart.Vertex pos5 = new ModelPart.Vertex(clipPos1, pos1.f_104372_, textureV);
                    if (distance > 0.0f) {
                        upperId = this.lowerJoint;
                        lowerId = this.upperJoint;
                    } else {
                        upperId = this.upperJoint;
                        lowerId = this.lowerJoint;
                    }
                    animatedPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos0, upperId), new AnimatedVertex(pos1, upperId), new AnimatedVertex(pos5, upperId), new AnimatedVertex(pos4, upperId)}, direction));
                    animatedPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, lowerId), new AnimatedVertex(pos5, lowerId), new AnimatedVertex(pos2, lowerId), new AnimatedVertex(pos3, lowerId)}, direction));
                    boolean bl = hasSameZ = pos4.f_104371_.z() < 0.0f == pos5.f_104371_.z() < 0.0f;
                    boolean bl2 = hasSameZ && pos4.f_104371_.z() < 0.0f == this.bendInFront ? true : (isFront = false);
                    if (isFront) {
                        animatedPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, this.middleJoint), new AnimatedVertex(pos5, this.middleJoint), new AnimatedVertex(pos5, this.upperJoint), new AnimatedVertex(pos4, this.upperJoint)}, 0.001f, direction));
                        animatedPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, this.lowerJoint), new AnimatedVertex(pos5, this.lowerJoint), new AnimatedVertex(pos5, this.middleJoint), new AnimatedVertex(pos4, this.middleJoint)}, 0.001f, direction));
                        continue;
                    }
                    if (hasSameZ) continue;
                    boolean startFront = pos4.f_104371_.z() > 0.0f;
                    int firstJoint = this.lowerJoint;
                    int secondJoint = this.lowerJoint;
                    int thirdJoint = startFront ? this.upperJoint : this.middleJoint;
                    int fourthJoint = startFront ? this.middleJoint : this.upperJoint;
                    int fifthJoint = this.upperJoint;
                    int sixthJoint = this.upperJoint;
                    animatedPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, firstJoint), new AnimatedVertex(pos5, secondJoint), new AnimatedVertex(pos5, thirdJoint), new AnimatedVertex(pos4, fourthJoint)}, 0.001f, direction));
                    animatedPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, fourthJoint), new AnimatedVertex(pos5, thirdJoint), new AnimatedVertex(pos5, fifthJoint), new AnimatedVertex(pos4, sixthJoint)}, 0.001f, direction));
                    continue;
                }
                int jointId = pos0.f_104371_.y() > this.yClipCoord ? this.upperJoint : this.lowerJoint;
                animatedPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos0, jointId), new AnimatedVertex(pos1, jointId), new AnimatedVertex(pos2, jointId), new AnimatedVertex(pos3, jointId)}, direction));
            }
            for (AnimatedPolygon quad : animatedPolygons) {
                Vector3f norm = new Vector3f((Vector3fc)quad.normal);
                norm.mul((Matrix3fc)poseStack.m_85850_().m_252943_());
                for (AnimatedVertex vertex : quad.animatedVertexPositions) {
                    Vector4f pos = new Vector4f((Vector3fc)vertex.f_104371_, 1.0f);
                    vertices.add(new SingleGroupVertexBuilder().setPosition(new Vec3f(pos.x(), pos.y(), pos.z()).scale(0.0625f)).setNormal(new Vec3f(norm.x(), norm.y(), norm.z())).setTextureCoordinate(new Vec2f(vertex.f_104372_, vertex.f_104373_)).setEffectiveJointIDs(new Vec3f(vertex.jointId.m_123341_(), 0.0f, 0.0f)).setEffectiveJointWeights(new Vec3f(1.0f, 0.0f, 0.0f)).setEffectiveJointNumber(1));
                }
                LimbPartTransformer.triangluatePolygon(indices, partName, indexCounter);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ChestPartTransformer
    extends HumanoidModelTransformer.PartTransformer<CustomizableCube> {
        static final float X_PLANE = 0.0f;
        static final VertexWeight[] WEIGHT_ALONG_Y = new VertexWeight[]{new VertexWeight(13.6666f, 0.23f, 0.77f), new VertexWeight(15.8333f, 0.254f, 0.746f), new VertexWeight(18.0f, 0.5f, 0.5f), new VertexWeight(20.1666f, 0.744f, 0.256f), new VertexWeight(22.3333f, 0.77f, 0.23f)};
        final float yClipCoord;

        public ChestPartTransformer(float yBasis) {
            this.yClipCoord = yBasis;
        }

        @Override
        public void bakeCube(PoseStack poseStack, String partName, CustomizableCube cube, List<SingleGroupVertexBuilder> vertices, Map<String, IntList> indices, HumanoidModelTransformer.PartTransformer.IndexCounter indexCounter) {
            ModelPart.Vertex pos5;
            ModelPart.Vertex pos4;
            ArrayList xClipPolygons = Lists.newArrayList();
            ArrayList xyClipPolygons = Lists.newArrayList();
            CustomizableCube.Polygon[] polygons = null;
            try {
                polygons = (CustomizableCube.Polygon[])customizableCube$polygons.get(cube);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
                return;
            }
            for (CustomizableCube.Polygon polygon : polygons) {
                if (polygon == null) continue;
                Matrix4f matrix = poseStack.m_85850_().m_252922_();
                ModelPart.Vertex pos0 = SkinLayer3DTransformer.getTranslatedVertex(polygon.vertices[0], matrix);
                ModelPart.Vertex pos1 = SkinLayer3DTransformer.getTranslatedVertex(polygon.vertices[1], matrix);
                ModelPart.Vertex pos2 = SkinLayer3DTransformer.getTranslatedVertex(polygon.vertices[2], matrix);
                ModelPart.Vertex pos3 = SkinLayer3DTransformer.getTranslatedVertex(polygon.vertices[3], matrix);
                net.minecraft.core.Direction direction = SkinLayer3DTransformer.getDirectionFromVector(polygon.normal.x, polygon.normal.y, polygon.normal.z);
                VertexWeight pos0Weight = ChestPartTransformer.getYClipWeight(pos0.f_104371_.y());
                VertexWeight pos1Weight = ChestPartTransformer.getYClipWeight(pos1.f_104371_.y());
                VertexWeight pos2Weight = ChestPartTransformer.getYClipWeight(pos2.f_104371_.y());
                VertexWeight pos3Weight = ChestPartTransformer.getYClipWeight(pos3.f_104371_.y());
                if (pos1.f_104371_.x() > 0.0f != pos2.f_104371_.x() > 0.0f) {
                    float distance = pos2.f_104371_.x() - pos1.f_104371_.x();
                    float textureU = pos1.f_104372_ + (pos2.f_104372_ - pos1.f_104372_) * ((0.0f - pos1.f_104371_.x()) / distance);
                    pos4 = new ModelPart.Vertex(0.0f, pos0.f_104371_.y(), pos0.f_104371_.z(), textureU, pos0.f_104373_);
                    pos5 = new ModelPart.Vertex(0.0f, pos1.f_104371_.y(), pos1.f_104371_.z(), textureU, pos1.f_104373_);
                    xClipPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos0, 8, 7, 0, pos0Weight.chestWeight, pos0Weight.torsoWeight, 0.0f), new AnimatedVertex(pos4, 8, 7, 0, pos0Weight.chestWeight, pos0Weight.torsoWeight, 0.0f), new AnimatedVertex(pos5, 8, 7, 0, pos1Weight.chestWeight, pos1Weight.torsoWeight, 0.0f), new AnimatedVertex(pos3, 8, 7, 0, pos3Weight.chestWeight, pos3Weight.torsoWeight, 0.0f)}, direction));
                    xClipPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, 8, 7, 0, pos0Weight.chestWeight, pos0Weight.torsoWeight, 0.0f), new AnimatedVertex(pos1, 8, 7, 0, pos1Weight.chestWeight, pos1Weight.torsoWeight, 0.0f), new AnimatedVertex(pos2, 8, 7, 0, pos2Weight.chestWeight, pos2Weight.torsoWeight, 0.0f), new AnimatedVertex(pos5, 8, 7, 0, pos1Weight.chestWeight, pos1Weight.torsoWeight, 0.0f)}, direction));
                    continue;
                }
                xClipPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos0, 8, 7, 0, pos0Weight.chestWeight, pos0Weight.torsoWeight, 0.0f), new AnimatedVertex(pos1, 8, 7, 0, pos1Weight.chestWeight, pos1Weight.torsoWeight, 0.0f), new AnimatedVertex(pos2, 8, 7, 0, pos2Weight.chestWeight, pos2Weight.torsoWeight, 0.0f), new AnimatedVertex(pos3, 8, 7, 0, pos3Weight.chestWeight, pos3Weight.torsoWeight, 0.0f)}, direction));
            }
            for (AnimatedPolygon polygon : xClipPolygons) {
                boolean upsideDown = polygon.animatedVertexPositions[1].f_104371_.y() > polygon.animatedVertexPositions[2].f_104371_.y();
                AnimatedVertex pos0 = upsideDown ? polygon.animatedVertexPositions[2] : polygon.animatedVertexPositions[0];
                AnimatedVertex pos1 = upsideDown ? polygon.animatedVertexPositions[3] : polygon.animatedVertexPositions[1];
                AnimatedVertex pos2 = upsideDown ? polygon.animatedVertexPositions[0] : polygon.animatedVertexPositions[2];
                AnimatedVertex pos3 = upsideDown ? polygon.animatedVertexPositions[1] : polygon.animatedVertexPositions[3];
                net.minecraft.core.Direction direction = SkinLayer3DTransformer.getDirectionFromVector(polygon.normal.x, polygon.normal.y, polygon.normal.z);
                List<VertexWeight> vertexWeights = ChestPartTransformer.getMiddleYClipWeights(pos1.f_104371_.y(), pos2.f_104371_.y());
                ArrayList animatedVertices = Lists.newArrayList();
                animatedVertices.add(pos0);
                animatedVertices.add(pos1);
                if (vertexWeights.size() > 0) {
                    for (VertexWeight vertexWeight : vertexWeights) {
                        float distance = pos2.f_104371_.y() - pos1.f_104371_.y();
                        float textureV = pos1.f_104373_ + (pos2.f_104373_ - pos1.f_104373_) * ((vertexWeight.yClipCoord - pos1.f_104371_.y()) / distance);
                        Vector3f clipPos1 = SkinLayer3DTransformer.getClipPoint(pos1.f_104371_, pos2.f_104371_, vertexWeight.yClipCoord);
                        Vector3f clipPos2 = SkinLayer3DTransformer.getClipPoint(pos0.f_104371_, pos3.f_104371_, vertexWeight.yClipCoord);
                        pos4 = new ModelPart.Vertex(clipPos2, pos0.f_104372_, textureV);
                        pos5 = new ModelPart.Vertex(clipPos1, pos1.f_104372_, textureV);
                        animatedVertices.add(new AnimatedVertex(pos4, 8, 7, 0, vertexWeight.chestWeight, vertexWeight.torsoWeight, 0.0f));
                        animatedVertices.add(new AnimatedVertex(pos5, 8, 7, 0, vertexWeight.chestWeight, vertexWeight.torsoWeight, 0.0f));
                    }
                }
                animatedVertices.add(pos3);
                animatedVertices.add(pos2);
                for (int i = 0; i < (animatedVertices.size() - 2) / 2; ++i) {
                    int start = i * 2;
                    AnimatedVertex p0 = (AnimatedVertex)((Object)animatedVertices.get(start));
                    AnimatedVertex p1 = (AnimatedVertex)((Object)animatedVertices.get(start + 1));
                    AnimatedVertex p2 = (AnimatedVertex)((Object)animatedVertices.get(start + 3));
                    AnimatedVertex p3 = (AnimatedVertex)((Object)animatedVertices.get(start + 2));
                    xyClipPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(p0, 8, 7, 0, p0.weight.x, p0.weight.y, 0.0f), new AnimatedVertex(p1, 8, 7, 0, p1.weight.x, p1.weight.y, 0.0f), new AnimatedVertex(p2, 8, 7, 0, p2.weight.x, p2.weight.y, 0.0f), new AnimatedVertex(p3, 8, 7, 0, p3.weight.x, p3.weight.y, 0.0f)}, direction));
                }
            }
            for (AnimatedPolygon polygon : xyClipPolygons) {
                Vector3f norm = new Vector3f((Vector3fc)polygon.normal);
                norm.mul((Matrix3fc)poseStack.m_85850_().m_252943_());
                for (AnimatedVertex vertex : polygon.animatedVertexPositions) {
                    int count;
                    Vector4f pos = new Vector4f((Vector3fc)vertex.f_104371_, 1.0f);
                    float weight1 = vertex.weight.x;
                    float weight2 = vertex.weight.y;
                    int joint1 = vertex.jointId.m_123341_();
                    int joint2 = vertex.jointId.m_123342_();
                    int n = count = weight1 > 0.0f && weight2 > 0.0f ? 2 : 1;
                    if (weight1 <= 0.0f) {
                        joint1 = joint2;
                        weight1 = weight2;
                    }
                    vertices.add(new SingleGroupVertexBuilder().setPosition(new Vec3f(pos.x(), pos.y(), pos.z()).scale(0.0625f)).setNormal(new Vec3f(norm.x(), norm.y(), norm.z())).setTextureCoordinate(new Vec2f(vertex.f_104372_, vertex.f_104373_)).setEffectiveJointIDs(new Vec3f(joint1, joint2, 0.0f)).setEffectiveJointWeights(new Vec3f(weight1, weight2, 0.0f)).setEffectiveJointNumber(count));
                }
                ChestPartTransformer.triangluatePolygon(indices, partName, indexCounter);
            }
        }

        static VertexWeight getYClipWeight(float y) {
            if (y < ChestPartTransformer.WEIGHT_ALONG_Y[0].yClipCoord) {
                return new VertexWeight(y, 0.0f, 1.0f);
            }
            int index = -1;
            for (int i = 0; i < WEIGHT_ALONG_Y.length; ++i) {
            }
            if (index > 0) {
                VertexWeight pair = WEIGHT_ALONG_Y[index];
                return new VertexWeight(y, pair.chestWeight, pair.torsoWeight);
            }
            return new VertexWeight(y, 1.0f, 0.0f);
        }

        static List<VertexWeight> getMiddleYClipWeights(float minY, float maxY) {
            ArrayList cutYs = Lists.newArrayList();
            for (VertexWeight vertexWeight : WEIGHT_ALONG_Y) {
                if (!(vertexWeight.yClipCoord > minY) || !(maxY >= vertexWeight.yClipCoord)) continue;
                cutYs.add(vertexWeight);
            }
            return cutYs;
        }

        static class VertexWeight {
            final float yClipCoord;
            final float chestWeight;
            final float torsoWeight;

            public VertexWeight(float yClipCoord, float chestWeight, float torsoWeight) {
                this.yClipCoord = yClipCoord;
                this.chestWeight = chestWeight;
                this.torsoWeight = torsoWeight;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class AnimatedPolygon {
        public final AnimatedVertex[] animatedVertexPositions;
        public final Vector3f normal;

        public AnimatedPolygon(AnimatedVertex[] positionsIn, net.minecraft.core.Direction directionIn) {
            this.animatedVertexPositions = positionsIn;
            this.normal = directionIn.m_253071_();
        }

        public AnimatedPolygon(AnimatedVertex[] positionsIn, float cor, net.minecraft.core.Direction directionIn) {
            this.animatedVertexPositions = positionsIn;
            positionsIn[0] = new AnimatedVertex(positionsIn[0], positionsIn[0].f_104372_, positionsIn[0].f_104373_ + cor, positionsIn[0].jointId, positionsIn[0].weight);
            positionsIn[1] = new AnimatedVertex(positionsIn[1], positionsIn[1].f_104372_, positionsIn[1].f_104373_ + cor, positionsIn[1].jointId, positionsIn[1].weight);
            positionsIn[2] = new AnimatedVertex(positionsIn[2], positionsIn[2].f_104372_, positionsIn[2].f_104373_ - cor, positionsIn[2].jointId, positionsIn[2].weight);
            positionsIn[3] = new AnimatedVertex(positionsIn[3], positionsIn[3].f_104372_, positionsIn[3].f_104373_ - cor, positionsIn[3].jointId, positionsIn[3].weight);
            this.normal = directionIn.m_253071_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class AnimatedVertex
    extends ModelPart.Vertex {
        final Vec3i jointId;
        final Vec3f weight;

        public AnimatedVertex(ModelPart.Vertex posTexVertx, int jointId) {
            this(posTexVertx, jointId, 0, 0, 1.0f, 0.0f, 0.0f);
        }

        public AnimatedVertex(ModelPart.Vertex posTexVertx, int jointId1, int jointId2, int jointId3, float weight1, float weight2, float weight3) {
            this(posTexVertx, new Vec3i(jointId1, jointId2, jointId3), new Vec3f(weight1, weight2, weight3));
        }

        public AnimatedVertex(ModelPart.Vertex posTexVertx, Vec3i ids, Vec3f weights) {
            this(posTexVertx, posTexVertx.f_104372_, posTexVertx.f_104373_, ids, weights);
        }

        public AnimatedVertex(ModelPart.Vertex posTexVertx, float u, float v, Vec3i ids, Vec3f weights) {
            super(posTexVertx.f_104371_.x(), posTexVertx.f_104371_.y(), posTexVertx.f_104371_.z(), u, v);
            this.jointId = ids;
            this.weight = weights;
        }
    }
}

