/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;
import yesman.epicfight.api.animation.AnimationClip;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.animation.types.datapack.ClipHoldingAnimation;
import yesman.epicfight.api.client.animation.ClientAnimationDataReader;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.api.forgeevent.AnimationRegistryEvent;
import yesman.epicfight.api.utils.ClearableIdMapper;
import yesman.epicfight.api.utils.InstantiateInvoker;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.main.EpicFightMod;

public class AnimationManager
extends SimpleJsonResourceReloadListener {
    private static final AnimationManager INSTANCE = new AnimationManager();
    private static ResourceManager resourceManager = null;
    private final Map<StaticAnimation, AnimationClip> animationClips = Maps.newHashMap();
    private final Map<ResourceLocation, StaticAnimation> animationRegistry = Maps.newHashMap();
    private final Map<ResourceLocation, StaticAnimation> userAnimations = Maps.newHashMap();
    private final ClearableIdMapper<StaticAnimation> animationIdMap = new ClearableIdMapper();
    private String currentWorkingModid;

    public static AnimationManager getInstance() {
        return INSTANCE;
    }

    public AnimationManager() {
        super(new GsonBuilder().create(), "animmodels/animations");
    }

    public StaticAnimation byId(int animationId) {
        if (!this.animationIdMap.m_175380_(animationId)) {
            throw new NoSuchElementException("No animation id " + animationId);
        }
        return (StaticAnimation)this.animationIdMap.m_7942_(animationId);
    }

    public StaticAnimation byKeyOrThrow(String resourceLocation) {
        return this.byKeyOrThrow(new ResourceLocation(resourceLocation));
    }

    public StaticAnimation byKeyOrThrow(ResourceLocation rl) {
        if (!this.animationRegistry.containsKey(rl)) {
            throw new NoSuchElementException("No animation with registry name " + rl);
        }
        return this.byKey(rl);
    }

    public StaticAnimation byKey(ResourceLocation rl) {
        return this.animationRegistry.get(rl);
    }

    public AnimationClip getStaticAnimationClip(StaticAnimation animation) {
        if (!this.animationClips.containsKey(animation)) {
            animation.loadAnimation(resourceManager);
        }
        return this.animationClips.get(animation);
    }

    public Map<ResourceLocation, StaticAnimation> getAnimations(Predicate<StaticAnimation> filter) {
        Map filteredItems = this.animationRegistry.entrySet().stream().filter(entry -> !this.userAnimations.containsKey(entry.getKey()) && filter.test((StaticAnimation)entry.getValue())).reduce(Maps.newHashMap(), (map, entry) -> {
            map.put((ResourceLocation)entry.getKey(), (StaticAnimation)entry.getValue());
            return map;
        }, (map1, map2) -> {
            map1.putAll(map2);
            return map1;
        });
        return ImmutableMap.copyOf((Map)filteredItems);
    }

    public int registerAnimation(StaticAnimation staticAnimation) {
        if (this.currentWorkingModid != null) {
            if (this.animationRegistry.containsKey(staticAnimation.getRegistryName())) {
                EpicFightMod.LOGGER.error("Animation registration failed.");
                new IllegalStateException("[EpicFightMod] Animation with registry name " + staticAnimation.getRegistryName() + " already exists!").printStackTrace();
                return -1;
            }
            this.animationRegistry.put(staticAnimation.getRegistryName(), staticAnimation);
            int id = this.animationRegistry.size();
            this.animationIdMap.m_122664_(staticAnimation, id);
            return id;
        }
        return -1;
    }

    public void registerUserAnimation(ClipHoldingAnimation animation) {
        this.animationRegistry.put(animation.getCreator().getRegistryName(), animation.cast());
    }

    public void removeUserAnimation(ClipHoldingAnimation animation) {
        this.animationRegistry.remove(animation.getCreator().getRegistryName());
    }

    public StaticAnimation refreshAnimation(StaticAnimation staticAnimation) {
        if (!this.animationRegistry.containsKey(staticAnimation.getRegistryName())) {
            throw new IllegalStateException("Animation refresh exception: No animation named " + staticAnimation.getRegistryName());
        }
        return this.animationRegistry.get(staticAnimation.getRegistryName());
    }

    public void loadAnimationClip(StaticAnimation animation, Function<StaticAnimation, AnimationClip> clipProvider) {
        if (!this.animationClips.containsKey(animation)) {
            AnimationClip animationClip = clipProvider.apply(animation);
            this.animationClips.put(animation, animationClip);
        }
    }

    public void onFailed(StaticAnimation animation) {
        if (!this.animationClips.containsKey(animation)) {
            this.animationClips.put(animation, AnimationClip.EMPTY_CLIP);
        }
    }

    public String workingModId() {
        return this.currentWorkingModid;
    }

    public static void readAnimationProperties(StaticAnimation animation) {
        ResourceLocation dataLocation = AnimationManager.getAnimationDataFileLocation(animation.getLocation());
        resourceManager.m_213713_(dataLocation).ifPresent(rs -> ClientAnimationDataReader.readAndApply(animation, rs));
    }

    protected Map<ResourceLocation, JsonElement> m_5944_(ResourceManager resourceManager, ProfilerFiller profilerIn) {
        AnimationManager.reloadResourceManager(resourceManager);
        Armatures.build(resourceManager);
        this.animationIdMap.clear();
        this.animationRegistry.clear();
        LinkedHashMap registryMap = Maps.newLinkedHashMap();
        ModLoader.get().postEvent((Event)new AnimationRegistryEvent(registryMap));
        this.animationClips.clear();
        registryMap.entrySet().forEach(entry -> {
            EpicFightMod.LOGGER.info("Register animations from " + (String)entry.getKey());
            this.currentWorkingModid = (String)entry.getKey();
            ((Runnable)entry.getValue()).run();
            this.currentWorkingModid = null;
        });
        return super.m_5944_(resourceManager, profilerIn);
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManager, ProfilerFiller profilerIn) {
        HashMap registeredAnimation = Maps.newHashMap();
        this.animationRegistry.values().forEach(a1 -> a1.getClipHolders().forEach(a2 -> registeredAnimation.put(a2.getRegistryName(), a2)));
        objectIn.entrySet().stream().filter(entry -> !registeredAnimation.containsKey(entry.getKey()) && !((ResourceLocation)entry.getKey()).m_135815_().contains("/data/")).sorted((e1, e2) -> ((ResourceLocation)e1.getKey()).toString().compareTo(((ResourceLocation)e2.getKey()).toString())).forEach(entry -> {
            if (!((ResourceLocation)entry.getKey()).m_135827_().equals(this.currentWorkingModid)) {
                this.currentWorkingModid = ((ResourceLocation)entry.getKey()).m_135827_();
            }
            try {
                this.readAnimationFromJson((ResourceLocation)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject());
            }
            catch (Exception e) {
                EpicFightMod.LOGGER.error("Failed to load User animation " + entry.getKey() + " because of " + e + ". Skipped.");
                e.printStackTrace();
            }
        });
        SkillManager.reloadAllSkillsAnimations();
        this.animationRegistry.values().stream().reduce(Lists.newArrayList(), (list, anim) -> {
            list.addAll(anim.getClipHolders());
            return list;
        }, (list1, list2) -> {
            list1.addAll(list2);
            return list1;
        }).forEach(animation -> {
            animation.postInit();
            if (EpicFightMod.isPhysicalClient()) {
                AnimationManager.readAnimationProperties(animation);
            }
        });
    }

    public static ResourceLocation getAnimationDataFileLocation(ResourceLocation location) {
        int splitIdx = location.m_135815_().lastIndexOf(47);
        if (splitIdx < 0) {
            splitIdx = 0;
        }
        return new ResourceLocation(location.m_135827_(), String.format("%s/data%s", location.m_135815_().substring(0, splitIdx), location.m_135815_().substring(splitIdx)));
    }

    private static void reloadResourceManager(ResourceManager pResourceManager) {
        if (resourceManager != pResourceManager) {
            resourceManager = pResourceManager;
        }
    }

    public static ResourceManager getAnimationResourceManager() {
        return EpicFightMod.isPhysicalClient() ? Minecraft.m_91087_().m_91098_() : resourceManager;
    }

    private void readAnimationFromJson(ResourceLocation rl, JsonObject json) throws Exception {
        JsonElement constructorElement = json.get("constructor");
        if (constructorElement == null) {
            throw new IllegalStateException("No constructor information has provided in User animation " + rl);
        }
        JsonObject constructorObject = constructorElement.getAsJsonObject();
        String invocationCommand = constructorObject.get("invocation_command").getAsString();
        StaticAnimation animation = InstantiateInvoker.invoke(invocationCommand, StaticAnimation.class).getResult();
        this.userAnimations.put(animation.getRegistryName(), animation);
        JsonElement propertiesElement = json.getAsJsonObject().get("properties");
        if (propertiesElement != null) {
            JsonObject propertiesObject = propertiesElement.getAsJsonObject();
            for (Map.Entry entry : propertiesObject.entrySet()) {
                AnimationProperty propertyKey = AnimationProperty.getSerializableProperty((String)entry.getKey());
                Object value = propertyKey.parseFrom((JsonElement)entry.getValue());
                animation.addPropertyUnsafe(propertyKey, value);
            }
        }
    }
}

