/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.world.structure;

import com.eeeab.eeeabsmobs.sever.entity.corpse.EntityCorpseWarlock;
import com.eeeab.eeeabsmobs.sever.init.EntityInit;
import com.eeeab.eeeabsmobs.sever.init.StructuresInit;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class StructureBloodyAltar
extends Structure {
    public static final Codec<StructureBloodyAltar> CODEC = StructureBloodyAltar.m_226607_(StructureBloodyAltar::new);
    private static final ResourceLocation BLOODY_ALTAR = new ResourceLocation("eeeabsmobs", "bloody_altar");
    private static final Map<ResourceLocation, BlockPos> OFFSET = new ImmutableMap.Builder().put((Object)BLOODY_ALTAR, (Object)new BlockPos(0, 1, 0)).build();

    protected StructureBloodyAltar(Structure.StructureSettings settings) {
        super(settings);
    }

    public static void generatePieces(StructureTemplateManager templateManager, BlockPos pos, Rotation rotation, StructurePieceAccessor pieceList, RandomSource random) {
        int x = pos.m_123341_();
        int z = pos.m_123343_();
        BlockPos rotationOffSet = new BlockPos(0, 0, 0).m_7954_(rotation);
        BlockPos blockpos = rotationOffSet.m_7918_(x, pos.m_123342_(), z);
        pieceList.m_142679_((StructurePiece)new Piece(templateManager, BLOODY_ALTAR, rotation, blockpos));
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        int i = context.f_226628_().f_45578_ >> 16;
        int j = context.f_226628_().f_45579_ >> 16;
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenrandom.m_188584_((long)(i ^ j << 9) ^ context.f_226627_());
        worldgenrandom.m_188502_();
        StructureTemplate structuretemplate = context.f_226625_().m_230359_(BLOODY_ALTAR);
        BlockPos blockpos = new BlockPos(structuretemplate.m_163801_().m_123341_() / 2, 0, structuretemplate.m_163801_().m_123343_() / 2);
        BlockPos blockPos1 = context.f_226628_().m_45615_();
        BlockPos blockPos2 = new BlockPos(blockPos1.m_123341_(), 31, blockPos1.m_123343_());
        return Optional.of(new Structure.GenerationStub(blockpos, builder -> StructureBloodyAltar.generatePieces(context.f_226625_(), blockPos2, Rotation.m_221990_((RandomSource)context.f_226626_()), (StructurePieceAccessor)builder, (RandomSource)context.f_226626_())));
    }

    public StructureType<?> m_213658_() {
        return (StructureType)StructuresInit.BLOODY_ALTAR_STRUCTURE.get();
    }

    public GenerationStep.Decoration m_226619_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public void m_214110_(WorldGenLevel level, StructureManager manager, ChunkGenerator generator, RandomSource random, BoundingBox box, ChunkPos chunkPos, PiecesContainer pieces) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int i = level.m_141937_();
        BoundingBox boundingbox = pieces.m_192756_();
        int j = boundingbox.m_162396_();
        for (int k = box.m_162395_(); k <= box.m_162399_(); ++k) {
            block1: for (int l = box.m_162398_(); l <= box.m_162401_(); ++l) {
                blockpos$mutableblockpos.m_122178_(k, j, l);
                if (level.m_46859_((BlockPos)blockpos$mutableblockpos) || !boundingbox.m_71051_((Vec3i)blockpos$mutableblockpos) || !pieces.m_192751_((BlockPos)blockpos$mutableblockpos)) continue;
                for (int i1 = j - 1; i1 > i; --i1) {
                    blockpos$mutableblockpos.m_142448_(i1);
                    if (!level.m_46859_((BlockPos)blockpos$mutableblockpos) && !level.m_8055_((BlockPos)blockpos$mutableblockpos).m_278721_()) continue block1;
                    level.m_7731_((BlockPos)blockpos$mutableblockpos, Blocks.f_50730_.m_49966_(), 2);
                }
            }
        }
    }

    public static class Piece
    extends TemplateStructurePiece {
        public Piece(StructureTemplateManager manager, ResourceLocation location, Rotation rotation, BlockPos pos) {
            super((StructurePieceType)StructuresInit.BA.get(), 0, manager, location, location.toString(), Piece.makeSettings(rotation), Piece.makePosition(location, pos));
        }

        public Piece(StructureTemplateManager templateManagerIn, CompoundTag tagCompound) {
            super((StructurePieceType)StructuresInit.BA.get(), tagCompound, templateManagerIn, location -> Piece.makeSettings(Rotation.valueOf((String)tagCompound.m_128461_("Rot"))));
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag tag) {
            this(context.f_226956_(), tag);
        }

        private static BlockPos makePosition(ResourceLocation location, BlockPos blockPos) {
            return blockPos.m_121955_((Vec3i)OFFSET.get(location));
        }

        private static StructurePlaceSettings makeSettings(Rotation rotation) {
            BlockIgnoreProcessor blockignoreprocessor = BlockIgnoreProcessor.f_74046_;
            return new StructurePlaceSettings().m_74379_(rotation).m_74377_(Mirror.NONE).m_74383_((StructureProcessor)blockignoreprocessor).m_74383_((StructureProcessor)new ProtectedBlockProcessor(BlockTags.f_144287_));
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag compoundTag) {
            super.m_183620_(context, compoundTag);
            compoundTag.m_128359_("Rot", this.f_73657_.m_74404_().name());
        }

        protected void m_213704_(String function, BlockPos blockPos, ServerLevelAccessor levelAccessor, RandomSource source, BoundingBox box) {
            if ("elite_spawn".equals(function)) {
                levelAccessor.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 2);
                EntityCorpseWarlock warlock = (EntityCorpseWarlock)((EntityType)EntityInit.CORPSE_WARLOCK.get()).m_20615_((Level)levelAccessor.m_6018_());
                if (warlock != null) {
                    warlock.m_20035_(blockPos, 0.0f, 0.0f);
                    warlock.m_6518_(levelAccessor, levelAccessor.m_6436_(blockPos), MobSpawnType.STRUCTURE, null, null);
                    warlock.setRestPos(blockPos);
                    levelAccessor.m_7967_((Entity)warlock);
                }
            }
        }
    }
}

