/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.util.damage;

import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.util.EMTagKey;
import com.eeeab.eeeabsmobs.sever.util.damage.DamageInfo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class DamageAdaptation {
    private final int adaptDamageTypesCount;
    private final int resetCountdown;
    private final float singleAdaptFactor;
    private final float maxAdaptFactor;
    private final boolean adaptsSameTypeMobs;
    private static final RandomSource random = RandomSource.m_216327_();
    private final Map<String, DamageInfo> ADAPT_MAP = new HashMap<String, DamageInfo>();

    public DamageAdaptation(int adaptDamageTypesCount, int resetCountdown, float singleAdaptFactor, float maxAdaptFactor, boolean adaptsSameTypeMobs) {
        this.adaptDamageTypesCount = adaptDamageTypesCount;
        this.resetCountdown = resetCountdown;
        this.singleAdaptFactor = singleAdaptFactor;
        this.maxAdaptFactor = maxAdaptFactor;
        this.adaptsSameTypeMobs = adaptsSameTypeMobs;
    }

    public DamageAdaptation(EMConfigHandler.DamageSourceAdaptConfig config) {
        this.adaptDamageTypesCount = (Integer)config.maxDamageSourceAdaptCount.get();
        this.resetCountdown = (Integer)config.resetCountdown.get() * 1000;
        this.singleAdaptFactor = ((Double)config.singleAdaptFactor.get()).floatValue();
        this.maxAdaptFactor = ((Double)config.maxAdaptFactor.get()).floatValue();
        this.adaptsSameTypeMobs = config.adaptsSameTypeMobs;
    }

    public void tick(LivingEntity entity) {
        if (entity.f_19797_ % (this.resetCountdown / 1000 * 20) == 0) {
            this.updateCache();
        }
    }

    public float damageAfterAdaptingOnce(@Nullable DamageSource source, float amount) {
        String key = DamageAdaptation.getKey(source, this.adaptsSameTypeMobs);
        if (key == null) {
            return amount;
        }
        DamageInfo info = this.ADAPT_MAP.getOrDefault(key, null);
        long systemMs = System.currentTimeMillis();
        if (info != null) {
            if (systemMs - info.getTimestamp() > (long)this.resetCountdown) {
                this.ADAPT_MAP.remove(key);
            } else {
                float newAdaptFactor = Math.min(info.getAdaptFactor() + this.singleAdaptFactor, this.maxAdaptFactor);
                float adaptedAmount = amount * (1.0f - newAdaptFactor);
                info.setAdaptFactor(newAdaptFactor);
                info.setTimestamp(systemMs);
                this.ADAPT_MAP.put(key, info);
                return Math.max(adaptedAmount, 0.0f);
            }
        }
        if (this.ADAPT_MAP.size() > this.adaptDamageTypesCount) {
            List keys = this.ADAPT_MAP.keySet().stream().toList();
            this.ADAPT_MAP.remove(keys.get(random.m_188503_(keys.size())));
            return amount;
        }
        this.ADAPT_MAP.put(key, new DamageInfo(systemMs, this.singleAdaptFactor));
        return amount;
    }

    public void updateCache() {
        Iterator<Map.Entry<String, DamageInfo>> iterator = this.ADAPT_MAP.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DamageInfo> entry = iterator.next();
            long systemMs = System.currentTimeMillis();
            if (systemMs - entry.getValue().getTimestamp() <= (long)this.resetCountdown) continue;
            iterator.remove();
        }
    }

    public void clearCache() {
        this.ADAPT_MAP.clear();
    }

    @Nullable
    private static String getKey(@Nullable DamageSource source, boolean adaptsSameTypeMobs) {
        if (source == null) {
            return "unknown:source";
        }
        if (source.m_7639_() == null && !source.m_269533_(EMTagKey.GENERAL_UNRESISTANT_TO)) {
            return "unknown:entity";
        }
        if (source.m_7639_() != null) {
            String key;
            String id;
            Entity entity = source.m_7639_();
            String string = id = adaptsSameTypeMobs ? entity.getClass().getName() : entity.m_20149_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                InteractionHand hand = player.m_7655_();
                key = DamageAdaptation.spliceCharacters(id, player.m_21120_(hand).m_41720_().m_5524_());
            } else {
                key = DamageAdaptation.spliceCharacters(id, source.m_19385_());
            }
            return key;
        }
        return null;
    }

    private static String spliceCharacters(String str1, String str2) {
        return str1 + ":" + str2;
    }
}

