/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.handler;

import com.eeeab.eeeabsmobs.sever.capability.FrenzyCapability;
import com.eeeab.eeeabsmobs.sever.capability.VertigoCapability;
import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityCameraShake;
import com.eeeab.eeeabsmobs.sever.handler.HandlerCapability;
import com.eeeab.eeeabsmobs.sever.init.EffectInit;
import com.eeeab.eeeabsmobs.sever.init.ItemInit;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class HandlerClientEvent {
    private static final ResourceLocation FRENZY_OUTLINE_LOCATION = new ResourceLocation("eeeabsmobs", "textures/gui/frenzy_outline.png");

    @SubscribeEvent
    public void onSetupCamera(ViewportEvent.ComputeCameraAngles event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        float delta = Minecraft.m_91087_().m_91296_();
        if (player != null) {
            float ticksExistedDelta = (float)player.f_19797_ + delta;
            if (((Boolean)EMConfigHandler.COMMON.OTHER.enableCameraShake.get()).booleanValue() && !Minecraft.m_91087_().m_91104_()) {
                float shakeAmplitude = 0.0f;
                for (EntityCameraShake cameraShake : player.m_9236_().m_45976_(EntityCameraShake.class, player.m_20191_().m_82377_(20.0, 20.0, 20.0))) {
                    if (!(cameraShake.m_20270_((Entity)player) < cameraShake.getRadius())) continue;
                    shakeAmplitude += cameraShake.getShakeAmount((Player)player, delta);
                }
                if (shakeAmplitude > 1.0f) {
                    shakeAmplitude = 1.0f;
                }
                if (player.m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
                    shakeAmplitude = 0.015f;
                }
                event.setPitch((float)((double)event.getPitch() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 3.0f + 2.0f) * 25.0));
                event.setYaw((float)((double)event.getYaw() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 5.0f + 1.0f) * 25.0));
                event.setRoll((float)((double)event.getRoll() + (double)shakeAmplitude * Math.cos(ticksExistedDelta * 4.0f) * 25.0));
            }
        }
    }

    @SubscribeEvent
    public void onRenderGuiOverlay(RenderGuiOverlayEvent.Post event) {
        FrenzyCapability.IFrenzyCapability capability;
        LocalPlayer player;
        if (event.getOverlay().overlay() == VanillaGuiOverlay.FROSTBITE.type().overlay() && (player = Minecraft.m_91087_().f_91074_) != null && (capability = HandlerCapability.getCapability((Entity)player, HandlerCapability.FRENZY_EFFECT_CAPABILITY)) != null && capability.isFrenzy() && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)FRENZY_OUTLINE_LOCATION);
            Window res = event.getWindow();
            event.getGuiGraphics().m_280163_(FRENZY_OUTLINE_LOCATION, 0, 0, 0.0f, 0.0f, res.m_85445_(), res.m_85446_(), res.m_85445_(), res.m_85446_());
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        VertigoCapability.IVertigoCapability capability = HandlerCapability.getCapability((Entity)player, HandlerCapability.MOVING_CONTROLLER_CAPABILITY);
        if (capability != null && capability.isVertigo()) {
            player.f_20885_ = capability.getYawHead();
            player.f_19859_ = player.m_146908_();
            player.f_19860_ = player.m_146909_();
            player.f_20886_ = player.f_20885_;
            player.m_146922_(capability.getYaw());
            player.m_146926_(capability.getPitch());
        }
    }

    @SubscribeEvent
    public void onRenderLiving(RenderLivingEvent.Pre<LivingEntity, EntityModel<LivingEntity>> event) {
        LivingEntity entity = event.getEntity();
        VertigoCapability.IVertigoCapability capability = HandlerCapability.getCapability((Entity)entity, HandlerCapability.MOVING_CONTROLLER_CAPABILITY);
        if (capability != null && capability.isVertigo()) {
            entity.f_20885_ = entity.f_20886_ = capability.getYawHead();
            entity.f_20883_ = entity.f_20884_ = capability.getCRenderYawOffset();
            entity.f_20921_ = entity.f_20920_ = capability.getCSwingProgress();
            entity.f_267362_.m_267711_(capability.getCLimbSwingAmount());
            entity.f_19859_ = capability.getYaw();
            entity.m_146922_(entity.f_19859_);
            entity.f_19860_ = capability.getPitch();
            entity.m_146926_(entity.f_19860_);
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent event) {
        Player player = event.getEntity();
        ItemStack itemStack = player.m_21211_();
        if (event.isCancelable() && itemStack.m_150930_((Item)ItemInit.GUARDIAN_CORE.get())) {
            PlayerRenderer renderer = event.getRenderer();
            ((PlayerModel)renderer.m_7200_()).f_102815_ = HumanoidModel.ArmPose.CROSSBOW_HOLD;
            ((PlayerModel)renderer.m_7200_()).f_102816_ = HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
    }
}

