/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.immortal;

import com.eeeab.animate.server.ai.AnimationMeleePlusAI;
import com.eeeab.animate.server.ai.AnimationSimpleAI;
import com.eeeab.animate.server.ai.animation.AnimationActivate;
import com.eeeab.animate.server.animation.Animation;
import com.eeeab.animate.server.handler.EMAnimationHandler;
import com.eeeab.eeeabsmobs.client.util.ControlledAnimation;
import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.IBoss;
import com.eeeab.eeeabsmobs.sever.entity.XpReward;
import com.eeeab.eeeabsmobs.sever.entity.ai.control.EMBodyRotationControl;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.EMLookAtGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.navigate.EMPathNavigateGround;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityAlienPortal;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityAbsImmortal;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.init.ParticleInit;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import com.eeeab.eeeabsmobs.sever.util.EMTagKey;
import com.eeeab.eeeabsmobs.sever.util.damage.DamageAdaptation;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityTheImmortal
extends EntityAbsImmortal
implements IBoss {
    public final Animation dieAnimation = Animation.create(60);
    public final Animation spawnAnimation = Animation.create(100);
    public final Animation switchStage2Animation = Animation.create(90);
    public final Animation switchStage3Animation = Animation.create(80);
    public final Animation teleportAnimation = Animation.create(20);
    private final Animation[] animations = new Animation[]{this.dieAnimation, this.spawnAnimation, this.switchStage2Animation, this.switchStage3Animation, this.teleportAnimation};
    private static final EntityDataAccessor<Integer> DATA_STAGE = SynchedEntityData.m_135353_(EntityTheImmortal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> DATA_SWORDS_HELD = SynchedEntityData.m_135353_(EntityTheImmortal.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final UUID HEALTH_UUID = UUID.fromString("E2F534E6-4A55-4B72-A9D2-3157D084A281");
    private static final UUID ARMOR_UUID = UUID.fromString("FA2FB8E8-FFE8-4D77-B23B-E0110D4A175F");
    private static final UUID ATTACK_UUID = UUID.fromString("F8DBD65D-3C4A-4851-83D3-4CB22964A196");
    private boolean releaseMark;
    private boolean switching;
    private int hurtCount;
    private int nextTeleportTick;
    private int immortalInvulnerableTime;
    private DamageSource lastDamageSource;
    private final DamageAdaptation damageAdaptation;
    public final ControlledAnimation coreControllerAnimation = new ControlledAnimation(10);
    public final ControlledAnimation glowControllerAnimation = new ControlledAnimation(20);

    public EntityTheImmortal(EntityType<? extends EntityAbsImmortal> type, Level level) {
        super(type, level);
        this.active = false;
        this.damageAdaptation = new DamageAdaptation(EMConfigHandler.COMMON.MOB.IMMORTAL.THE_IMMORTAL.adaptConfig);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 8.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 8.0f);
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
    }

    @Override
    protected XpReward getEntityReward() {
        return XpReward.XP_REWARD_EPIC_BOSS;
    }

    public float getStepHeight() {
        return 3.0f;
    }

    public boolean m_203441_(FluidState fluidState) {
        return fluidState.m_205070_(FluidTags.f_13132_);
    }

    @Override
    public boolean m_142535_(float fallDistance, float multiplier, DamageSource damageSource) {
        return false;
    }

    @Override
    public boolean m_147207_(MobEffectInstance effectInstance, @Nullable Entity entity) {
        return this.isActive() && ModEntityUtils.isBeneficial(effectInstance.m_19544_()) && super.m_147207_(effectInstance, entity);
    }

    public void m_147215_(MobEffectInstance effectInstance, @Nullable Entity entity) {
        if (this.isActive() && ModEntityUtils.isBeneficial(effectInstance.m_19544_())) {
            super.m_147215_(effectInstance, entity);
        }
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return this.isActive() && ModEntityUtils.isBeneficial(effectInstance.m_19544_()) && super.m_7301_(effectInstance);
    }

    @Override
    public boolean m_6051_() {
        return false;
    }

    @Override
    protected boolean canBePushedByEntity(Entity entity) {
        return false;
    }

    @Override
    public boolean m_6063_() {
        return false;
    }

    public void m_7601_(BlockState state, Vec3 motionMultiplier) {
        if (!state.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(state, motionMultiplier);
        }
    }

    @Override
    protected boolean m_8028_() {
        return false;
    }

    public boolean m_21224_() {
        return super.m_21224_();
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new EMBodyRotationControl((Mob)this);
    }

    @NotNull
    protected PathNavigation m_6037_(Level level) {
        return new EMPathNavigateGround(this, level);
    }

    @Override
    public boolean m_6673_(DamageSource damageSource) {
        Animation animation = this.getAnimation();
        return this.immortalInvulnerableTime > 0 || !this.isActive() || animation == this.switchStage2Animation || animation == this.teleportAnimation || animation == this.switchStage3Animation || super.m_6673_(damageSource);
    }

    protected boolean m_6129_() {
        return false;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    @Override
    protected EMConfigHandler.AttributeConfig getAttributeConfig() {
        return EMConfigHandler.COMMON.MOB.IMMORTAL.THE_IMMORTAL.combatConfig;
    }

    @Override
    protected boolean showBossBloodBars() {
        return (Boolean)EMConfigHandler.COMMON.OTHER.enableShowBloodBars.get();
    }

    @Override
    protected BossEvent.BossBarColor bossBloodBarsColor() {
        return BossEvent.BossBarColor.WHITE;
    }

    @Override
    protected void onAnimationFinish(Animation animation) {
        if (!(this.m_9236_().f_46443_ || animation != this.switchStage2Animation && animation != this.switchStage3Animation)) {
            this.m_21153_(this.m_21233_());
            this.switching = false;
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{EntityAbsImmortal.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal(this, 0.8){

            public boolean m_8036_() {
                return EntityTheImmortal.this.active && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new EMLookAtGoal(this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new EMLookAtGoal(this, Mob.class, 6.0f));
    }

    @Override
    protected void registerCustomGoals() {
        super.registerCustomGoals();
        this.f_21345_.m_25352_(1, new AnimationSimpleAI<EntityTheImmortal>(this, () -> this.switchStage2Animation));
        this.f_21345_.m_25352_(1, new AnimationSimpleAI<EntityTheImmortal>(this, () -> this.switchStage3Animation));
        this.f_21345_.m_25352_(1, new AnimationSimpleAI<EntityTheImmortal>(this, () -> this.teleportAnimation));
        this.f_21345_.m_25352_(2, new AnimationActivate<EntityTheImmortal>(this, () -> this.spawnAnimation));
        this.f_21345_.m_25352_(2, new AnimationMeleePlusAI<EntityTheImmortal>(this, (double)1.05f, -1, new Supplier[0]).ignoreSight());
    }

    @Override
    public void m_8119_() {
        this.m_146922_(this.f_20883_);
        super.m_8119_();
        this.floatImmortal();
        this.glowControllerAnimation.updatePrevTimer();
        this.coreControllerAnimation.updatePrevTimer();
        if (this.m_20159_()) {
            this.m_8127_();
        }
        if (!this.m_9236_().f_46443_ && this.isActive() && !this.m_21525_() && this.isNoAnimation() && this.checkTeleportConditions(this.m_5448_())) {
            this.nextTeleportTick = 200 + this.f_19796_.m_188503_(100);
            this.playAnimation(this.teleportAnimation);
        }
        this.pushEntitiesAway(2.0f, this.m_20206_(), 2.0f, 2.0f);
        if (!this.isActive()) {
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        }
        LivingEntity lookTarget = this.m_271686_();
        if (this.m_5448_() != null) {
            lookTarget = this.m_5448_();
        }
        int tick = this.getAnimationTick();
        if (this.getAnimation() == this.switchStage2Animation || this.getAnimation() == this.switchStage3Animation) {
            this.m_21573_().m_26573_();
            this.m_20334_(0.0, this.m_20096_() ? 0.0 : this.m_20184_().f_82480_, 0.0);
            int startLookTime = 50;
            if (this.getAnimation() == this.switchStage3Animation) {
                startLookTime = 45;
            }
            if (tick > startLookTime && lookTarget != null && lookTarget.m_6084_()) {
                this.m_21391_((Entity)lookTarget, 25.0f, 30.0f);
                this.m_21563_().m_24960_((Entity)lookTarget, 25.0f, 30.0f);
            } else {
                this.m_146922_(this.f_19859_);
            }
            if (tick == 15) {
                if (!this.m_9236_().f_46443_) {
                    EntityAlienPortal entity = new EntityAlienPortal(this.m_9236_(), (LivingEntity)this);
                    int offsetSide = this.getAnimation() == this.switchStage2Animation ? -1 : 1;
                    double radiansSide = Math.toRadians(this.m_146908_() + (float)(offsetSide == -1 ? 180 : 0));
                    double radians = Math.toRadians(this.m_146908_() + 90.0f);
                    double x = this.m_20185_() + Math.cos(radians) + 1.5 * Math.cos(radiansSide);
                    double y = this.m_20186_();
                    double z = this.m_20189_() + Math.sin(radians) + 1.5 * Math.sin(radiansSide);
                    entity.m_6034_(x, y, z);
                    this.m_9236_().m_7967_((Entity)entity);
                }
            } else if (tick > 39) {
                this.setHeldIndex(this.getStage().heldIndex);
            }
        } else if (this.getAnimation() == this.spawnAnimation) {
            if (tick > 20 && lookTarget != null && lookTarget.m_6084_()) {
                this.m_21391_((Entity)lookTarget, 30.0f, 30.0f);
                this.m_21563_().m_24960_((Entity)lookTarget, 30.0f, 30.0f);
            }
        } else if (this.getAnimation() == this.teleportAnimation) {
            if (lookTarget != null && lookTarget.m_6084_()) {
                this.m_21391_((Entity)lookTarget, 200.0f, 30.0f);
                this.m_21563_().m_24960_((Entity)lookTarget, 200.0f, 30.0f);
            }
            if (tick == 10 || tick == 15) {
                this.doTeleportEffect();
            }
        }
        this.f_19859_ = this.m_146908_();
        EMAnimationHandler.INSTANCE.updateAnimations(this);
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        LivingEntity lookTarget = this.m_5448_();
        int tick = this.getAnimationTick();
        if (this.getAnimation() == this.teleportAnimation && tick == 15) {
            for (int i = 16; i > 0 && !this.tryTeleportToTargetBehind((Entity)lookTarget, i); --i) {
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        Animation animation = this.getAnimation();
        if (!this.m_9236_().f_46443_) {
            if (this.f_19797_ % 20 == 0) {
                this.hurtCount = 0;
            }
            if (this.immortalInvulnerableTime > 0) {
                --this.immortalInvulnerableTime;
            }
            if (this.nextTeleportTick > 0) {
                --this.nextTeleportTick;
            }
            if (animation == this.switchStage2Animation || animation == this.switchStage3Animation) {
                this.m_5634_(this.m_21233_() / (float)animation.getDuration());
            }
            this.damageAdaptation.tick((LivingEntity)this);
        }
        this.glowControllerAnimation.incrementOrDecreaseTimer(this.isActive() && !this.m_21224_());
        this.coreControllerAnimation.incrementOrDecreaseTimer(!this.isNoAnimation() && this.getAnimation() != this.spawnAnimation);
    }

    public void m_21153_(float health) {
        if (health < this.m_21223_()) {
            float oldDamage = this.m_21223_() - health;
            float damageCap = ((Double)EMConfigHandler.COMMON.MOB.IMMORTAL.THE_IMMORTAL.maximumDamageCap.damageCap.get()).floatValue();
            float damage = Math.min(oldDamage, this.lastDamageSource == null || this.lastDamageSource.m_269533_(EMTagKey.GENERAL_UNRESISTANT_TO) ? oldDamage : damageCap);
            damage = this.damageAdaptation.damageAfterAdaptingOnce(this.lastDamageSource, damage);
            health = this.m_21223_() - damage;
            if (this.switching || this.immortalInvulnerableTime > 0) {
                this.immortalInvulnerableTime = 10;
                return;
            }
        }
        super.m_21153_(health);
        if (!(this.m_21223_() <= 0.0f) || this.getStage() != Stage.STAGE3) {
            // empty if block
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        if (!this.m_9236_().f_46443_) {
            ++this.hurtCount;
            this.lastDamageSource = source;
            if (this.m_6673_(source)) {
                return false;
            }
            if (this.estimatedHealthAfterDealingDamage(damage) && !this.releaseMark) {
                if (this.isNoAnimation()) {
                    this.releaseMark = true;
                    this.playAnimation(this.getSpecialSkillByStage(this.getStage()));
                }
                return false;
            }
            if (source.m_7639_() != null || source.m_269533_(EMTagKey.GENERAL_UNRESISTANT_TO)) {
                boolean flag = super.m_6469_(source, damage);
                return flag;
            }
        }
        return false;
    }

    private boolean estimatedHealthAfterDealingDamage(float damage) {
        return (this.m_21223_() - damage) / this.m_21233_() <= 0.5f;
    }

    private Animation getSpecialSkillByStage(Stage stage) {
        return null;
    }

    private boolean checkTeleportConditions(LivingEntity target) {
        return this.nextTeleportTick <= 0 && this.m_5448_() != null && this.m_20280_((Entity)target) < Math.pow(3.0, 2.0) && this.f_19796_.m_188503_(this.hurtCount >= 3 ? 50 : 200) == 0;
    }

    private void floatImmortal() {
        if (this.m_20077_()) {
            CollisionContext collisioncontext = CollisionContext.m_82750_((Entity)this);
            if (collisioncontext.m_6513_(LiquidBlock.f_54690_, this.m_20183_(), true) && !this.m_9236_().m_6425_(this.m_20183_().m_7494_()).m_205070_(FluidTags.f_13132_)) {
                this.m_6853_(true);
            } else {
                this.m_20256_(this.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.15, 0.0));
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_STAGE, (Object)Stage.STAGE1.index);
        this.f_19804_.m_135372_(DATA_SWORDS_HELD, (Object)Stage.STAGE1.heldIndex);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("stage", this.getStage().index);
        compound.m_128379_("switching", this.switching);
        compound.m_128379_("releaseMark", this.releaseMark);
        compound.m_128379_("isActive", this.isActive());
        compound.m_128344_("heldIndex", this.getHeldIndex());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(DATA_STAGE, (Object)compound.m_128451_("stage"));
        this.switching = compound.m_128471_("switching");
        this.releaseMark = compound.m_128471_("releaseMark");
        this.setActive(compound.m_128471_("isActive"));
        this.setHeldIndex(compound.m_128445_("heldIndex"));
        if (this.switching) {
            if (this.getStage() == Stage.STAGE1) {
                this.nextStage(Stage.STAGE2);
            } else if (this.getStage() == Stage.STAGE2) {
                this.playAnimation(this.switchStage2Animation);
            } else if (this.getStage() == Stage.STAGE3) {
                this.playAnimation(this.switchStage3Animation);
            }
        }
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!itemStack.m_150930_(Items.f_41852_)) {
            return InteractionResult.PASS;
        }
        if (this.isActive() || this.m_21525_()) {
            return InteractionResult.PASS;
        }
        if (!player.m_150110_().f_35937_) {
            System.out.println("\u7269\u54c1\u6570\u91cf\u51cf1");
        }
        this.playAnimation(this.spawnAnimation);
        this.setActive(true);
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @javax.annotation.Nullable SpawnGroupData spawnDataIn, @javax.annotation.Nullable CompoundTag dataTag) {
        this.setActive(false);
        this.nextStage(Stage.STAGE1);
        return spawnDataIn;
    }

    public Stage getStage() {
        return Stage.byStage((Integer)this.f_19804_.m_135370_(DATA_STAGE));
    }

    public byte getHeldIndex() {
        return (Byte)this.f_19804_.m_135370_(DATA_SWORDS_HELD);
    }

    public void setHeldIndex(byte index) {
        this.f_19804_.m_135381_(DATA_SWORDS_HELD, (Object)index);
    }

    @Override
    public boolean isGlow() {
        return !this.glowControllerAnimation.isStop();
    }

    @Override
    protected boolean canPlayMusic() {
        return this.isActive() && super.canPlayMusic();
    }

    @Override
    public SoundEvent getBossMusic() {
        return (SoundEvent)SoundInit.THE_ARMY_OF_MINOTAUR.get();
    }

    @Override
    public void setOwner(@Nullable EntityAbsImmortal owner) {
    }

    @Override
    public void setOwnerUUID(UUID uuid) {
    }

    @Override
    public void setSpawnParticle(int amount) {
    }

    @Override
    public boolean isSummon() {
        return false;
    }

    @Override
    public Animation getDeathAnimation() {
        return this.dieAnimation;
    }

    @Override
    public Animation[] getAnimations() {
        return this.animations;
    }

    private boolean tryTeleportToTargetBehind(@Nullable Entity target, int distance) {
        double d2;
        double d1;
        double radian = target != null && target.m_6084_() ? Math.toRadians(this.getAngleBetweenEntities((Entity)this, target) + 90.0) : Math.toRadians(this.f_19796_.m_188503_(360));
        double d0 = this.m_20185_() - (double)(this.f_19796_.m_188503_(distance) + distance) * Math.cos(radian);
        if (this.m_20984_(d0, d1 = this.m_20186_() + (double)this.f_19796_.m_188503_(6), d2 = this.m_20189_() - (double)(this.f_19796_.m_188503_(distance) + distance) * Math.sin(radian), false)) {
            if (!this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    private void doTeleportEffect() {
        for (int i = 0; i < 15; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleInit.VERTICAL_LINE.get(), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.0, 0.0);
        }
    }

    private void nextStage(Stage stage) {
        Animation playAnimation;
        try {
            playAnimation = null;
            switch (this.getStage()) {
                case STAGE1: {
                    if (stage != Stage.STAGE2) break;
                    this.switching = true;
                    this.playAnimation(this.getNoAnimation());
                    playAnimation = this.switchStage2Animation;
                    break;
                }
                case STAGE2: {
                    if (stage != Stage.STAGE3) break;
                    this.switching = true;
                    playAnimation = this.switchStage3Animation;
                }
            }
            if (this.m_21223_() <= 0.0f) {
                this.m_21153_(0.1f);
            }
        }
        finally {
            this.releaseMark = false;
            this.changeAttribute(stage.addHealth, stage.addArmor, stage.addAttack);
            this.f_19804_.m_135381_(DATA_STAGE, (Object)stage.index);
            this.damageAdaptation.clearCache();
        }
        this.playAnimation(playAnimation);
    }

    private void changeAttribute(float addHealth, float addArmor, float addAttack) {
        AttributeInstance health = this.m_21051_(Attributes.f_22276_);
        AttributeInstance armor = this.m_21051_(Attributes.f_22284_);
        AttributeInstance attack = this.m_21051_(Attributes.f_22281_);
        if (health != null) {
            health.m_22127_(HEALTH_UUID);
            health.m_22125_(new AttributeModifier(HEALTH_UUID, "Immortal add health", (double)addHealth, AttributeModifier.Operation.ADDITION));
        }
        if (armor != null) {
            armor.m_22127_(ARMOR_UUID);
            armor.m_22125_(new AttributeModifier(ARMOR_UUID, "Immortal add armor", (double)addArmor, AttributeModifier.Operation.ADDITION));
        }
        if (attack != null) {
            attack.m_22127_(ATTACK_UUID);
            attack.m_22125_(new AttributeModifier(ATTACK_UUID, "Immortal add attack", (double)addAttack, AttributeModifier.Operation.ADDITION));
        }
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22279_, 0.36).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)ForgeMod.ENTITY_GRAVITY.get(), 0.075);
    }

    public static enum Stage {
        STAGE1(0, 0.0f, 6.0f, 9.0f, 0),
        STAGE2(1, 250.0f, 8.0f, 11.0f, 1),
        STAGE3(2, 150.0f, 12.0f, 14.0f, 2);

        public final int index;
        public final float addHealth;
        public final float addArmor;
        public final float addAttack;
        public final byte heldIndex;

        private Stage(int index, float addHealth, float addArmor, float addAttack, byte heldIndex) {
            this.index = index;
            this.addHealth = addHealth;
            this.addArmor = addArmor;
            this.addAttack = addAttack;
            this.heldIndex = heldIndex;
        }

        public static Stage byStage(int type) {
            for (Stage value : Stage.values()) {
                if (value.index != type) continue;
                return value;
            }
            return STAGE1;
        }
    }
}

