/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.immortal;

import com.eeeab.animate.server.ai.AnimationAI;
import com.eeeab.animate.server.ai.AnimationMeleePlusAI;
import com.eeeab.animate.server.ai.animation.AnimationAreaMelee;
import com.eeeab.animate.server.ai.animation.AnimationBlock;
import com.eeeab.animate.server.ai.animation.AnimationDie;
import com.eeeab.animate.server.animation.Animation;
import com.eeeab.animate.server.handler.EMAnimationHandler;
import com.eeeab.eeeabsmobs.client.particle.util.AdvancedParticleBase;
import com.eeeab.eeeabsmobs.client.particle.util.AdvancedParticleData;
import com.eeeab.eeeabsmobs.client.particle.util.ParticleComponent;
import com.eeeab.eeeabsmobs.client.particle.util.RibbonComponent;
import com.eeeab.eeeabsmobs.client.particle.util.RibbonParticleData;
import com.eeeab.eeeabsmobs.client.particle.util.anim.AnimData;
import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.IEntity;
import com.eeeab.eeeabsmobs.sever.entity.XpReward;
import com.eeeab.eeeabsmobs.sever.entity.ai.control.EMBodyRotationControl;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.EMLookAtGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.navigate.EMPathNavigateGround;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityAbsImmortal;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.init.EffectInit;
import com.eeeab.eeeabsmobs.sever.init.ParticleInit;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import com.eeeab.eeeabsmobs.sever.util.EMTagKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityImmortalExecutioner
extends EntityAbsImmortal
implements IEntity {
    public final Animation dieAnimation = Animation.create(35);
    public final Animation avoidAnimation = Animation.create(15);
    public final Animation blockAnimation = Animation.create(15);
    public final Animation counterAnimation = Animation.create(15);
    public final Animation attackAnimationLeft = Animation.create(17);
    public final Animation attackAnimationRight = Animation.create(17);
    public final Animation sidesWayAnimationLeft = Animation.create(10);
    public final Animation sidesWayAnimationRight = Animation.create(10);
    public final Animation impactStorageAnimation = Animation.create(60);
    public final Animation impactHoldAnimation = Animation.create(20);
    public final Animation impactStopAnimation = Animation.create(10);
    public final Animation cullStorageAnimation = Animation.create(20);
    public final Animation cullHoldAnimation = Animation.create(15);
    public final Animation cullStopAnimation = Animation.create(10);
    private final Animation[] animations = new Animation[]{this.dieAnimation, this.avoidAnimation, this.blockAnimation, this.counterAnimation, this.attackAnimationLeft, this.attackAnimationRight, this.sidesWayAnimationLeft, this.sidesWayAnimationRight, this.impactStorageAnimation, this.impactHoldAnimation, this.impactStopAnimation, this.cullStorageAnimation, this.cullHoldAnimation, this.cullStopAnimation};
    @OnlyIn(value=Dist.CLIENT)
    public Vec3[] fire;
    private int nextAvoidTick;
    private int nextStampTick;
    private int nextCullTick;
    private static final UniformInt AVOID_INTERVAL = TimeUtil.m_145020_((int)5, (int)12);
    private static final UniformInt STAMP_INTERVAL = TimeUtil.m_145020_((int)12, (int)16);
    private static final UniformInt CULL_INTERVAL = TimeUtil.m_145020_((int)6, (int)9);
    private int hurtCount;
    private static final int MAX_HURT_COUNT = 6;

    public EntityImmortalExecutioner(EntityType<EntityImmortalExecutioner> type, Level level) {
        super((EntityType<? extends EntityAbsImmortal>)type, level);
        this.active = true;
        this.dropAfterDeathAnim = false;
        if (this.m_9236_().f_46443_) {
            this.fire = new Vec3[]{new Vec3(0.0, 0.0, 0.0)};
        }
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
    }

    @Override
    protected XpReward getEntityReward() {
        return XpReward.XP_REWARD_ELITE;
    }

    @Override
    protected EMConfigHandler.AttributeConfig getAttributeConfig() {
        return EMConfigHandler.COMMON.MOB.IMMORTAL.IMMORTAL_EXECUTIONER.combatConfig;
    }

    @Override
    protected EMConfigHandler.DamageCapConfig getDamageCap() {
        return EMConfigHandler.COMMON.MOB.IMMORTAL.IMMORTAL_EXECUTIONER.maximumDamageCap;
    }

    public float getStepHeight() {
        return 2.0f;
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 1.1f;
    }

    @Override
    protected boolean m_8028_() {
        return false;
    }

    @Override
    public boolean m_6051_() {
        return false;
    }

    protected int m_7302_(int air) {
        return air;
    }

    @Override
    public boolean m_142535_(float fallDistance, float multiplier, DamageSource damageSource) {
        return false;
    }

    public boolean m_6060_() {
        return this.m_20094_() > 0 || this.m_9236_().f_46443_ && this.m_20291_(0);
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return (this.isNoAnimation() || this.getAnimation() == this.impactHoldAnimation && EffectInit.VERTIGO_EFFECT.get() == effectInstance.m_19544_()) && super.m_7301_(effectInstance);
    }

    public boolean m_6779_(LivingEntity target) {
        return super.m_6779_(target);
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new EMBodyRotationControl((Mob)this);
    }

    @NotNull
    protected PathNavigation m_6037_(Level level) {
        return new EMPathNavigateGround(this, level);
    }

    @Override
    protected void onAnimationFinish(Animation animation) {
        super.onAnimationFinish(animation);
        if (!this.m_9236_().f_46443_ && animation == this.cullStopAnimation) {
            this.nextCullTick = CULL_INTERVAL.m_214085_(this.f_19796_);
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.75, 100));
        this.f_21345_.m_25352_(7, (Goal)new EMLookAtGoal(this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new EMLookAtGoal(this, EntityAbsImmortal.class, 6.0f));
    }

    @Override
    protected void registerCustomGoals() {
        super.registerCustomGoals();
        Consumer<LivingEntity> consumer = hitEntity -> this.executionerHurtTarget((LivingEntity)hitEntity, this.getFirePower() > 1.0f);
        this.f_21345_.m_25352_(1, new AnimationDie<EntityImmortalExecutioner>(this));
        this.f_21345_.m_25352_(1, (Goal)new ExecutionerCullGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new ExecutionerSharpImpactGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new AnimationBlock<EntityImmortalExecutioner>(this, () -> this.blockAnimation){

            @Override
            public void m_8037_() {
                super.m_8037_();
                if (((EntityImmortalExecutioner)this.entity).getAnimationTick() == 10 && ((EntityImmortalExecutioner)this.entity).m_5448_() != null && ((EntityImmortalExecutioner)this.entity).m_5448_().m_6084_() && ((EntityImmortalExecutioner)this.entity).targetDistance < 5.0f && (((EntityImmortalExecutioner)this.entity).blockEntity != null || ((EntityImmortalExecutioner)this.entity).m_217043_().m_188499_())) {
                    ((EntityImmortalExecutioner)this.entity).playAnimation(((EntityImmortalExecutioner)this.entity).counterAnimation);
                }
            }
        });
        this.f_21345_.m_25352_(1, new AnimationAreaMelee<EntityImmortalExecutioner>(this, () -> this.attackAnimationLeft, 8, 3.0f, 1.0f, 1.0f, 80.0f, 40.0f, 3.5f, true).setCustomHitMethod(consumer));
        this.f_21345_.m_25352_(1, new AnimationAreaMelee<EntityImmortalExecutioner>(this, () -> this.attackAnimationRight, 8, 3.0f, 1.0f, 1.0f, 40.0f, 80.0f, 3.5f, true).setCustomHitMethod(consumer));
        this.f_21345_.m_25352_(1, (Goal)new ExecutionerSimpleAI(this, true, () -> this.avoidAnimation, () -> this.sidesWayAnimationRight, () -> this.sidesWayAnimationLeft));
        this.f_21345_.m_25352_(2, new AnimationMeleePlusAI<EntityImmortalExecutioner>(this, 1.0, 5, 1, () -> this.attackAnimationRight, () -> this.attackAnimationLeft));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            boolean isClose;
            if (this.m_5448_() != null && !this.m_5448_().m_6084_()) {
                this.m_6710_(null);
            }
            boolean bl = isClose = this.m_5448_() != null && (this.targetDistance < 6.0f || ModEntityUtils.checkTargetComingCloser((LivingEntity)this, this.m_5448_()) && this.targetDistance < 5.0f);
            if (!this.m_21525_() && this.isNoAnimation()) {
                if (isClose && this.nextAvoidTick <= 0 && (this.hurtCount == 0 && this.f_19796_.m_188503_(100) == 0 || this.hurtCount != 0 && this.hurtCount < 6)) {
                    this.nextAvoidTick = AVOID_INTERVAL.m_214085_(this.f_19796_);
                    this.checkAndPlayComboAnimations(true, this.avoidAnimation, this.sidesWayAnimationLeft, this.sidesWayAnimationRight);
                }
                if (!isClose && this.m_5448_() != null && this.nextStampTick <= 0) {
                    this.nextStampTick = STAMP_INTERVAL.m_214085_(this.f_19796_);
                    this.playAnimation(this.impactStorageAnimation);
                }
                if (this.m_5448_() != null && this.targetDistance < 10.0f && this.nextCullTick <= 0) {
                    this.playAnimation(this.cullStorageAnimation);
                }
            }
        }
        int tick = this.getAnimationTick();
        if (this.getAnimation() == this.avoidAnimation) {
            float avoidYaw;
            LivingEntity target = this.m_5448_();
            boolean flag = target != null && target.m_6084_();
            double angle = flag ? this.getAngleBetweenEntities((Entity)this, (Entity)target) : (double)this.f_20883_;
            float f = avoidYaw = flag ? (float)Math.toRadians(angle + 90.0) : (float)Math.toRadians(angle + 270.0);
            if (tick == 5) {
                if (this.m_20096_() || this.m_20077_() || this.m_20069_()) {
                    float speed = 3.0f;
                    this.fastMove(speed, avoidYaw);
                }
            } else if (tick == 14) {
                this.checkAndPlayComboAnimations((this.m_20096_() || this.m_20077_() || this.m_20069_()) && this.f_19796_.m_188501_() > this.m_21223_() / this.m_21233_(), this.sidesWayAnimationLeft, this.sidesWayAnimationRight, this.cullStorageAnimation);
            }
        } else if (this.getAnimation() == this.sidesWayAnimationLeft || this.getAnimation() == this.sidesWayAnimationRight) {
            boolean isLeft;
            boolean bl = isLeft = this.getAnimation() == this.sidesWayAnimationLeft;
            if (tick == 1) {
                double angle = this.f_20883_;
                float speed = 2.0f;
                if (this.m_5448_() != null && this.targetDistance < 6.0f) {
                    speed += 1.5f;
                }
                int randomAngle = this.f_19796_.m_188503_(11) - 10;
                float sideAvoidYaw = isLeft ? (float)Math.toRadians(angle + (double)randomAngle) : (float)Math.toRadians(angle + 180.0 + (double)randomAngle);
                this.fastMove(speed, sideAvoidYaw);
            } else if (tick > 8) {
                this.checkAndPlayComboAnimations(this.f_19796_.m_188501_() < 0.6f && this.m_5448_() != null && this.targetDistance < 10.0f, this.cullStorageAnimation);
            }
        } else if (this.getAnimation() == this.cullHoldAnimation) {
            if (tick == 3) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundInit.IMMORTAL_EXECUTIONER_DASH.get(), this.m_5720_(), 1.0f, 1.0f, false);
            }
            if (tick == 4) {
                this.doRibbonEffect();
                this.m_5496_((SoundEvent)SoundInit.IMMORTAL_EXECUTIONER_SCRATCH.get(), 0.8f, this.m_6100_());
            }
        } else if (this.getAnimation() == this.attackAnimationRight || this.getAnimation() == this.attackAnimationLeft) {
            if (tick == 7) {
                this.m_5496_((SoundEvent)SoundInit.IMMORTAL_EXECUTIONER_SCRATCH.get(), 0.8f, this.m_6100_());
            }
        } else if (this.getAnimation() == this.counterAnimation && tick == 5) {
            this.m_5496_((SoundEvent)SoundInit.IMMORTAL_EXECUTIONER_SCRATCH.get(), 1.2f, this.m_6100_() - 0.2f);
        }
        if (this.m_9236_().f_46443_ && this.fire != null && this.fire.length != 0) {
            boolean isPower;
            float power = this.getFirePower();
            boolean bl = isPower = power > 1.0f;
            if (this.m_6084_() && this.active) {
                if (this.getAnimation() != this.impactHoldAnimation) {
                    if (isPower && this.f_19797_ % 4 == 1 || this.f_19797_ % 8 == 1) {
                        float scale = (8.0f + this.f_19796_.m_188501_()) * power;
                        this.doSoulFireEffect(0, scale, isPower ? 4 : 8);
                        this.doSoulFireEffect(180, scale, isPower ? 4 : 8);
                    }
                } else if (tick == 2) {
                    this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundInit.IMMORTAL_EXECUTIONER_DASH.get(), this.m_5720_(), 1.5f, 0.8f, false);
                } else if (tick == 3) {
                    this.doRibbonEffect();
                }
            }
            if (this.f_20919_ < 20 && this.f_19797_ % 9 == 1) {
                SimpleParticleType particleType = ParticleTypes.f_123762_;
                if (this.m_5842_()) {
                    particleType = ParticleTypes.f_123795_;
                }
                Vec3 vec3 = this.fire[0];
                for (int i = 0; i < (isPower ? 2 : 5); ++i) {
                    double x = vec3.f_82479_ + (2.0 * this.f_19796_.m_188500_() - 1.0) * 0.25;
                    double y = vec3.f_82480_ + (double)(this.m_20206_() * 0.1f);
                    double z = vec3.f_82481_ + (2.0 * this.f_19796_.m_188500_() - 1.0) * 0.25;
                    this.m_9236_().m_7106_((ParticleOptions)particleType, x, y, z, 0.0, 0.007, 0.0);
                }
            }
        }
        EMAnimationHandler.INSTANCE.updateAnimations(this);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            if (this.nextAvoidTick > 0) {
                --this.nextAvoidTick;
            }
            if (this.nextStampTick > 0) {
                --this.nextStampTick;
            }
            if (this.nextCullTick > 0) {
                --this.nextCullTick;
            }
            if (this.f_19797_ % 15 == 0 && this.hurtCount > 0) {
                --this.hurtCount;
            }
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        if (this.m_9236_().f_46443_) {
            return false;
        }
        if (source.m_7639_() != null) {
            boolean hitFlag;
            ++this.hurtCount;
            float attackArc = 220.0f;
            float entityRelativeAngle = ModEntityUtils.getTargetRelativeAngle((LivingEntity)this, source.m_7639_().m_20182_());
            boolean bl = hitFlag = !source.m_269533_(DamageTypeTags.f_268490_) && entityRelativeAngle <= attackArc / 2.0f && entityRelativeAngle >= -attackArc / 2.0f || entityRelativeAngle >= 360.0f - attackArc / 2.0f || entityRelativeAngle <= -attackArc + 45.0f;
            if (hitFlag && this.inBlocking()) {
                this.m_216990_((SoundEvent)SoundInit.IMMORTAL_EXECUTIONER_BLOCK.get());
                return false;
            }
            if (hitFlag && (ModEntityUtils.isProjectileSource(source) || this.f_19796_.m_188501_() < 0.6f) && this.isNoAnimation() && !this.m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
                Entity entity = source.m_7639_();
                if (entity instanceof LivingEntity) {
                    LivingEntity block;
                    this.blockEntity = block = (LivingEntity)entity;
                }
                this.m_216990_((SoundEvent)SoundInit.IMMORTAL_EXECUTIONER_BLOCK.get());
                this.playAnimation(this.blockAnimation);
                return false;
            }
            if (this.m_5448_() != null && this.isNoAnimation() && this.hurtCount >= 6) {
                this.hurtCount = 0;
                this.nextAvoidTick = AVOID_INTERVAL.m_214085_(this.f_19796_);
                this.checkAndPlayComboAnimations(true, this.avoidAnimation, this.sidesWayAnimationLeft, this.sidesWayAnimationRight);
            }
            return super.m_6469_(source, damage);
        }
        if (source.m_269533_(EMTagKey.GENERAL_UNRESISTANT_TO)) {
            return super.m_6469_(source, damage);
        }
        return false;
    }

    public double m_142593_(LivingEntity entity) {
        return this.m_20205_() * 2.5f * this.m_20205_() * 2.5f + entity.m_20205_();
    }

    @Override
    protected void m_147246_() {
    }

    @Override
    public Animation getDeathAnimation() {
        return this.dieAnimation;
    }

    @Override
    public Animation[] getAnimations() {
        return this.animations;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SoundInit.IMMORTAL_EXECUTIONER_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundInit.IMMORTAL_EXECUTIONER_DEATH.get();
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 120.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22284_, 12.0).m_22268_(Attributes.f_22279_, 0.34).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22278_, 0.85).m_22268_(Attributes.f_22282_, 0.15);
    }

    public float getFirePower() {
        Animation animation;
        float multiplier = 1.0f;
        if (this.m_20071_() || this.m_146890_()) {
            multiplier = 0.5f;
        }
        if (this.m_20077_() || this.m_6060_()) {
            multiplier = 1.2f;
        }
        if ((animation = this.getAnimation()) == this.impactStorageAnimation || animation == this.impactHoldAnimation) {
            multiplier += 0.2f;
        }
        return multiplier;
    }

    public void executionerHurtTarget(LivingEntity hitEntity, boolean disableShield) {
        Player player;
        double baseDamage = this.m_21133_(Attributes.f_22281_);
        boolean flag = hitEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)(baseDamage * (double)this.getFirePower()));
        if (flag && disableShield && hitEntity instanceof Player && (player = (Player)hitEntity).m_21254_()) {
            player.m_36384_(true);
        }
        if (flag) {
            hitEntity.m_147207_(new MobEffectInstance((MobEffect)EffectInit.ERODE_EFFECT.get(), 200), (Entity)this);
        }
    }

    public boolean inBlocking() {
        return !this.m_9236_().f_46443_ && this.getAnimation() == this.blockAnimation && this.getAnimationTick() > 1;
    }

    private void checkAndPlayComboAnimations(boolean conditions, Animation ... combos) {
        if (conditions) {
            this.playAnimation(combos[this.f_19796_.m_188503_(combos.length)]);
        }
    }

    private void fastMove(float speed, float sideAvoidYaw) {
        Vec3 move = this.m_20184_().m_82520_((double)speed * Math.cos(sideAvoidYaw), 0.0, (double)speed * Math.sin(sideAvoidYaw));
        this.m_20334_(move.f_82479_, this.m_20184_().f_82480_, move.f_82481_);
        this.doRibbonEffect();
    }

    private void doSoulFireEffect(int yaw, float scale, int duration) {
        AdvancedParticleBase.spawnParticle(this.m_9236_(), (ParticleType<AdvancedParticleData>)((ParticleType)ParticleInit.STRIP_SOUL_FIRE.get()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0, false, yaw, 0.0, 0.0, 0.0, scale, 1.0, 1.0, 1.0, 0.8, 0.0, duration, true, false, true, new ParticleComponent[]{new ParticleComponent.PinLocation(this.fire), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Y, AnimData.constant(0.2f), true)});
    }

    private ImpartHitResult raytraceEntities(Vec3 from, Vec3 to) {
        ImpartHitResult result = new ImpartHitResult();
        result.setBlockHit((HitResult)this.m_9236_().m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)));
        if (result.getBlockHit() != null) {
            to = result.getBlockHit().m_82450_();
        }
        List entities = this.m_9236_().m_45976_(LivingEntity.class, new AABB(from, to).m_82377_(1.0, 2.5, 1.0));
        for (LivingEntity entity : entities) {
            if (this == entity) continue;
            AABB aabb = entity.m_20191_().m_82377_(1.0, 2.5, 1.0);
            Optional hit = aabb.m_82371_(from, to);
            if (aabb.m_82390_(from)) {
                result.addEntityHit(entity);
                continue;
            }
            if (!hit.isPresent()) continue;
            result.addEntityHit(entity);
        }
        return result;
    }

    private void doRibbonEffect() {
        if (this.m_9236_().f_46443_ && this.fire != null && this.fire.length != 0) {
            AdvancedParticleBase.spawnParticle(this.m_9236_(), (ParticleType<AdvancedParticleData>)((ParticleType)ParticleInit.ADV_ORB.get()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 10.0, true, false, false, new ParticleComponent[]{new ParticleComponent.PinLocation(this.fire), new RibbonComponent((ParticleType<? extends RibbonParticleData>)((ParticleType)ParticleInit.FLAT_RIBBON.get()), 8, 0.0, 0.0, 0.0, 0.12f, 0.06, 0.94, 1.0, 0.75, true, true, new ParticleComponent[]{new RibbonComponent.PropertyOverLength(RibbonComponent.PropertyOverLength.EnumRibbonProperty.ALPHA, AnimData.KeyTrack.startAndEnd(0.5f, 1.0f)), new RibbonComponent.PropertyOverLength(RibbonComponent.PropertyOverLength.EnumRibbonProperty.SCALE, AnimData.KeyTrack.startAndEnd(1.0f, 0.0f))}, false)});
        }
    }

    static class ExecutionerCullGoal
    extends ExecutionerSimpleAI {
        public ExecutionerCullGoal(EntityImmortalExecutioner entity) {
            super(entity, true, () -> entity.cullStorageAnimation, () -> entity.cullHoldAnimation, () -> entity.cullStopAnimation, () -> entity.counterAnimation);
        }

        @Override
        public void m_8037_() {
            Animation animation = ((EntityImmortalExecutioner)this.entity).getAnimation();
            LivingEntity target = ((EntityImmortalExecutioner)this.entity).m_5448_();
            int tick = ((EntityImmortalExecutioner)this.entity).getAnimationTick();
            if (animation == ((EntityImmortalExecutioner)this.entity).cullStorageAnimation) {
                super.m_8037_();
                this.doNextAnimation(animation, ((EntityImmortalExecutioner)this.entity).cullHoldAnimation);
            } else if (animation == ((EntityImmortalExecutioner)this.entity).cullHoldAnimation) {
                if (target != null) {
                    if (tick < 4) {
                        super.m_8037_();
                    } else if (tick == 4) {
                        this.pursuit(15.0f, 5.0f, target.m_20186_() - ((EntityImmortalExecutioner)this.entity).m_20186_());
                    } else if (tick == 5) {
                        this.doHurtTarget(100.0f, 3.8f, true);
                    } else if (tick > 6) {
                        ((EntityImmortalExecutioner)this.entity).m_146922_(((EntityImmortalExecutioner)this.entity).f_19859_);
                    }
                    this.doNextAnimation(animation, ((EntityImmortalExecutioner)this.entity).cullStopAnimation);
                } else {
                    ((EntityImmortalExecutioner)this.entity).playAnimation(((EntityImmortalExecutioner)this.entity).cullStopAnimation);
                }
            } else if (animation == ((EntityImmortalExecutioner)this.entity).counterAnimation) {
                if (tick < 5) {
                    super.m_8037_();
                } else if (tick == 5) {
                    this.pursuit(5.0f, 3.0f, target != null ? target.m_20186_() - ((EntityImmortalExecutioner)this.entity).m_20186_() : ((EntityImmortalExecutioner)this.entity).m_20186_());
                } else if (tick == 6) {
                    this.doHurtTarget(140.0f, 4.0f, false);
                } else if (tick > 7) {
                    ((EntityImmortalExecutioner)this.entity).m_146922_(((EntityImmortalExecutioner)this.entity).f_19859_);
                }
            }
        }

        private void doHurtTarget(float attackArc, float range, boolean knock) {
            List<LivingEntity> entities = ((EntityImmortalExecutioner)this.entity).getNearByLivingEntities(range, range - 0.5f, range, range);
            for (LivingEntity livingEntity : entities) {
                float entityRelativeAngle = ModEntityUtils.getTargetRelativeAngle((LivingEntity)this.entity, livingEntity);
                float entityHitDistance = (float)Math.sqrt((livingEntity.m_20189_() - ((EntityImmortalExecutioner)this.entity).m_20189_()) * (livingEntity.m_20189_() - ((EntityImmortalExecutioner)this.entity).m_20189_()) + (livingEntity.m_20185_() - ((EntityImmortalExecutioner)this.entity).m_20185_()) * (livingEntity.m_20185_() - ((EntityImmortalExecutioner)this.entity).m_20185_())) - livingEntity.m_20205_() / 2.0f;
                if (!(entityHitDistance <= range && entityRelativeAngle <= attackArc / 2.0f && entityRelativeAngle >= -attackArc / 2.0f || entityRelativeAngle >= 360.0f - attackArc / 2.0f) && !(entityRelativeAngle <= -360.0f + attackArc / 2.0f)) continue;
                ((EntityImmortalExecutioner)this.entity).executionerHurtTarget(livingEntity, ((EntityImmortalExecutioner)this.entity).getFirePower() > 1.0f);
                if (!knock) continue;
                livingEntity.m_20256_(livingEntity.m_20184_().m_82520_(0.0, 0.45, 0.0));
            }
        }

        private void pursuit(float pursuitDistance, float moveMultiplier, double y) {
            float targetDistance = ((EntityImmortalExecutioner)this.entity).targetDistance;
            if (((EntityImmortalExecutioner)this.entity).m_5448_() != null && ((EntityImmortalExecutioner)this.entity).m_5448_().m_6084_() && targetDistance < pursuitDistance && targetDistance > 0.0f) {
                moveMultiplier = targetDistance - 0.25f;
            }
            targetDistance = ((EntityImmortalExecutioner)this.entity).targetDistance;
            if (((EntityImmortalExecutioner)this.entity).m_5448_() == null || targetDistance > 1.0f) {
                ((EntityImmortalExecutioner)this.entity).m_6478_(MoverType.SELF, new Vec3(Math.cos(Math.toRadians(((EntityImmortalExecutioner)this.entity).m_146908_() + 90.0f)) * (double)moveMultiplier, y, Math.sin(Math.toRadians(((EntityImmortalExecutioner)this.entity).m_146908_() + 90.0f)) * (double)moveMultiplier));
            }
        }
    }

    static class ExecutionerSharpImpactGoal
    extends ExecutionerSimpleAI {
        private LivingEntity target;

        public ExecutionerSharpImpactGoal(EntityImmortalExecutioner entity) {
            super(entity, false, () -> entity.impactStorageAnimation, () -> entity.impactHoldAnimation, () -> entity.impactStopAnimation);
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.target = ((EntityImmortalExecutioner)this.entity).m_5448_();
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.target = null;
        }

        @Override
        public void m_8037_() {
            int tick = ((EntityImmortalExecutioner)this.entity).getAnimationTick();
            Animation animation = ((EntityImmortalExecutioner)this.entity).getAnimation();
            if (animation == ((EntityImmortalExecutioner)this.entity).impactStorageAnimation) {
                ((EntityImmortalExecutioner)this.entity).m_20334_(0.0, 0.025f, 0.0);
                if (this.target != null) {
                    ((EntityImmortalExecutioner)this.entity).m_21563_().m_24960_((Entity)this.target, 360.0f, 30.0f);
                    ((EntityImmortalExecutioner)this.entity).m_21391_((Entity)this.target, 360.0f, 30.0f);
                }
                this.doNextAnimation(animation, ((EntityImmortalExecutioner)this.entity).impactHoldAnimation, 25 + ((EntityImmortalExecutioner)this.entity).m_217043_().m_188503_(animation.getDuration() - 25));
            } else if (animation == ((EntityImmortalExecutioner)this.entity).impactHoldAnimation) {
                ((EntityImmortalExecutioner)this.entity).m_20334_(0.0, 0.0, 0.0);
                double baseMoveMultiplier = 15.0;
                double deltaY = Math.ceil(((EntityImmortalExecutioner)this.entity).m_20186_() - 0.5);
                if (tick == 2) {
                    Vec3 point;
                    Vec3 preVec3 = ((EntityImmortalExecutioner)this.entity).m_20182_();
                    Vec3 targetVec3 = new Vec3(Math.cos(Math.toRadians(((EntityImmortalExecutioner)this.entity).m_146908_() + 90.0f)) * baseMoveMultiplier, deltaY, Math.sin(Math.toRadians(((EntityImmortalExecutioner)this.entity).m_146908_() + 90.0f)) * baseMoveMultiplier);
                    if (this.target != null && (baseMoveMultiplier = Math.min((point = ModEntityUtils.findPounceTargetPoint((Entity)this.entity, (Entity)this.target, 5.0)).m_82554_(preVec3), 20.0)) >= 1.0) {
                        deltaY = point.f_82480_ - ((EntityImmortalExecutioner)this.entity).m_20186_();
                        Vec3 normalizedVector = point.m_82546_(preVec3).m_82541_().m_82490_(baseMoveMultiplier);
                        targetVec3 = new Vec3(normalizedVector.f_82479_, deltaY, normalizedVector.f_82481_);
                    }
                    ((EntityImmortalExecutioner)this.entity).m_6478_(MoverType.SELF, targetVec3);
                    ImpartHitResult hitResult = ((EntityImmortalExecutioner)this.entity).raytraceEntities(preVec3, ((EntityImmortalExecutioner)this.entity).m_20182_());
                    hitResult.getEntities().forEach(hitEntity -> ((EntityImmortalExecutioner)this.entity).executionerHurtTarget((LivingEntity)hitEntity, true));
                    if (hitResult.getBlockHit() != null && hitResult.getBlockHit().m_6662_() == HitResult.Type.BLOCK) {
                        ((EntityImmortalExecutioner)this.entity).m_146884_(hitResult.getBlockHit().m_82450_().m_82520_(0.0, 0.5, 0.0));
                        ((EntityImmortalExecutioner)this.entity).m_7292_(new MobEffectInstance((MobEffect)EffectInit.VERTIGO_EFFECT.get(), 50, 0, false, false));
                    }
                }
                this.doNextAnimation(animation, ((EntityImmortalExecutioner)this.entity).impactStopAnimation);
            }
        }
    }

    static class ExecutionerSimpleAI
    extends AnimationAI<EntityImmortalExecutioner> {
        private final boolean lookAtTarget;
        private final Supplier<Animation>[] animations;

        @SafeVarargs
        public ExecutionerSimpleAI(EntityImmortalExecutioner entity, boolean lookAtTarget, Supplier<Animation> ... animations) {
            super(entity);
            this.lookAtTarget = lookAtTarget;
            this.animations = animations;
        }

        @Override
        protected boolean test(Animation animation) {
            return Arrays.stream(this.animations).anyMatch(supplier -> animation == supplier.get());
        }

        public void m_8037_() {
            super.m_8037_();
            LivingEntity target = ((EntityImmortalExecutioner)this.entity).m_5448_();
            if (this.lookAtTarget && target != null) {
                ((EntityImmortalExecutioner)this.entity).m_21563_().m_24960_((Entity)target, 180.0f, 30.0f);
                ((EntityImmortalExecutioner)this.entity).m_21391_((Entity)target, 180.0f, 30.0f);
            }
        }

        protected void doNextAnimation(Animation now, Animation next) {
            this.doNextAnimation(now, next, now.getDuration() - 1);
        }

        protected void doNextAnimation(Animation now, Animation next, int lastTick) {
            if (((EntityImmortalExecutioner)this.entity).getAnimation() == now && ((EntityImmortalExecutioner)this.entity).getAnimationTick() >= lastTick) {
                ((EntityImmortalExecutioner)this.entity).playAnimation(next);
            }
        }
    }

    public static class ImpartHitResult {
        private BlockHitResult blockHit;
        private final List<LivingEntity> entities = new ArrayList<LivingEntity>();

        @Nullable
        public BlockHitResult getBlockHit() {
            return this.blockHit;
        }

        public List<LivingEntity> getEntities() {
            return this.entities;
        }

        public void setBlockHit(HitResult rayTraceResult) {
            if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK) {
                this.blockHit = (BlockHitResult)rayTraceResult;
            }
        }

        public void addEntityHit(LivingEntity entity) {
            this.entities.add(entity);
        }
    }
}

