/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.effects;

import com.eeeab.eeeabsmobs.client.particle.util.AdvancedParticleData;
import com.eeeab.eeeabsmobs.client.particle.util.ParticleComponent;
import com.eeeab.eeeabsmobs.client.particle.util.anim.AnimData;
import com.eeeab.eeeabsmobs.client.util.ControlledAnimation;
import com.eeeab.eeeabsmobs.client.util.ModParticleUtils;
import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityMagicEffects;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityScorch;
import com.eeeab.eeeabsmobs.sever.entity.guling.EntityNamelessGuardian;
import com.eeeab.eeeabsmobs.sever.init.ParticleInit;
import com.eeeab.eeeabsmobs.sever.util.damage.EMDamageSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityGuardianLaser
extends EntityMagicEffects {
    public static final double GUARDIAN_RADIUS = 32.0;
    public static final int PRE_SHOOT_DURATION = 20;
    public double endPosX;
    public double endPosY;
    public double endPosZ;
    public double collidePosX;
    public double collidePosY;
    public double collidePosZ;
    public double prevCollidePosX;
    public double prevCollidePosY;
    public double prevCollidePosZ;
    public float yHeadRotAngle;
    public float xHeadRotAngle;
    public ControlledAnimation displayControlled = new ControlledAnimation(3);
    public boolean ON = true;
    public Direction blockSide = null;
    private static final EntityDataAccessor<Float> Y_HEAD_ROT_ANGLE = SynchedEntityData.m_135353_(EntityGuardianLaser.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> X_HEAD_ROT_ANGLE = SynchedEntityData.m_135353_(EntityGuardianLaser.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DURATION = SynchedEntityData.m_135353_(EntityGuardianLaser.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_PLAYER = SynchedEntityData.m_135353_(EntityGuardianLaser.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float prevYHeadRotAngle;
    public float prevXHeadRotAngle;
    @OnlyIn(value=Dist.CLIENT)
    private Vec3[] attractorPos;

    public EntityGuardianLaser(EntityType<? extends EntityGuardianLaser> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
        if (level.f_46443_) {
            this.attractorPos = new Vec3[]{new Vec3(0.0, 0.0, 0.0)};
        }
    }

    public EntityGuardianLaser(EntityType<? extends EntityGuardianLaser> type, Level world, LivingEntity caster, double x, double y, double z, float yaw, float pitch, int duration) {
        this(type, world);
        this.caster = caster;
        this.setYHeadRotAngle(yaw);
        this.setXHeadRotAngle(pitch);
        this.setDuration(duration);
        this.m_6034_(x, y, z);
        this.calculateEndPos();
        if (!this.m_9236_().f_46443_) {
            this.setCasterId(caster.m_19879_());
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.prevCollidePosX = this.collidePosX;
        this.prevCollidePosY = this.collidePosY;
        this.prevCollidePosZ = this.collidePosZ;
        this.prevYHeadRotAngle = this.yHeadRotAngle;
        this.prevXHeadRotAngle = this.xHeadRotAngle;
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        if (this.f_19797_ == 1 && this.m_9236_().f_46443_) {
            this.caster = (LivingEntity)this.m_9236_().m_6815_(this.getCasterId());
        }
        if (!this.m_9236_().f_46443_) {
            if (this.isPlayer() && this.caster instanceof Player) {
                this.updateWithPlayer();
            } else if (this.caster instanceof EntityNamelessGuardian) {
                this.updateWithGuardian();
            } else if (this.caster != null) {
                this.updateWithEntity(0.0f);
            }
        }
        if (this.caster != null) {
            this.yHeadRotAngle = (float)Math.toRadians(this.caster.f_20885_ + 90.0f);
            this.xHeadRotAngle = (float)(-Math.toRadians(this.caster.m_146909_()));
        }
        if (!this.ON && this.displayControlled.isStop()) {
            this.m_146870_();
        }
        if (this.ON && !this.isAccumulating()) {
            this.displayControlled.increaseTimer();
        } else {
            this.displayControlled.decreaseTimer();
        }
        if (this.caster != null && !this.caster.m_6084_()) {
            this.m_146870_();
        }
        if (this.m_9236_().f_46443_ && this.f_19797_ <= 10 && this.caster != null) {
            double rootX = this.caster.m_20185_();
            double rootY = this.caster.m_20186_() + (double)(this.caster.m_20206_() / 2.0f) + (double)0.3f;
            double rootZ = this.caster.m_20189_();
            this.attractorPos[0] = new Vec3(rootX, rootY, rootZ);
            ModParticleUtils.advAttractorParticle((ParticleType<AdvancedParticleData>)((ParticleType)ParticleInit.ADV_ORB.get()), (Entity)this.caster, 12, 0.5f, 5.0f, 8.0f, new ParticleComponent[]{new ParticleComponent.Attractor(this.attractorPos, 1.6f, 0.0f, ParticleComponent.Attractor.EnumAttractorBehavior.EXPONENTIAL), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, AnimData.KeyTrack.startAndEnd(0.0f, 0.6f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, AnimData.KeyTrack.startAndEnd(6.0f, 3.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.RED, AnimData.KeyTrack.startAndEnd(1.0f, 0.3f), false)}, false);
        }
        if (this.f_19797_ > 20) {
            this.calculateEndPos();
            List<LivingEntity> hit = this.raytraceEntities((Level)this.m_9236_(), (Vec3)new Vec3((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_()), (Vec3)new Vec3((double)this.endPosX, (double)this.endPosY, (double)this.endPosZ)).entities;
            if (this.blockSide != null) {
                this.spawnExplosionParticles(2);
                if (!this.m_9236_().f_46443_ && !this.isPlayer() && ((Boolean)EMConfigHandler.COMMON.ENTITY.GUARDIAN_LASER.enableGenerateScorchEntity.get()).booleanValue()) {
                    EntityScorch scorch = new EntityScorch(this.m_9236_(), this.prevCollidePosX, this.prevCollidePosY, this.prevCollidePosZ);
                    this.m_9236_().m_7967_((Entity)scorch);
                }
            }
            if (!this.m_9236_().f_46443_) {
                for (LivingEntity target : hit) {
                    target.m_20254_(3);
                    LivingEntity livingEntity = this.caster;
                    if (livingEntity instanceof EntityNamelessGuardian) {
                        EntityNamelessGuardian guardian = (EntityNamelessGuardian)livingEntity;
                        guardian.guardianHurtTarget(EMDamageSource.guardianLaserAttack(this, (Entity)guardian), guardian, target, 0.035f, 0.22f, 1.0f, true, false, false);
                        continue;
                    }
                    if (this.caster == null) continue;
                    target.m_6469_(this.m_269291_().m_269333_(this.caster), 5.0f + target.m_21233_() * 0.01f);
                }
            }
        }
        if (this.f_19797_ - 20 > this.getDuration()) {
            this.ON = false;
        }
    }

    public boolean isAccumulating() {
        return this.f_19797_ <= 20;
    }

    private void spawnExplosionParticles(int amount) {
        int i;
        for (i = 0; i < amount; ++i) {
            float velocity = 0.2f;
            float yaw = (float)((double)(this.f_19796_.m_188501_() * 2.0f) * Math.PI);
            float motionY = this.f_19796_.m_188501_() * 0.2f;
            float motionX = 0.2f * Mth.m_14089_((float)yaw);
            float motionZ = 0.2f * Mth.m_14031_((float)yaw);
            this.m_9236_().m_7106_((ParticleOptions)ParticleInit.GUARDIAN_SPARK.get(), this.collidePosX, this.collidePosY + 0.1, this.collidePosZ, (double)motionX, (double)motionY, (double)motionZ);
        }
        for (i = 0; i < amount / 2; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123756_, this.collidePosX, this.collidePosY, this.collidePosZ, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(Y_HEAD_ROT_ANGLE, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(X_HEAD_ROT_ANGLE, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(DURATION, (Object)0);
        this.m_20088_().m_135372_(IS_PLAYER, (Object)false);
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        if (this.caster == null) {
            this.m_146870_();
        }
    }

    public float getYHeadRotAngle() {
        return ((Float)this.m_20088_().m_135370_(Y_HEAD_ROT_ANGLE)).floatValue();
    }

    public void setYHeadRotAngle(float rotAngle) {
        this.m_20088_().m_135381_(Y_HEAD_ROT_ANGLE, (Object)Float.valueOf(rotAngle));
    }

    public boolean isPlayer() {
        return (Boolean)this.m_20088_().m_135370_(IS_PLAYER);
    }

    public void setPlayer(boolean flag) {
        this.m_20088_().m_135381_(IS_PLAYER, (Object)flag);
    }

    public float getXHeadRotAngle() {
        return ((Float)this.m_20088_().m_135370_(X_HEAD_ROT_ANGLE)).floatValue();
    }

    public void setXHeadRotAngle(float rotAngle) {
        this.m_20088_().m_135381_(X_HEAD_ROT_ANGLE, (Object)Float.valueOf(rotAngle));
    }

    public int getDuration() {
        return (Integer)this.m_20088_().m_135370_(DURATION);
    }

    public void setDuration(int duration) {
        this.m_20088_().m_135381_(DURATION, (Object)duration);
    }

    private void calculateEndPos() {
        double radius;
        double d = radius = this.isPlayer() ? (Double)EMConfigHandler.COMMON.ENTITY.GUARDIAN_LASER.playerShootRadius.get() : 32.0;
        if (this.m_9236_().m_5776_()) {
            this.endPosX = this.m_20185_() + radius * Math.cos(this.yHeadRotAngle) * Math.cos(this.xHeadRotAngle);
            this.endPosZ = this.m_20189_() + radius * Math.sin(this.yHeadRotAngle) * Math.cos(this.xHeadRotAngle);
            this.endPosY = this.m_20186_() + radius * Math.sin(this.xHeadRotAngle);
        } else {
            this.endPosX = this.m_20185_() + radius * Math.cos(this.getYHeadRotAngle()) * Math.cos(this.getXHeadRotAngle());
            this.endPosZ = this.m_20189_() + radius * Math.sin(this.getYHeadRotAngle()) * Math.cos(this.getXHeadRotAngle());
            this.endPosY = this.m_20186_() + radius * Math.sin(this.getXHeadRotAngle());
        }
    }

    public LaserHitResult raytraceEntities(Level world, Vec3 from, Vec3 to) {
        LaserHitResult result = new LaserHitResult();
        result.setBlockHit((HitResult)world.m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)));
        if (result.getBlockHit() != null) {
            Vec3 hitVec = result.getBlockHit().m_82450_();
            this.collidePosX = hitVec.f_82479_;
            this.collidePosY = hitVec.f_82480_;
            this.collidePosZ = hitVec.f_82481_;
            this.blockSide = result.getBlockHit().m_82434_();
        } else {
            this.collidePosX = this.endPosX;
            this.collidePosY = this.endPosY;
            this.collidePosZ = this.endPosZ;
            this.blockSide = null;
        }
        List entities = world.m_45976_(LivingEntity.class, new AABB(Math.min(this.m_20185_(), this.collidePosX), Math.min(this.m_20186_(), this.collidePosY), Math.min(this.m_20189_(), this.collidePosZ), Math.max(this.m_20185_(), this.collidePosX), Math.max(this.m_20186_(), this.collidePosY), Math.max(this.m_20189_(), this.collidePosZ)).m_82377_(1.0, 1.0, 1.0));
        for (LivingEntity entity : entities) {
            if (entity == this.caster) continue;
            float pad = entity.m_6143_() + 0.5f;
            AABB aabb = entity.m_20191_().m_82377_((double)pad, (double)pad, (double)pad);
            Optional hit = aabb.m_82371_(from, to);
            if (aabb.m_82390_(from)) {
                result.addEntityHit(entity);
                continue;
            }
            if (!hit.isPresent()) continue;
            result.addEntityHit(entity);
        }
        return result;
    }

    public boolean m_6783_(double distance) {
        Double radius = (Double)EMConfigHandler.COMMON.ENTITY.GUARDIAN_LASER.playerShootRadius.get();
        return this.isPlayer() ? distance < radius * radius * 2.0 : distance < 2048.0;
    }

    private void updateWithPlayer() {
        this.setYHeadRotAngle((float)Math.toRadians(this.caster.f_20885_ + 90.0f));
        this.setXHeadRotAngle((float)Math.toRadians(-this.caster.m_146909_()));
        Vec3 vecOffset = this.caster.m_20154_().m_82541_().m_82490_(1.0);
        this.m_6034_(this.caster.m_20185_() + vecOffset.m_7096_(), this.caster.m_20186_() + (double)(this.caster.m_20206_() * 0.5f) + vecOffset.m_7098_(), this.caster.m_20189_() + vecOffset.m_7094_());
    }

    private void updateWithGuardian() {
        this.updateWithEntity(1.35f);
    }

    private void updateWithEntity(float offset) {
        double radians = Math.toRadians(this.caster.f_20885_ + 90.0f);
        this.setYHeadRotAngle((float)radians);
        this.setXHeadRotAngle((float)((double)(-this.caster.m_146909_()) * Math.PI / 180.0));
        double offsetX = Math.cos(radians) * (double)offset;
        double offsetZ = Math.sin(radians) * (double)offset;
        this.m_6034_(this.caster.m_20185_() + offsetX, this.caster.m_20186_() + (double)(this.caster.m_20206_() * 0.75f), this.caster.m_20189_() + offsetZ);
    }

    public static class LaserHitResult {
        private BlockHitResult blockHit;
        private final List<LivingEntity> entities = new ArrayList<LivingEntity>();

        public BlockHitResult getBlockHit() {
            return this.blockHit;
        }

        public void setBlockHit(HitResult rayTraceResult) {
            if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK) {
                this.blockHit = (BlockHitResult)rayTraceResult;
            }
        }

        public void addEntityHit(LivingEntity entity) {
            this.entities.add(entity);
        }
    }
}

