/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.effects;

import com.eeeab.eeeabsmobs.client.util.ControlledAnimation;
import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityMagicEffects;
import com.eeeab.eeeabsmobs.sever.entity.guling.EntityNamelessGuardian;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.init.EntityInit;
import com.eeeab.eeeabsmobs.sever.init.ParticleInit;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class EntityGuardianBlade
extends EntityMagicEffects {
    public final ControlledAnimation controlled = new ControlledAnimation(100);
    private static final int DURATION = 35;
    private boolean moveOffset;
    private float damage = 1.0f;
    private static final float[][] BLOCK_OFFSETS = new float[][]{{-0.5f, -0.5f}, {-0.5f, 0.5f}, {0.5f, 0.5f}, {0.5f, -0.5f}};

    public EntityGuardianBlade(EntityType<?> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
    }

    public EntityGuardianBlade(Level level, LivingEntity caster, double x, double y, double z, float yRot, boolean moveOffset) {
        this((EntityType)EntityInit.GUARDIAN_BLADE.get(), level);
        this.moveOffset = moveOffset;
        this.caster = caster;
        this.m_146922_(yRot * 57.295776f - 90.0f);
        this.m_6034_(x, y, z);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.controlled.updatePrevTimer();
        this.m_6478_(MoverType.SELF, this.m_20184_());
        if (this.controlled.isStop()) {
            Vec3 lookAngle = this.m_20154_();
            float speed = 1.35f;
            if (this.moveOffset) {
                speed += this.f_19796_.m_188501_() * 0.5f;
            }
            this.shoot(lookAngle.f_82479_, lookAngle.f_82480_, lookAngle.f_82481_, speed);
            if (this.caster != null) {
                this.damage = (float)this.caster.m_21133_(Attributes.f_22281_);
            }
            this.controlled.increaseTimer(1);
        } else if (this.controlled.increaseTimerChain().getTimer() <= 35 && this.controlled.getTimer() % 5 == 0) {
            double ac = 0.5;
            this.m_20256_(this.m_20184_().m_82542_(ac, ac, ac));
        }
        if (this.controlled.getTimer() > 35 || this.f_19797_ > this.controlled.getDuration()) {
            this.m_146870_();
        } else {
            this.breakBlockEffect();
            this.doHurtTarget();
        }
    }

    private void shoot(double x, double y, double z, double speed) {
        this.m_20334_(x * speed, y * speed, z * speed);
    }

    private void doHurtTarget() {
        if (!this.m_9236_().f_46443_) {
            float progress = this.controlled.getAnimationProgressTemporaryInvesed();
            if ((double)progress < 0.2) {
                return;
            }
            List entities = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(0.2));
            for (LivingEntity target : entities) {
                if (target == this.caster) continue;
                if (this.caster instanceof EntityNamelessGuardian) {
                    this.damage += target.m_21233_() * 0.05f;
                }
                if (this.caster instanceof Player) {
                    this.damage = (float)Math.min(EMConfigHandler.COMMON.ITEM.GUARDIAN_AXE_TOOL.attackDamageValue * 2.0, (double)this.damage);
                }
                this.damage = Math.max(1.0f, this.damage * progress);
                this.damage = ModEntityUtils.actualDamageIsCalculatedBasedOnArmor(this.damage, target.m_21230_(), (float)target.m_21133_(Attributes.f_22285_), 1.0f);
                target.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)this.caster), this.damage);
            }
        }
    }

    private void breakBlockEffect() {
        if (this.m_9236_().f_46443_) {
            double theta = (double)this.m_146908_() * (Math.PI / 180);
            double perpX = Math.cos(theta);
            double perpZ = Math.sin(theta);
            double vecX = Math.cos(theta += 1.5707963267948966);
            double vecZ = Math.sin(theta);
            double x = this.m_20185_() + 1.0 * vecX;
            double y = this.m_20191_().f_82289_ + 0.1;
            double z = this.m_20189_() + 1.0 * vecZ;
            int hitY = Mth.m_14107_((double)(this.m_20186_() - 0.2));
            for (float[] floats : BLOCK_OFFSETS) {
                float ox = floats[0];
                float oy = floats[1];
                int hitX = Mth.m_14107_((double)(x + (double)ox));
                int hitZ = Mth.m_14107_((double)(z + (double)oy));
                BlockPos hit = new BlockPos(hitX, hitY, hitZ);
                BlockState block = this.m_9236_().m_8055_(hit);
                if (block.m_60799_() == RenderShape.INVISIBLE) continue;
                double count = Math.max(0.0, Math.floor(15.0f * this.controlled.getAnimationProgressTemporaryInvesed()) - 2.0);
                int n = 0;
                while ((double)n < count) {
                    double pa = this.f_19796_.m_188500_() * 2.0 * Math.PI;
                    double pd = this.f_19796_.m_188500_() * 0.6 - 0.1;
                    double px = x + Math.cos(pa) * pd;
                    double pz = z + Math.sin(pa) * pd;
                    double magnitude = this.f_19796_.m_188500_() * 4.0 + 5.0;
                    double velX = perpX * magnitude;
                    double velY = this.f_19796_.m_188500_() * 3.0 + 6.0;
                    double velZ = perpZ * magnitude;
                    if (vecX * (pz - this.m_20189_()) - vecZ * (px - this.m_20185_()) > 0.0) {
                        velX = -velX;
                        velZ = -velZ;
                    }
                    this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), px, y, pz, velX, velY, velZ);
                    ++n;
                }
            }
            if (this.controlled.getTimer() % 6 == 0) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleInit.GUARDIAN_SPARK.get(), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, (double)(this.f_19796_.m_188501_() * 0.05f), 0.0);
            }
        }
    }
}

