/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.effects;

import com.eeeab.eeeabsmobs.client.util.ControlledAnimation;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityMagicEffects;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.init.EntityInit;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityCrimsonRay
extends EntityMagicEffects {
    public static final double ATTACK_RADIUS = 16.0;
    public static final int PRE_SHOOT_DURATION = 1;
    public double endPosX;
    public double endPosY;
    public double endPosZ;
    public double collidePosX;
    public double collidePosY;
    public double collidePosZ;
    public double prevCollidePosX;
    public double prevCollidePosY;
    public double prevCollidePosZ;
    public float yaw;
    public float pitch;
    public float preYaw;
    public float prePitch;
    public ControlledAnimation displayControlled = new ControlledAnimation(3);
    public boolean ON = true;
    public Direction blockSide = null;
    private static final EntityDataAccessor<Float> YAW = SynchedEntityData.m_135353_(EntityCrimsonRay.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> PITCH = SynchedEntityData.m_135353_(EntityCrimsonRay.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DURATION = SynchedEntityData.m_135353_(EntityCrimsonRay.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public EntityCrimsonRay(EntityType<? extends EntityCrimsonRay> type, Level level) {
        super(type, level);
        this.f_19811_ = true;
    }

    public EntityCrimsonRay(Level world, LivingEntity caster, Vec3 pos, int duration) {
        this((EntityType<? extends EntityCrimsonRay>)((EntityType)EntityInit.CRIMSON_RAY.get()), world);
        this.caster = caster;
        this.setPitch(1.5707964f);
        this.setYaw((float)((double)(this.m_146908_() - 90.0f) * Math.PI / 180.0));
        this.setDuration(duration);
        this.m_146884_(pos);
        this.calculateEndPos();
        if (!this.m_9236_().f_46443_) {
            this.setCasterId(caster.m_19879_());
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.prevCollidePosX = this.collidePosX;
        this.prevCollidePosY = this.collidePosY;
        this.prevCollidePosZ = this.collidePosZ;
        this.preYaw = this.yaw;
        this.prePitch = this.pitch;
        this.yaw = this.getYaw();
        this.pitch = this.getPitch();
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        if (this.f_19797_ == 1 && this.m_9236_().f_46443_) {
            this.caster = (LivingEntity)this.m_9236_().m_6815_(this.getCasterId());
        }
        if (this.f_19797_ >= 1) {
            if (this.f_19797_ == 1) {
                this.m_5496_((SoundEvent)SoundInit.CRIMSON_RAY.get(), 0.25f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * -0.2f + 1.0f);
            }
            this.calculateEndPos();
            List<LivingEntity> hit = this.raytraceEntities((Level)this.m_9236_(), (Vec3)new Vec3((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_()), (Vec3)new Vec3((double)this.endPosX, (double)this.endPosY, (double)this.endPosZ)).entities;
            if (this.blockSide != null) {
                if (!this.m_9236_().f_46443_) {
                    BlockPos minPos = new BlockPos(Mth.m_14107_((double)(this.collidePosX - 0.5)), Mth.m_14107_((double)(this.collidePosY - 0.5)), Mth.m_14107_((double)(this.collidePosZ - 0.5)));
                    BlockPos maxPos = new BlockPos(Mth.m_14107_((double)(this.collidePosX + 0.5)), Mth.m_14107_((double)(this.collidePosY + 0.5)), Mth.m_14107_((double)(this.collidePosZ + 0.5)));
                    BlockPos.m_121990_((BlockPos)minPos, (BlockPos)maxPos).forEach(pos -> {
                        if (ModEntityUtils.canDestroyBlock(this.m_9236_(), pos, this, 50.0f) && ModEntityUtils.canMobDestroy(this)) {
                            this.m_9236_().m_46961_(pos, false);
                        }
                    });
                } else {
                    this.spawnExplosionParticles();
                }
            }
            if (!this.m_9236_().f_46443_) {
                for (LivingEntity target : hit) {
                    if (target == this.caster) continue;
                    target.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)this.caster), 5.0f + target.m_21233_() * 0.01f);
                }
            }
        }
        if (!this.ON && this.displayControlled.isStop() || this.caster != null && !this.caster.m_6084_()) {
            this.m_146870_();
        }
        if (this.ON && this.isAccumulating()) {
            this.displayControlled.increaseTimer();
        } else {
            this.displayControlled.decreaseTimer();
        }
        if (this.f_19797_ - 1 > this.getDuration()) {
            this.ON = false;
        }
    }

    public boolean isAccumulating() {
        return this.f_19797_ > 1;
    }

    private void spawnExplosionParticles() {
        for (int i = 0; i < 2; ++i) {
            float velocity = 0.12f;
            float yaw = (float)((double)(this.f_19796_.m_188501_() * 2.0f) * Math.PI);
            float motionY = this.f_19796_.m_188501_() * -0.12f;
            float motionX = 0.12f * Mth.m_14089_((float)yaw);
            float motionZ = 0.12f * Mth.m_14031_((float)yaw);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.collidePosX, this.collidePosY + 0.1, this.collidePosZ, (double)motionX, (double)motionY, (double)motionZ);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(YAW, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(PITCH, (Object)Float.valueOf(0.0f));
        this.m_20088_().m_135372_(DURATION, (Object)0);
    }

    public boolean m_6783_(double distance) {
        return distance < Math.pow(16.0, 3.0);
    }

    public float getYaw() {
        return ((Float)this.m_20088_().m_135370_(YAW)).floatValue();
    }

    public void setYaw(float rotAngle) {
        this.m_20088_().m_135381_(YAW, (Object)Float.valueOf(rotAngle));
    }

    public float getPitch() {
        return ((Float)this.m_20088_().m_135370_(PITCH)).floatValue();
    }

    public void setPitch(float rotAngle) {
        this.m_20088_().m_135381_(PITCH, (Object)Float.valueOf(rotAngle));
    }

    public int getDuration() {
        return (Integer)this.m_20088_().m_135370_(DURATION);
    }

    public void setDuration(int duration) {
        this.m_20088_().m_135381_(DURATION, (Object)duration);
    }

    private void calculateEndPos() {
        double radius = 16.0;
        if (this.m_9236_().m_5776_()) {
            this.endPosX = this.m_20185_() + radius * Math.cos(this.yaw) * Math.cos(this.pitch);
            this.endPosZ = this.m_20189_() + radius * Math.sin(this.yaw) * Math.cos(this.pitch);
            this.endPosY = this.m_20186_() + radius * Math.sin(this.pitch);
        } else {
            this.endPosX = this.m_20185_() + radius * Math.cos(this.getYaw()) * Math.cos(this.getPitch());
            this.endPosZ = this.m_20189_() + radius * Math.sin(this.getYaw()) * Math.cos(this.getPitch());
            this.endPosY = this.m_20186_() + radius * Math.sin(this.getPitch());
        }
    }

    public LaserHitResult raytraceEntities(Level world, Vec3 from, Vec3 to) {
        LaserHitResult result = new LaserHitResult();
        result.setBlockHit((HitResult)world.m_45547_(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)));
        if (result.getBlockHit() != null) {
            Vec3 hitVec = result.getBlockHit().m_82450_();
            this.collidePosX = hitVec.f_82479_;
            this.collidePosY = hitVec.f_82480_;
            this.collidePosZ = hitVec.f_82481_;
            this.blockSide = result.getBlockHit().m_82434_();
        } else {
            this.collidePosX = this.endPosX;
            this.collidePosY = this.endPosY;
            this.collidePosZ = this.endPosZ;
            this.blockSide = null;
        }
        List entities = world.m_45976_(LivingEntity.class, new AABB(Math.min(this.m_20185_(), this.collidePosX), Math.min(this.m_20186_(), this.collidePosY), Math.min(this.m_20189_(), this.collidePosZ), Math.max(this.m_20185_(), this.collidePosX), Math.max(this.m_20186_(), this.collidePosY), Math.max(this.m_20189_(), this.collidePosZ)).m_82377_(1.0, 1.0, 1.0));
        for (LivingEntity entity : entities) {
            if (entity == this.caster) continue;
            float pad = entity.m_6143_() + 0.5f;
            AABB aabb = entity.m_20191_().m_82377_((double)pad, (double)pad, (double)pad);
            Optional hit = aabb.m_82371_(from, to);
            if (aabb.m_82390_(from)) {
                result.addEntityHit(entity);
                continue;
            }
            if (!hit.isPresent()) continue;
            result.addEntityHit(entity);
        }
        return result;
    }

    public static class LaserHitResult {
        private BlockHitResult blockHit;
        private final List<LivingEntity> entities = new ArrayList<LivingEntity>();

        public BlockHitResult getBlockHit() {
            return this.blockHit;
        }

        public void setBlockHit(HitResult rayTraceResult) {
            if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK) {
                this.blockHit = (BlockHitResult)rayTraceResult;
            }
        }

        public void addEntityHit(LivingEntity entity) {
            this.entities.add(entity);
        }
    }

    public static class PreAttack
    extends EntityMagicEffects {
        private final ControlledAnimation phaseController = new ControlledAnimation(2);
        private static final EntityDataAccessor<Integer> DATA_PHASE = SynchedEntityData.m_135353_(PreAttack.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        private Vec3 pos;

        public PreAttack(EntityType<?> type, Level level) {
            super(type, level);
        }

        public PreAttack(Level level, Vec3 pos, LivingEntity caster) {
            this((EntityType)EntityInit.CRIMSON_RAY_PRE.get(), level);
            this.pos = pos;
            this.caster = caster;
        }

        @Override
        protected void m_8097_() {
            super.m_8097_();
            this.f_19804_.m_135372_(DATA_PHASE, (Object)0);
        }

        @Override
        public void m_8119_() {
            super.m_8119_();
            if (!this.m_9236_().f_46443_) {
                if (this.pos == null || this.caster == null) {
                    this.m_146870_();
                    return;
                }
                switch (this.getPhase()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        if (!this.phaseController.increaseTimerChain().isEnd()) break;
                        this.setPhase(this.getPhase() + 1);
                        this.phaseController.resetTimer();
                        break;
                    }
                    case 5: {
                        if (!this.phaseController.increaseTimerChain().isEnd()) break;
                        this.m_9236_().m_7967_((Entity)new EntityCrimsonRay(this.m_9236_(), this.caster, this.pos, 10));
                        this.m_146870_();
                    }
                }
            }
        }

        public boolean m_6783_(double distance) {
            return distance < Math.pow(16.0, 3.0);
        }

        public int getPhase() {
            return (Integer)this.f_19804_.m_135370_(DATA_PHASE);
        }

        public void setPhase(int phase) {
            this.f_19804_.m_135381_(DATA_PHASE, (Object)phase);
        }
    }
}

