/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.corpse;

import com.eeeab.animate.server.ai.AnimationMeleeAI;
import com.eeeab.animate.server.ai.animation.AnimationActivate;
import com.eeeab.animate.server.ai.animation.AnimationMelee;
import com.eeeab.animate.server.animation.Animation;
import com.eeeab.animate.server.handler.EMAnimationHandler;
import com.eeeab.eeeabsmobs.sever.entity.EEEABMobLibrary;
import com.eeeab.eeeabsmobs.sever.entity.GlowEntity;
import com.eeeab.eeeabsmobs.sever.entity.IEntity;
import com.eeeab.eeeabsmobs.sever.entity.VenerableEntity;
import com.eeeab.eeeabsmobs.sever.entity.XpReward;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.EMLookAtGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.owner.player.OwnerProtectToPlayerGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.owner.player.OwnerResetToPlayerGoal;
import com.eeeab.eeeabsmobs.sever.entity.util.ModMobType;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import java.util.UUID;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityCorpseToPlayer
extends EEEABMobLibrary
implements IEntity,
GlowEntity,
VenerableEntity<Player> {
    public final Animation attackAnimation1 = Animation.create(15);
    public final Animation attackAnimation2 = Animation.create(15);
    public final Animation attackAnimation3 = Animation.create(15);
    public final Animation spawnAnimation = Animation.create(20);
    private final Animation[] animations = new Animation[]{this.attackAnimation1, this.attackAnimation2, this.attackAnimation3, this.spawnAnimation};
    private UUID ownerUUID;
    @Nullable
    private Player owner;
    private int countdown = -1;
    private static final EntityDataAccessor<Boolean> DATA_ACTIVE = SynchedEntityData.m_135353_(EntityCorpseToPlayer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public EntityCorpseToPlayer(EntityType<? extends EntityCorpseToPlayer> type, Level level) {
        super((EntityType<? extends EEEABMobLibrary>)type, level);
        this.active = true;
    }

    @Override
    protected XpReward getEntityReward() {
        return XpReward.XP_REWARD_NONE;
    }

    @Override
    public boolean isGlow() {
        return this.m_21223_() > 0.0f;
    }

    protected boolean m_8028_() {
        return false;
    }

    @NotNull
    public MobType m_6336_() {
        return ModMobType.PLAYER_SUMMONS;
    }

    protected boolean m_6125_() {
        return false;
    }

    public void setInitSpawn() {
        this.playAnimation(this.spawnAnimation);
        this.active = false;
        this.setActive(false);
    }

    @Override
    protected void m_8099_() {
        this.registerCustomGoals();
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Player.class}));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    protected void registerCustomGoals() {
        this.f_21345_.m_25352_(1, new AnimationActivate<EntityCorpseToPlayer>(this, () -> this.spawnAnimation));
        this.f_21345_.m_25352_(1, new AnimationMelee<EntityCorpseToPlayer>(this, () -> this.attackAnimation1, 9, 2.0f, 1.0f, 1.0f));
        this.f_21345_.m_25352_(1, new AnimationMelee<EntityCorpseToPlayer>(this, () -> this.attackAnimation2, 9, 2.0f, 1.0f, 1.0f));
        this.f_21345_.m_25352_(1, new AnimationMelee<EntityCorpseToPlayer>(this, () -> this.attackAnimation3, 9, 2.0f, 1.5f, 1.5f));
        this.f_21345_.m_25352_(2, new AnimationMeleeAI<EntityCorpseToPlayer>(this, 1.2, 5, () -> this.attackAnimation1, () -> this.attackAnimation2, () -> this.attackAnimation3));
        this.f_21345_.m_25352_(7, (Goal)new EMLookAtGoal(this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, new OwnerResetToPlayerGoal<EntityCorpseToPlayer>(this, 12.0));
        this.f_21345_.m_25352_(3, new OwnerProtectToPlayerGoal<EntityCorpseToPlayer>(this, 12.0f));
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.m_9236_().f_46443_ && this.getAnimation() == this.spawnAnimation) {
            this.setSpawnParticle(4);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        EMAnimationHandler.INSTANCE.updateAnimations(this);
        if (!this.m_9236_().f_46443_ && this.active && !this.isActive()) {
            this.setActive(true);
        }
        if (!this.m_9236_().f_46443_ && this.m_5448_() != null && !this.m_5448_().m_6084_()) {
            this.m_6710_(null);
        }
        this.active = this.isActive();
        if (!this.active) {
            this.m_21573_().m_26573_();
            this.m_146922_(this.f_19859_);
            this.f_20883_ = this.m_146908_();
        }
        if (this.isSummon() && --this.countdown <= 0) {
            this.m_6469_(this.m_269291_().m_269064_(), this.m_21233_() * 0.25f);
            this.countdown = 20;
        }
    }

    public void setSpawnParticle(int amount) {
        RandomSource randomsource = this.m_217043_();
        BlockState blockstate = this.m_20075_();
        if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
            for (int i = 0; i < amount; ++i) {
                double d0 = this.m_20185_() + (double)Mth.m_216283_((RandomSource)randomsource, (float)-0.2f, (float)0.2f);
                double d1 = this.m_20186_();
                double d2 = this.m_20189_() + (double)Mth.m_216283_((RandomSource)randomsource, (float)-0.2f, (float)0.2f);
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate), d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ACTIVE, (Object)true);
    }

    @Override
    protected void m_147246_() {
        for (int i = 0; i < 10; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.015;
            double d1 = this.f_19796_.m_188583_() * 0.015;
            double d2 = this.f_19796_.m_188583_() * 0.015;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d0, d1, d2);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        this.countdown = 400 + this.f_19796_.m_188503_(200);
        return groupData;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.owner != null && this.owner.m_21223_() > 0.0f) {
            compound.m_128362_("owner", this.owner.m_20148_());
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setOwnerUUID(compound.m_128403_("owner") ? compound.m_128342_("owner") : null);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return EntityCorpseToPlayer.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22281_, 6.0);
    }

    public void setActive(boolean isActive) {
        this.f_19804_.m_135381_(DATA_ACTIVE, (Object)isActive);
    }

    public boolean isActive() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ACTIVE);
    }

    @Override
    public Animation[] getAnimations() {
        return this.animations;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundInit.CORPSE_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SoundInit.CORPSE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundInit.CORPSE_DEATH.get();
    }

    @Override
    @Nullable
    public Player getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(@Nullable Player owner) {
        this.owner = owner;
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwnerUUID(UUID uuid) {
        this.ownerUUID = uuid;
    }

    @Override
    public boolean isSummon() {
        return true;
    }
}

