/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity;

import com.eeeab.animate.server.animation.Animation;
import com.eeeab.animate.server.animation.EMAnimatedEntity;
import com.eeeab.animate.server.handler.EMAnimationHandler;
import com.eeeab.eeeabsmobs.EEEABMobs;
import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.EEEABMobEntity;
import java.util.Arrays;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;

public abstract class EEEABMobLibrary
extends EEEABMobEntity
implements EMAnimatedEntity,
IEntityAdditionalSpawnData {
    private int animationTick;
    private final Animation noAnimation;
    private Animation animation;
    public boolean canplayHurtAnimation;
    public boolean hurtInterruptsAnimation;

    public EEEABMobLibrary(EntityType<? extends EEEABMobLibrary> type, Level level) {
        super(type, level);
        this.animation = this.noAnimation = Animation.create(0);
        this.canplayHurtAnimation = true;
        this.hurtInterruptsAnimation = false;
    }

    public Animation getDeathAnimation() {
        return this.noAnimation;
    }

    public Animation getHurtAnimation() {
        return this.noAnimation;
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        boolean attack = super.m_6469_(source, damage);
        if (attack) {
            if (this.m_21223_() > 0.0f && (this.getAnimation() == this.getNoAnimation() || this.hurtInterruptsAnimation) && this.canplayHurtAnimation) {
                EMAnimationHandler.INSTANCE.sendEMAnimationMessage(this, this.getHurtAnimation());
            } else if (this.m_21223_() <= 0.0f) {
                EMAnimationHandler.INSTANCE.sendEMAnimationMessage(this, this.getDeathAnimation());
            }
        }
        return attack;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.checkAnimationLegality();
    }

    private void checkAnimationLegality() {
        if (!((Boolean)EMConfigHandler.COMMON.OTHER.enableAnimationLegalityLogPrint.get()).booleanValue()) {
            return;
        }
        Animation[] animations = this.getAnimations();
        if (animations != null && this.m_6084_()) {
            for (Animation animation : Arrays.stream(animations).filter(a -> a != this.noAnimation && a != this.getAnimation() && a.m_216984_()).toList()) {
                if (this.f_19797_ % 200 != 0) continue;
                EEEABMobs.LOGGER.warn("{} \u2192 there is illegal action data: Mob= {} Animation= {}[{}]", (Object)(this.m_9236_().f_46443_ ? "Client" : "Server"), (Object)this.m_7755_().getString(), (Object)animation, (Object)ArrayUtils.indexOf((Object[])this.getAnimations(), (Object)((Object)animation)));
            }
        }
    }

    @Override
    protected int getDeathDuration() {
        Animation death = this.getDeathAnimation();
        if (death != this.getNoAnimation()) {
            return death.getDuration();
        }
        return 20;
    }

    public void playAnimation(Animation animation) {
        if (animation != null) {
            EMAnimationHandler.INSTANCE.sendEMAnimationMessage(this, animation);
        }
    }

    @Override
    public int getAnimationTick() {
        return this.animationTick;
    }

    @Override
    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    @Override
    public Animation getAnimation() {
        return this.animation;
    }

    @Override
    public void setAnimation(Animation animation) {
        if (animation != this.getNoAnimation()) {
            this.onAnimationStart(animation);
        } else {
            this.onAnimationFinish(this.animation);
        }
        this.animation = animation;
    }

    @Override
    @NotNull
    public Animation getNoAnimation() {
        return this.noAnimation;
    }

    public boolean isNoAnimation() {
        return this.animation == this.noAnimation;
    }

    protected void onAnimationStart(Animation animation) {
    }

    protected void onAnimationFinish(Animation animation) {
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(ArrayUtils.indexOf((Object[])this.getAnimations(), (Object)((Object)this.getAnimation())));
        buffer.writeInt(this.getAnimationTick());
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.f_19859_ = this.m_146908_();
        this.f_20883_ = this.f_20886_ = this.f_20885_;
        this.f_20884_ = this.f_20886_;
        int animOrdinal = additionalData.readInt();
        int animTick = additionalData.readInt();
        this.setAnimation(animOrdinal == -1 ? this.noAnimation : this.getAnimations()[animOrdinal]);
        this.setAnimationTick(animTick);
    }
}

