/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="eeeabsmobs", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class EMConfigHandler {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final Common COMMON;

    private EMConfigHandler() {
    }

    static {
        COMMON = new Common(BUILDER);
        SPEC = BUILDER.build();
    }

    public static class Common {
        public final Mob MOB;
        public final Entity ENTITY;
        public final Item ITEM;
        public final Other OTHER;

        public Common(ForgeConfigSpec.Builder builder) {
            this.MOB = new Mob(builder);
            this.ENTITY = new Entity(builder);
            this.ITEM = new Item(builder);
            this.OTHER = new Other(builder);
        }
    }

    public static class ToolConfig {
        public final ForgeConfigSpec.DoubleValue attackDamage;
        public final ForgeConfigSpec.DoubleValue attackSpeed;
        public double attackDamageValue;
        public double attackSpeedValue;

        ToolConfig(double attackDamage, double attackSpeed) {
            this.attackSpeedValue = attackSpeed;
            this.attackDamageValue = attackDamage;
            this.attackDamage = BUILDER.comment("Set tool attack damage").defineInRange("Attack damage", attackDamage, 0.0, 3.4028234663852886E38);
            this.attackSpeed = BUILDER.comment("Set tool attack speed").defineInRange("Attack speed", attackSpeed, 0.0, 3.4028234663852886E38);
        }
    }

    public static class DamageSourceAdaptConfig {
        public final ForgeConfigSpec.IntValue maxDamageSourceAdaptCount;
        public final ForgeConfigSpec.IntValue resetCountdown;
        public final ForgeConfigSpec.DoubleValue singleAdaptFactor;
        public final ForgeConfigSpec.DoubleValue maxAdaptFactor;
        public final boolean adaptsSameTypeMobs;

        public DamageSourceAdaptConfig(ForgeConfigSpec.Builder builder, int maxDamageSourceAdaptCount, int resetCountdown, double singleAdaptFactor, double maxAdaptFactor, boolean adaptsSameTypeMobs) {
            builder.push("Damage Adapt");
            this.maxDamageSourceAdaptCount = BUILDER.comment("Set this mob max damage source adapt count").defineInRange("Max damageSource adapt count", maxDamageSourceAdaptCount, 10, 1024);
            this.resetCountdown = BUILDER.comment("Set the effective time for a single adapt damage source(second)").defineInRange("Effective time", resetCountdown, 10, 1024);
            this.singleAdaptFactor = BUILDER.comment("Set the factor of each reduction of the same damage source").defineInRange("Single adapt factor", singleAdaptFactor, 0.0, 1.0);
            this.maxAdaptFactor = BUILDER.comment("Set the max damage reduction factor").defineInRange("Max adapt factor", maxAdaptFactor, 0.0, 1.0);
            this.adaptsSameTypeMobs = adaptsSameTypeMobs;
            builder.pop();
        }
    }

    public static class DamageCapConfig {
        public final ForgeConfigSpec.DoubleValue damageCap;

        public DamageCapConfig(double damageCapPercentage) {
            this.damageCap = BUILDER.comment("Set this mob damageCap").defineInRange("DamageCap", damageCapPercentage, 0.0, 1024.0);
        }
    }

    public static class AttributeConfig {
        public final ForgeConfigSpec.DoubleValue healthMultiplier;
        public final ForgeConfigSpec.DoubleValue attackMultiplier;

        public AttributeConfig() {
            this(1.0f, 1.0f);
        }

        public AttributeConfig(float healthMultiplier, float attackMultiplier) {
            this.healthMultiplier = BUILDER.comment("Set this mob health multiplier").defineInRange("Health multiplier", (double)healthMultiplier, 0.0, Double.MAX_VALUE);
            this.attackMultiplier = BUILDER.comment("Set this mob attack multiplier").defineInRange("Attack multiplier", (double)attackMultiplier, 0.0, Double.MAX_VALUE);
        }
    }

    public static class Other {
        public final ForgeConfigSpec.BooleanValue enableCameraShake;
        public final ForgeConfigSpec.BooleanValue enableShowBloodBars;
        public final ForgeConfigSpec.BooleanValue enableSameMobsTypeInjury;
        public final ForgeConfigSpec.BooleanValue enableRenderFallingBlock;
        public final ForgeConfigSpec.BooleanValue enablePlayBossMusic;
        public final ForgeConfigSpec.BooleanValue enableFrenzyDestroyBlock;
        public final ForgeConfigSpec.BooleanValue enableAnimationLegalityLogPrint;

        public Other(ForgeConfigSpec.Builder builder) {
            builder.push("Other");
            this.enableCameraShake = BUILDER.comment("If 'False' disable camera shake").define("Enable camera shake", true);
            this.enableShowBloodBars = BUILDER.comment("If 'False' disable bosses blood bars").define("Enable bosses blood bars", true);
            this.enableSameMobsTypeInjury = BUILDER.comment("If 'False' able inflict damage between mobs of the same type").define("Mobs of the same type cannot cause harm", true);
            this.enableRenderFallingBlock = BUILDER.comment("If 'False' disable falling block rendering").define("Enable falling block rendering", true);
            this.enablePlayBossMusic = BUILDER.comment("If 'False' disable play boss music").define("Enable play boss music", true);
            this.enableFrenzyDestroyBlock = BUILDER.comment("If 'False' disable frenzy potion destroy block").define("Enable frenzy potion destroy block", true);
            this.enableAnimationLegalityLogPrint = BUILDER.comment("If 'True' enable print illegal animation logs(For developers only)").define("Enable print illegal logs", false);
            builder.pop();
        }
    }

    public static class GuardianLaser {
        public final ForgeConfigSpec.DoubleValue playerShootRadius;
        public final ForgeConfigSpec.BooleanValue enableGenerateScorchEntity;

        public GuardianLaser(ForgeConfigSpec.Builder builder) {
            builder.push("Guardian Laser");
            this.enableGenerateScorchEntity = BUILDER.comment("If 'False' disable scorch generate on the ground").define("Enable scorch generate", true);
            this.playerShootRadius = BUILDER.comment("Set the maximum shooting distance when the user is a player").defineInRange("Set attack radius", 16.0, 1.0, 64.0);
            builder.pop();
        }
    }

    public static class Entity {
        public final GuardianLaser GUARDIAN_LASER;

        public Entity(ForgeConfigSpec.Builder builder) {
            builder.push("Entity");
            this.GUARDIAN_LASER = new GuardianLaser(builder);
            builder.pop();
        }
    }

    public static class NamelessGuardian {
        public final ForgeConfigSpec.BooleanValue enableNonCombatHeal;
        public final ForgeConfigSpec.DoubleValue suckBloodMultiplier;
        public final ForgeConfigSpec.BooleanValue enableForcedSuckBlood;
        public final ForgeConfigSpec.BooleanValue challengeMode;
        public final AttributeConfig combatConfig;
        public final DamageCapConfig maximumDamageCap;

        public NamelessGuardian(ForgeConfigSpec.Builder builder) {
            builder.push("Nameless Guardian");
            this.suckBloodMultiplier = BUILDER.comment("Set suck blood multiplier").defineInRange("Suck blood multiplier", 1.0, 0.0, 1024.0);
            this.enableNonCombatHeal = BUILDER.comment("If 'False' disable non-combat heal").define("Enable non-combat heal", true);
            this.enableForcedSuckBlood = BUILDER.comment("If 'False' disable forced suck blood on power status(Does not take effect in Challenge mode)").define("Enable forced suck blood", true);
            this.challengeMode = BUILDER.comment("Be careful! It's going to get tricky!").define("Challenge mode!", false);
            this.combatConfig = new AttributeConfig();
            this.maximumDamageCap = new DamageCapConfig(20.0);
            builder.pop();
        }
    }

    public static class GulingSentinelHeavy {
        public final ForgeConfigSpec.BooleanValue enableNonCombatHeal;
        public final AttributeConfig combatConfig;

        public GulingSentinelHeavy(ForgeConfigSpec.Builder builder) {
            builder.push("Guling Sentinel-Heavy");
            this.enableNonCombatHeal = BUILDER.comment("If 'False' disable non-combat heal").define("Enable non-combat heal", true);
            this.combatConfig = new AttributeConfig();
            builder.pop();
        }
    }

    public static class GulingSentinel {
        public final ForgeConfigSpec.BooleanValue enableNonCombatHeal;
        public final AttributeConfig combatConfig;

        public GulingSentinel(ForgeConfigSpec.Builder builder) {
            builder.push("Guling Sentinel");
            this.enableNonCombatHeal = BUILDER.comment("If 'False' disable non-combat heal").define("Enable non-combat heal", true);
            this.combatConfig = new AttributeConfig();
            builder.pop();
        }
    }

    public static class GulingMobs {
        public final NamelessGuardian NAMELESS_GUARDIAN;
        public final GulingSentinel GULING_SENTINEL;
        public final GulingSentinelHeavy GULING_SENTINEL_HEAVY;

        public GulingMobs(ForgeConfigSpec.Builder builder) {
            builder.push("Structure-Guling");
            this.GULING_SENTINEL = new GulingSentinel(builder);
            this.GULING_SENTINEL_HEAVY = new GulingSentinelHeavy(builder);
            this.NAMELESS_GUARDIAN = new NamelessGuardian(builder);
            builder.pop();
        }
    }

    public static class CorpseWarlock {
        public final ForgeConfigSpec.DoubleValue maxDistanceTakeDamage;
        public final AttributeConfig combatConfig;
        public final DamageCapConfig maximumDamageCap;

        public CorpseWarlock(ForgeConfigSpec.Builder builder) {
            builder.push("Corpse Warlock");
            this.maxDistanceTakeDamage = BUILDER.comment("Set the distance to take damage from projectiles").defineInRange("Attack distance", 12.0, 1.0, 32.0);
            this.combatConfig = new AttributeConfig();
            this.maximumDamageCap = new DamageCapConfig(22.0);
            builder.pop();
        }
    }

    public static class Corpse {
        public final AttributeConfig combatConfig;
        public final ForgeConfigSpec.BooleanValue enableConvertToCorpse;

        public Corpse(ForgeConfigSpec.Builder builder) {
            builder.push("Corpse & Corpse Villager");
            this.combatConfig = new AttributeConfig();
            this.enableConvertToCorpse = BUILDER.comment("If 'False', it will not be converted to corpse").define("Converted to corpse", true);
            builder.pop();
        }
    }

    public static class CorpseMobs {
        public final Corpse CORPSE;
        public final CorpseWarlock CORPSE_WARLOCK;

        public CorpseMobs(ForgeConfigSpec.Builder builder) {
            builder.push("Structure-Bloody Altar");
            this.CORPSE = new Corpse(builder);
            this.CORPSE_WARLOCK = new CorpseWarlock(builder);
            builder.pop();
        }
    }

    public static class Immortal {
        public final AttributeConfig combatConfig;
        public final DamageCapConfig maximumDamageCap;
        public final DamageSourceAdaptConfig adaptConfig;

        public Immortal(ForgeConfigSpec.Builder builder) {
            builder.push("Immortal Boss");
            this.combatConfig = new AttributeConfig();
            this.maximumDamageCap = new DamageCapConfig(20.0);
            this.adaptConfig = new DamageSourceAdaptConfig(builder, 100, 15, 0.08, 0.8, true);
            builder.pop();
        }
    }

    public static class ImmortalExecutioner {
        public final AttributeConfig combatConfig;
        public final DamageCapConfig maximumDamageCap;

        public ImmortalExecutioner(ForgeConfigSpec.Builder builder) {
            builder.push("Immortal Executioner");
            this.combatConfig = new AttributeConfig();
            this.maximumDamageCap = new DamageCapConfig(22.0);
            builder.pop();
        }
    }

    public static class ImmortalGolem {
        public final AttributeConfig combatConfig;

        public ImmortalGolem(ForgeConfigSpec.Builder builder) {
            builder.push("Immortal Golem");
            this.combatConfig = new AttributeConfig();
            builder.pop();
        }
    }

    public static class ImmortalShaman {
        public final AttributeConfig combatConfig;
        public final ForgeConfigSpec.DoubleValue healPercentage;

        public ImmortalShaman(ForgeConfigSpec.Builder builder) {
            builder.push("Immortal Shaman");
            this.healPercentage = BUILDER.comment("Immortal Shaman heal values (based on max health percentage)").defineInRange("Heal percentage", 0.5, 0.0, 1.0);
            this.combatConfig = new AttributeConfig();
            builder.pop();
        }
    }

    public static class ImmortalKnight {
        public final AttributeConfig combatConfig;

        public ImmortalKnight(ForgeConfigSpec.Builder builder) {
            builder.push("Immortal Knight");
            this.combatConfig = new AttributeConfig();
            builder.pop();
        }
    }

    public static class ImmortalSkeleton {
        public final AttributeConfig combatConfig;

        public ImmortalSkeleton(ForgeConfigSpec.Builder builder) {
            builder.push("Immortal Skeleton");
            this.combatConfig = new AttributeConfig();
            builder.pop();
        }
    }

    public static class ImmortalMobs {
        public final ImmortalSkeleton IMMORTAL_SKELETON;
        public final ImmortalKnight IMMORTAL_KNIGHT;
        public final ImmortalShaman IMMORTAL_SHAMAN;
        public final ImmortalGolem IMMORTAL_GOLEM;
        public final ImmortalExecutioner IMMORTAL_EXECUTIONER;
        public final Immortal THE_IMMORTAL;

        public ImmortalMobs(ForgeConfigSpec.Builder builder) {
            builder.push("Immortal Mobs");
            this.IMMORTAL_SKELETON = new ImmortalSkeleton(builder);
            this.IMMORTAL_KNIGHT = new ImmortalKnight(builder);
            this.IMMORTAL_SHAMAN = new ImmortalShaman(builder);
            this.IMMORTAL_GOLEM = new ImmortalGolem(builder);
            this.IMMORTAL_EXECUTIONER = new ImmortalExecutioner(builder);
            this.THE_IMMORTAL = new Immortal(builder);
            builder.pop();
        }
    }

    public static class Mob {
        public final CorpseMobs CORPSES;
        public final ImmortalMobs IMMORTAL;
        public final GulingMobs GULING;

        public Mob(ForgeConfigSpec.Builder builder) {
            builder.push("Mobs");
            this.IMMORTAL = new ImmortalMobs(builder);
            this.CORPSES = new CorpseMobs(builder);
            this.GULING = new GulingMobs(builder);
            builder.pop();
        }
    }

    public static class Item {
        public final ForgeConfigSpec.BooleanValue enableGhostWarriorArmorItemDurability;
        public final ForgeConfigSpec.IntValue itemImmortalStaffCoolingTime;
        public final ForgeConfigSpec.IntValue itemImmortalStaffStorageTime;
        public final ToolConfig GUARDIAN_AXE_TOOL;
        public final ToolConfig NETHERWORLD_KATANA_TOOL;
        public final ForgeConfigSpec.IntValue itemHowitzerCoolingTime;
        public final ForgeConfigSpec.DoubleValue itemHowitzerGrenadeDamage;
        public final ForgeConfigSpec.DoubleValue itemHowitzerGrenadeExplosionRadius;
        public final ForgeConfigSpec.DoubleValue SSNCumulativeMaximumDamage;
        public final ForgeConfigSpec.IntValue SSNCoolingTime;

        public Item(ForgeConfigSpec.Builder builder) {
            builder.push("Items");
            builder.push("Summoning Soul Necklace");
            this.SSNCumulativeMaximumDamage = BUILDER.comment("Set the maximum amount of damage a player can take while holding this item").defineInRange("Set the maximum cumulative damage taken", 50.0, 1.0, 3.4028234663852886E38);
            this.SSNCoolingTime = BUILDER.comment("Set item cool down time after player summons (seconds)").defineInRange("Set item cool down time", 20, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.push("Howitzer");
            this.itemHowitzerCoolingTime = BUILDER.comment("Set item cool down time after player on use (seconds)").defineInRange("Set item cool down time", 2, 0, Integer.MAX_VALUE);
            this.itemHowitzerGrenadeDamage = BUILDER.comment("Set Grenade maximum explosion damage(damage to the center of the explosion)").defineInRange("Set damage cap", 10.0, 1.0, 128.0);
            this.itemHowitzerGrenadeExplosionRadius = BUILDER.comment("Set Grenade explosion radius(the bigger the blast radius, the higher the damage)").defineInRange("Set explosion radius", 2.5, 1.0, 10.0);
            builder.pop();
            builder.push("Guardian Axe");
            this.GUARDIAN_AXE_TOOL = new ToolConfig(15.0, 0.9);
            builder.pop();
            builder.push("Immortal Staff");
            this.itemImmortalStaffCoolingTime = BUILDER.comment("Set the cool down time after using the weapon (seconds)").defineInRange("Set item cool down time", 1, 0, 60);
            this.itemImmortalStaffStorageTime = BUILDER.comment("Set the weapon recharge time (seconds)").defineInRange("Set item recharge time", 1, 0, 60);
            builder.pop();
            builder.push("Ghost Warrior Armor & Weapons");
            this.enableGhostWarriorArmorItemDurability = BUILDER.comment("If 'True' the 'Ghost Warrior Armor' will be damaged due to durability").define("Enable armor durability", false);
            this.NETHERWORLD_KATANA_TOOL = new ToolConfig(14.0, 1.4);
            builder.pop();
            builder.pop();
        }
    }
}

