/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.capability;

import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.corpse.EntityCorpseToPlayer;
import com.eeeab.eeeabsmobs.sever.handler.HandlerCapability;
import com.eeeab.eeeabsmobs.sever.init.EntityInit;
import com.eeeab.eeeabsmobs.sever.init.ItemInit;
import com.eeeab.eeeabsmobs.sever.integration.curios.ICuriosApi;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerCapability {
    public static ResourceLocation ID = new ResourceLocation("eeeabsmobs", "player_cap");

    public static class PlayerCapabilityProvider
    implements ICapabilityProvider,
    ICapabilitySerializable<CompoundTag> {
        private final LazyOptional<PlayerCapabilityImpl> instance = LazyOptional.of(PlayerCapabilityImpl::new);

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return HandlerCapability.PLAYER_CAPABILITY.orEmpty(cap, this.instance.cast());
        }

        public CompoundTag serializeNBT() {
            return ((PlayerCapabilityImpl)this.instance.orElseThrow(NullPointerException::new)).serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            ((PlayerCapabilityImpl)this.instance.orElseThrow(NullPointerException::new)).deserializeNBT(nbt);
        }
    }

    public static class PlayerCapabilityImpl
    implements IPlayerCapability {
        private float SSNCumulativeDamage;
        private int SSNInvulnerableTime;

        @Override
        public void tick(Player player) {
            if (this.SSNInvulnerableTime > 0) {
                --this.SSNInvulnerableTime;
            }
        }

        @Override
        public void hurt(Player player, DamageSource source, float damage) {
            Entity entity = source.m_7639_();
            if (entity != null && this.SSNInvulnerableTime <= 0) {
                this.SSNInvulnerableTime = 10;
                Item item = (Item)ItemInit.SOUL_SUMMONING_NECKLACE.get();
                if (ICuriosApi.isLoaded()) {
                    if (ICuriosApi.INSTANCE.isPresentInventory((LivingEntity)player, item)) {
                        this.doSSNCapability(player, entity, item, damage);
                    }
                } else if (this.ifPresentItem(player, item.m_7968_())) {
                    this.doSSNCapability(player, entity, item, damage);
                }
            }
        }

        private void doSSNCapability(Player player, Entity target, Item item, float damage) {
            if (!player.m_36335_().m_41519_(item)) {
                this.SSNCumulativeDamage += damage;
                if (this.SSNCumulativeDamage >= ((Double)EMConfigHandler.COMMON.ITEM.SSNCumulativeMaximumDamage.get()).floatValue()) {
                    player.m_36335_().m_41524_(item, (Integer)EMConfigHandler.COMMON.ITEM.SSNCoolingTime.get() * 20);
                    if (!player.m_9236_().f_46443_) {
                        Vec3 vec3 = player.m_20182_();
                        EntityCorpseToPlayer entity = (EntityCorpseToPlayer)((EntityType)EntityInit.CORPSE_TO_PLAYER.get()).m_20615_(player.m_9236_());
                        if (entity != null) {
                            entity.setInitSpawn();
                            entity.m_6518_((ServerLevelAccessor)((ServerLevel)player.m_9236_()), player.m_9236_().m_6436_(BlockPos.m_274561_((double)vec3.f_82479_, (double)vec3.f_82480_, (double)vec3.f_82481_)), MobSpawnType.MOB_SUMMONED, null, null);
                            entity.m_20219_(vec3);
                            entity.setOwner(player);
                            if (player != target && target instanceof LivingEntity) {
                                LivingEntity livingEntity = (LivingEntity)target;
                                entity.m_6710_(livingEntity);
                            }
                            player.m_9236_().m_7967_((Entity)entity);
                        }
                    }
                    this.SSNCumulativeDamage = 0.0f;
                }
            }
        }

        private boolean ifPresentItem(Player player, ItemStack itemStack) {
            return player.m_150109_().m_36063_(itemStack);
        }

        public CompoundTag serializeNBT() {
            return new CompoundTag();
        }

        public void deserializeNBT(CompoundTag nbt) {
        }
    }

    public static interface IPlayerCapability
    extends INBTSerializable<CompoundTag> {
        public void tick(Player var1);

        public void hurt(Player var1, DamageSource var2, float var3);
    }
}

