/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.capability;

import com.eeeab.eeeabsmobs.client.particle.base.ParticleRing;
import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.handler.HandlerCapability;
import com.eeeab.eeeabsmobs.sever.init.EffectInit;
import com.eeeab.eeeabsmobs.sever.init.ItemInit;
import com.eeeab.eeeabsmobs.sever.integration.curios.ICuriosApi;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrenzyCapability {
    public static final ResourceLocation ID = new ResourceLocation("eeeabsmobs", "frenzy_cap");

    public static class FrenzyCapabilityProvider
    implements ICapabilityProvider,
    ICapabilitySerializable<CompoundTag> {
        private final LazyOptional<FrenzyCapabilityImpl> instance = LazyOptional.of(FrenzyCapabilityImpl::new);

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return HandlerCapability.FRENZY_EFFECT_CAPABILITY.orEmpty(cap, this.instance.cast());
        }

        public CompoundTag serializeNBT() {
            return ((FrenzyCapabilityImpl)this.instance.orElseThrow(NullPointerException::new)).serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            ((FrenzyCapabilityImpl)this.instance.orElseThrow(NullPointerException::new)).deserializeNBT(nbt);
        }
    }

    public static class FrenzyCapabilityImpl
    implements IFrenzyCapability {
        private final UUID ATTACK_UUID = UUID.fromString("3039A932-0AF9-E41C-2DD5-996DCCF1E8A0");
        private final UUID SPEED_UUID = UUID.fromString("CB12110E-C2D2-2E2B-3F2E-97956CB5A564");
        private boolean isFrenzy;
        private long count;
        private int level;

        @Override
        public boolean isFrenzy() {
            return this.isFrenzy;
        }

        @Override
        public void setLevel(int level) {
            this.level = level;
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        @Override
        public void onStart(LivingEntity entity) {
            if (entity != null) {
                this.isFrenzy = true;
                AttributeInstance attack = entity.m_21051_(Attributes.f_22281_);
                AttributeInstance speed = entity.m_21051_(Attributes.f_22279_);
                if (attack != null && speed != null) {
                    int i = Math.min(this.level + 1, 5);
                    double attackValue = attack.m_22115_() * 0.2 * (double)i;
                    if (entity instanceof Player) {
                        attackValue = i;
                    }
                    double speedValue = speed.m_22115_() * 0.2 * (double)i;
                    attack.m_22127_(this.ATTACK_UUID);
                    speed.m_22127_(this.SPEED_UUID);
                    attack.m_22125_(new AttributeModifier(this.ATTACK_UUID, "Add frenzy attack", attackValue, AttributeModifier.Operation.ADDITION));
                    speed.m_22125_(new AttributeModifier(this.SPEED_UUID, "Add frenzy speed", speedValue, AttributeModifier.Operation.ADDITION));
                }
            }
        }

        @Override
        public void tick(LivingEntity entity) {
            if (this.isFrenzy()) {
                MobEffectInstance effect = entity.m_21124_((MobEffect)EffectInit.FRENZY_EFFECT.get());
                if (effect != null) {
                    int duration = effect.m_19557_();
                    int durationTick = 50 * (this.level + 1);
                    if (duration <= 10 && duration >= 0) {
                        if (entity instanceof Player) {
                            Player player = (Player)entity;
                            Item item = (Item)ItemInit.SOUL_SUMMONING_NECKLACE.get();
                            if (ICuriosApi.isLoaded() && ICuriosApi.INSTANCE.isPresentInventory((LivingEntity)player, item) || player.m_150109_().f_35974_.stream().anyMatch(i -> i.m_150930_(item))) {
                                player.m_36335_().m_41524_(item, 20);
                                durationTick /= 2;
                            }
                        }
                        entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, durationTick, 1, false, true, true));
                        entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, durationTick, this.level, false, true, true));
                        entity.m_7292_(new MobEffectInstance((MobEffect)EffectInit.ARMOR_LOWER_EFFECT.get(), durationTick, this.level, false, true, true));
                        return;
                    }
                }
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (this.count <= 0L && player.f_19797_ % 10 == 0) {
                        player.m_36324_().m_38707_(1, 1.0f);
                    }
                    if (player.m_20142_() && !player.m_21211_().m_41720_().m_41472_()) {
                        if (this.count < 20L) {
                            ++this.count;
                        }
                    } else {
                        --this.count;
                    }
                    if (this.count >= 20L && player.m_36324_().m_38702_() > 0) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 20, this.level, false, false, true));
                        player.m_36399_(0.25f);
                        boolean checkCanDestroyBlock = (Boolean)EMConfigHandler.COMMON.OTHER.enableFrenzyDestroyBlock.get();
                        if (!entity.m_9236_().f_46443_ && checkCanDestroyBlock) {
                            AABB bb = entity.m_20191_();
                            int minx = Mth.m_14107_((double)(bb.f_82288_ - 2.75));
                            int miny = Mth.m_14107_((double)(bb.f_82289_ + 0.15));
                            int minz = Mth.m_14107_((double)(bb.f_82290_ - 2.75));
                            BlockPos min = new BlockPos(minx, miny, minz);
                            int maxx = Mth.m_14107_((double)(bb.f_82291_ + 2.75));
                            int maxy = Mth.m_14107_((double)(bb.f_82292_ + 0.5));
                            int maxz = Mth.m_14107_((double)(bb.f_82293_ + 2.75));
                            BlockPos max = new BlockPos(maxx, maxy, maxz);
                            if (entity.m_9236_().m_46832_(min, max)) {
                                BlockPos.m_121990_((BlockPos)min, (BlockPos)max).filter(pos -> ModEntityUtils.canDestroyBlock(entity.m_9236_(), pos, (Entity)entity, 2.0f) && entity.m_9236_().m_7702_(pos) == null).forEach(pos -> entity.m_9236_().m_46961_(pos, false));
                            }
                        }
                        List entities = player.m_9236_().m_45971_(LivingEntity.class, TargetingConditions.f_26872_, (LivingEntity)player, player.m_20191_().m_82377_(1.0, (double)0.2f, 1.0));
                        for (LivingEntity hitEntity : entities) {
                            if (hitEntity == player) continue;
                            boolean hitFlag = false;
                            if (player.m_20142_()) {
                                hitFlag = hitEntity.m_6469_(hitEntity.m_269291_().m_269333_((LivingEntity)player), (float)this.level);
                            }
                            if (!hitFlag) continue;
                            double angle = this.getAngleBetweenEntities((Entity)entity, (Entity)hitEntity);
                            double x = 3.0 * Math.cos(Math.toRadians(angle - 90.0));
                            double z = 3.0 * Math.sin(Math.toRadians(angle - 90.0));
                            hitEntity.m_20334_(x, 0.35, z);
                            hitEntity.m_7292_(new MobEffectInstance((MobEffect)EffectInit.VERTIGO_EFFECT.get(), 20, 0, false, false, true));
                        }
                        if (player.m_9236_().f_46443_) {
                            double x = player.m_20185_();
                            double y = player.m_20186_() + (double)(player.m_20206_() / 2.0f);
                            double z = player.m_20189_();
                            double motionX = player.m_20184_().f_82479_;
                            double motionY = player.m_20184_().f_82480_;
                            double motionZ = player.m_20184_().f_82481_;
                            if (player.f_19797_ % 3 == 0) {
                                player.m_9236_().m_7106_((ParticleOptions)new ParticleRing.RingData((float)Math.toRadians(-player.f_20883_), 0.0f, 30, 0.8f, 0.8f, 0.9f, 0.08f, 32.0f, false, ParticleRing.EnumRingBehavior.GROW_THEN_SHRINK), x + 8.0 * motionX, y + 1.5 * motionY, z + 8.0 * motionZ, 0.0, 0.0, 0.0);
                            }
                        }
                    }
                }
            }
        }

        public double getAngleBetweenEntities(Entity attacker, Entity target) {
            return Math.atan2(target.m_20189_() - attacker.m_20189_(), target.m_20185_() - attacker.m_20185_()) * 57.29577951308232 + 90.0;
        }

        @Override
        public void onEnd(LivingEntity entity) {
            if (entity != null && this.isFrenzy()) {
                this.count = 0L;
                this.isFrenzy = false;
                AttributeInstance attack = entity.m_21051_(Attributes.f_22281_);
                AttributeInstance speed = entity.m_21051_(Attributes.f_22279_);
                if (attack != null && speed != null) {
                    attack.m_22127_(this.ATTACK_UUID);
                    speed.m_22127_(this.SPEED_UUID);
                }
            }
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("is_frenzy", this.isFrenzy);
            nbt.m_128405_("level", this.level);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.isFrenzy = nbt.m_128471_("is_frenzy");
            this.level = nbt.m_128451_("level");
        }
    }

    public static interface IFrenzyCapability
    extends INBTSerializable<CompoundTag> {
        public boolean isFrenzy();

        public void setLevel(int var1);

        public int getLevel();

        public void onStart(LivingEntity var1);

        public void onEnd(LivingEntity var1);

        public void tick(LivingEntity var1);
    }
}

