/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.util;

import com.eeeab.eeeabsmobs.client.particle.util.AdvancedParticleBase;
import com.eeeab.eeeabsmobs.client.particle.util.AdvancedParticleData;
import com.eeeab.eeeabsmobs.client.particle.util.ParticleComponent;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;

public class ModParticleUtils {
    private static final RandomSource random = RandomSource.m_216343_();

    private ModParticleUtils() {
    }

    public static void particleOutburst(Level world, int points, ParticleOptions[] particles, double x, double y, double z, float[][] speedModifiers) {
        double d = random.m_188583_() * 0.05;
        double e = random.m_188583_() * 0.05;
        for (int j = 0; j < points; ++j) {
            double newX = random.m_188500_() - 0.5 + random.m_188583_() * 0.15 + d;
            double newZ = random.m_188500_() - 0.5 + random.m_188583_() * 0.15 + e;
            double newY = random.m_188500_() - 0.5 + random.m_188500_() * 0.5;
            for (int i = 0; i < particles.length; ++i) {
                world.m_7106_(particles[i], x, y, z, newX / (double)speedModifiers[i][0], newY / (double)speedModifiers[i][1], newZ / (double)speedModifiers[i][2]);
            }
        }
    }

    public static void particleOutburst(Level world, int points, ParticleOptions[] particles, double x, double y, double z, float[][] velDividers, double speedModifier) {
        double d = random.m_188583_() * 0.05;
        double e = random.m_188583_() * 0.05;
        for (int j = 0; j < points; ++j) {
            double newX = (random.m_188500_() - 0.5 + random.m_188583_() * 0.15 + d) * speedModifier;
            double newZ = (random.m_188500_() - 0.5 + random.m_188583_() * 0.15 + e) * speedModifier;
            double newY = random.m_188500_() - 0.5 + random.m_188500_() * 0.5;
            for (int i = 0; i < particles.length; ++i) {
                world.m_7106_(particles[i], x, y, z, newX / (double)velDividers[i][0], newY / (double)velDividers[i][1], newZ / (double)velDividers[i][2]);
            }
        }
    }

    public static void roundParticleOutburst(Level world, double points, ParticleOptions[] particles, double x, double y, double z, float sizeModifier) {
        double phi = Math.PI * (3.0 - Math.sqrt(5.0));
        int i = 0;
        while ((double)i < points) {
            double velocityY = 1.0 - (double)i / (points - 1.0) * 2.0;
            double radius = Math.sqrt(1.0 - velocityY * velocityY);
            double theta = phi * (double)i;
            double velocityX = Math.cos(theta) * radius;
            double velocityZ = Math.sin(theta) * radius;
            float sideOffset = (float)(random.m_188583_() * 0.2) * (float)(random.m_188499_() ? 1 : -1);
            for (ParticleOptions particle : particles) {
                world.m_6493_(particle, true, x, y, z, velocityX * (double)(sizeModifier + sideOffset), velocityY * (double)sizeModifier, velocityZ * (double)(sizeModifier + sideOffset));
            }
            ++i;
        }
    }

    public static void annularParticleOutburst(Level world, double points, ParticleOptions[] particles, double x, double y, double z, double speedModifier, double yOffSet) {
        int i = 1;
        while ((double)i <= points) {
            double yaw = (double)((float)i * 360.0f) / points;
            double xSpeed = speedModifier * Math.cos(Math.toRadians(yaw));
            double zSpeed = speedModifier * Math.sin(Math.toRadians(yaw));
            for (ParticleOptions particle : particles) {
                world.m_7106_(particle, x, y + yOffSet, z, xSpeed, 0.0, zSpeed);
            }
            ++i;
        }
    }

    public static void annularParticleOutburst(Level world, double points, ParticleOptions[] particles, double x, double y, double z, double speedModifier, double yOffSet, float angle) {
        int i = 1;
        while ((double)i <= points) {
            double yaw = (double)((float)i * angle) / points;
            double xSpeed = speedModifier * Math.cos(Math.toRadians(yaw));
            double zSpeed = speedModifier * Math.sin(Math.toRadians(yaw));
            for (ParticleOptions particle : particles) {
                world.m_7106_(particle, x, y + yOffSet, z, xSpeed, 0.0, zSpeed);
            }
            ++i;
        }
    }

    public static void sphericalParticleOutburst(Level level, float points, ParticleOptions[] particles, LivingEntity entity, float yOffset, double inFrontOffset, double sideOffset, double speedModifier) {
        double perpFacing = (double)entity.f_20883_ * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        double vx = Math.cos(facingAngle) * inFrontOffset;
        double vz = Math.sin(facingAngle) * inFrontOffset;
        double perpX = Math.cos(perpFacing);
        double perpZ = Math.sin(perpFacing);
        double px = entity.m_20185_() + vx + perpX * sideOffset;
        double py = entity.m_20186_() + (double)yOffset;
        double pz = entity.m_20189_() + vz + perpZ * sideOffset;
        perpFacing += 1.0;
        for (float i = -points; i <= points; i += 1.0f) {
            for (float j = -points; j <= points; j += 1.0f) {
                for (float k = -points; k <= points; k += 1.0f) {
                    double d0 = (double)j + (random.m_188500_() - random.m_188500_()) * 0.5;
                    double d1 = (double)i + (random.m_188500_() - random.m_188500_()) * 0.5;
                    double d2 = (double)k + (random.m_188500_() - random.m_188500_()) * 0.5;
                    double d3 = (double)Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1 + d2 * d2))) / 0.5 + random.m_188500_() - random.m_188500_() * 0.05;
                    for (ParticleOptions type : particles) {
                        level.m_7106_(type, px, py, pz, d0 / d3 * speedModifier, d1 / d3 * speedModifier, d2 / d3 * speedModifier);
                    }
                    if (i == -points || i == points || j == -points || j == points) continue;
                    k += points * 2.0f - 1.0f;
                }
            }
        }
    }

    public static void annularParticleOutburstOnGround(Level level, ParticleOptions particle, LivingEntity entity, int quantity, int randomQuantity, double sizeModifier, double inFrontOffset, double sideOffset, double speedModifier) {
        BlockParticleOption blockPO;
        if (particle instanceof BlockParticleOption && (blockPO = (BlockParticleOption)particle).m_123642_().m_60799_() == RenderShape.INVISIBLE) {
            return;
        }
        double perpFacing = (double)entity.f_20883_ * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        double vx = Math.cos(facingAngle) * inFrontOffset;
        double vz = Math.sin(facingAngle) * inFrontOffset;
        double perpX = Math.cos(perpFacing);
        double perpZ = Math.sin(perpFacing);
        double fx = entity.m_20185_() + vx + perpX * sideOffset;
        double fy = entity.m_20191_().f_82289_ + 0.1;
        double fz = entity.m_20189_() + vz + perpZ * sideOffset;
        int amount = quantity + random.m_188503_(randomQuantity);
        while (amount-- > 0) {
            double theta = random.m_188500_() * Math.PI * 2.0;
            double dist = random.m_188500_() * 0.1 + sizeModifier;
            double sx = Math.cos(theta);
            double sz = Math.sin(theta);
            double px = fx + sx * dist;
            double py = fy + random.m_188500_() * 0.1;
            double pz = fz + sz * dist;
            level.m_7106_(particle, px, py, pz, sx * speedModifier, 0.0, sz * speedModifier);
        }
    }

    public static void randomAnnularParticleOutburst(Level world, double points, ParticleOptions[] particles, double x, double y, double z, float speedModifier) {
        int i = 0;
        while ((double)i < points) {
            double yaw = (double)i * (Math.PI * 2 / points);
            double vy = random.m_188501_() * 0.1f - 0.05f;
            double vx = speedModifier * Mth.m_14089_((float)((float)yaw));
            double vz = speedModifier * Mth.m_14031_((float)((float)yaw));
            for (ParticleOptions particle : particles) {
                world.m_7106_(particle, x, y, z, vx, vy, vz);
            }
            ++i;
        }
    }

    public static void advAttractorParticle(ParticleType<AdvancedParticleData> advParticleType, Entity entity, int particleCount, float yOffset, float scale, float duration, ParticleComponent[] components, boolean isAnimation) {
        while (--particleCount != 0) {
            double radius = 2.0f * entity.m_20205_();
            double yaw = (double)(random.m_188501_() * 2.0f) * Math.PI;
            double pitch = (double)(random.m_188501_() * 2.0f) * Math.PI;
            double ox = radius * Math.sin(yaw) * Math.sin(pitch);
            double oy = radius * Math.cos(pitch);
            double oz = radius * Math.cos(yaw) * Math.sin(pitch);
            double rootX = entity.m_20185_();
            double rootY = entity.m_20186_() + (double)(entity.m_20206_() / 2.0f) + (double)yOffset;
            double rootZ = entity.m_20189_();
            AdvancedParticleBase.spawnParticle(entity.m_9236_(), advParticleType, rootX + ox, rootY + oy, rootZ + oz, 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, scale, 1.0, 1.0, 1.0, 1.0, 1.0, duration, true, false, isAnimation, components);
        }
    }
}

