/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.render.effects;

import com.eeeab.eeeabsmobs.client.render.EMRenderType;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityCrimsonRay;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class RenderCrimsonRay
extends EntityRenderer<EntityCrimsonRay> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("eeeabsmobs", "textures/effects/crimson_ray.png");
    private static final float TEXTURE_WIDTH = 256.0f;
    private static final float TEXTURE_HEIGHT = 32.0f;
    private static final float START_RADIUS = 1.2f;
    private static final float BEAM_RADIUS = 0.8f;

    public RenderCrimsonRay(EntityRendererProvider.Context mgr) {
        super(mgr);
    }

    public void render(EntityCrimsonRay ray, float entityYaw, float delta, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        double collidePosX = ray.prevCollidePosX + (ray.collidePosX - ray.prevCollidePosX) * (double)delta;
        double collidePosY = ray.prevCollidePosY + (ray.collidePosY - ray.prevCollidePosY) * (double)delta;
        double collidePosZ = ray.prevCollidePosZ + (ray.collidePosZ - ray.prevCollidePosZ) * (double)delta;
        double posX = ray.f_19854_ + (ray.m_20185_() - ray.f_19854_) * (double)delta;
        double posY = ray.f_19855_ + (ray.m_20186_() - ray.f_19855_) * (double)delta;
        double posZ = ray.f_19856_ + (ray.m_20189_() - ray.f_19856_) * (double)delta;
        float yaw = ray.preYaw + (ray.yaw - ray.preYaw) * delta;
        float pitch = ray.prePitch + (ray.pitch - ray.prePitch) * delta;
        float length = (float)Math.sqrt(Math.pow(collidePosX - posX, 2.0) + Math.pow(collidePosY - posY, 2.0) + Math.pow(collidePosZ - posZ, 2.0));
        int frame = Mth.m_14143_((float)(((float)(ray.displayControlled.getTimer() - 1) + delta) * 2.0f));
        if (frame < 0) {
            frame = 6;
        }
        if (!ray.isAccumulating()) {
            return;
        }
        VertexConsumer vertex$builder = bufferIn.m_6299_(EMRenderType.getGlowingEffect(this.getTextureLocation(ray)));
        this.renderStart(ray, frame, matrixStackIn, vertex$builder, delta, packedLightIn);
        this.renderBeam(length, 57.295776f * yaw, 57.295776f * pitch, frame, matrixStackIn, vertex$builder, packedLightIn);
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(collidePosX - posX, collidePosY - posY, collidePosZ - posZ);
        this.renderEnd(frame, ray.blockSide, matrixStackIn, vertex$builder, packedLightIn);
        matrixStackIn.m_85849_();
    }

    public ResourceLocation getTextureLocation(EntityCrimsonRay entity) {
        return TEXTURE;
    }

    private void renderFlatQuad(int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn, boolean faceCamera) {
        float minU = 0.0f + 0.0625f * (float)frame;
        float minV = 0.0f;
        float maxU = minU + 0.0625f;
        float maxV = minV + 0.5f;
        float SIZE = 1.2f;
        PoseStack.Pose matrix$stack$entry = matrixStackIn.m_85850_();
        Matrix4f matrix4f = matrix$stack$entry.m_252922_();
        Matrix3f matrix3f = matrix$stack$entry.m_252943_();
        if (faceCamera) {
            RenderCrimsonRay.drawVertex(matrix4f, matrix3f, builder, -SIZE, -SIZE, 0.0f, minU, minV, packedLightIn);
            RenderCrimsonRay.drawVertex(matrix4f, matrix3f, builder, -SIZE, SIZE, 0.0f, minU, maxV, packedLightIn);
            RenderCrimsonRay.drawVertex(matrix4f, matrix3f, builder, SIZE, SIZE, 0.0f, maxU, maxV, packedLightIn);
            RenderCrimsonRay.drawVertex(matrix4f, matrix3f, builder, SIZE, -SIZE, 0.0f, maxU, minV, packedLightIn);
        } else {
            RenderCrimsonRay.drawVertex(matrix4f, matrix3f, builder, -SIZE, 0.0f, -SIZE, minU, minV, packedLightIn);
            RenderCrimsonRay.drawVertex(matrix4f, matrix3f, builder, -SIZE, 0.0f, SIZE, minU, maxV, packedLightIn);
            RenderCrimsonRay.drawVertex(matrix4f, matrix3f, builder, SIZE, 0.0f, SIZE, maxU, maxV, packedLightIn);
            RenderCrimsonRay.drawVertex(matrix4f, matrix3f, builder, SIZE, 0.0f, -SIZE, maxU, minV, packedLightIn);
        }
    }

    private void renderStart(EntityCrimsonRay ray, int frame, PoseStack matrixStackIn, VertexConsumer builder, float delta, int packedLightIn) {
        matrixStackIn.m_85836_();
        float speed = ((float)ray.f_19797_ + delta) * 3.0f;
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(90.0f - ray.m_146908_() + speed));
        matrixStackIn.m_85837_(0.0, (double)0.001f, 0.0);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn, false);
        matrixStackIn.m_85849_();
    }

    private void renderEnd(int frame, Direction side, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        matrixStackIn.m_85836_();
        Quaternionf quat = this.f_114476_.m_253208_();
        matrixStackIn.m_252781_(quat);
        matrixStackIn.m_252880_(0.0f, 0.1f, 0.0f);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn, true);
        matrixStackIn.m_85849_();
        if (side == null) {
            return;
        }
        matrixStackIn.m_85836_();
        Quaternionf rotation = side.m_253075_();
        rotation.mul((Quaternionfc)Axis.f_252529_.m_252977_(90.0f));
        matrixStackIn.m_252781_(rotation);
        matrixStackIn.m_252880_(0.0f, 0.0f, -0.01f);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn, true);
        matrixStackIn.m_85849_();
    }

    private void drawBeam(float length, int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        float minU = 0.0f;
        float minV = 0.5f + 0.03125f * (float)frame;
        float maxU = minU + 0.078125f;
        float maxV = minV + 0.03125f;
        PoseStack.Pose matrix$stack$entry = matrixStackIn.m_85850_();
        Matrix4f matrix4f = matrix$stack$entry.m_252922_();
        Matrix3f matrix3f = matrix$stack$entry.m_252943_();
        float SIZE = 0.8f;
        RenderCrimsonRay.drawVertex(matrix4f, matrix3f, builder, -SIZE, 0.0f, 0.0f, minU, minV, packedLightIn);
        RenderCrimsonRay.drawVertex(matrix4f, matrix3f, builder, -SIZE, length, 0.0f, minU, maxV, packedLightIn);
        RenderCrimsonRay.drawVertex(matrix4f, matrix3f, builder, SIZE, length, 0.0f, maxU, maxV, packedLightIn);
        RenderCrimsonRay.drawVertex(matrix4f, matrix3f, builder, SIZE, 0.0f, 0.0f, maxU, minV, packedLightIn);
    }

    private void renderBeam(float length, float yaw, float pitch, int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(yaw - 90.0f));
        matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-pitch));
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(Minecraft.m_91087_().f_91063_.m_109153_().m_90589_() + 90.0f));
        this.drawBeam(length, frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-Minecraft.m_91087_().f_91063_.m_109153_().m_90589_() - 90.0f));
        this.drawBeam(length, frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-Minecraft.m_91087_().f_91063_.m_109153_().m_90589_() + 180.0f));
        this.drawBeam(length, frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85836_();
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(-Minecraft.m_91087_().f_91063_.m_109153_().m_90589_() - 180.0f));
        this.drawBeam(length, frame, matrixStackIn, builder, packedLightIn);
        matrixStackIn.m_85849_();
        matrixStackIn.m_85849_();
    }

    public static void drawVertex(Matrix4f matrix, Matrix3f normals, VertexConsumer vertexBuilder, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, int packedLightIn) {
        vertexBuilder.m_252986_(matrix, offsetX, offsetY, offsetZ).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(textureX, textureY).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_252939_(normals, 1.0f, 0.0f, 1.0f).m_5752_();
    }

    public static class RenderPreAttack
    extends EntityRenderer<EntityCrimsonRay.PreAttack> {
        private static final ResourceLocation TEXTURE = new ResourceLocation("eeeabsmobs", "textures/effects/crimson_ray_pre.png");
        private static final float TEXTURE_WIDTH = 256.0f;
        private static final float TEXTURE_HEIGHT = 32.0f;
        private static final float SIZE = 0.6f;

        public RenderPreAttack(EntityRendererProvider.Context context) {
            super(context);
        }

        public void render(EntityCrimsonRay.PreAttack crack, float entityYaw, float delta, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
            VertexConsumer consumer = bufferIn.m_6299_(EMRenderType.getGlowingEffect(TEXTURE));
            matrixStackIn.m_85836_();
            matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(90.0f - crack.m_146908_()));
            matrixStackIn.m_85837_(0.0, (double)0.001f, 0.0);
            matrixStackIn.m_85841_(-2.0f, -2.0f, -2.0f);
            this.renderFlatQuad(crack.getPhase(), matrixStackIn, consumer, packedLightIn);
            matrixStackIn.m_85849_();
        }

        public ResourceLocation getTextureLocation(EntityCrimsonRay.PreAttack pEntity) {
            return TEXTURE;
        }

        private void renderFlatQuad(int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn) {
            float minU = 0.0f + 0.125f * (float)frame;
            float minV = 0.0f;
            float maxU = minU + 0.125f;
            float maxV = minV + 1.0f;
            PoseStack.Pose matrix$stack$entry = matrixStackIn.m_85850_();
            Matrix4f matrix4f = matrix$stack$entry.m_252922_();
            Matrix3f matrix3f = matrix$stack$entry.m_252943_();
            RenderCrimsonRay.drawVertex(matrix4f, matrix3f, builder, -0.6f, 0.0f, -0.6f, minU, minV, packedLightIn);
            RenderCrimsonRay.drawVertex(matrix4f, matrix3f, builder, -0.6f, 0.0f, 0.6f, minU, maxV, packedLightIn);
            RenderCrimsonRay.drawVertex(matrix4f, matrix3f, builder, 0.6f, 0.0f, 0.6f, maxU, maxV, packedLightIn);
            RenderCrimsonRay.drawVertex(matrix4f, matrix3f, builder, 0.6f, 0.0f, -0.6f, maxU, minV, packedLightIn);
        }
    }
}

