/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.particle.util;

import com.eeeab.eeeabsmobs.client.particle.util.AdvancedParticleBase;
import com.eeeab.eeeabsmobs.client.particle.util.ParticleRotation;
import com.eeeab.eeeabsmobs.client.particle.util.anim.AnimData;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class ParticleComponent {
    public void init(AdvancedParticleBase particle) {
    }

    public void preUpdate(AdvancedParticleBase particle) {
    }

    public void postUpdate(AdvancedParticleBase particle) {
    }

    public void preRender(AdvancedParticleBase particle, float partialTicks) {
    }

    public void postRender(AdvancedParticleBase particle, VertexConsumer buffer, Camera renderInfo, float partialTicks, int lightmap) {
    }

    public static class FaceMotion
    extends ParticleComponent {
        @Override
        public void preRender(AdvancedParticleBase particle, float partialTicks) {
            double dz;
            double dy;
            double dx = particle.getPosX() - particle.getPrevPosX();
            double d = Math.sqrt(dx * dx + (dy = particle.getPosY() - particle.getPrevPosY()) * dy + (dz = particle.getPosZ() - particle.getPrevPosZ()) * dz);
            if (d != 0.0) {
                ParticleRotation particleRotation = particle.rotation;
                if (particleRotation instanceof ParticleRotation.EulerAngles) {
                    ParticleRotation.EulerAngles eulerRot = (ParticleRotation.EulerAngles)particleRotation;
                    double a = dy / d;
                    a = Math.max(-1.0, Math.min(1.0, a));
                    float pitch = -((float)Math.asin(a));
                    float yaw = -((float)(Math.atan2(dz, dx) + Math.PI));
                    eulerRot.roll = pitch;
                    eulerRot.yaw = yaw;
                } else {
                    particleRotation = particle.rotation;
                    if (particleRotation instanceof ParticleRotation.OrientVector) {
                        ParticleRotation.OrientVector orientRot = (ParticleRotation.OrientVector)particleRotation;
                        orientRot.orientation = new Vec3(dx, dy, dz).m_82541_();
                    }
                }
            }
        }
    }

    public static class Orbit
    extends ParticleComponent {
        private final Vec3[] location;
        private final AnimData phase;
        private final AnimData radius;
        private final AnimData axisX;
        private final AnimData axisY;
        private final AnimData axisZ;
        private final boolean faceCamera;

        public Orbit(Vec3[] location, AnimData phase, AnimData radius, AnimData axisX, AnimData axisY, AnimData axisZ, boolean faceCamera) {
            this.location = location;
            this.phase = phase;
            this.radius = radius;
            this.axisX = axisX;
            this.axisY = axisY;
            this.axisZ = axisZ;
            this.faceCamera = faceCamera;
        }

        @Override
        public void init(AdvancedParticleBase particle) {
            this.apply(particle, 0.0f);
        }

        @Override
        public void preUpdate(AdvancedParticleBase particle) {
            float ageFrac = particle.getAge() / (float)particle.m_107273_();
            this.apply(particle, ageFrac);
        }

        private void apply(AdvancedParticleBase particle, float t) {
            float p = this.phase.evaluate(t);
            float r = this.radius.evaluate(t);
            Vector3f axis = this.faceCamera && Minecraft.m_91087_().f_91074_ != null ? new Vector3f((Vector3fc)Minecraft.m_91087_().f_91074_.m_20154_().m_252839_()) : new Vector3f(this.axisX.evaluate(t), this.axisY.evaluate(t), this.axisZ.evaluate(t));
            axis.normalize();
            Quaternionf quat = new Quaternionf(axis.x, axis.y, axis.z, p * (float)Math.PI * 2.0f);
            Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
            Vector3f start = axis;
            if ((double)Math.abs(axis.dot((Vector3fc)up)) > 0.99) {
                start = new Vector3f(1.0f, 0.0f, 0.0f);
            }
            start.cross((Vector3fc)up);
            start.normalize();
            Vector3f newPos = start;
            newPos.rotate((Quaternionfc)quat);
            newPos.mul(r);
            if (this.location.length > 0 && this.location[0] != null) {
                newPos.add((float)this.location[0].f_82479_, (float)this.location[0].f_82480_, (float)this.location[0].f_82481_);
            }
            particle.m_107264_(newPos.x(), newPos.y(), newPos.z());
        }
    }

    public static class Attractor
    extends ParticleComponent {
        private final Vec3[] location;
        private final float strength;
        private final float killDist;
        private final EnumAttractorBehavior behavior;
        private Vec3 startLocation;

        public Attractor(Vec3[] location, float strength, float killDist, EnumAttractorBehavior behavior) {
            this.location = location;
            this.strength = strength;
            this.killDist = killDist;
            this.behavior = behavior;
        }

        @Override
        public void init(AdvancedParticleBase particle) {
            this.startLocation = new Vec3(particle.getPosX(), particle.getPosY(), particle.getPosZ());
        }

        @Override
        public void preUpdate(AdvancedParticleBase particle) {
            float ageFrac = particle.getAge() / (float)(particle.m_107273_() - 1);
            if (this.location.length > 0) {
                Vec3 destinationVec = this.location[0];
                Vec3 currPos = new Vec3(particle.getPosX(), particle.getPosY(), particle.getPosZ());
                Vec3 diff = destinationVec.m_82546_(currPos);
                if (diff.m_82553_() < (double)this.killDist) {
                    particle.m_107274_();
                }
                if (this.behavior == EnumAttractorBehavior.EXPONENTIAL) {
                    Vec3 path = destinationVec.m_82546_(this.startLocation).m_82490_(Math.pow(ageFrac, this.strength)).m_82549_(this.startLocation).m_82546_(currPos);
                    particle.m_6257_(path.f_82479_, path.f_82480_, path.f_82481_);
                } else if (this.behavior == EnumAttractorBehavior.LINEAR) {
                    Vec3 path = destinationVec.m_82546_(this.startLocation).m_82490_((double)ageFrac).m_82549_(this.startLocation).m_82546_(currPos);
                    particle.m_6257_(path.f_82479_, path.f_82480_, path.f_82481_);
                } else {
                    double dist = Math.max(diff.m_82553_(), 0.001);
                    diff = diff.m_82541_().m_82490_((double)this.strength / (dist * dist));
                    particle.setMotionX(Math.min(particle.getMotionX() + diff.f_82479_, 5.0));
                    particle.setMotionY(Math.min(particle.getMotionY() + diff.f_82480_, 5.0));
                    particle.setMotionZ(Math.min(particle.getMotionZ() + diff.f_82481_, 5.0));
                }
            }
        }

        public static enum EnumAttractorBehavior {
            LINEAR,
            EXPONENTIAL,
            SIMULATED;

        }
    }

    public static class PinLocation
    extends ParticleComponent {
        private final Vec3[] location;

        public PinLocation(Vec3[] location) {
            this.location = location;
        }

        @Override
        public void init(AdvancedParticleBase particle) {
            if (this.location != null && this.location.length > 0) {
                particle.m_107264_(this.location[0].f_82479_, this.location[0].f_82480_, this.location[0].f_82481_);
            }
        }

        @Override
        public void preUpdate(AdvancedParticleBase particle) {
            if (this.location != null && this.location.length > 0) {
                particle.m_107264_(this.location[0].f_82479_, this.location[0].f_82480_, this.location[0].f_82481_);
            }
        }
    }

    public static class PropertyControl
    extends ParticleComponent {
        private final AnimData animData;
        private final EnumParticleProperty property;
        private final boolean additive;

        public PropertyControl(EnumParticleProperty property, AnimData animData, boolean additive) {
            this.property = property;
            this.animData = animData;
            this.additive = additive;
        }

        @Override
        public void init(AdvancedParticleBase particle) {
            float value = this.animData.evaluate(0.0f);
            this.applyUpdate(particle, value);
            this.applyRender(particle, value);
        }

        @Override
        public void preRender(AdvancedParticleBase particle, float partialTicks) {
            float ageFrac = (particle.getAge() + partialTicks) / (float)particle.m_107273_();
            float value = this.animData.evaluate(ageFrac);
            this.applyRender(particle, value);
        }

        @Override
        public void preUpdate(AdvancedParticleBase particle) {
            float ageFrac = particle.getAge() / (float)particle.m_107273_();
            float value = this.animData.evaluate(ageFrac);
            this.applyUpdate(particle, value);
        }

        private void applyUpdate(AdvancedParticleBase particle, float value) {
            if (this.property == EnumParticleProperty.POS_X) {
                if (this.additive) {
                    particle.setPosX(particle.getPosX() + (double)value);
                } else {
                    particle.setPosX(value);
                }
            } else if (this.property == EnumParticleProperty.POS_Y) {
                if (this.additive) {
                    particle.setPosY(particle.getPosY() + (double)value);
                } else {
                    particle.setPosY(value);
                }
            } else if (this.property == EnumParticleProperty.POS_Z) {
                if (this.additive) {
                    particle.setPosZ(particle.getPosZ() + (double)value);
                } else {
                    particle.setPosZ(value);
                }
            } else if (this.property == EnumParticleProperty.MOTION_X) {
                if (this.additive) {
                    particle.setMotionX(particle.getMotionX() + (double)value);
                } else {
                    particle.setMotionX(value);
                }
            } else if (this.property == EnumParticleProperty.MOTION_Y) {
                if (this.additive) {
                    particle.setMotionY(particle.getMotionY() + (double)value);
                } else {
                    particle.setMotionY(value);
                }
            } else if (this.property == EnumParticleProperty.MOTION_Z) {
                if (this.additive) {
                    particle.setMotionZ(particle.getMotionZ() + (double)value);
                } else {
                    particle.setMotionZ(value);
                }
            } else if (this.property == EnumParticleProperty.AIR_DIFFUSION_SPEED) {
                particle.airDiffusionSpeed = this.additive ? (particle.airDiffusionSpeed += value) : value;
            }
        }

        private void applyRender(AdvancedParticleBase particle, float value) {
            ParticleRotation particleRotation;
            if (this.property == EnumParticleProperty.RED) {
                particle.red = this.additive ? (particle.red += value) : value;
            } else if (this.property == EnumParticleProperty.GREEN) {
                particle.green = this.additive ? (particle.green += value) : value;
            } else if (this.property == EnumParticleProperty.BLUE) {
                particle.blue = this.additive ? (particle.blue += value) : value;
            } else if (this.property == EnumParticleProperty.ALPHA) {
                particle.alpha = this.additive ? (particle.alpha += value) : value;
            } else if (this.property == EnumParticleProperty.SCALE) {
                particle.scale = this.additive ? (particle.scale += value) : value;
            } else if (this.property == EnumParticleProperty.YAW) {
                ParticleRotation particleRotation2 = particle.rotation;
                if (particleRotation2 instanceof ParticleRotation.EulerAngles) {
                    ParticleRotation.EulerAngles eulerRot = (ParticleRotation.EulerAngles)particleRotation2;
                    eulerRot.yaw = this.additive ? (eulerRot.yaw += value) : value;
                }
            } else if (this.property == EnumParticleProperty.PITCH) {
                ParticleRotation particleRotation3 = particle.rotation;
                if (particleRotation3 instanceof ParticleRotation.EulerAngles) {
                    ParticleRotation.EulerAngles eulerRot = (ParticleRotation.EulerAngles)particleRotation3;
                    eulerRot.pitch = this.additive ? (eulerRot.pitch += value) : value;
                }
            } else if (this.property == EnumParticleProperty.ROLL) {
                ParticleRotation particleRotation4 = particle.rotation;
                if (particleRotation4 instanceof ParticleRotation.EulerAngles) {
                    ParticleRotation.EulerAngles eulerRot = (ParticleRotation.EulerAngles)particleRotation4;
                    eulerRot.roll = this.additive ? (eulerRot.roll += value) : value;
                }
            } else if (this.property == EnumParticleProperty.PARTICLE_ANGLE && (particleRotation = particle.rotation) instanceof ParticleRotation.FaceCamera) {
                ParticleRotation.FaceCamera faceCameraRot = (ParticleRotation.FaceCamera)particleRotation;
                faceCameraRot.faceCameraAngle = this.additive ? (faceCameraRot.faceCameraAngle += value) : value;
            }
        }

        public static enum EnumParticleProperty {
            POS_X,
            POS_Y,
            POS_Z,
            MOTION_X,
            MOTION_Y,
            MOTION_Z,
            AIR_DIFFUSION_SPEED,
            RED,
            GREEN,
            BLUE,
            ALPHA,
            SCALE,
            YAW,
            PITCH,
            ROLL,
            PARTICLE_ANGLE;

        }
    }
}

