/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.model.entity;

import com.eeeab.animate.client.model.EMHierarchicalModel;
import com.eeeab.eeeabsmobs.client.model.animation.AnimationCommon;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityImmortalGolem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModelImmortalGolem
extends EMHierarchicalModel<EntityImmortalGolem>
implements ArmedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public ModelImmortalGolem(ModelPart root) {
        this.root = root.m_171324_("root");
        ModelPart upper = this.root.m_171324_("upper");
        this.head = upper.m_171324_("head");
        this.body = upper.m_171324_("body");
        this.leftArm = this.body.m_171324_("leftArm");
        this.rightArm = this.body.m_171324_("rightArm");
        ModelPart lower = this.root.m_171324_("lower");
        this.rightLeg = lower.m_171324_("rightLeg");
        this.leftLeg = lower.m_171324_("leftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition upper = root.m_171599_("upper", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = upper.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -7.5f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.3f)).m_171514_(34, 0).m_171488_(-4.0f, -6.5f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.6f)), PartPose.m_171419_((float)0.0f, (float)-18.0f, (float)0.0f));
        PartDefinition body = upper.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(11, 22).m_171488_(-3.5f, 0.0f, -2.0f, 7.0f, 10.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-18.0f, (float)0.0f));
        PartDefinition leftArm = body.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(35, 24).m_171488_(-1.5f, -1.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.0f, (float)1.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition leftHand = leftArm.m_171599_("leftHand", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = body.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(35, 24).m_171480_().m_171488_(-0.5f, -1.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-5.0f, (float)1.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition rightHand = rightArm.m_171599_("rightHand", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition lower = root.m_171599_("lower", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = lower.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(1, 26).m_171488_(-1.0f, 1.0f, -1.1f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-9.0f, (float)0.1f));
        PartDefinition rightLeg = lower.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(1, 26).m_171480_().m_171488_(-1.0f, 1.0f, -1.1f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)-9.0f, (float)0.1f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    @Override
    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(EntityImmortalGolem entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        float delta = ageInTicks - (float)entity.f_19797_;
        float frame = (float)entity.frame + delta;
        ModelImmortalGolem.lookAtAnimation(netHeadYaw, headPitch, 1.0f, this.head);
        float walkSpeed = 0.8f;
        float walkDegree = 0.8f;
        this.flap(this.root, walkSpeed, walkDegree * 0.05f, false, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.walk(this.leftLeg, walkSpeed, walkDegree * 1.2f, true, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.walk(this.rightLeg, walkSpeed, walkDegree * 1.2f, false, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.walk(this.leftArm, walkSpeed, walkDegree * 0.2f, false, 0.0f, -0.05f, limbSwing, limbSwingAmount);
        this.walk(this.rightArm, walkSpeed, walkDegree * 0.2f, true, 0.0f, -0.05f, limbSwing, limbSwingAmount);
        float speed = 0.08f;
        float degree = 0.05f;
        if (entity.m_6084_()) {
            this.walk(this.head, speed, degree, false, 0.5f, -0.05f, frame, 1.0f);
            this.walk(this.rightArm, speed, degree, true, 0.0f, -0.05f, frame, 1.0f);
            this.swing(this.rightArm, speed, degree, true, 0.0f, 0.0f, frame, 1.0f);
            this.walk(this.leftArm, speed, degree, false, 0.0f, -0.05f, frame, 1.0f);
            this.swing(this.leftArm, speed, degree, false, 0.0f, 0.0f, frame, 1.0f);
        }
        if (entity.getAnimation() == entity.spawnAnimation) {
            this.setStaticRotationAngle(this.leftArm, 90.0f, 0.0f, 0.0f);
            this.setStaticRotationAngle(this.rightArm, 90.0f, 0.0f, 0.0f);
        }
        if (entity.isDangerous() && entity.getAnimation() != entity.spawnAnimation) {
            this.setStaticRotationAngle(this.leftArm, 20.0f, 25.0f, 0.0f);
            this.setStaticRotationAngle(this.rightArm, 20.0f, -25.0f, 0.0f);
        }
        this.m_233381_(entity.spawnAnimation, AnimationCommon.SPAWN, ageInTicks);
        this.m_233381_(entity.hurtAnimation, AnimationImmortalGolem.HURT, ageInTicks);
        this.m_233381_(entity.attackAnimation, AnimationImmortalGolem.ATTACK, ageInTicks);
    }

    public void m_6002_(HumanoidArm humanoidArm, PoseStack poseStack) {
        boolean flag = humanoidArm == HumanoidArm.RIGHT;
        ModelPart model$part = flag ? this.rightArm : this.leftArm;
        this.root.m_104299_(poseStack);
        this.body.m_104299_(poseStack);
        model$part.m_104299_(poseStack);
        poseStack.m_85841_(0.6f, 0.6f, 0.6f);
        this.offsetStackPosition(poseStack, flag);
    }

    private void offsetStackPosition(PoseStack translate, boolean isRightArm) {
        if (isRightArm) {
            translate.m_85837_(0.125, 0.1625, 0.0);
        } else {
            translate.m_85837_(-0.125, 0.1625, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class AnimationImmortalGolem {
        public static final AnimationDefinition ATTACK = AnimationDefinition.Builder.m_232275_((float)0.6f).m_232279_("root", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.25f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.1f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.5f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("root", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.16766666f, KeyframeAnimations.m_253186_((float)-2.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.3433333f, KeyframeAnimations.m_253186_((float)2.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("upper", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.16766666f, KeyframeAnimations.m_253186_((float)-5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.3433333f, KeyframeAnimations.m_253186_((float)2.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("head", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.16766666f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.5f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.3433333f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("head", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.16766666f, KeyframeAnimations.m_253186_((float)-10.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.3433333f, KeyframeAnimations.m_253186_((float)-5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("leftArm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.16766666f, KeyframeAnimations.m_253186_((float)-60.08f, (float)4.53f, (float)-2.12f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.25f, KeyframeAnimations.m_253186_((float)6.38f, (float)20.49f, (float)-15.99f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.3433333f, KeyframeAnimations.m_253186_((float)42.39f, (float)-3.92f, (float)-7.47f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("rightArm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.16766666f, KeyframeAnimations.m_253186_((float)-60.08f, (float)-4.53f, (float)2.12f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.25f, KeyframeAnimations.m_253186_((float)6.38f, (float)-20.49f, (float)15.99f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.3433333f, KeyframeAnimations.m_253186_((float)42.39f, (float)3.92f, (float)7.47f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232282_();
        public static final AnimationDefinition HURT = AnimationDefinition.Builder.m_232275_((float)0.5f).m_232279_("head", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.125f, KeyframeAnimations.m_253126_((float)0.0f, (float)2.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.2916767f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("head", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.08343333f, KeyframeAnimations.m_253186_((float)-5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.16766666f, KeyframeAnimations.m_253186_((float)5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.2916767f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232282_();

        private AnimationImmortalGolem() {
        }
    }
}

