/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.model.entity;

import com.eeeab.animate.client.model.EMHierarchicalModel;
import com.eeeab.eeeabsmobs.sever.entity.corpse.EntityCorpseWarlock;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelCorpseWarlock
extends EMHierarchicalModel<EntityCorpseWarlock> {
    private final ModelPart root;
    private final ModelPart upper;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart cloak;
    public final ModelPart head;

    public ModelCorpseWarlock(ModelPart root) {
        this.root = root.m_171324_("root");
        this.upper = this.root.m_171324_("upper");
        this.head = this.upper.m_171324_("head");
        this.rightArm = this.upper.m_171324_("rightArm");
        this.leftArm = this.upper.m_171324_("leftArm");
        this.cloak = this.upper.m_171324_("body").m_171324_("cloak");
        ModelPart lower = this.root.m_171324_("lower");
        this.rightLeg = lower.m_171324_("rightLeg");
        this.leftLeg = lower.m_171324_("leftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition upper = root.m_171599_("upper", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-14.0f, (float)0.0f));
        PartDefinition head = upper.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition head_r1 = head.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(34, 0).m_171488_(-3.7f, -4.8f, -4.3f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.2f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)0.0f, (float)0.0872f, (float)0.7844f, (float)0.0617f));
        PartDefinition head_r2 = head.m_171599_("head_r2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -3.8f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.3f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition body = upper.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(62, 18).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 18).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 17.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cloak = body.m_171599_("cloak", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-11.5338f, (float)2.7579f));
        PartDefinition cloak_r1 = cloak.m_171599_("cloak_r1", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171488_(-6.5f, -1.0f, 0.0f, 13.0f, 20.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = upper.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(26, 18).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.m_171423_((float)-5.4f, (float)-10.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition leftArm = upper.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(26, 18).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.1f)).m_171555_(false), PartPose.m_171423_((float)5.5f, (float)-10.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition lower = root.m_171599_("lower", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition rightLeg = lower.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(44, 18).m_171480_().m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = lower.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(44, 18).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    @Override
    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(EntityCorpseWarlock entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        ModelCorpseWarlock.lookAtAnimation(netHeadYaw, headPitch, 1.0f, this.head);
        float delta = ageInTicks - (float)entity.f_19797_;
        float frame = (float)entity.frame + delta;
        float walkSpeed = 0.7f;
        float walkDegree = 0.6f;
        this.flap(this.root, walkSpeed, walkDegree * 0.08f, false, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.walk(this.leftLeg, walkSpeed, walkDegree * 1.2f, true, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        this.walk(this.rightLeg, walkSpeed, walkDegree * 1.2f, false, 0.0f, 0.0f, limbSwing, limbSwingAmount);
        if (entity.isNoAnimation()) {
            this.walk(this.rightArm, walkSpeed, walkDegree, true, -0.2f, -0.1f, limbSwing, limbSwingAmount);
            this.walk(this.leftArm, walkSpeed, walkDegree, false, -0.2f, 0.1f, limbSwing, limbSwingAmount);
            this.walk(this.cloak, walkSpeed * 0.5f, walkDegree * 0.5f, false, 0.0f, 0.0f, limbSwing, limbSwingAmount);
            this.flap(this.rightArm, walkSpeed * 0.2f, walkDegree * 0.2f, true, 0.2f, -0.2f, limbSwing, limbSwingAmount);
            this.flap(this.leftArm, walkSpeed * 0.2f, walkDegree * 0.2f, true, 0.2f, 0.2f, limbSwing, limbSwingAmount);
        }
        float speed = 0.12f;
        float degree = 0.1f;
        if (entity.m_6084_()) {
            this.walk(this.upper, 0.1f, 0.005f, true, 0.0f, -0.005f, frame, 1.0f);
            this.walk(this.rightArm, speed, degree, true, 0.0f, 0.0f, frame, 1.0f);
            this.swing(this.rightArm, speed, degree, true, 0.0f, 0.0f, frame, 1.0f);
            this.walk(this.leftArm, speed, degree, false, 0.0f, 0.0f, frame, 1.0f);
            this.swing(this.leftArm, speed, degree, false, 0.0f, 0.0f, frame, 1.0f);
        }
        this.m_233385_(entity.attackAnimation, AnimationCorpseWarlock.ATTACK, ageInTicks, 1.0f);
        this.m_233385_(entity.tearSpaceAnimation, AnimationCorpseWarlock.TEAR_SPACE, ageInTicks, 1.0f);
        this.m_233385_(entity.teleportAnimation, AnimationCorpseWarlock.TELEPORT, ageInTicks, 1.0f);
        this.m_233385_(entity.vampireAnimation, entity.isHeal() ? AnimationCorpseWarlock.VAMPIRE_HEAL : AnimationCorpseWarlock.VAMPIRE_ATTACK, ageInTicks, 1.0f);
        this.m_233385_(entity.robustAnimation, AnimationCorpseWarlock.ROBUST_ATTACK, ageInTicks, 1.0f);
        if (entity.getAnimation() == entity.summonAnimation || entity.getAnimation() == entity.frenzyAnimation || entity.getAnimation() == entity.babbleAnimation) {
            float animationSpeed = 1.0f;
            if (entity.getAnimation() == entity.babbleAnimation) {
                this.head.f_104203_ = -0.17453294f;
                animationSpeed = 0.5f;
            }
            this.rightArm.f_104202_ = 0.0f;
            this.rightArm.f_104200_ = -6.0f;
            this.leftArm.f_104202_ = 0.0f;
            this.leftArm.f_104200_ = 6.0f;
            this.rightArm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6666f * animationSpeed)) * 0.5f;
            this.leftArm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6666f * animationSpeed)) * 0.5f;
            this.rightArm.f_104205_ = 2.3561945f;
            this.leftArm.f_104205_ = -2.3561945f;
            this.rightArm.f_104204_ = 0.0f;
            this.leftArm.f_104204_ = 0.0f;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class AnimationCorpseWarlock {
        public static final AnimationDefinition VAMPIRE_ATTACK = AnimationDefinition.Builder.m_232275_((float)4.5f).m_232279_("upper", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5f, KeyframeAnimations.m_253186_((float)40.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.75f, KeyframeAnimations.m_253186_((float)-20.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.0f, KeyframeAnimations.m_253186_((float)30.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("head", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5f, KeyframeAnimations.m_253186_((float)22.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)-45.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.5f, KeyframeAnimations.m_253186_((float)-45.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.75f, KeyframeAnimations.m_253186_((float)5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.0f, KeyframeAnimations.m_253186_((float)-20.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("rightArm", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5f, KeyframeAnimations.m_253126_((float)-0.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253126_((float)-1.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.5f, KeyframeAnimations.m_253126_((float)-1.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.75f, KeyframeAnimations.m_253126_((float)-1.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.5f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("rightArm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5f, KeyframeAnimations.m_253186_((float)-90.0f, (float)0.0f, (float)75.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)150.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)150.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.75f, KeyframeAnimations.m_253186_((float)-90.0f, (float)80.0f, (float)75.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.0f, KeyframeAnimations.m_253186_((float)-90.0f, (float)-20.0f, (float)75.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("leftArm", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5f, KeyframeAnimations.m_253126_((float)0.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253126_((float)1.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.5f, KeyframeAnimations.m_253126_((float)1.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.75f, KeyframeAnimations.m_253126_((float)1.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.5f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("leftArm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5f, KeyframeAnimations.m_253186_((float)-90.0f, (float)0.0f, (float)-75.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)-150.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)-150.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.75f, KeyframeAnimations.m_253186_((float)-90.0f, (float)-80.0f, (float)-75.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.0f, KeyframeAnimations.m_253186_((float)-90.0f, (float)20.0f, (float)-75.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("rightLeg", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5f, KeyframeAnimations.m_253126_((float)0.0f, (float)1.0f, (float)-1.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)2.0f, (float)-3.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.5f, KeyframeAnimations.m_253126_((float)0.0f, (float)2.0f, (float)-3.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.75f, KeyframeAnimations.m_253126_((float)0.0f, (float)1.0f, (float)-1.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.5f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("rightLeg", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(3.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.75f, KeyframeAnimations.m_253186_((float)7.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("cloak", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(3.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.75f, KeyframeAnimations.m_253186_((float)-10.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.0f, KeyframeAnimations.m_253186_((float)30.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232282_();
        public static final AnimationDefinition VAMPIRE_HEAL = AnimationDefinition.Builder.m_232275_((float)4.5f).m_232279_("upper", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.75f, KeyframeAnimations.m_253186_((float)-5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.0f, KeyframeAnimations.m_253186_((float)-10.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("head", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)-45.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.5f, KeyframeAnimations.m_253186_((float)-45.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.75f, KeyframeAnimations.m_253186_((float)22.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.0f, KeyframeAnimations.m_253186_((float)15.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("rightArm", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.0f, KeyframeAnimations.m_253126_((float)-1.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.5f, KeyframeAnimations.m_253126_((float)-1.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.75f, KeyframeAnimations.m_253126_((float)-0.75f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.0f, KeyframeAnimations.m_253126_((float)-0.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.5f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("rightArm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)150.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)150.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.75f, KeyframeAnimations.m_253186_((float)-90.0f, (float)0.0f, (float)75.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)75.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("leftArm", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.0f, KeyframeAnimations.m_253126_((float)1.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.5f, KeyframeAnimations.m_253126_((float)1.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.75f, KeyframeAnimations.m_253126_((float)0.75f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.0f, KeyframeAnimations.m_253126_((float)0.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.5f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("leftArm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)-150.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)-150.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.75f, KeyframeAnimations.m_253186_((float)-90.0f, (float)0.0f, (float)-75.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)-75.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("rightLeg", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)2.0f, (float)-3.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.5f, KeyframeAnimations.m_253126_((float)0.0f, (float)2.0f, (float)-3.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.75f, KeyframeAnimations.m_253126_((float)0.0f, (float)1.0f, (float)-1.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.5f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("cloak", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(3.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(3.75f, KeyframeAnimations.m_253186_((float)-5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.0f, KeyframeAnimations.m_253186_((float)10.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232282_();
        public static final AnimationDefinition TELEPORT = AnimationDefinition.Builder.m_232275_((float)1.5f).m_232279_("root", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.75f, KeyframeAnimations.m_253186_((float)0.0f, (float)-360.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("rightArm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.75f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)90.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("leftArm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.75f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)-90.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232282_();
        public static final AnimationDefinition TEAR_SPACE = AnimationDefinition.Builder.m_232275_((float)1.5f).m_232279_("upper", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.75f, KeyframeAnimations.m_253186_((float)-5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.875f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("rightArm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.75f, KeyframeAnimations.m_253186_((float)-90.0f, (float)65.0f, (float)-15.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.875f, KeyframeAnimations.m_253186_((float)-122.5f, (float)22.5f, (float)-15.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)-50.0f, (float)-10.0f, (float)-15.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("leftArm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.75f, KeyframeAnimations.m_253186_((float)-90.0f, (float)-65.0f, (float)15.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.875f, KeyframeAnimations.m_253186_((float)-122.5f, (float)-22.5f, (float)15.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)-50.0f, (float)10.0f, (float)15.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("cloak", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.9167666f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.0834333f, KeyframeAnimations.m_253186_((float)15.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232282_();
        public static final AnimationDefinition ROBUST_ATTACK = AnimationDefinition.Builder.m_232275_((float)5.0f).m_232279_("upper", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5f, KeyframeAnimations.m_253186_((float)7.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)15.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.25f, KeyframeAnimations.m_253186_((float)22.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.5f, KeyframeAnimations.m_253186_((float)30.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.75f, KeyframeAnimations.m_253186_((float)-10.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.5f, KeyframeAnimations.m_253186_((float)-10.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.958343f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("head", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5f, KeyframeAnimations.m_253186_((float)6.67f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)10.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.25f, KeyframeAnimations.m_253186_((float)21.25f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.5f, KeyframeAnimations.m_253186_((float)32.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.75f, KeyframeAnimations.m_253186_((float)-20.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.5f, KeyframeAnimations.m_253186_((float)-20.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.958343f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("rightArm", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5f, KeyframeAnimations.m_253126_((float)-1.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253126_((float)-1.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.25f, KeyframeAnimations.m_253126_((float)-1.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.5f, KeyframeAnimations.m_253126_((float)-1.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.75f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.5f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.958343f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("rightArm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5f, KeyframeAnimations.m_253186_((float)-20.0f, (float)-20.0f, (float)30.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)-20.0f, (float)-20.0f, (float)30.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.25f, KeyframeAnimations.m_253186_((float)-55.0f, (float)-35.0f, (float)52.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.5f, KeyframeAnimations.m_253186_((float)-90.0f, (float)-50.0f, (float)75.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.75f, KeyframeAnimations.m_253186_((float)0.0f, (float)-20.0f, (float)75.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)-20.0f, (float)75.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.958343f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("leftArm", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5f, KeyframeAnimations.m_253126_((float)1.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253126_((float)1.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.25f, KeyframeAnimations.m_253126_((float)1.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.5f, KeyframeAnimations.m_253126_((float)1.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.75f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.5f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.958343f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("leftArm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5f, KeyframeAnimations.m_253186_((float)-20.0f, (float)20.0f, (float)-30.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)-20.0f, (float)20.0f, (float)-30.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.25f, KeyframeAnimations.m_253186_((float)-55.0f, (float)35.0f, (float)-52.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.5f, KeyframeAnimations.m_253186_((float)-90.0f, (float)50.0f, (float)-75.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.75f, KeyframeAnimations.m_253186_((float)0.0f, (float)20.0f, (float)-75.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)20.0f, (float)-75.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.958343f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("rightLeg", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.25f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.75f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)10.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)10.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.958343f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("root", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.25f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)180.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.75f, KeyframeAnimations.m_253186_((float)0.0f, (float)270.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(2.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)360.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)360.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("leftLeg", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5f, KeyframeAnimations.m_253126_((float)0.0f, (float)2.0f, (float)-3.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)2.0f, (float)-3.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.25f, KeyframeAnimations.m_253126_((float)0.0f, (float)2.0f, (float)-3.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.5f, KeyframeAnimations.m_253126_((float)0.0f, (float)1.0f, (float)-1.5f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.75f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("leftLeg", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.25f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.5f, KeyframeAnimations.m_253186_((float)7.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(1.75f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)-10.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.5f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)-10.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(4.958343f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232282_();
        public static final AnimationDefinition ATTACK = AnimationDefinition.Builder.m_232275_((float)0.75f).m_232279_("upper", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.16766666f, KeyframeAnimations.m_253186_((float)7.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.3433333f, KeyframeAnimations.m_253186_((float)-7.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.75f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("head", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.16766666f, KeyframeAnimations.m_253186_((float)12.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.3433333f, KeyframeAnimations.m_253186_((float)12.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.75f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("cloak", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.16766666f, KeyframeAnimations.m_253186_((float)-7.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.3433333f, KeyframeAnimations.m_253186_((float)20.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.75f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("rightArm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.16766666f, KeyframeAnimations.m_253186_((float)-28.92f, (float)-8.09f, (float)-18.17f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.3433333f, KeyframeAnimations.m_253186_((float)-5.24f, (float)14.08f, (float)69.35f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.75f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("leftArm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.16766666f, KeyframeAnimations.m_253186_((float)-28.92f, (float)8.09f, (float)18.17f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.3433333f, KeyframeAnimations.m_253186_((float)-5.24f, (float)-14.08f, (float)-69.35f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.75f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232282_();

        private AnimationCorpseWarlock() {
        }
    }
}

