/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.model.entity;

import com.eeeab.animate.client.model.EMHierarchicalModel;
import com.eeeab.eeeabsmobs.client.model.animation.AnimationCommon;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityAbsImmortalSkeleton;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModelAbsImmortalSkeleton
extends EMHierarchicalModel<EntityAbsImmortalSkeleton>
implements ArmedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart upper;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public ModelAbsImmortalSkeleton(ModelPart root) {
        this.root = root.m_171324_("root");
        this.upper = this.root.m_171324_("upper");
        this.head = this.upper.m_171324_("head");
        this.leftArm = this.upper.m_171324_("leftArm");
        this.rightArm = this.upper.m_171324_("rightArm");
        ModelPart lower = this.root.m_171324_("lower");
        this.rightLeg = lower.m_171324_("rightLeg");
        this.leftLeg = lower.m_171324_("leftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)24.0f, (float)0.0f));
        PartDefinition upper = root.m_171599_("upper", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)-12.0f, (float)0.0f));
        PartDefinition head = upper.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.25f)).m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.85f)).m_171514_(0, 33).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition body = upper.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(18, 17).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(16, 49).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = upper.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(9, 16).m_171488_(-0.1038f, -1.4128f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(40, 49).m_171488_(-0.1038f, -2.0128f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.3f)), PartPose.m_171423_((float)4.1f, (float)-10.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0873f));
        PartDefinition rightArm = upper.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(9, 16).m_171480_().m_171488_(-1.9924f, -1.3257f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(40, 49).m_171480_().m_171488_(-3.9924f, -2.0257f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.3f)).m_171555_(false), PartPose.m_171423_((float)-4.0f, (float)-10.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0873f));
        PartDefinition lower = root.m_171599_("lower", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)-12.0f, (float)0.0f));
        PartDefinition leftLeg = lower.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-1.2f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(0, 49).m_171488_(-2.2f, -0.2f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.22f)), PartPose.m_171419_((float)2.2f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = lower.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 49).m_171480_().m_171488_(-2.0f, -0.2f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.22f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)128);
    }

    @Override
    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(EntityAbsImmortalSkeleton entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        ModelAbsImmortalSkeleton.lookAtAnimation(netHeadYaw, headPitch, 1.0f, this.head);
        float delta = ageInTicks - (float)entity.f_19797_;
        float frame = (float)entity.frame + delta;
        if (entity.m_6084_()) {
            float cycle = 0.8f;
            this.walk(this.upper, 0.1f, 0.005f, true, 0.0f, -0.005f, frame, 1.0f);
            this.bob(this.upper, cycle * 0.2f, cycle * 0.2f, false, frame, 1.0f);
            this.bob(this.leftArm, cycle * 0.2f, cycle * 0.2f, false, frame, 1.0f);
            this.bob(this.rightArm, cycle * 0.2f, cycle * 0.2f, false, frame, 1.0f);
            this.bob(this.head, cycle * -0.2f, cycle * -0.2f, false, frame, 1.0f);
            this.bob(this.head, cycle, cycle * 0.5f, false, limbSwing, limbSwingAmount);
            this.walk(this.leftArm, 0.15f, 0.05f, true, 0.0f, 0.0f, frame, 1.0f);
            this.walk(this.rightArm, 0.15f, 0.05f, false, 0.0f, 0.0f, frame, 1.0f);
            this.walk(this.leftLeg, cycle, cycle * 1.2f, false, 0.0f, -0.05f, limbSwing, limbSwingAmount);
            this.walk(this.rightLeg, cycle, cycle * 1.2f, true, 0.0f, -0.05f, limbSwing, limbSwingAmount);
            if (entity.getCareerType() == EntityAbsImmortalSkeleton.CareerType.ARCHER) {
                this.m_267799_(AnimationImmortalSkeleton.WALK, limbSwing, limbSwingAmount, 1.0f, 2.0f);
            } else if (entity.isNoAnimation()) {
                this.walk(this.leftArm, cycle, cycle * 1.2f, false, 0.0f, -0.05f, limbSwing, limbSwingAmount);
                this.walk(this.rightArm, cycle, cycle * 1.2f, true, 0.0f, -0.05f, limbSwing, limbSwingAmount);
            }
        }
        if (entity.getAnimation() == entity.castAnimation) {
            this.rightArm.f_104202_ = 0.0f;
            this.rightArm.f_104200_ = -5.0f;
            this.leftArm.f_104202_ = 0.0f;
            this.leftArm.f_104200_ = 5.0f;
            this.rightArm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.leftArm.f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
            this.rightArm.f_104205_ = 2.3561945f;
            this.leftArm.f_104205_ = -2.3561945f;
            this.rightArm.f_104204_ = 0.0f;
            this.leftArm.f_104204_ = 0.0f;
        } else if (entity.getAnimation() == entity.bowAnimation) {
            this.setStaticRotationAngle(this.rightArm, -85.0f, -10.0f, -10.0f);
            this.setStaticRotationAngle(this.leftArm, -75.0f, 25.0f, 10.0f);
        } else if (entity.getAnimation() == entity.crossBowChangeAnimation) {
            AnimationUtils.m_102086_((ModelPart)this.rightArm, (ModelPart)this.leftArm, (LivingEntity)entity, (boolean)true);
        } else if (entity.getAnimation() == entity.crossBowHoldAnimation) {
            AnimationUtils.m_102097_((ModelPart)this.rightArm, (ModelPart)this.leftArm, (ModelPart)this.head, (boolean)true);
        }
        this.m_233381_(entity.spawnAnimation, AnimationCommon.SPAWN, ageInTicks);
        this.m_233381_(entity.swingArmAnimation, AnimationImmortalSkeleton.SWINGARM, ageInTicks);
        this.m_233381_(entity.meleeAnimation1, AnimationImmortalSkeleton.MELEE1, ageInTicks);
        this.m_233381_(entity.meleeAnimation2, AnimationImmortalSkeleton.MELEE2, ageInTicks);
        this.m_233381_(entity.roarAnimation, AnimationImmortalSkeleton.ROAR, ageInTicks);
        this.m_233381_(entity.blockAnimation, AnimationImmortalSkeleton.BLOCK, ageInTicks);
        this.m_233381_(entity.dieAnimation, AnimationCommon.DIE, ageInTicks);
    }

    public void m_6002_(HumanoidArm humanoidArm, PoseStack poseStack) {
        ModelPart model$part = humanoidArm == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
        this.root.m_104299_(poseStack);
        this.upper.m_104299_(poseStack);
        model$part.m_104299_(poseStack);
        poseStack.m_85837_(0.0, 0.0, 0.085);
        poseStack.m_85841_(0.9375f, 0.9375f, 0.9375f);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class AnimationImmortalSkeleton {
        public static final AnimationDefinition WALK = AnimationDefinition.Builder.m_232275_((float)0.0f).m_232274_().m_232279_("leftArm", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("leftArm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)-75.0f, (float)25.0f, (float)10.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("rightArm", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)-0.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("rightArm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)-85.0f, (float)-10.0f, (float)-10.0f), AnimationChannel.Interpolations.f_232229_)})).m_232282_();
        public static final AnimationDefinition SWINGARM = AnimationDefinition.Builder.m_232275_((float)0.75f).m_232279_("root", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.4167667f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.1f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.75f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("root", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.25f, KeyframeAnimations.m_253186_((float)-2.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.5416766f, KeyframeAnimations.m_253186_((float)2.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.75f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("upper", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.25f, KeyframeAnimations.m_253186_((float)-5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.5416766f, KeyframeAnimations.m_253186_((float)2.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.75f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_)})).m_232279_("head", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.25f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.5f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.5416766f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("head", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.25f, KeyframeAnimations.m_253186_((float)-10.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.5416766f, KeyframeAnimations.m_253186_((float)-5.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.75f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("leftArm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.25f, KeyframeAnimations.m_253186_((float)-120.08f, (float)4.53f, (float)-2.12f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.2916767f, KeyframeAnimations.m_253186_((float)-116.88f, (float)2.0f, (float)2.24f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.4167667f, KeyframeAnimations.m_253186_((float)-21.96f, (float)-9.14f, (float)18.25f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5416766f, KeyframeAnimations.m_253186_((float)11.54f, (float)-6.0f, (float)2.34f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.75f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("rightArm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.25f, KeyframeAnimations.m_253186_((float)-120.08f, (float)-4.53f, (float)2.12f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.2916767f, KeyframeAnimations.m_253186_((float)-116.88f, (float)-2.0f, (float)-2.24f), AnimationChannel.Interpolations.f_232230_), new Keyframe(0.4167667f, KeyframeAnimations.m_253186_((float)-21.96f, (float)9.14f, (float)-18.25f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.5416766f, KeyframeAnimations.m_253186_((float)11.54f, (float)6.0f, (float)-2.34f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.75f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232282_();
        public static final AnimationDefinition MELEE1 = AnimationDefinition.Builder.m_232275_((float)0.75f).m_232279_("leftArm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.08f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.2f, KeyframeAnimations.m_253186_((float)60.0f, (float)20.0f, (float)-20.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.52f, KeyframeAnimations.m_253186_((float)-15.0f, (float)0.0f, (float)-7.5f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.64f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("rightArm", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.2f, KeyframeAnimations.m_253126_((float)0.0f, (float)1.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.36f, KeyframeAnimations.m_253126_((float)0.0f, (float)-1.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.44f, KeyframeAnimations.m_253126_((float)0.0f, (float)-0.5f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.52f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("rightArm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.2f, KeyframeAnimations.m_253186_((float)-135.19f, (float)20.0f, (float)-10.51f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.28f, KeyframeAnimations.m_253186_((float)-150.0f, (float)10.0f, (float)-8.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.4f, KeyframeAnimations.m_253186_((float)-52.4f, (float)-35.14f, (float)9.57f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.44f, KeyframeAnimations.m_253186_((float)-38.22f, (float)-28.51f, (float)5.38f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.56f, KeyframeAnimations.m_253186_((float)-20.0f, (float)-20.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.68f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("upper", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.2f, KeyframeAnimations.m_253186_((float)-5.0f, (float)1.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.4f, KeyframeAnimations.m_253186_((float)10.0f, (float)-10.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.44f, KeyframeAnimations.m_253186_((float)9.95f, (float)-9.94f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.64f, KeyframeAnimations.m_253186_((float)2.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("head", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.2f, KeyframeAnimations.m_253186_((float)0.0f, (float)-5.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.44f, KeyframeAnimations.m_253186_((float)10.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.72f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("root", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.2f, KeyframeAnimations.m_253186_((float)-9.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.44f, KeyframeAnimations.m_253186_((float)4.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.6f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("rightLeg", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.2f, KeyframeAnimations.m_253186_((float)25.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.44f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232282_();
        public static final AnimationDefinition MELEE2 = AnimationDefinition.Builder.m_232275_((float)0.75f).m_232279_("leftArm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)-1.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.16f, KeyframeAnimations.m_253186_((float)54.04f, (float)36.85f, (float)-32.34f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.4f, KeyframeAnimations.m_253186_((float)53.13f, (float)26.08f, (float)-24.78f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.56f, KeyframeAnimations.m_253186_((float)-6.64f, (float)-0.83f, (float)-6.73f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.72f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)-1.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("rightArm", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.16f, KeyframeAnimations.m_253126_((float)0.0f, (float)1.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.4f, KeyframeAnimations.m_253126_((float)0.0f, (float)-1.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.56f, KeyframeAnimations.m_253126_((float)0.0f, (float)-0.29f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.64f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("rightArm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.16f, KeyframeAnimations.m_253186_((float)-106.7f, (float)-14.11f, (float)61.69f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.4f, KeyframeAnimations.m_253186_((float)4.01f, (float)-8.93f, (float)70.24f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.56f, KeyframeAnimations.m_253186_((float)-32.24f, (float)-6.26f, (float)54.49f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.72f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("upper", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.16f, KeyframeAnimations.m_253186_((float)-5.0f, (float)-40.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.4f, KeyframeAnimations.m_253186_((float)10.0f, (float)20.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.56f, KeyframeAnimations.m_253186_((float)-2.0f, (float)5.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.72f, KeyframeAnimations.m_253186_((float)2.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("head", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.16f, KeyframeAnimations.m_253186_((float)-2.53f, (float)9.99f, (float)-0.66f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.4f, KeyframeAnimations.m_253186_((float)10.11f, (float)9.92f, (float)0.88f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.56f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("root", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.16f, KeyframeAnimations.m_253186_((float)-6.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.4f, KeyframeAnimations.m_253186_((float)6.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.56f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232282_();
        public static final AnimationDefinition ROAR = AnimationDefinition.Builder.m_232275_((float)2.0f).m_232279_("root", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.44f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)-1.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.6f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)-3.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.56f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)-3.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.76f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)-1.33f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.92f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("upper", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.44f, KeyframeAnimations.m_253186_((float)-20.0f, (float)5.0f, (float)-2.5f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.6f, KeyframeAnimations.m_253186_((float)45.0f, (float)-2.5f, (float)-2.5f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.4f, KeyframeAnimations.m_253186_((float)40.0f, (float)-5.71f, (float)-2.5f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.56f, KeyframeAnimations.m_253186_((float)27.63f, (float)-6.13f, (float)-2.5f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.76f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("head", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.44f, KeyframeAnimations.m_253186_((float)15.0f, (float)-5.0f, (float)-2.5f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.6f, KeyframeAnimations.m_253186_((float)-40.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.4f, KeyframeAnimations.m_253186_((float)-35.5f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.56f, KeyframeAnimations.m_253186_((float)-28.12f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.76f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("leftArm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.44f, KeyframeAnimations.m_253186_((float)-90.5f, (float)10.0f, (float)20.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.6f, KeyframeAnimations.m_253186_((float)30.5f, (float)0.0f, (float)-20.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.56f, KeyframeAnimations.m_253186_((float)30.5f, (float)0.0f, (float)-10.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.76f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("rightArm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.44f, KeyframeAnimations.m_253186_((float)-90.5f, (float)-10.0f, (float)-20.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.6f, KeyframeAnimations.m_253186_((float)30.5f, (float)0.0f, (float)20.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.56f, KeyframeAnimations.m_253186_((float)30.5f, (float)0.0f, (float)10.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.76f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("leftLeg", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.44f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)2.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.6f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)1.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.56f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)1.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.76f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.44f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.92f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("leftLeg", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.44f, KeyframeAnimations.m_253186_((float)20.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.6f, KeyframeAnimations.m_253186_((float)10.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.56f, KeyframeAnimations.m_253186_((float)10.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.76f, KeyframeAnimations.m_253186_((float)4.44f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.92f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("rightLeg", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.44f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.6f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)-2.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.56f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)-2.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.76f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)-0.89f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.92f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("rightLeg", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.44f, KeyframeAnimations.m_253186_((float)-50.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.6f, KeyframeAnimations.m_253186_((float)-10.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.56f, KeyframeAnimations.m_253186_((float)-10.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.76f, KeyframeAnimations.m_253186_((float)-4.44f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(1.92f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232282_();
        public static final AnimationDefinition BLOCK = AnimationDefinition.Builder.m_232275_((float)0.5f).m_232279_("upper", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.12f, KeyframeAnimations.m_253186_((float)5.0f, (float)15.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.36f, KeyframeAnimations.m_253186_((float)5.0f, (float)15.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.48f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("head", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.12f, KeyframeAnimations.m_253186_((float)-7.5f, (float)-12.5f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.36f, KeyframeAnimations.m_253186_((float)-7.5f, (float)-12.5f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.48f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("leftArm", new AnimationChannel(AnimationChannel.Targets.f_232250_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.12f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)-1.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.36f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)-1.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.48f, KeyframeAnimations.m_253126_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("leftArm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.12f, KeyframeAnimations.m_253186_((float)-60.0f, (float)60.0f, (float)20.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.36f, KeyframeAnimations.m_253186_((float)-60.0f, (float)60.0f, (float)20.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.48f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232279_("rightArm", new AnimationChannel(AnimationChannel.Targets.f_232251_, new Keyframe[]{new Keyframe(0.0f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.12f, KeyframeAnimations.m_253186_((float)7.5f, (float)0.0f, (float)10.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.36f, KeyframeAnimations.m_253186_((float)7.5f, (float)0.0f, (float)10.0f), AnimationChannel.Interpolations.f_232229_), new Keyframe(0.48f, KeyframeAnimations.m_253186_((float)0.0f, (float)0.0f, (float)0.0f), AnimationChannel.Interpolations.f_232229_)})).m_232282_();

        private AnimationImmortalSkeleton() {
        }
    }
}

