/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.animate.server.ai;

import com.eeeab.animate.server.animation.Animation;
import com.eeeab.eeeabsmobs.sever.entity.EEEABMobLibrary;
import java.util.EnumSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;

public class AnimationMeleeAI<T extends EEEABMobLibrary>
extends Goal {
    protected T attacker;
    protected Path path;
    protected final double speed;
    protected long lastCanUseCheck;
    protected int ticksUntilNextAttack;
    private final Supplier<Animation>[] animations;
    private final Predicate<T> customFlag;
    protected int attackInterval = 10;
    protected boolean followingTargetEvenIfNotSeen = false;

    @SafeVarargs
    public AnimationMeleeAI(T attacker, double speed, Supplier<Animation> ... animations) {
        this((EEEABMobLibrary)attacker, speed, (T e) -> e.active, animations);
    }

    @SafeVarargs
    public AnimationMeleeAI(T attacker, double speed, int attackInterval, Supplier<Animation> ... animations) {
        this((EEEABMobLibrary)attacker, speed, (T e) -> e.active, animations);
        this.attackInterval = attackInterval;
    }

    @SafeVarargs
    public AnimationMeleeAI(T attacker, double speed, int attackInterval, Predicate<T> customFlag, Supplier<Animation> ... animations) {
        this(attacker, speed, customFlag, animations);
        this.attackInterval = attackInterval;
    }

    @SafeVarargs
    public AnimationMeleeAI(T attacker, double speed, Predicate<T> customFlag, Supplier<Animation> ... animations) {
        this.attacker = attacker;
        this.speed = speed;
        this.customFlag = customFlag;
        this.animations = animations;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public AnimationMeleeAI<T> ignoreSight() {
        this.followingTargetEvenIfNotSeen = true;
        return this;
    }

    public boolean m_8036_() {
        long gameTime = this.attacker.m_9236_().m_46467_();
        if (!this.customFlag.test(this.attacker)) {
            return false;
        }
        if (gameTime - this.lastCanUseCheck < (long)this.attackInterval) {
            return false;
        }
        this.lastCanUseCheck = gameTime;
        LivingEntity target = this.attacker.m_5448_();
        if (target == null) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        if (!this.attacker.m_6779_(target)) {
            return false;
        }
        this.path = this.attacker.m_21573_().m_6570_((Entity)target, 0);
        if (this.path != null) {
            return true;
        }
        return this.attacker.m_142593_(target) >= this.attacker.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
    }

    public boolean m_8045_() {
        LivingEntity livingentity = this.attacker.m_5448_();
        if (!this.customFlag.test(this.attacker)) {
            return false;
        }
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.attacker.m_21573_().m_26571_();
        }
        if (!this.attacker.m_21444_(livingentity.m_20183_())) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }

    public void m_8056_() {
        this.attacker.m_21573_().m_26536_(this.path, this.speed);
        this.attacker.m_21561_(true);
    }

    public void m_8041_() {
        LivingEntity livingentity = this.attacker.m_5448_();
        if (!EntitySelector.f_20406_.test(livingentity)) {
            this.attacker.m_6710_(null);
        }
        this.attacker.m_21561_(false);
        this.attacker.m_21573_().m_26573_();
    }

    public void m_8037_() {
        LivingEntity target = this.attacker.m_5448_();
        if (target != null) {
            this.attacker.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            double distance = this.attacker.m_262793_(target);
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            if (this.ticksUntilNextAttack == 0 && this.attacker.m_142593_(target) >= distance) {
                this.ticksUntilNextAttack = this.getAttackInterval();
                ((EEEABMobLibrary)this.attacker).playAnimation(this.getAnimationByRandom());
            }
        }
    }

    protected int getAttackInterval() {
        return this.m_183277_(this.attackInterval);
    }

    private Animation getAnimationByRandom() {
        if (this.animations == null || this.animations.length == 0) {
            return ((EEEABMobLibrary)this.attacker).getNoAnimation();
        }
        return this.animations[this.attacker.m_217043_().m_188503_(this.animations.length)].get();
    }
}

