/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createsifter.compat.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.random.Percentaged;
import com.blamejared.createtweaker.recipe.manager.base.IProcessingRecipeManager;
import com.oierbravo.createsifter.ModRecipeTypes;
import com.oierbravo.createsifter.content.contraptions.components.sifter.SiftingRecipe;
import com.oierbravo.createsifter.content.contraptions.components.sifter.SiftingRecipeSerializer;
import com.oierbravo.createsifter.foundation.data.recipe.SiftingRecipeBuilder;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.createsifter.SiftingManager")
public class SiftingRecipeManager
implements IProcessingRecipeManager<SiftingRecipe> {
    public SiftingRecipeSerializer getSifterSerializer() {
        return (SiftingRecipeSerializer)ModRecipeTypes.SIFTING.getSerializer();
    }

    @ZenCodeType.Method
    public void addRecipe(String name, Percentaged<IItemStack>[] outputs, IIngredient[] itemInputs, @ZenCodeType.OptionalInt(value=100) int duration, @ZenCodeType.OptionalBoolean(value=false) boolean waterlogged, @ZenCodeType.OptionalInt(value=1) int minimumSpeed) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", name);
        SiftingRecipeBuilder builder = new SiftingRecipeBuilder(this.getSifterSerializer().getFactory(), resourceLocation);
        builder.withItemOutputs((ProcessingOutput[])Arrays.stream(outputs).map(mcWeightedItemStack -> new ProcessingOutput(((IItemStack)mcWeightedItemStack.getData()).getInternal(), (float)mcWeightedItemStack.getPercentage())).toArray(ProcessingOutput[]::new));
        ArrayList ingredients = new ArrayList();
        Arrays.stream(itemInputs).forEach(iIngredient -> ingredients.add(iIngredient.asVanillaIngredient()));
        builder.withItemIngredients(ingredients.toArray(new Ingredient[0]));
        builder.duration(duration);
        builder.waterlogged(waterlogged);
        builder.minimumSpeed(minimumSpeed);
        SiftingRecipe recipe = builder.build();
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (Recipe)recipe));
    }

    public AllRecipeTypes getCreateRecipeType() {
        return null;
    }

    public RecipeType<SiftingRecipe> getRecipeType() {
        return ModRecipeTypes.SIFTING.getType();
    }
}

