/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.data;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithLootingCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import trapcraft.TrapcraftBlocks;
import trapcraft.TrapcraftEntityTypes;

public class TrapcraftLootTableProvider
extends LootTableProvider {
    public TrapcraftLootTableProvider(PackOutput packOutput) {
        super(packOutput, BuiltInLootTables.m_78766_(), List.of(new LootTableProvider.SubProviderEntry(Blocks::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(Entities::new, LootContextParamSets.f_81415_)));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationTracker) {
    }

    private static class Entities
    extends EntityLootSubProvider {
        protected Entities() {
            super(FeatureFlags.f_244280_.m_247355_());
        }

        public void m_246942_() {
            this.m_245309_((EntityType)TrapcraftEntityTypes.DUMMY.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42748_)).m_79080_(LootItemRandomChanceWithLootingCondition.m_81963_((float)0.5f, (float)0.0625f))));
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return TrapcraftEntityTypes.ENTITIES.getEntries().stream().map(Supplier::get);
        }
    }

    private static class Blocks
    extends BlockLootSubProvider {
        protected Blocks() {
            super(Collections.emptySet(), FeatureFlags.f_244280_.m_247355_());
        }

        protected void m_245660_() {
            this.dropsSelf((Supplier<? extends Block>)TrapcraftBlocks.FAN);
            this.dropsSelf((Supplier<? extends Block>)TrapcraftBlocks.MAGNETIC_CHEST);
            this.dropsSelf((Supplier<? extends Block>)TrapcraftBlocks.BEAR_TRAP);
            this.dropsSelf((Supplier<? extends Block>)TrapcraftBlocks.SPIKES);
            this.dropsSelf((Supplier<? extends Block>)TrapcraftBlocks.IGNITER);
            this.droppingWithSilkTouchOrItemInRange((Supplier<? extends Block>)TrapcraftBlocks.GRASS_COVERING, (Supplier<? extends ItemLike>)((Supplier<ItemLike>)() -> Items.f_42398_), (NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f));
        }

        private void dropsSelf(Supplier<? extends Block> block) {
            this.m_245724_(block.get());
        }

        private void droppingWithSilkTouchOrItemInRange(Supplier<? extends Block> block, Supplier<? extends ItemLike> dropItem, NumberProvider range) {
            this.m_246481_(block.get(), b -> this.m_245142_((Block)b, (ItemLike)dropItem.get(), range));
        }

        protected Iterable<Block> getKnownBlocks() {
            return TrapcraftBlocks.BLOCKS.getEntries().stream().map(Supplier::get).collect(Collectors.toList());
        }
    }
}

