/*
 * Decompiled with CFR 0.152.
 */
package trapcraft.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHandler {
    public static ServerConfig SERVER;
    private static ForgeConfigSpec CONFIG_SERVER_SPEC;

    public static void init(IEventBus eventBus) {
        Pair commonPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        CONFIG_SERVER_SPEC = (ForgeConfigSpec)commonPair.getRight();
        SERVER = (ServerConfig)commonPair.getLeft();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)CONFIG_SERVER_SPEC);
    }

    public static class ServerConfig {
        public ForgeConfigSpec.IntValue FAN_RANGE;
        public ForgeConfigSpec.DoubleValue FAN_ACCELERATION;
        public ForgeConfigSpec.DoubleValue FAN_MAX_SPEED;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            this.FAN_RANGE = builder.comment("The distance at which entities are pushed by the fan.").translation("trapcraft.config.fan_range").defineInRange("fan_range", 5, 0, 64);
            this.FAN_ACCELERATION = builder.comment("The rate at which velocity is added to entities.").translation("trapcraft.config.fan_acceleration").defineInRange("fan_acceleration", 0.05, 0.01, 1.0);
            this.FAN_MAX_SPEED = builder.comment("The max velocity entities can be given by a fan.").translation("trapcraft.config.fan_max_speed").defineInRange("fan_max_speed", 0.3, 0.01, 1.0);
        }
    }
}

