/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.slasharts;

import java.util.function.Function;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.SlashArtsRegistry;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;

public class SlashArts {
    public static final ResourceKey<Registry<SlashArts>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)SlashBlade.prefix("slash_arts"));
    public static final int ChargeTicks = 9;
    public static final int ChargeJustTicks = 3;
    public static final int ChargeJustTicksMax = 5;
    private Function<LivingEntity, ResourceLocation> comboState;
    private Function<LivingEntity, ResourceLocation> comboStateJust;
    private Function<LivingEntity, ResourceLocation> comboStateSuper;
    private String descriptionId;

    public static ResourceLocation getRegistryKey(SlashArts state) {
        return SlashArtsRegistry.REGISTRY.get().getKey((Object)state);
    }

    public static int getJustReceptionSpan(LivingEntity user) {
        return Math.min(5, 3 + EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44976_, (LivingEntity)user));
    }

    public ResourceLocation doArts(ArtsType type, LivingEntity user) {
        switch (type) {
            case Jackpot: {
                return this.getComboStateJust(user);
            }
            case Success: {
                return this.getComboState(user);
            }
            case Super: {
                return this.getComboStateSuper().apply(user);
            }
        }
        return ComboStateRegistry.NONE.getId();
    }

    public SlashArts(Function<LivingEntity, ResourceLocation> state) {
        this.comboState = state;
        this.comboStateJust = state;
        this.setComboStateSuper(entity -> ComboStateRegistry.JUDGEMENT_CUT_END.getId());
    }

    public ResourceLocation getComboState(LivingEntity user) {
        return this.comboState.apply(user);
    }

    public ResourceLocation getComboStateJust(LivingEntity user) {
        return this.comboStateJust.apply(user);
    }

    public SlashArts setComboStateJust(Function<LivingEntity, ResourceLocation> state) {
        this.comboStateJust = state;
        return this;
    }

    public Function<LivingEntity, ResourceLocation> getComboStateSuper() {
        return this.comboStateSuper;
    }

    public SlashArts setComboStateSuper(Function<LivingEntity, ResourceLocation> comboStateSuper) {
        this.comboStateSuper = comboStateSuper;
        return this;
    }

    public Component getDescription() {
        return Component.m_237115_((String)this.getDescriptionId());
    }

    public String toString() {
        return SlashArtsRegistry.REGISTRY.get().getKey((Object)this).toString();
    }

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.m_137492_((String)"slash_art", (ResourceLocation)SlashArtsRegistry.REGISTRY.get().getKey((Object)this));
        }
        return this.descriptionId;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public static enum ArtsType {
        Fail,
        Success,
        Jackpot,
        Super;

    }
}

