/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.registry.slashblade;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.slashblade.EnchantmentDefinition;
import mods.flammpfeil.slashblade.registry.slashblade.PropertiesDefinition;
import mods.flammpfeil.slashblade.registry.slashblade.RenderDefinition;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class SlashBladeDefinition {
    public static final Codec<SlashBladeDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("name").forGetter(SlashBladeDefinition::getName), (App)RenderDefinition.CODEC.fieldOf("render").forGetter(SlashBladeDefinition::getRenderDefinition), (App)PropertiesDefinition.CODEC.fieldOf("properties").forGetter(SlashBladeDefinition::getStateDefinition), (App)EnchantmentDefinition.CODEC.listOf().optionalFieldOf("enchantments", (Object)Lists.newArrayList()).forGetter(SlashBladeDefinition::getEnchantments)).apply((Applicative)instance, SlashBladeDefinition::new));
    public static final ResourceKey<Registry<SlashBladeDefinition>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)SlashBlade.prefix("named_blades"));
    private final ResourceLocation name;
    private final RenderDefinition renderDefinition;
    private final PropertiesDefinition stateDefinition;
    private final List<EnchantmentDefinition> enchantments;
    public static final BladeComparator COMPARATOR = new BladeComparator();

    public SlashBladeDefinition(ResourceLocation name, RenderDefinition renderDefinition, PropertiesDefinition stateDefinition, List<EnchantmentDefinition> enchantments) {
        this.name = name;
        this.renderDefinition = renderDefinition;
        this.stateDefinition = stateDefinition;
        this.enchantments = enchantments;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public String getTranslationKey() {
        return Util.m_137492_((String)"item", (ResourceLocation)this.getName());
    }

    public RenderDefinition getRenderDefinition() {
        return this.renderDefinition;
    }

    public PropertiesDefinition getStateDefinition() {
        return this.stateDefinition;
    }

    public List<EnchantmentDefinition> getEnchantments() {
        return this.enchantments;
    }

    public ItemStack getBlade() {
        return this.getBlade(SBItems.slashblade);
    }

    public ItemStack getBlade(Item bladeItem) {
        ItemStack result = new ItemStack((ItemLike)bladeItem);
        result.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
            state.setBaseAttackModifier(this.stateDefinition.getBaseAttackModifier());
            state.setMaxDamage(this.stateDefinition.getMaxDamage());
            state.setComboRoot(this.stateDefinition.getComboRoot());
            state.setSlashArtsKey(this.stateDefinition.getSpecialAttackType());
            this.stateDefinition.getSpecialEffects().forEach(state::addSpecialEffect);
            this.stateDefinition.getDefaultType().forEach(type -> {
                switch (type) {
                    case BEWITCHED: {
                        state.setDefaultBewitched(true);
                        break;
                    }
                    case BROKEN: {
                        result.m_41721_(result.m_41776_() - 1);
                        state.setBroken(true);
                        break;
                    }
                    case SEALED: {
                        state.setSealed(true);
                        break;
                    }
                }
            });
            state.setModel(this.renderDefinition.getModelName());
            state.setTexture(this.renderDefinition.getTextureName());
            state.setColorCode(this.renderDefinition.getSummonedSwordColor());
            state.setEffectColorInverse(this.renderDefinition.isSummonedSwordColorInverse());
            state.setCarryType(this.renderDefinition.getStandbyRenderType());
            if (!this.getName().equals((Object)SlashBlade.prefix("none"))) {
                state.setTranslationKey(this.getTranslationKey());
            }
            result.m_41784_().m_128365_("bladeState", (Tag)state.serializeNBT());
        });
        for (EnchantmentDefinition instance : this.enchantments) {
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(instance.getEnchantmentID());
            result.m_41663_(enchantment, instance.getEnchantmentLevel());
        }
        return result;
    }

    private static class BladeComparator
    implements Comparator<Map.Entry<ResourceKey<SlashBladeDefinition>, SlashBladeDefinition>> {
        private BladeComparator() {
        }

        @Override
        public int compare(Map.Entry<ResourceKey<SlashBladeDefinition>, SlashBladeDefinition> left, Map.Entry<ResourceKey<SlashBladeDefinition>, SlashBladeDefinition> right) {
            if (left.getKey().m_135782_().m_135827_().equalsIgnoreCase("slashblade")) {
                return -1;
            }
            if (right.getKey().m_135782_().m_135827_().equalsIgnoreCase("slashblade")) {
                return 1;
            }
            String leftName = left.getKey().m_135782_().toString();
            String rightName = right.getKey().m_135782_().toString();
            return leftName.compareToIgnoreCase(rightName);
        }
    }
}

