/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.registry.slashblade;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mods.flammpfeil.slashblade.client.renderer.CarryType;
import mods.flammpfeil.slashblade.init.DefaultResources;
import net.minecraft.resources.ResourceLocation;

public class RenderDefinition {
    public static final Codec<RenderDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.optionalFieldOf("texture", (Object)DefaultResources.resourceDefaultTexture).forGetter(RenderDefinition::getTextureName), (App)ResourceLocation.f_135803_.optionalFieldOf("model", (Object)DefaultResources.resourceDefaultModel).forGetter(RenderDefinition::getModelName), (App)Codec.INT.optionalFieldOf("summon_sword_color", (Object)-13421569).forGetter(RenderDefinition::getSummonedSwordColor), (App)Codec.BOOL.optionalFieldOf("color_inverse", (Object)false).forGetter(RenderDefinition::isSummonedSwordColorInverse), (App)CarryType.CODEC.optionalFieldOf("carry_type", (Object)CarryType.DEFAULT).forGetter(RenderDefinition::getStandbyRenderType)).apply((Applicative)instance, RenderDefinition::new));
    private final ResourceLocation TextureName;
    private final ResourceLocation ModelName;
    private final int SummonedSwordColor;
    private final boolean SummonedSwordColorInverse;
    private final CarryType StandbyRenderType;

    private RenderDefinition(ResourceLocation texture, ResourceLocation model, int color, boolean colorInverse, CarryType standby) {
        this.TextureName = texture;
        this.ModelName = model;
        this.SummonedSwordColor = color;
        this.SummonedSwordColorInverse = colorInverse;
        this.StandbyRenderType = standby;
    }

    public ResourceLocation getModelName() {
        return this.ModelName;
    }

    public ResourceLocation getTextureName() {
        return this.TextureName;
    }

    public boolean isSummonedSwordColorInverse() {
        return this.SummonedSwordColorInverse;
    }

    public int getSummonedSwordColor() {
        return this.SummonedSwordColor;
    }

    public CarryType getStandbyRenderType() {
        return this.StandbyRenderType;
    }

    public static class Builder {
        private ResourceLocation TextureName = DefaultResources.resourceDefaultTexture;
        private ResourceLocation ModelName = DefaultResources.resourceDefaultModel;
        private int SummonedSwordColor = -13421569;
        private boolean SummonedSwordColorInverse = false;
        private CarryType StandbyRenderType = CarryType.DEFAULT;

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder textureName(ResourceLocation TextureName) {
            this.TextureName = TextureName;
            return this;
        }

        public Builder modelName(ResourceLocation ModelName) {
            this.ModelName = ModelName;
            return this;
        }

        public Builder effectColor(int SummonedSwordColor) {
            this.SummonedSwordColor = SummonedSwordColor;
            return this;
        }

        public Builder effectColorInverse(boolean SummonedSwordColorInverse) {
            this.SummonedSwordColorInverse = SummonedSwordColorInverse;
            return this;
        }

        public Builder standbyRenderType(CarryType standbyRenderType) {
            this.StandbyRenderType = standbyRenderType;
            return this;
        }

        public RenderDefinition build() {
            return new RenderDefinition(this.TextureName, this.ModelName, this.SummonedSwordColor, this.SummonedSwordColorInverse, this.StandbyRenderType);
        }
    }
}

