/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.recipe;

import java.util.Iterator;
import java.util.Map;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.recipe.SlashBladeShapedRecipeSerializer;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class SlashBladeShapedRecipe
extends ShapedRecipe {
    public static final RecipeSerializer<SlashBladeShapedRecipe> SERIALIZER = new SlashBladeShapedRecipeSerializer<ShapedRecipe, SlashBladeShapedRecipe>(RecipeSerializer.f_44076_, SlashBladeShapedRecipe::new);
    private final ResourceLocation outputBlade;

    public SlashBladeShapedRecipe(ShapedRecipe compose, ResourceLocation outputBlade) {
        super(compose.m_6423_(), compose.m_6076_(), compose.m_245232_(), compose.m_44220_(), compose.m_44221_(), compose.m_7527_(), SlashBladeShapedRecipe.getResultBlade(outputBlade));
        this.outputBlade = outputBlade;
    }

    private static ItemStack getResultBlade(ResourceLocation outputBlade) {
        Item bladeItem = ForgeRegistries.ITEMS.containsKey(outputBlade) ? (Item)ForgeRegistries.ITEMS.getValue(outputBlade) : SBItems.slashblade;
        return bladeItem.m_7968_();
    }

    public ResourceLocation getOutputBlade() {
        return this.outputBlade;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        ItemStack result = SlashBladeShapedRecipe.getResultBlade(this.getOutputBlade());
        if (!ForgeRegistries.ITEMS.getKey((Object)result.m_41720_()).equals((Object)this.getOutputBlade())) {
            result = ((SlashBladeDefinition)SlashBlade.getSlashBladeDefinitionRegistry(access).m_7745_(this.getOutputBlade())).getBlade(result.m_41720_());
        }
        return result;
    }

    public ItemStack m_5874_(CraftingContainer container, RegistryAccess access) {
        ItemStack result = this.m_8043_(access);
        if (!(result.m_41720_() instanceof ItemSlashBlade)) {
            result = new ItemStack((ItemLike)SBItems.slashblade);
        }
        ISlashBladeState resultState = (ISlashBladeState)result.getCapability(ItemSlashBlade.BLADESTATE).orElseThrow(NullPointerException::new);
        for (ItemStack stack : container.m_280657_()) {
            if (!(stack.m_41720_() instanceof ItemSlashBlade)) continue;
            ISlashBladeState ingredientState = (ISlashBladeState)stack.getCapability(ItemSlashBlade.BLADESTATE).orElseThrow(NullPointerException::new);
            resultState.setProudSoulCount(resultState.getProudSoulCount() + ingredientState.getProudSoulCount());
            resultState.setKillCount(resultState.getKillCount() + ingredientState.getKillCount());
            resultState.setRefine(resultState.getRefine() + ingredientState.getRefine());
            this.updateEnchantment(result, stack);
        }
        return result;
    }

    private void updateEnchantment(ItemStack result, ItemStack ingredient) {
        Map newItemEnchants = result.getAllEnchantments();
        Map oldItemEnchants = ingredient.getAllEnchantments();
        Iterator iterator = oldItemEnchants.keySet().iterator();
        while (iterator.hasNext()) {
            Enchantment enchantIndex;
            Enchantment enchantment = enchantIndex = (Enchantment)iterator.next();
            int destLevel = newItemEnchants.containsKey(enchantIndex) ? (Integer)newItemEnchants.get(enchantIndex) : 0;
            int srcLevel = (Integer)oldItemEnchants.get(enchantIndex);
            srcLevel = Math.max(srcLevel, destLevel);
            srcLevel = Math.min(srcLevel, enchantment.m_6586_());
            boolean canApplyFlag = enchantment.canApplyAtEnchantingTable(result);
            if (!canApplyFlag) continue;
            for (Enchantment curEnchantIndex : newItemEnchants.keySet()) {
                if (curEnchantIndex == enchantIndex || enchantment.m_44695_(curEnchantIndex)) continue;
                canApplyFlag = false;
                break;
            }
            if (!canApplyFlag) continue;
            newItemEnchants.put(enchantIndex, srcLevel);
        }
        EnchantmentHelper.m_44865_((Map)newItemEnchants, (ItemStack)result);
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

