/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.recipe;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.item.SwordType;
import mods.flammpfeil.slashblade.registry.slashblade.EnchantmentDefinition;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;

public class RequestDefinition {
    public static final Codec<RequestDefinition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.optionalFieldOf("name", (Object)SlashBlade.prefix("none")).forGetter(RequestDefinition::getName), (App)Codec.INT.optionalFieldOf("proud_soul", (Object)0).forGetter(RequestDefinition::getProudSoulCount), (App)Codec.INT.optionalFieldOf("kill", (Object)0).forGetter(RequestDefinition::getKillCount), (App)Codec.INT.optionalFieldOf("refine", (Object)0).forGetter(RequestDefinition::getRefineCount), (App)EnchantmentDefinition.CODEC.listOf().optionalFieldOf("enchantments", (Object)Lists.newArrayList()).forGetter(RequestDefinition::getEnchantments), (App)SwordType.CODEC.listOf().optionalFieldOf("sword_type", (Object)Lists.newArrayList()).forGetter(RequestDefinition::getDefaultType)).apply((Applicative)instance, RequestDefinition::new));
    private final ResourceLocation name;
    private final int proudSoulCount;
    private final int killCount;
    private final int refineCount;
    private final List<EnchantmentDefinition> enchantments;
    private final List<SwordType> defaultType;

    public RequestDefinition(ResourceLocation name, int proud, int kill, int refine, List<EnchantmentDefinition> enchantments, List<SwordType> defaultType) {
        this.name = name;
        this.proudSoulCount = proud;
        this.killCount = kill;
        this.refineCount = refine;
        this.enchantments = enchantments;
        this.defaultType = defaultType;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public int getProudSoulCount() {
        return this.proudSoulCount;
    }

    public int getKillCount() {
        return this.killCount;
    }

    public int getRefineCount() {
        return this.refineCount;
    }

    public List<EnchantmentDefinition> getEnchantments() {
        return this.enchantments;
    }

    public List<SwordType> getDefaultType() {
        return this.defaultType;
    }

    public static RequestDefinition fromJSON(JsonObject json) {
        return CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).resultOrPartial(msg -> SlashBlade.LOGGER.error("Failed to parse : {}", msg)).orElseGet(Builder.newInstance()::build);
    }

    public JsonElement toJson() {
        return (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).resultOrPartial(msg -> SlashBlade.LOGGER.error("Failed to encode : {}", msg)).orElseThrow();
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.getName());
        buffer.writeInt(this.getProudSoulCount());
        buffer.writeInt(this.getKillCount());
        buffer.writeInt(this.getRefineCount());
        buffer.m_236828_(this.getEnchantments(), (buf, request) -> {
            buf.m_130085_(request.getEnchantmentID());
            buf.writeByte(request.getEnchantmentLevel());
        });
        buffer.m_236828_(this.getDefaultType(), (buf, request) -> buf.m_130070_(request.name().toLowerCase()));
    }

    public static RequestDefinition fromNetwork(FriendlyByteBuf buffer) {
        ResourceLocation name = buffer.m_130281_();
        int proud = buffer.readInt();
        int kill = buffer.readInt();
        int refine = buffer.readInt();
        List enchantments = buffer.m_236845_(buf -> new EnchantmentDefinition(buf.m_130281_(), buf.readByte()));
        List types = buffer.m_236845_(buf -> SwordType.valueOf(buf.m_130277_().toUpperCase()));
        return new RequestDefinition(name, proud, kill, refine, enchantments, types);
    }

    public void initItemStack(ItemStack blade) {
        blade.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
            if (!this.name.equals((Object)SlashBlade.prefix("none"))) {
                state.setTranslationKey(this.getTranslationKey());
            }
            state.setProudSoulCount(this.getProudSoulCount());
            state.setKillCount(this.getKillCount());
            state.setRefine(this.getRefineCount());
            this.getEnchantments().forEach(enchantment -> blade.m_41663_((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(enchantment.getEnchantmentID()), enchantment.getEnchantmentLevel()));
            this.defaultType.forEach(type -> {
                switch (type) {
                    case BEWITCHED: {
                        state.setDefaultBewitched(true);
                        break;
                    }
                    case BROKEN: {
                        blade.m_41721_(blade.m_41776_() - 1);
                        state.setBroken(true);
                        break;
                    }
                    case SEALED: {
                        state.setSealed(true);
                        break;
                    }
                }
            });
        });
    }

    public boolean test(ItemStack blade) {
        if (blade == null || blade.m_41619_()) {
            return false;
        }
        if (!blade.getCapability(ItemSlashBlade.BLADESTATE).isPresent()) {
            return false;
        }
        ISlashBladeState state = (ISlashBladeState)blade.getCapability(ItemSlashBlade.BLADESTATE).orElseThrow(NullPointerException::new);
        boolean nameCheck = this.name.equals((Object)SlashBlade.prefix("none")) ? state.getTranslationKey().isBlank() : state.getTranslationKey().equals(this.getTranslationKey());
        boolean proudCheck = state.getProudSoulCount() >= this.getProudSoulCount();
        boolean killCheck = state.getKillCount() >= this.getKillCount();
        boolean refineCheck = state.getRefine() >= this.getRefineCount();
        for (EnchantmentDefinition enchantment : this.getEnchantments()) {
            if (blade.getEnchantmentLevel((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(enchantment.getEnchantmentID())) >= enchantment.getEnchantmentLevel()) continue;
            return false;
        }
        boolean types = SwordType.from(blade).containsAll(this.getDefaultType());
        return nameCheck && proudCheck && killCheck && refineCheck && types;
    }

    public String getTranslationKey() {
        return Util.m_137492_((String)"item", (ResourceLocation)this.getName());
    }

    public static class Builder {
        private ResourceLocation name = SlashBlade.prefix("none");
        private int proudCount = 0;
        private int killCount = 0;
        private int refineCount = 0;
        private List<EnchantmentDefinition> enchantments = new ArrayList<EnchantmentDefinition>();
        private List<SwordType> defaultType = new ArrayList<SwordType>();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder name(ResourceLocation name) {
            this.name = name;
            return this;
        }

        public Builder proudSoul(int proudCount) {
            this.proudCount = proudCount;
            return this;
        }

        public Builder killCount(int killCount) {
            this.killCount = killCount;
            return this;
        }

        public Builder refineCount(int refineCount) {
            this.refineCount = refineCount;
            return this;
        }

        public Builder addEnchantment(EnchantmentDefinition ... enchantments) {
            for (EnchantmentDefinition enchantment : enchantments) {
                this.enchantments.add(enchantment);
            }
            return this;
        }

        public Builder addSwordType(SwordType ... types) {
            for (SwordType type : types) {
                this.defaultType.add(type);
            }
            return this;
        }

        public RequestDefinition build() {
            return new RequestDefinition(this.name, this.proudCount, this.killCount, this.refineCount, this.enchantments, this.defaultType);
        }
    }
}

