/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event.drop;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mods.flammpfeil.slashblade.SlashBlade;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class EntityDropEntry {
    public static final Codec<EntityDropEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("entity_type").forGetter(EntityDropEntry::getEntityType), (App)ResourceLocation.f_135803_.fieldOf("blade").forGetter(EntityDropEntry::getBladeName), (App)Codec.FLOAT.optionalFieldOf("drop_rate", (Object)Float.valueOf(1.0f)).forGetter(EntityDropEntry::getDropRate), (App)Codec.BOOL.optionalFieldOf("request_slashblade", (Object)false).forGetter(EntityDropEntry::isRequestSlashBladeKill), (App)Codec.BOOL.optionalFieldOf("drop_fixed", (Object)false).forGetter(EntityDropEntry::isDropFixedPoint), (App)Vec3.f_231074_.optionalFieldOf("drop_point", (Object)new Vec3(0.0, 0.0, 0.0)).forGetter(EntityDropEntry::getDropPoint)).apply((Applicative)instance, EntityDropEntry::new));
    public static final ResourceKey<Registry<EntityDropEntry>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)SlashBlade.prefix("entity_drop"));
    private final ResourceLocation entityType;
    private final ResourceLocation bladeName;
    private final float dropRate;
    private final boolean requestSlashBladeKill;
    private final boolean dropFixedPoint;
    private final Vec3 dropPoint;

    public EntityDropEntry(ResourceLocation entityType, ResourceLocation bladeName, float dropRate) {
        this(entityType, bladeName, dropRate, true, false, new Vec3(0.0, 0.0, 0.0));
    }

    public EntityDropEntry(ResourceLocation entityType, ResourceLocation bladeName, float dropRate, boolean request) {
        this(entityType, bladeName, dropRate, request, false, new Vec3(0.0, 0.0, 0.0));
    }

    public EntityDropEntry(ResourceLocation entityType, ResourceLocation bladeName, float dropRate, boolean request, boolean pointFixed, Vec3 point) {
        this.entityType = entityType;
        this.bladeName = bladeName;
        this.dropRate = dropRate;
        this.requestSlashBladeKill = request;
        this.dropFixedPoint = pointFixed;
        this.dropPoint = point;
    }

    public ResourceLocation getBladeName() {
        return this.bladeName;
    }

    public ResourceLocation getEntityType() {
        return this.entityType;
    }

    public float getDropRate() {
        return this.dropRate;
    }

    public boolean isRequestSlashBladeKill() {
        return this.requestSlashBladeKill;
    }

    public boolean isDropFixedPoint() {
        return this.dropFixedPoint;
    }

    public Vec3 getDropPoint() {
        return this.dropPoint;
    }
}

