/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event;

import mods.flammpfeil.slashblade.util.NBTHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class KnockBackHandler {
    static final String NBT_KEY = "knockback_factor";

    public static void setCancel(LivingEntity target) {
        KnockBackHandler.setFactor(target, 0.0, 0.0, 0.0);
    }

    public static void setSmash(LivingEntity target, double horizontalFactor) {
        KnockBackHandler.setFactor(target, horizontalFactor, 0.0, 0.0);
    }

    public static void setVertical(LivingEntity target, double verticalFactor) {
        KnockBackHandler.setFactor(target, 0.0, verticalFactor, -verticalFactor);
    }

    public static void setFactor(LivingEntity target, double horizontalFactor, double verticalFactor, double addFallDistance) {
        NBTHelper.putVector3d(target.getPersistentData(), NBT_KEY, new Vec3(horizontalFactor, verticalFactor, addFallDistance));
    }

    @SubscribeEvent
    public static void onLivingKnockBack(LivingKnockBackEvent event) {
        LivingEntity target = event.getEntity();
        CompoundTag nbt = target.getPersistentData();
        if (!nbt.m_128441_(NBT_KEY)) {
            return;
        }
        Vec3 factor = NBTHelper.getVector3d(nbt, NBT_KEY);
        nbt.m_128473_(NBT_KEY);
        if (target.f_19789_ < 0.0f) {
            target.f_19789_ = 0.0f;
        }
        target.f_19789_ = (float)((double)target.f_19789_ + factor.f_82481_);
        if (target.m_217043_().m_188500_() < target.m_21051_(Attributes.f_22278_).m_22135_()) {
            return;
        }
        target.f_19812_ = true;
        Vec3 motion = target.m_20184_();
        if (factor.f_82479_ == 0.0) {
            event.setCanceled(true);
            motion = motion.m_82542_(0.0, 1.0, 0.0);
        } else {
            event.setStrength((float)((double)event.getStrength() * factor.f_82479_));
        }
        if (0.0 < factor.f_82480_) {
            target.m_6853_(false);
            event.getEntity().m_20334_(motion.f_82479_, Math.max(motion.f_82480_, factor.f_82480_), motion.f_82481_);
        } else if (factor.f_82480_ < 0.0) {
            event.getEntity().m_20334_(motion.f_82479_, Math.min(motion.f_82480_, factor.f_82480_), motion.f_82481_);
        }
    }
}

