/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import com.google.common.collect.Lists;
import com.mojang.math.Axis;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import mods.flammpfeil.slashblade.entity.IShootable;
import mods.flammpfeil.slashblade.entity.Projectile;
import mods.flammpfeil.slashblade.event.FallHandler;
import mods.flammpfeil.slashblade.util.AttackManager;
import mods.flammpfeil.slashblade.util.EnumSetConverter;
import mods.flammpfeil.slashblade.util.KnockBacks;
import mods.flammpfeil.slashblade.util.NBTHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import org.joml.Vector4f;

public class EntitySlashEffect
extends Projectile
implements IShootable {
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(EntitySlashEffect.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FLAGS = SynchedEntityData.m_135353_(EntitySlashEffect.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> RANK = SynchedEntityData.m_135353_(EntitySlashEffect.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ROTATION_OFFSET = SynchedEntityData.m_135353_(EntitySlashEffect.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ROTATION_ROLL = SynchedEntityData.m_135353_(EntitySlashEffect.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> BASESIZE = SynchedEntityData.m_135353_(EntitySlashEffect.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private int lifetime = 10;
    private KnockBacks action = KnockBacks.cancel;
    private double damage = 1.0;
    private boolean cycleHit = false;
    private List<Entity> alreadyHits = Lists.newArrayList();
    private SoundEvent livingEntitySound = SoundEvents.f_12557_;
    EnumSet<FlagsState> flags = EnumSet.noneOf(FlagsState.class);
    int intFlags = 0;

    public KnockBacks getKnockBack() {
        return this.action;
    }

    public void setKnockBack(KnockBacks action) {
        this.action = action;
    }

    public void setKnockBackOrdinal(int ordinal) {
        this.action = 0 <= ordinal && ordinal < KnockBacks.values().length ? KnockBacks.values()[ordinal] : KnockBacks.cancel;
    }

    public boolean doCycleHit() {
        return this.cycleHit;
    }

    public void setCycleHit(boolean cycleHit) {
        this.cycleHit = cycleHit;
    }

    protected SoundEvent getHitEntitySound() {
        return this.livingEntitySound;
    }

    public EntitySlashEffect(EntityType<? extends Projectile> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.m_20242_(true);
    }

    public static EntitySlashEffect createInstance(PlayMessages.SpawnEntity packet, Level worldIn) {
        return new EntitySlashEffect((EntityType<? extends Projectile>)SlashBlade.RegistryEvents.SlashEffect, worldIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COLOR, (Object)0x3333FF);
        this.f_19804_.m_135372_(FLAGS, (Object)0);
        this.f_19804_.m_135372_(RANK, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROTATION_OFFSET, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROTATION_ROLL, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(BASESIZE, (Object)Float.valueOf(1.0f));
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        NBTHelper.getNBTCoupler(compound).put("RotationOffset", Float.valueOf(this.getRotationOffset())).put("RotationRoll", Float.valueOf(this.getRotationRoll())).put("BaseSize", Float.valueOf(this.getBaseSize())).put("Color", this.getColor()).put("Rank", Float.valueOf(this.getRank())).put("damage", this.damage).put("crit", this.getIsCritical()).put("clip", this.isNoClip()).put("Lifetime", this.getLifetime()).put("Knockback", this.getKnockBack().ordinal());
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        NBTHelper.getNBTCoupler(compound).get("RotationOffset", this::setRotationOffset, new Float[0]).get("RotationRoll", this::setRotationRoll, new Float[0]).get("BaseSize", this::setBaseSize, new Float[0]).get("Color", this::setColor, new Integer[0]).get("Rank", this::setRank, new Float[0]).get("damage", v -> {
            this.damage = v;
        }, this.damage).get("crit", this::setIsCritical, new Boolean[0]).get("clip", this::setNoClip, new Boolean[0]).get("Lifetime", this::setLifetime, new Integer[0]).get("Knockback", this::setKnockBackOrdinal, new Integer[0]);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean isWave() {
        return false;
    }

    @Override
    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        if (!this.isWave()) {
            this.m_20334_(0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        double d0 = this.m_20191_().m_82309_() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntitySlashEffect.m_20150_()) * d0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.m_6034_(x, y, z);
        this.m_19915_(yaw, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6001_(double x, double y, double z) {
        this.m_20334_(0.0, 0.0, 0.0);
    }

    private void setFlags(FlagsState value) {
        this.flags.add(value);
        this.refreshFlags();
    }

    private void removeFlags(FlagsState value) {
        this.flags.remove((Object)value);
        this.refreshFlags();
    }

    private void refreshFlags() {
        if (this.m_9236_().m_5776_()) {
            int newValue = (Integer)this.f_19804_.m_135370_(FLAGS);
            if (this.intFlags != newValue) {
                this.intFlags = newValue;
                this.flags = EnumSetConverter.convertToEnumSet(FlagsState.class, this.intFlags);
            }
        } else {
            int newValue = EnumSetConverter.convertToInt(this.flags);
            if (this.intFlags != newValue) {
                this.f_19804_.m_135381_(FLAGS, (Object)newValue);
                this.intFlags = newValue;
            }
        }
    }

    public void setIndirect(boolean value) {
        if (value) {
            this.setFlags(FlagsState.Indirect);
        } else {
            this.removeFlags(FlagsState.Indirect);
        }
    }

    public boolean getIndirect() {
        this.refreshFlags();
        return this.flags.contains((Object)FlagsState.Indirect);
    }

    public void setMute(boolean value) {
        if (value) {
            this.setFlags(FlagsState.Mute);
        } else {
            this.removeFlags(FlagsState.Mute);
        }
    }

    public boolean getMute() {
        this.refreshFlags();
        return this.flags.contains((Object)FlagsState.Mute);
    }

    public void setIsCritical(boolean value) {
        if (value) {
            this.setFlags(FlagsState.Critical);
        } else {
            this.removeFlags(FlagsState.Critical);
        }
    }

    public boolean getIsCritical() {
        this.refreshFlags();
        return this.flags.contains((Object)FlagsState.Critical);
    }

    public void setNoClip(boolean value) {
        this.f_19794_ = value;
        if (value) {
            this.setFlags(FlagsState.NoClip);
        } else {
            this.removeFlags(FlagsState.NoClip);
        }
    }

    public boolean isNoClip() {
        if (!this.m_9236_().f_46443_) {
            return this.f_19794_;
        }
        this.refreshFlags();
        return this.flags.contains((Object)FlagsState.NoClip);
    }

    public SoundEvent getSlashSound() {
        return SoundEvents.f_12520_;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ == 2) {
            if (!this.getMute()) {
                this.m_5496_(this.getSlashSound(), 0.8f, 0.625f + 0.1f * this.f_19796_.m_188501_());
            } else {
                this.m_5496_(SoundEvents.f_12317_, 0.5f, 0.4f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
            }
            if (this.getIsCritical()) {
                this.m_5496_(this.getHitEntitySound(), 0.2f, 0.4f + 0.25f * this.f_19796_.m_188501_());
            }
        }
        if (this.f_19797_ % 2 == 0 || this.f_19797_ < 5) {
            Vec3 start = this.m_20182_();
            Vector4f normal = new Vector4f(1.0f, 0.0f, 0.0f, 1.0f);
            Vector4f dir = new Vector4f(0.0f, 0.0f, 1.0f, 1.0f);
            float progress = (float)this.f_19797_ / (float)this.lifetime;
            Axis.f_252436_.m_252977_(60.0f + this.getRotationOffset() - 200.0f * progress).transform(normal);
            Axis.f_252403_.m_252977_(this.getRotationRoll()).transform(normal);
            Axis.f_252529_.m_252977_(this.m_146909_()).transform(normal);
            Axis.f_252436_.m_252977_(-this.m_146908_()).transform(normal);
            Axis.f_252436_.m_252977_(60.0f + this.getRotationOffset() - 200.0f * progress).transform(dir);
            Axis.f_252403_.m_252977_(this.getRotationRoll()).transform(dir);
            Axis.f_252529_.m_252977_(this.m_146909_()).transform(dir);
            Axis.f_252436_.m_252977_(-this.m_146908_()).transform(dir);
            Vec3 normal3d = new Vec3((double)normal.x(), (double)normal.y(), (double)normal.z());
            BlockHitResult rayResult = this.m_20193_().m_45547_(new ClipContext(start.m_82549_(normal3d.m_82490_(1.5)), start.m_82549_(normal3d.m_82490_(3.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, null));
            if (this.getShooter() != null && !this.getShooter().m_20070_() && rayResult.m_6662_() == HitResult.Type.BLOCK) {
                FallHandler.spawnLandingParticle((Entity)this, rayResult.m_82450_(), normal3d, 3.0f);
            }
            if (IConcentrationRank.ConcentrationRanks.S.level < this.getRankCode().level) {
                Vec3 vec3 = start.m_82549_(normal3d.m_82490_((double)this.getBaseSize() * 2.5));
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), (double)(dir.x() + normal.x()), (double)(dir.y() + normal.y()), (double)(dir.z() + normal.z()));
                float randScale = this.f_19796_.m_188501_() * 1.0f + 0.5f;
                vec3 = vec3.m_82520_((double)(dir.x() * randScale), (double)(dir.y() * randScale), (double)(dir.z() * randScale));
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), (double)(dir.x() + normal.x()), (double)(dir.y() + normal.y()), (double)(dir.z() + normal.z()));
            }
        }
        if (this.getShooter() != null && this.f_19797_ % 2 == 0) {
            List<Entity> hits;
            boolean forceHit = true;
            if (!this.getIndirect() && this.getShooter() instanceof LivingEntity) {
                LivingEntity shooter = (LivingEntity)this.getShooter();
                float ratio = (float)this.damage * (this.getIsCritical() ? 1.1f : 1.0f);
                hits = AttackManager.areaAttack(shooter, this.action.action, ratio, forceHit, false, true, this.alreadyHits);
            } else {
                hits = AttackManager.areaAttack(this, this.action.action, 4.0, forceHit, false, this.alreadyHits);
            }
            if (!this.doCycleHit()) {
                this.alreadyHits.addAll(hits);
            }
        }
        this.tryDespawn();
    }

    public List<Entity> getAlreadyHits() {
        return this.alreadyHits;
    }

    protected void tryDespawn() {
        if (!this.m_9236_().m_5776_() && this.getLifetime() < this.f_19797_) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public int getColor() {
        return (Integer)this.m_20088_().m_135370_(COLOR);
    }

    public void setColor(int value) {
        this.m_20088_().m_135381_(COLOR, (Object)value);
    }

    public float getRank() {
        return ((Float)this.m_20088_().m_135370_(RANK)).floatValue();
    }

    public void setRank(float value) {
        this.m_20088_().m_135381_(RANK, (Object)Float.valueOf(value));
    }

    public IConcentrationRank.ConcentrationRanks getRankCode() {
        return IConcentrationRank.ConcentrationRanks.getRankFromLevel(this.getRank());
    }

    public int getLifetime() {
        return Math.min(this.lifetime, 1000);
    }

    public void setLifetime(int value) {
        this.lifetime = value;
    }

    public float getRotationOffset() {
        return ((Float)this.m_20088_().m_135370_(ROTATION_OFFSET)).floatValue();
    }

    public void setRotationOffset(float value) {
        this.m_20088_().m_135381_(ROTATION_OFFSET, (Object)Float.valueOf(value));
    }

    public float getRotationRoll() {
        return ((Float)this.m_20088_().m_135370_(ROTATION_ROLL)).floatValue();
    }

    public void setRotationRoll(float value) {
        this.m_20088_().m_135381_(ROTATION_ROLL, (Object)Float.valueOf(value));
    }

    public float getBaseSize() {
        return ((Float)this.m_20088_().m_135370_(BASESIZE)).floatValue();
    }

    public void setBaseSize(float value) {
        this.m_20088_().m_135381_(BASESIZE, (Object)Float.valueOf(value));
    }

    @Override
    @Nullable
    public Entity getShooter() {
        return this.m_19749_();
    }

    @Override
    public void setShooter(Entity shooter) {
        this.m_5602_(shooter);
    }

    public List<MobEffectInstance> getPotionEffects() {
        List effects = PotionUtils.m_43566_((CompoundTag)this.getPersistentData());
        if (effects.isEmpty()) {
            effects.add(new MobEffectInstance(MobEffects.f_19614_, 1, 1));
        }
        return effects;
    }

    public void setDamage(double damageIn) {
        this.damage = damageIn;
    }

    @Override
    public double getDamage() {
        return this.damage;
    }

    @Nullable
    public EntityHitResult getRayTrace(Vec3 p_213866_1_, Vec3 p_213866_2_) {
        return ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)p_213866_1_, (Vec3)p_213866_2_, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), entity -> !entity.m_5833_() && entity.m_6084_() && entity.m_6087_() && entity != this.getShooter());
    }

    static enum FlagsState {
        Critical,
        NoClip,
        Mute,
        Indirect;

    }
}

