/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.ability.StunManager;
import mods.flammpfeil.slashblade.entity.IShootable;
import mods.flammpfeil.slashblade.entity.Projectile;
import mods.flammpfeil.slashblade.util.EnumSetConverter;
import mods.flammpfeil.slashblade.util.NBTHelper;
import mods.flammpfeil.slashblade.util.TargetSelector;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;

public class EntityAbstractSummonedSword
extends Projectile
implements IShootable {
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(EntityAbstractSummonedSword.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FLAGS = SynchedEntityData.m_135353_(EntityAbstractSummonedSword.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HIT_ENTITY_ID = SynchedEntityData.m_135353_(EntityAbstractSummonedSword.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> OFFSET_YAW = SynchedEntityData.m_135353_(EntityAbstractSummonedSword.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ROLL = SynchedEntityData.m_135353_(EntityAbstractSummonedSword.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Byte> PIERCE = SynchedEntityData.m_135353_(EntityAbstractSummonedSword.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<String> MODEL = SynchedEntityData.m_135353_(EntityAbstractSummonedSword.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> DELAY = SynchedEntityData.m_135353_(EntityAbstractSummonedSword.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int ticksInGround;
    private boolean inGround;
    private BlockState inBlockState;
    private int ticksInAir;
    private double damage = 1.0;
    private IntOpenHashSet alreadyHits;
    private Entity hitEntity = null;
    static final int ON_GROUND_LIFE_TIME = 100;
    private SoundEvent hitEntitySound = SoundEvents.f_12514_;
    private SoundEvent hitEntityPlayerSound = SoundEvents.f_12514_;
    private SoundEvent hitGroundSound = SoundEvents.f_12515_;
    protected EnumSet<FlagsState> flags = EnumSet.noneOf(FlagsState.class);
    protected int intFlags = 0;
    private static final String defaultModelName = "slashblade:model/util/ss";
    private static final ResourceLocation defaultModel = new ResourceLocation("slashblade:model/util/ss.obj");
    public LazyOptional<ResourceLocation> modelLoc = LazyOptional.of(() -> new ResourceLocation(this.getModelName() + ".obj"));
    private static final ResourceLocation defaultTexture = new ResourceLocation("slashblade:model/util/ss.png");
    public LazyOptional<ResourceLocation> textureLoc = LazyOptional.of(() -> new ResourceLocation(this.getModelName() + ".png"));

    protected SoundEvent getHitEntitySound() {
        return this.hitEntitySound;
    }

    protected SoundEvent getHitEntityPlayerSound() {
        return this.hitEntityPlayerSound;
    }

    protected SoundEvent getHitGroundSound() {
        return this.hitGroundSound;
    }

    public EntityAbstractSummonedSword(EntityType<? extends Projectile> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.m_20242_(true);
    }

    public static EntityAbstractSummonedSword createInstance(PlayMessages.SpawnEntity packet, Level worldIn) {
        return new EntityAbstractSummonedSword((EntityType<? extends Projectile>)SlashBlade.RegistryEvents.SummonedSword, worldIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COLOR, (Object)0x3333FF);
        this.f_19804_.m_135372_(FLAGS, (Object)0);
        this.f_19804_.m_135372_(HIT_ENTITY_ID, (Object)-1);
        this.f_19804_.m_135372_(OFFSET_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROLL, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(PIERCE, (Object)0);
        this.f_19804_.m_135372_(MODEL, (Object)"");
        this.f_19804_.m_135372_(DELAY, (Object)10);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        NBTHelper.getNBTCoupler(compound).put("Color", this.getColor()).put("life", (short)this.ticksInGround).put("inBlockState", this.inBlockState != null ? NbtUtils.m_129202_((BlockState)this.inBlockState) : null).put("inGround", this.inGround).put("damage", this.damage).put("crit", this.getIsCritical()).put("clip", this.isNoClip()).put("PierceLevel", this.getPierce()).put("model", this.getModelName()).put("Delay", this.getDelay());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        NBTHelper.getNBTCoupler(compound).get("Color", this::setColor, new Integer[0]).get("life", v -> {
            this.ticksInGround = v;
        }, new Integer[0]).get("inBlockState", v -> {
            this.inBlockState = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)v);
        }, new CompoundTag[0]).get("inGround", v -> {
            this.inGround = v;
        }, new Boolean[0]).get("damage", v -> {
            this.damage = v;
        }, this.damage).get("crit", this::setIsCritical, new Boolean[0]).get("clip", this::setNoClip, new Boolean[0]).get("PierceLevel", this::setPierce, new Byte[0]).get("model", this::setModelName, new String[0]).get("Delay", this::setDelay, new Integer[0]);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vec3d = new Vec3(x, y, z).m_82541_().m_82520_(this.f_19796_.m_188583_() * (double)0.0075f * (double)inaccuracy, this.f_19796_.m_188583_() * (double)0.0075f * (double)inaccuracy, this.f_19796_.m_188583_() * (double)0.0075f * (double)inaccuracy).m_82490_((double)velocity);
        this.m_20256_(vec3d);
        float f = Mth.m_14116_((float)((float)vec3d.m_165925_()));
        this.m_146884_(this.m_20182_());
        this.m_146922_((float)(Mth.m_14136_((double)vec3d.f_82479_, (double)vec3d.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vec3d.f_82480_, (double)f) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
        this.ticksInGround = 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        double d0 = this.m_20191_().m_82309_() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return distance < (d0 = d0 * 64.0 * EntityAbstractSummonedSword.m_20150_()) * d0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.m_6034_(x, y, z);
        this.m_19915_(yaw, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6001_(double x, double y, double z) {
        this.m_20334_(x, y, z);
        if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
            float f = Mth.m_14116_((float)((float)(x * x + z * z)));
            this.m_146926_((float)(Mth.m_14136_((double)y, (double)f) * 57.2957763671875));
            this.m_146922_((float)(Mth.m_14136_((double)x, (double)z) * 57.2957763671875));
            this.f_19860_ = this.m_146909_();
            this.f_19859_ = this.m_146908_();
            this.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            this.ticksInGround = 0;
        }
    }

    protected void setFlags(FlagsState value) {
        this.flags.add(value);
        this.refreshFlags();
    }

    protected void removeFlags(FlagsState value) {
        this.flags.remove((Object)value);
        this.refreshFlags();
    }

    private void refreshFlags() {
        if (this.m_9236_().m_5776_()) {
            int newValue = (Integer)this.f_19804_.m_135370_(FLAGS);
            if (this.intFlags != newValue) {
                this.intFlags = newValue;
                this.flags = EnumSetConverter.convertToEnumSet(FlagsState.class, this.intFlags);
            }
        } else {
            int newValue = EnumSetConverter.convertToInt(this.flags);
            if (this.intFlags != newValue) {
                this.f_19804_.m_135381_(FLAGS, (Object)newValue);
                this.intFlags = newValue;
            }
        }
    }

    public void setIsCritical(boolean value) {
        if (value) {
            this.setFlags(FlagsState.Critical);
        } else {
            this.removeFlags(FlagsState.Critical);
        }
    }

    public boolean getIsCritical() {
        this.refreshFlags();
        return this.flags.contains((Object)FlagsState.Critical);
    }

    public void setNoClip(boolean value) {
        this.f_19794_ = value;
        if (value) {
            this.setFlags(FlagsState.NoClip);
        } else {
            this.removeFlags(FlagsState.NoClip);
        }
    }

    public boolean isNoClip() {
        if (!this.m_9236_().m_5776_()) {
            return this.f_19794_;
        }
        this.refreshFlags();
        return this.flags.contains((Object)FlagsState.NoClip);
    }

    public void m_8119_() {
        VoxelShape voxelshape;
        super.m_8119_();
        if (this.getHitEntity() != null) {
            Entity hits = this.getHitEntity();
            if (!hits.m_6084_()) {
                this.burst();
            } else {
                this.m_6034_(hits.m_20185_(), hits.m_20186_() + (double)(hits.m_20192_() * 0.5f), hits.m_20189_());
                int delay = this.getDelay();
                this.setDelay(--delay);
                if (!this.m_9236_().m_5776_() && delay < 0) {
                    this.burst();
                }
            }
            return;
        }
        boolean disallowedHitBlock = this.isNoClip();
        BlockPos blockpos = this.m_20097_();
        BlockState blockstate = this.m_9236_().m_8055_(blockpos);
        if (!(blockstate.m_60795_() || disallowedHitBlock || (voxelshape = blockstate.m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_())) {
            for (AABB axisalignedbb : voxelshape.m_83299_()) {
                if (!axisalignedbb.m_82338_(blockpos).m_82390_(new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()))) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.m_20070_()) {
            this.m_20095_();
        }
        if (this.inGround && !disallowedHitBlock) {
            if (this.inBlockState != blockstate && this.m_9236_().m_45772_(this.m_20191_().m_82400_(0.06))) {
                this.burst();
            } else if (!this.m_9236_().m_5776_()) {
                this.tryDespawn();
            }
        } else {
            Vec3 motionVec = this.m_20184_();
            if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
                float f = Mth.m_14116_((float)((float)motionVec.m_165925_()));
                this.m_146922_((float)(Mth.m_14136_((double)motionVec.f_82479_, (double)motionVec.f_82481_) * 57.2957763671875));
                this.m_146926_((float)(Mth.m_14136_((double)motionVec.f_82480_, (double)f) * 57.2957763671875));
                this.f_19859_ = this.m_146908_();
                this.f_19860_ = this.m_146909_();
            }
            ++this.ticksInAir;
            Vec3 positionVec = this.m_20182_();
            Vec3 movedVec = positionVec.m_82549_(motionVec);
            BlockHitResult raytraceresult = this.m_9236_().m_45547_(new ClipContext(positionVec, movedVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
                movedVec = raytraceresult.m_82450_();
            }
            while (this.m_6084_()) {
                EntityHitResult entityraytraceresult = this.getRayTrace(positionVec, movedVec);
                if (entityraytraceresult != null) {
                    raytraceresult = entityraytraceresult;
                }
                if (raytraceresult != null && raytraceresult.m_6662_() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)raytraceresult).m_82443_();
                    Entity entity1 = this.getShooter();
                    if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).m_7099_((Player)entity)) {
                        raytraceresult = null;
                        entityraytraceresult = null;
                    }
                }
                if (!(raytraceresult == null || disallowedHitBlock && raytraceresult.m_6662_() == HitResult.Type.BLOCK || ForgeEventFactory.onProjectileImpact((net.minecraft.world.entity.projectile.Projectile)this, (HitResult)raytraceresult))) {
                    this.m_6532_((HitResult)raytraceresult);
                    this.f_19812_ = true;
                }
                if (entityraytraceresult == null || this.getPierce() <= 0) break;
                raytraceresult = null;
            }
            motionVec = this.m_20184_();
            double mx = motionVec.f_82479_;
            double my = motionVec.f_82480_;
            double mz = motionVec.f_82481_;
            if (this.getIsCritical()) {
                for (int i = 0; i < 4; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_() + mx * (double)i / 4.0, this.m_20186_() + my * (double)i / 4.0, this.m_20189_() + mz * (double)i / 4.0, -mx, -my + 0.2, -mz);
                }
            }
            this.m_6034_(this.m_20185_() + mx, this.m_20186_() + my, this.m_20189_() + mz);
            float f4 = Mth.m_14116_((float)((float)motionVec.m_165925_()));
            if (disallowedHitBlock) {
                this.m_146922_((float)(Mth.m_14136_((double)(-mx), (double)(-mz)) * 57.2957763671875));
            } else {
                this.m_146922_((float)(Mth.m_14136_((double)mx, (double)mz) * 57.2957763671875));
            }
            this.m_146926_((float)(Mth.m_14136_((double)my, (double)f4) * 57.2957763671875));
            while (this.m_146909_() - this.f_19860_ < -180.0f) {
                this.f_19860_ -= 360.0f;
            }
            while (this.m_146909_() - this.f_19860_ >= 180.0f) {
                this.f_19860_ += 360.0f;
            }
            while (this.m_146908_() - this.f_19859_ < -180.0f) {
                this.f_19859_ -= 360.0f;
            }
            while (this.m_146908_() - this.f_19859_ >= 180.0f) {
                this.f_19859_ += 360.0f;
            }
            this.m_146926_(Mth.m_14179_((float)0.2f, (float)this.f_19860_, (float)this.m_146909_()));
            this.m_146922_(Mth.m_14179_((float)0.2f, (float)this.f_19859_, (float)this.m_146908_()));
            float f1 = 0.99f;
            if (this.m_20069_()) {
                for (int j = 0; j < 4; ++j) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() - mx * 0.25, this.m_20186_() - my * 0.25, this.m_20189_() - mz * 0.25, mx, my, mz);
                }
            }
            this.m_20256_(motionVec.m_82490_((double)f1));
            if (!this.m_20068_() && !disallowedHitBlock) {
                Vec3 vec3d3 = this.m_20184_();
                this.m_20334_(vec3d3.f_82479_, vec3d3.f_82480_ - (double)0.05f, vec3d3.f_82481_);
            }
            this.m_20101_();
        }
        if (!this.m_9236_().m_5776_() && this.ticksInGround <= 0 && 100 < this.f_19797_) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void tryDespawn() {
        ++this.ticksInGround;
        if (100 <= this.ticksInGround) {
            this.burst();
        }
    }

    protected void m_6532_(HitResult raytraceResultIn) {
        HitResult.Type type = raytraceResultIn.m_6662_();
        switch (type) {
            case ENTITY: {
                this.m_5790_((EntityHitResult)raytraceResultIn);
                break;
            }
            case BLOCK: {
                this.m_8060_((BlockHitResult)raytraceResultIn);
                break;
            }
        }
    }

    protected void m_8060_(BlockHitResult blockraytraceresult) {
        BlockState blockstate;
        this.inBlockState = blockstate = this.m_9236_().m_8055_(blockraytraceresult.m_82425_());
        Vec3 vec3d = blockraytraceresult.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(vec3d);
        Vec3 vec3d1 = this.m_20182_().m_82546_(vec3d.m_82541_().m_82490_((double)0.05f));
        this.m_6034_(vec3d1.f_82479_, vec3d1.f_82480_, vec3d1.f_82481_);
        this.m_5496_(this.getHitGroundSound(), 1.0f, 2.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        this.inGround = true;
        this.setIsCritical(false);
        this.setPierce((byte)0);
        this.resetAlreadyHits();
        blockstate.m_60669_(this.m_9236_(), blockstate, blockraytraceresult, (net.minecraft.world.entity.projectile.Projectile)this);
    }

    public void doForceHitEntity(Entity target) {
        this.m_5790_(new EntityHitResult(target));
    }

    protected void m_5790_(EntityHitResult p_213868_1_) {
        DamageSource damagesource;
        Entity shooter;
        Entity targetEntity = p_213868_1_.m_82443_();
        int i = Mth.m_14165_((double)this.getDamage());
        if (this.getPierce() > 0) {
            if (this.alreadyHits == null) {
                this.alreadyHits = new IntOpenHashSet(5);
            }
            if (this.alreadyHits.size() >= this.getPierce() + 1) {
                this.burst();
                return;
            }
            this.alreadyHits.add(targetEntity.m_19879_());
        }
        if (this.getIsCritical()) {
            i += this.f_19796_.m_188503_(i / 2 + 2);
        }
        if ((shooter = this.getShooter()) == null) {
            damagesource = this.m_269291_().m_269104_((Entity)this, (Entity)this);
        } else {
            damagesource = this.m_269291_().m_269104_((Entity)this, shooter);
            if (shooter instanceof LivingEntity) {
                Entity hits = targetEntity;
                if (targetEntity instanceof PartEntity) {
                    hits = ((PartEntity)targetEntity).getParent();
                }
                ((LivingEntity)shooter).m_21335_(hits);
            }
        }
        int fireTime = targetEntity.m_20094_();
        if (this.m_6060_() && !(targetEntity instanceof EnderMan)) {
            targetEntity.m_20254_(5);
        }
        targetEntity.f_19802_ = 0;
        if (targetEntity.m_6469_(damagesource, (float)i)) {
            Entity hits = targetEntity;
            if (targetEntity instanceof PartEntity) {
                hits = ((PartEntity)targetEntity).getParent();
            }
            if (hits instanceof LivingEntity) {
                LivingEntity targetLivingEntity = (LivingEntity)hits;
                StunManager.setStun(targetLivingEntity);
                if (!this.m_9236_().m_5776_() && this.getPierce() <= 0) {
                    this.setHitEntity(hits);
                }
                if (!this.m_9236_().m_5776_() && shooter instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)targetLivingEntity, (Entity)shooter);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)shooter), (Entity)targetLivingEntity);
                }
                this.affectEntity(targetLivingEntity, this.getPotionEffects(), 1.0);
                if (shooter != null && targetLivingEntity != shooter && targetLivingEntity instanceof Player && shooter instanceof ServerPlayer) {
                    ((ServerPlayer)shooter).m_6330_(this.getHitEntityPlayerSound(), SoundSource.PLAYERS, 0.18f, 0.45f);
                }
            }
            this.m_5496_(this.getHitEntitySound(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
            if (!(this.getPierce() > 0 || this.getHitEntity() != null && this.getHitEntity().m_6084_())) {
                this.burst();
            }
        } else {
            targetEntity.m_7311_(fireTime);
            this.ticksInAir = 0;
            if (!this.m_9236_().m_5776_() && this.m_20184_().m_82556_() < 1.0E-7) {
                if (this.getPierce() <= 1) {
                    this.burst();
                } else {
                    this.setPierce((byte)(this.getPierce() - 1));
                }
            }
        }
    }

    public int getColor() {
        return (Integer)this.m_20088_().m_135370_(COLOR);
    }

    public void setColor(int value) {
        this.m_20088_().m_135381_(COLOR, (Object)value);
    }

    public byte getPierce() {
        return (Byte)this.m_20088_().m_135370_(PIERCE);
    }

    public void setPierce(byte value) {
        this.m_20088_().m_135381_(PIERCE, (Object)value);
    }

    public int getDelay() {
        return (Integer)this.m_20088_().m_135370_(DELAY);
    }

    public void setDelay(int value) {
        this.m_20088_().m_135381_(DELAY, (Object)value);
    }

    @Nullable
    protected EntityHitResult getRayTrace(Vec3 p_213866_1_, Vec3 p_213866_2_) {
        return ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)p_213866_1_, (Vec3)p_213866_2_, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), p_213871_1_ -> !(p_213871_1_.m_5833_() || !p_213871_1_.m_6084_() || !p_213871_1_.m_6087_() || p_213871_1_ == this.getShooter() && this.ticksInAir < 5 || this.alreadyHits != null && this.alreadyHits.contains(p_213871_1_.m_19879_())));
    }

    @Override
    @Nullable
    public Entity getShooter() {
        return this.m_19749_();
    }

    @Override
    public void setShooter(Entity shooter) {
        this.m_5602_(shooter);
    }

    public List<MobEffectInstance> getPotionEffects() {
        List effects = PotionUtils.m_43566_((CompoundTag)this.getPersistentData());
        if (effects.isEmpty()) {
            effects.add(new MobEffectInstance(MobEffects.f_19614_, 1, 1));
        }
        return effects;
    }

    public void burst() {
        this.m_5496_(SoundEvents.f_11983_, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        if (!this.m_9236_().m_5776_()) {
            if (this.m_9236_() instanceof ServerLevel) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 16, 0.5, 0.5, 0.5, 0.25);
            }
            this.burst(this.getPotionEffects(), null);
        }
        super.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public void burst(List<MobEffectInstance> effects, @Nullable Entity focusEntity) {
        List<Entity> list = TargetSelector.getTargettableEntitiesWithinAABB(this.m_9236_(), 2.0, this);
        list.stream().filter(e -> e instanceof LivingEntity).map(e -> (LivingEntity)e).forEach(e -> {
            double distanceSq = this.m_20280_((Entity)e);
            if (distanceSq < 9.0) {
                double factor = 1.0 - Math.sqrt(distanceSq) / 4.0;
                if (e == focusEntity) {
                    factor = 1.0;
                }
                this.affectEntity((LivingEntity)e, effects, factor);
            }
        });
    }

    public void affectEntity(LivingEntity focusEntity, List<MobEffectInstance> effects, double factor) {
        for (MobEffectInstance effectinstance : this.getPotionEffects()) {
            MobEffect effect = effectinstance.m_19544_();
            if (effect.m_8093_()) {
                effect.m_19461_((Entity)this, this.getShooter(), focusEntity, effectinstance.m_19564_(), factor);
                continue;
            }
            int duration = (int)(factor * (double)effectinstance.m_19557_() + 0.5);
            if (duration <= 0) continue;
            focusEntity.m_7292_(new MobEffectInstance(effect, duration, effectinstance.m_19564_(), effectinstance.m_19571_(), effectinstance.m_19572_()));
        }
    }

    public void resetAlreadyHits() {
        if (this.alreadyHits != null) {
            this.alreadyHits.clear();
        }
    }

    public void setHitEntity(Entity hitEntity) {
        if (hitEntity != this) {
            this.f_19804_.m_135381_(HIT_ENTITY_ID, (Object)hitEntity.m_19879_());
            this.f_19804_.m_135381_(OFFSET_YAW, (Object)Float.valueOf(this.f_19796_.m_188501_() * 360.0f));
            this.setDelay(100);
        }
    }

    @Nullable
    public Entity getHitEntity() {
        int id;
        if (this.hitEntity == null && 0 <= (id = ((Integer)this.f_19804_.m_135370_(HIT_ENTITY_ID)).intValue())) {
            this.hitEntity = this.m_9236_().m_6815_(id);
        }
        return this.hitEntity;
    }

    public float getOffsetYaw() {
        return ((Float)this.f_19804_.m_135370_(OFFSET_YAW)).floatValue();
    }

    public float getRoll() {
        return ((Float)this.f_19804_.m_135370_(ROLL)).floatValue();
    }

    public void setRoll(float value) {
        this.f_19804_.m_135381_(ROLL, (Object)Float.valueOf(value));
    }

    public void setDamage(double damageIn) {
        this.damage = damageIn;
    }

    @Override
    public double getDamage() {
        return this.damage;
    }

    public void setModelName(String name) {
        this.f_19804_.m_135381_(MODEL, (Object)Optional.ofNullable(name).orElse(defaultModelName));
    }

    public String getModelName() {
        String name = (String)this.f_19804_.m_135370_(MODEL);
        if (name == null || name.length() == 0) {
            name = defaultModelName;
        }
        return name;
    }

    public ResourceLocation getModelLoc() {
        return (ResourceLocation)this.modelLoc.orElse((Object)defaultModel);
    }

    public ResourceLocation getTextureLoc() {
        return (ResourceLocation)this.textureLoc.orElse((Object)defaultTexture);
    }

    public void m_7334_(Entity entityIn) {
    }

    static enum FlagsState {
        Critical,
        NoClip;

    }
}

