/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.compat.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.registration.ISubtypeRegistration;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import net.minecraft.resources.ResourceLocation;

@JeiPlugin
public class JEICompat
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return SlashBlade.prefix("slashblade");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(SBItems.slashblade, (stack, context) -> {
            if (!stack.getCapability(ItemSlashBlade.BLADESTATE).isPresent()) {
                return "";
            }
            ISlashBladeState state = (ISlashBladeState)stack.getCapability(ItemSlashBlade.BLADESTATE).orElseThrow(NullPointerException::new);
            String transKey = state.getTranslationKey();
            if (transKey.isBlank()) {
                return transKey;
            }
            ResourceLocation bladeID = this.getBladeId(transKey);
            if (BladeModelManager.getClientSlashBladeRegistry().m_7804_(bladeID)) {
                SlashBladeDefinition blade = (SlashBladeDefinition)BladeModelManager.getClientSlashBladeRegistry().m_7745_(bladeID);
                state.setModel(blade.getRenderDefinition().getModelName());
                state.setTexture(blade.getRenderDefinition().getTextureName());
            }
            return transKey;
        });
    }

    private ResourceLocation getBladeId(String translationKey) {
        return ResourceLocation.m_135820_((String)translationKey.substring(5).replace('.', ':'));
    }
}

