/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import java.util.List;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.util.TargetSelector;
import mods.flammpfeil.slashblade.util.TimeValueHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class ArrowReflector {
    public static boolean isMatch(Entity arrow, Entity attacker) {
        if (arrow == null) {
            return false;
        }
        return arrow instanceof Projectile;
    }

    public static void doReflect(Entity arrow, Entity attacker) {
        if (!ArrowReflector.isMatch(arrow, attacker)) {
            return;
        }
        arrow.f_19864_ = true;
        if (attacker != null) {
            ItemStack stack;
            Vec3 dir = attacker.m_20154_();
            if (!(attacker instanceof LivingEntity) && !(stack = ((LivingEntity)attacker).m_21205_()).m_41619_() && stack.m_41720_() instanceof ItemSlashBlade) {
                Entity target = stack.getCapability(ItemSlashBlade.BLADESTATE).map(s -> s.getTargetEntity(attacker.m_9236_())).orElse(null);
                dir = target != null ? arrow.m_20182_().m_82546_(target.m_20299_(1.0f)).m_82541_() : arrow.m_20182_().m_82546_(attacker.m_20154_().m_82490_(10.0).m_82549_(attacker.m_20299_(1.0f))).m_82541_();
            }
            arrow.m_20256_(dir);
            ((Projectile)arrow).m_6686_(dir.f_82479_, dir.f_82480_, dir.f_82481_, 1.1f, 0.5f);
            arrow.m_20242_(true);
            if (arrow instanceof AbstractArrow) {
                ((AbstractArrow)arrow).m_36762_(true);
            }
        }
    }

    public static void doTicks(LivingEntity attacker) {
        ItemStack stack = attacker.m_21205_();
        if (stack.m_41619_()) {
            return;
        }
        if (!(stack.m_41720_() instanceof ItemSlashBlade)) {
            return;
        }
        stack.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(s -> {
            double period;
            ComboState currentCS;
            int ticks = attacker.m_21252_();
            if (ticks == 0) {
                return;
            }
            ResourceLocation old = s.getComboSeq();
            ResourceLocation current = s.resolvCurrentComboState(attacker);
            ComboState comboState = currentCS = ComboStateRegistry.REGISTRY.get().getValue(current) != null ? (ComboState)ComboStateRegistry.REGISTRY.get().getValue(current) : (ComboState)ComboStateRegistry.NONE.get();
            if (old != current) {
                ComboState oldCS = (ComboState)ComboStateRegistry.REGISTRY.get().getValue(current);
                ticks = (int)((double)ticks - TimeValueHelper.getTicksFromMSec(oldCS.getTimeoutMS()));
            }
            if ((double)ticks < (period = TimeValueHelper.getTicksFromFrames(currentCS.getEndFrame() - currentCS.getStartFrame()) * (double)(1.0f / currentCS.getSpeed()))) {
                List<Entity> founds = TargetSelector.getReflectableEntitiesWithinAABB(attacker);
                founds.stream().filter(e -> e instanceof Projectile && ((Projectile)e).m_19749_() != attacker).forEach(e -> ArrowReflector.doReflect(e, (Entity)attacker));
            }
        });
    }
}

