/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nymmd.types;

import jp.nyatla.nymmd.types.MmdVector3;

public class MmdVector4 {
    public double x;
    public double y;
    public double z;
    public double w;

    public void setValue(MmdVector4 v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
        this.w = v.w;
    }

    public void QuaternionSlerp(MmdVector4 pvec4Src1, MmdVector4 pvec4Src2, double fLerpValue) {
        double qr = pvec4Src1.x * pvec4Src2.x + pvec4Src1.y * pvec4Src2.y + pvec4Src1.z * pvec4Src2.z + pvec4Src1.w * pvec4Src2.w;
        double t0 = 1.0 - fLerpValue;
        if (qr < 0.0) {
            this.x = pvec4Src1.x * t0 - pvec4Src2.x * fLerpValue;
            this.y = pvec4Src1.y * t0 - pvec4Src2.y * fLerpValue;
            this.z = pvec4Src1.z * t0 - pvec4Src2.z * fLerpValue;
            this.w = pvec4Src1.w * t0 - pvec4Src2.w * fLerpValue;
        } else {
            this.x = pvec4Src1.x * t0 + pvec4Src2.x * fLerpValue;
            this.y = pvec4Src1.y * t0 + pvec4Src2.y * fLerpValue;
            this.z = pvec4Src1.z * t0 + pvec4Src2.z * fLerpValue;
            this.w = pvec4Src1.w * t0 + pvec4Src2.w * fLerpValue;
        }
        this.QuaternionNormalize(this);
    }

    public void QuaternionNormalize(MmdVector4 pvec4Src) {
        double fSqr = 1.0 / Math.sqrt(pvec4Src.x * pvec4Src.x + pvec4Src.y * pvec4Src.y + pvec4Src.z * pvec4Src.z + pvec4Src.w * pvec4Src.w);
        this.x = pvec4Src.x * fSqr;
        this.y = pvec4Src.y * fSqr;
        this.z = pvec4Src.z * fSqr;
        this.w = pvec4Src.w * fSqr;
    }

    public void QuaternionCreateAxis(MmdVector3 pvec3Axis, double fRotAngle) {
        if (Math.abs(fRotAngle) < (double)1.0E-4f) {
            this.z = 0.0;
            this.y = 0.0;
            this.x = 0.0;
            this.w = 1.0;
        } else {
            double fTemp = Math.sin(fRotAngle *= 0.5);
            this.x = (double)pvec3Axis.x * fTemp;
            this.y = (double)pvec3Axis.y * fTemp;
            this.z = (double)pvec3Axis.z * fTemp;
            this.w = Math.cos(fRotAngle);
        }
    }

    public void QuaternionMultiply(MmdVector4 pvec4Src1, MmdVector4 pvec4Src2) {
        double px = pvec4Src1.x;
        double py = pvec4Src1.y;
        double pz = pvec4Src1.z;
        double pw = pvec4Src1.w;
        double qx = pvec4Src2.x;
        double qy = pvec4Src2.y;
        double qz = pvec4Src2.z;
        double qw = pvec4Src2.w;
        this.x = pw * qx + px * qw + py * qz - pz * qy;
        this.y = pw * qy - px * qz + py * qw + pz * qx;
        this.z = pw * qz + px * qy - py * qx + pz * qw;
        this.w = pw * qw - px * qx - py * qy - pz * qz;
    }

    public void QuaternionCreateEuler(MmdVector3 pvec3EulerAngle) {
        double xRadian = (double)pvec3EulerAngle.x * 0.5;
        double yRadian = (double)pvec3EulerAngle.y * 0.5;
        double zRadian = (double)pvec3EulerAngle.z * 0.5;
        double sinX = Math.sin(xRadian);
        double cosX = Math.cos(xRadian);
        double sinY = Math.sin(yRadian);
        double cosY = Math.cos(yRadian);
        double sinZ = Math.sin(zRadian);
        double cosZ = Math.cos(zRadian);
        this.x = sinX * cosY * cosZ - cosX * sinY * sinZ;
        this.y = cosX * sinY * cosZ + sinX * cosY * sinZ;
        this.z = cosX * cosY * sinZ - sinX * sinY * cosZ;
        this.w = cosX * cosY * cosZ + sinX * sinY * sinZ;
    }
}

