/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.util;

import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class JSONUtil {
    private static final Pattern SIMPLE_VALUE = Pattern.compile("[A-Za-z0-9._+-]+");

    static String handleEscape(String str) {
        return SIMPLE_VALUE.matcher(str).matches() ? str : StringTag.m_129303_((String)str);
    }

    public static String NBTtoJsonString(Tag childTag) {
        String str;
        byte i = childTag.m_7060_();
        if (childTag instanceof CompoundTag) {
            str = JSONUtil.NBTtoJsonString((CompoundTag)childTag);
        } else if (childTag instanceof ListTag) {
            str = JSONUtil.NBTtoJsonString((ListTag)childTag);
        } else if (i == 1 || i == 2 || i == 3 || i == 4 || i == 5 || i == 6) {
            str = childTag.toString();
            str = str.replaceAll("[fdbsL]", "");
        } else {
            str = childTag.toString();
        }
        return str;
    }

    public static String NBTtoJsonString(ListTag list) {
        StringBuilder stringbuilder = new StringBuilder("[");
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                stringbuilder.append(',');
            }
            stringbuilder.append(JSONUtil.NBTtoJsonString(list.get(i)));
        }
        return stringbuilder.append(']').toString();
    }

    public static String NBTtoJsonString(CompoundTag tag) {
        StringBuilder stringbuilder = new StringBuilder("{");
        Set collection = tag.m_128431_();
        for (String s : collection) {
            if (stringbuilder.length() != 1) {
                stringbuilder.append(',');
            }
            stringbuilder.append(JSONUtil.handleEscape(s)).append(':').append(JSONUtil.NBTtoJsonString(tag.m_128423_(s)));
        }
        return stringbuilder.append('}').toString();
    }
}

